/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.acceso;

import adalid.commons.bundles.Bundle;
import adalid.core.AbstractPersistentEnumerationEntity;
import adalid.core.Instance;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.StringField;
import adalid.core.enums.Kleenean;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Property;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import java.util.Locale;

@EntityClass(independent=Kleenean.TRUE, resourceType=ResourceType.CONFIGURATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, access=OperationAccess.PUBLIC, rowsLimit=0)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.FALSE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.FALSE)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class ClaseFabricador
extends AbstractPersistentEnumerationEntity {
    public static final String FCSS_VALIDATOR = "fcssValidator";
    @PrimaryKey
    public IntegerProperty numero;
    @BusinessKey
    @StringField(maxLength=100)
    public StringProperty codigo;
    @ColumnField(nullable=Kleenean.FALSE)
    @StringField(maxLength=100)
    public StringProperty codigoClaseRecurso;
    @ColumnField(nullable=Kleenean.FALSE)
    @StringField(maxLength=200)
    public StringProperty nombreClaseFabricador;
    @StringField(maxLength=200)
    public StringProperty codigoConjuntoSegmento;
    @StringField(maxLength=200)
    public StringProperty nombreConjuntoSegmento;
    @DescriptionProperty
    @StringField(maxLength=0)
    public StringProperty descripcionConjuntoSegmento;
    @ColumnField(nullable=Kleenean.FALSE)
    public BooleanProperty elemental;
    public Instance C01;
    public Instance C02;
    public Instance C03;
    public Instance C04;
    public Instance C05;
    public Instance C06;
    public Instance C0A;
    public Instance C0B;
    public Instance C0C;
    public Instance C0D;
    public Instance C0E;
    public Instance C0F;
    public Instance C0G;
    public Instance C07;
    public Instance C08;
    private static final String PAQUETE = "project_root_package_name.lib.core.control";
    private static final String PREFIJO = "FabricadorConjunto";

    public ClaseFabricador(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "segment set factory class");
        this.setLocalizedLabel(SPANISH, "clase de fabricador de conjunto de segmentos");
        this.setLocalizedShortLabel(ENGLISH, "factory class");
        this.setLocalizedShortLabel(SPANISH, "clase de fabricador");
        this.setLocalizedCollectionLabel(ENGLISH, "Segment Set Factory Classes");
        this.setLocalizedCollectionLabel(SPANISH, "Clases de Fabricador de Conjunto de Segmentos");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Factory Classes");
        this.setLocalizedCollectionShortLabel(SPANISH, "Clases de Fabricador");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.elemental.setInitialValue(false);
        this.elemental.setDefaultValue(false);
        this.numero.setLocalizedLabel(ENGLISH, "factory class number");
        this.numero.setLocalizedLabel(SPANISH, "n\u00famero de la clase de fabricador");
        this.numero.setLocalizedShortLabel(ENGLISH, "number");
        this.numero.setLocalizedShortLabel(SPANISH, "n\u00famero");
        this.codigo.setLocalizedLabel(ENGLISH, "factory class code");
        this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo de la clase de fabricador");
        this.codigo.setLocalizedShortLabel(ENGLISH, "code");
        this.codigo.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.codigoClaseRecurso.setLocalizedLabel(ENGLISH, "resource class code");
        this.codigoClaseRecurso.setLocalizedLabel(SPANISH, "c\u00f3digo de la clase de recurso");
        this.codigoClaseRecurso.setLocalizedShortLabel(ENGLISH, "resource class code");
        this.codigoClaseRecurso.setLocalizedShortLabel(SPANISH, "c\u00f3digo clase recurso");
        this.nombreClaseFabricador.setLocalizedLabel(ENGLISH, "factory class name");
        this.nombreClaseFabricador.setLocalizedLabel(SPANISH, "nombre de la clase de fabricador");
        this.nombreClaseFabricador.setLocalizedShortLabel(ENGLISH, "factory class name");
        this.nombreClaseFabricador.setLocalizedShortLabel(SPANISH, "nombre clase fabricador");
        this.codigoConjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set code");
        this.codigoConjuntoSegmento.setLocalizedLabel(SPANISH, "c\u00f3digo del conjunto de segmentos");
        this.nombreConjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set name");
        this.nombreConjuntoSegmento.setLocalizedLabel(SPANISH, "nombre del conjunto de segmentos");
        this.descripcionConjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set description");
        this.descripcionConjuntoSegmento.setLocalizedLabel(SPANISH, "descripci\u00f3n del conjunto de segmentos");
        this.elemental.setLocalizedLabel(ENGLISH, "requires elements");
        this.elemental.setLocalizedLabel(SPANISH, "requiere elementos");
    }

    @Override
    protected void settleInstances() {
        super.settleInstances();
        this.setInstanceFields(this.C01, "usuario", "UsuariosSupervisados");
        this.setInstanceFields(this.C02, "usuario", "UsuariosSupervisadosDirectamente");
        this.setInstanceFields(this.C03, "usuario", "UsuariosSupervisadosSinIncluirSupervisor");
        this.setInstanceFields(this.C04, "usuario", "UsuariosSupervisadosDirectamenteSinIncluirSupervisor");
        this.setInstanceFields(this.C05, "usuario", "UsuariosUsuarioActual");
        this.setInstanceFields(this.C06, "usuario", "UsuariosUsuarioOperacionesCalendarizadas");
        this.setInstanceFields(this.C07, "usuario", "UsuariosSupervisadosIndirectamente");
        this.setInstanceFields(this.C08, "usuario", "UsuariosSupervisadosIndirectamenteSinIncluirSupervisor");
        this.setInstanceFields(this.C0A, "grupo_usuario", "GrupoDelUsuarioActual");
        this.setInstanceFields(this.C0B, "grupo_usuario", "GrupoDelUsuarioActualConSusSubgrupos");
        this.setInstanceFields(this.C0C, "grupo_usuario", "GrupoDelUsuarioActualConSusSubgruposDirectos");
        this.setInstanceFields(this.C0D, "grupo_usuario", "SubgruposDelGrupoDelUsuarioActual");
        this.setInstanceFields(this.C0E, "grupo_usuario", "SubgruposDirectosDelGrupoDelUsuarioActual");
        this.setInstanceFields(this.C0F, "grupo_usuario", "GruposDelConjuntoConSusSubgrupos", true);
        this.setInstanceFields(this.C0G, "grupo_usuario", "GruposDelConjuntoConSusSubgruposDirectos", true);
    }

    private void setInstanceFields(Instance clase, String tabla, String conjunto) {
        this.setInstanceFields(clase, tabla, conjunto, false);
    }

    private void setInstanceFields(Instance clase, String tabla, String conjunto, boolean elementado) {
        String codigoClaseFabricador = PREFIJO + conjunto;
        clase.newInstanceField(this.codigo, codigoClaseFabricador);
        clase.newInstanceField(this.codigoClaseRecurso, tabla);
        clase.newInstanceField(this.nombreClaseFabricador, "project_root_package_name.lib.core.control." + codigoClaseFabricador);
        clase.newInstanceField((Property)this.elemental, elementado);
        this.setInstanceFields(clase, codigoClaseFabricador, ENGLISH);
        this.setInstanceFields(clase, codigoClaseFabricador, SPANISH);
    }

    private void setInstanceFields(Instance clase, String codigoClaseFabricador, Locale locale) {
        String code = Bundle.getTrimmedToNullString(codigoClaseFabricador + ".code", locale);
        String name = Bundle.getTrimmedToNullString(codigoClaseFabricador + ".name", locale);
        String description = Bundle.getTrimmedToNullString(codigoClaseFabricador + ".description", locale);
        clase.newInstanceField(this.codigoConjuntoSegmento, code, locale);
        clase.newInstanceField(this.nombreConjuntoSegmento, name, locale);
        clase.newInstanceField(this.descripcionConjuntoSegmento, description, locale);
    }
}

