/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.enums;

import adalid.commons.enums.EnumBitLabelSet;
import adalid.commons.list.ListOption;
import adalid.commons.list.ListOptions;
import adalid.commons.util.BitUtils;
import adalid.commons.util.IntUtils;

public enum EnumBit implements ListOption
{
    TRUE(true),
    FALSE(false);

    private final boolean value;

    public static EnumBit valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static EnumBit valueOf(Boolean b) {
        return EnumBit.valueOf(BitUtils.valueOf(b));
    }

    public static EnumBit valueOf(char c) {
        return EnumBit.valueOf(BitUtils.valueOf(c));
    }

    public static EnumBit valueOf(Integer i) {
        return EnumBit.valueOf(BitUtils.valueOf(i));
    }

    public static EnumBit valueOf(Long l) {
        return EnumBit.valueOf(BitUtils.valueOf(l));
    }

    public static ListOptions getListOptions() {
        return EnumBit.getListOptions(EnumBitLabelSet.YES_OR_NO);
    }

    public static ListOptions getListOptions(EnumBitLabelSet bls) {
        return EnumBit.getListOptions(bls, false);
    }

    public static ListOptions getListOptions(EnumBitLabelSet bls, boolean anulable) {
        return EnumBit.getListOptions(bls, anulable, false);
    }

    public static ListOptions getListOptions(EnumBitLabelSet bls, boolean anulable, boolean ordenado) {
        ListOptions list = new ListOptions(anulable, ordenado);
        for (EnumBit e : EnumBit.values()) {
            list.add(e.intValue(), e.getLabel(bls));
        }
        return list;
    }

    private EnumBit(boolean value) {
        this.value = value;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public int intValue() {
        return IntUtils.valueOf(this.value);
    }

    public String getLabel() {
        return BitUtils.getLabel(this.value);
    }

    public String getLabel(EnumBitLabelSet bls) {
        return BitUtils.getLabel(this.value, bls);
    }

    @Override
    public Object getOptionValue() {
        return this.intValue();
    }

    @Override
    public String getOptionLabel() {
        return this.getLabel();
    }

    @Override
    public String getOptionDescription() {
        return null;
    }

    @Override
    public boolean isOptionDisabled() {
        return false;
    }

    @Override
    public boolean isNoSelectionOption() {
        return false;
    }
}

