/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import java.lang.reflect.Array;

public class ArrUtils {
    public static <T> T[] arrayOf(Class<T> clazz) {
        return clazz == null ? null : (Object[])Array.newInstance(clazz, 0);
    }

    public static <T> T[] arrayOf(T value) {
        if (value == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(value.getClass(), 1);
        array[0] = value;
        return array;
    }

    public static <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null || array1.length == 0) {
            return ArrUtils.clone(array2);
        }
        if (array2 == null || array2.length == 0) {
            return ArrUtils.clone(array1);
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (type1.isAssignableFrom(type2)) {
                throw ase;
            }
            throw new IllegalArgumentException("cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
        }
        return joinedArray;
    }

    public static <T> T[] join(Class<T> type, T[] ... arrays) {
        if (type == null || arrays == null || arrays.length == 0) {
            return null;
        }
        int length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        if (length == 0) {
            return null;
        }
        Object[] join = (Object[])Array.newInstance(type, length);
        int position = 0;
        for (T[] array : arrays) {
            if (array == null || array.length <= 0) continue;
            System.arraycopy(array, 0, join, position, array.length);
            position += array.length;
        }
        return join;
    }

    public static <T> T[] clone(T[] array) {
        return array == null ? null : (Object[])array.clone();
    }
}

