/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import adalid.commons.bundles.Bundle;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.ArrUtils;
import adalid.commons.util.BitUtils;
import adalid.commons.util.Damm;
import adalid.commons.util.HexUtils;
import adalid.commons.util.KVP;
import adalid.commons.util.NumUtils;
import adalid.commons.util.ObjUtils;
import adalid.commons.util.TimeUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StrUtils {
    private static final Logger logger = Logger.getLogger(StrUtils.class);
    private static final ExtendedProperties bootstrapping = PropertiesHandler.getBootstrapping();
    private static final Pattern LTRIMMER = Pattern.compile("^\\s+");
    private static final Pattern RTRIMMER = Pattern.compile("\\s+$");
    private static final boolean SQL_ID_HASH_CODE_AFFIX = BitUtils.valueOf(bootstrapping.getString("sql.identifier.hash.code.affix", "false"));
    private static final boolean SQL_ID_HASH_PKEY_VALUE = BitUtils.valueOf(bootstrapping.getString("sql.identifier.hash.pkey.value", "false"));
    private static final boolean SQL_ID_INFO = BitUtils.valueOf(bootstrapping.getString("sql.identifier.info", "false"));
    private static final boolean SQL_ID_WARN = BitUtils.valueOf(bootstrapping.getString("sql.identifier.warn", "false"));
    public static final String VALID_CHARS = "abcdefghijklmnopqrstuvwxyz_1234567890";
    public static final int MAX_STRING_LENGTH = Short.MAX_VALUE;
    private static final int MDD = 13;
    private static final double X2MDD = Math.pow(10.0, 13.0);
    private static final Pattern esIdentificadorSqlValido = Pattern.compile("^[a-zA-Z]\\w*$");
    private static final Pattern esIdentificadorArchivoValido = Pattern.compile("^[\\w\\-\\.]*$");
    private static final String SQLTAG = "SQLID#";
    private static final Set<String> setIdentificadorSql = new LinkedHashSet<String>();
    private static int setIdentificadorSqlCount = 0;
    private static final String DEFAULT_SEPARATOR = "_";
    private static final String INVALID_SEPARATOR = "[\\u0000-\\u001F0-9A-Za-z\\u0080-\\uFFFF]";
    private static final Pattern mavenIdentifierPattern = Pattern.compile("^[a-z].*$");
    private static final Pattern mavenVersionPattern = Pattern.compile("^[\\d]+\\.[\\d]+.*$");
    private static final Pattern oracleVersionPattern = Pattern.compile("^\\d+[a-z]$");
    private static final String DEFAULT_REPLACEMENT = "_";
    private static final String BS = "\b";
    private static final String HT = "\t";
    private static final String LF = "\n";
    private static final String FF = "\f";
    private static final String CR = "\r";
    private static final String DQ = "\"";
    private static final String bs = "\\b";
    private static final String ht = "\\t";
    private static final String lf = "\\n";
    private static final String ff = "\\f";
    private static final String cr = "\\r";
    private static final String dq = "\\\"";
    private static final String[] slashedChars = new String[]{"\b", "\t", "\n", "\f", "\r", "\""};
    private static final String[] replacements = new String[]{"\\b", "\\t", "\\n", "\\f", "\\r", "\\\""};
    private static final Pattern esIdentificadorSqlCalificado = Pattern.compile("^\\w+(\\.\\w+)*$");
    private static final char[] SQL_QUOTES = new char[]{'\'', '\"'};

    public static String digest(String credentials) {
        return StrUtils.digest(credentials, null);
    }

    public static String digest(String credentials, String algorithm) {
        return StrUtils.digest(credentials, algorithm, null);
    }

    public static String digest(String credentials, String algorithm, String encoding) {
        if (StringUtils.isBlank((String)credentials)) {
            return credentials;
        }
        algorithm = StringUtils.defaultIfBlank((String)algorithm, (String)"MD5");
        try {
            MessageDigest md = (MessageDigest)MessageDigest.getInstance(algorithm).clone();
            if (StringUtils.isBlank((String)encoding)) {
                md.update(credentials.getBytes());
            } else {
                md.update(credentials.getBytes(encoding));
            }
            return HexUtils.convert(md.digest());
        }
        catch (UnsupportedEncodingException | CloneNotSupportedException | NoSuchAlgorithmException ex) {
            return credentials;
        }
    }

    public static String separateLines(String string, int maxLineLength) {
        return StrUtils.separateLines(string, maxLineLength, LF);
    }

    public static String separateLines(String string, int maxLineLength, String separator) {
        return StrUtils.separateLines(string, maxLineLength, separator, false);
    }

    public static String separateLines(String string, int maxLineLength, String separator, boolean separatorLine) {
        List<String> list = StrUtils.split(string, maxLineLength, separator, separatorLine);
        String sep = StrUtils.splitSeparator(separator);
        String str = StringUtils.join(list, (String)sep);
        boolean ls = StrUtils.linesSeparator(separator, separatorLine);
        return !ls ? str : StringUtils.replace((String)str, (String)(sep + sep + sep), (String)(sep + sep));
    }

    public static List<String> split(String string) {
        return StrUtils.split(string, 80);
    }

    public static List<String> split(String string, int max) {
        return StrUtils.split(string, max, null);
    }

    public static List<String> split(String string, int max, String separator) {
        return StrUtils.split(string, max, separator, false);
    }

    public static List<String> split(String string, int max, String separator, boolean separatorLine) {
        return StrUtils.split(string, max, separator, separatorLine, null);
    }

    public static List<String> split(String string, int max, String separator, boolean separatorLine, String prefix) {
        ArrayList<String> strings = new ArrayList<String>();
        String str = StringUtils.trimToNull((String)string);
        if (str != null) {
            String[] stringArray;
            String sep = StrUtils.splitSeparator(separator);
            String nlp = prefix == null ? "" : prefix;
            boolean ls = StrUtils.linesSeparator(separator, separatorLine);
            if (separator == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = str;
            } else {
                stringArray = StringUtils.splitByWholeSeparator((String)str, (String)separator);
            }
            String[] paragraphs = stringArray;
            int lastParagraph = paragraphs.length - 1;
            for (int i = 0; i < paragraphs.length; ++i) {
                String paragraph = paragraphs[i].replaceAll(" +$", "");
                if (max > 0) {
                    int maxLineLength = max;
                    if (paragraph.length() > maxLineLength) {
                        String[] words;
                        Object line = "";
                        for (String word : words = StringUtils.split((String)paragraph)) {
                            int lineLength = ((String)line).length();
                            int wordLength = word.length() + 1;
                            if (lineLength == 0) {
                                line = word;
                                continue;
                            }
                            if (lineLength + wordLength > maxLineLength) {
                                strings.add((String)line);
                                maxLineLength = max - nlp.length();
                                line = nlp + word;
                                continue;
                            }
                            line = (String)line + " " + word;
                        }
                        strings.add((String)line);
                    } else {
                        strings.add(paragraph);
                    }
                } else {
                    strings.add(paragraph);
                }
                if (!ls || i >= lastParagraph) continue;
                strings.add(sep);
            }
        }
        return strings;
    }

    private static boolean linesSeparator(String separator, boolean separatorLine) {
        String sep = StrUtils.splitSeparator(separator);
        return separatorLine && sep != null && !sep.isEmpty();
    }

    private static String splitSeparator(String separator) {
        return separator == null ? null : separator.replaceAll(" +", "");
    }

    public static String ltrim(String s) {
        return s == null ? null : LTRIMMER.matcher(s).replaceAll("");
    }

    public static String ltrimToNull(String s) {
        String t = StrUtils.ltrim(s);
        return t == null || t.isEmpty() ? null : t;
    }

    public static String rtrim(String s) {
        return s == null ? null : RTRIMMER.matcher(s).replaceAll("");
    }

    public static String rtrimToNull(String s) {
        String t = StrUtils.rtrim(s);
        return t == null || t.isEmpty() ? null : t;
    }

    public static String toString(Object obj) {
        return obj == null ? null : (obj instanceof String ? (String)obj : obj.toString());
    }

    public static boolean allAreBlank(String ... strings) {
        for (String string : strings) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            return false;
        }
        return true;
    }

    public static boolean noneIsBlank(String ... strings) {
        for (String string : strings) {
            if (!StringUtils.isBlank((String)string)) continue;
            return false;
        }
        return true;
    }

    public static boolean notAllAreBlank(String ... strings) {
        return !StrUtils.allAreBlank(strings);
    }

    public static boolean oneIsBlank(String ... strings) {
        return !StrUtils.noneIsBlank(strings);
    }

    public static boolean equalsAny(String string, String strings) {
        return string != null && strings != null && string.equals(strings);
    }

    public static boolean equalsAny(String string, String ... strings) {
        return string != null && strings != null && ArrayUtils.contains((Object[])strings, (Object)string);
    }

    public static String[] blankless(String ... strings) {
        List<String> list = StrUtils.blankless(Arrays.asList(strings));
        return list.toArray((String[])ArrUtils.arrayOf(String.class));
    }

    public static Set<String> blankless(Set<String> strings) {
        List<String> list = StrUtils.blankless(new ArrayList<String>(strings));
        return new LinkedHashSet<String>(list);
    }

    public static List<String> blankless(List<String> strings) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : strings) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            list.add(string);
        }
        return list;
    }

    public static String coalesce(String ... strings) {
        for (String string : strings) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            return string.trim();
        }
        return null;
    }

    public static String coalesceToDefault(String defaultString, String strings) {
        String string = StrUtils.coalesce(strings);
        return string == null ? defaultString : string;
    }

    public static String coalesceToDefault(String defaultString, String ... strings) {
        String string = StrUtils.coalesce(strings);
        return string == null ? defaultString : string;
    }

    public static String coalesceToEmpty(String strings) {
        String string = StrUtils.coalesce(strings);
        return string == null ? "" : string;
    }

    public static String coalesceToEmpty(String ... strings) {
        String string = StrUtils.coalesce(strings);
        return string == null ? "" : string;
    }

    public static String coalesceToNull(String strings) {
        String string = StrUtils.coalesce(strings);
        return string == null ? Bundle.getString("null_value.string") : string;
    }

    public static String coalesceToNull(String ... strings) {
        String string = StrUtils.coalesce(strings);
        return string == null ? Bundle.getString("null_value.string") : string;
    }

    public static String getLongNumericKey(String string) {
        return StringUtils.isBlank((String)string) ? "?" : StrUtils.getLongNumericKeyCode(StrUtils.getHumplessCase(string, '_'));
    }

    public static String getLongNumericCode(String string) {
        return StringUtils.isBlank((String)string) ? null : StrUtils.getLongNumericKeyCode(string);
    }

    public static String getLongNumericKeyCode(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return SQL_ID_HASH_PKEY_VALUE ? "" + StrUtils.getLongHashCode(string) : StrUtils.longNumericCode(string);
    }

    private static String longNumericCode(String string) {
        int m;
        String clean = string.trim();
        String first = StrUtils.firstDigit(clean);
        String numst = StrUtils.getNumericString(clean);
        String digit = "" + Damm.digit(numst);
        int l = clean.length();
        int d = l < (m = 13) ? l : m;
        int w = l / d;
        int r = l % d;
        int beginIndex = 0;
        Object digits = "";
        for (int i = 0; i < d; ++i) {
            int x = i < r ? w + 1 : w;
            int endIndex = beginIndex + x;
            String chunk = clean.substring(beginIndex, endIndex);
            digits = (String)digits + Damm.digit(StrUtils.getNumericString(chunk));
            beginIndex = endIndex;
        }
        char[] chars = clean.toCharArray();
        int sum = 0;
        for (char c : chars) {
            sum += c;
        }
        if (m > beginIndex) {
            String filler = "" + (long)X2MDD * (long)sum / (long)m;
            digits = (String)digits + filler.substring(0, m - beginIndex);
        }
        return first + (String)digits + digit + String.format("%04d", sum % 10000);
    }

    private static String firstDigit(String string) {
        char c = Character.toUpperCase(string.charAt(0));
        int i = StrUtils.digitBetweenZeroAndEight(c);
        return "" + i;
    }

    private static int digitBetweenZeroAndEight(char c) {
        return c < 'A' ? 0 : (c < 'D' ? 1 : (c < 'G' ? 2 : (c < 'J' ? 3 : (c < 'M' ? 4 : (c < 'P' ? 5 : (c < 'T' ? 6 : (c < 'W' ? 7 : (c > 'Z' ? 0 : 8))))))));
    }

    public static char firstWordCase(String string) {
        if (string == null || string.isEmpty()) {
            return '?';
        }
        boolean lc = false;
        boolean uc = false;
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c)) {
                lc |= Character.isLowerCase(c);
                uc |= Character.isUpperCase(c);
                continue;
            }
            if (c != '-' && c != '_' && !Character.isDigit(c)) break;
            return 'X';
        }
        return (char)(lc && uc ? 77 : (lc ? 76 : (uc ? 85 : 88)));
    }

    public static String getRandomString() {
        return StrUtils.getRandomString(0);
    }

    public static String getRandomString(int length) {
        String uuid = UUID.randomUUID().toString().toUpperCase().replaceAll("-", "");
        int endIndex = length < 1 || length > uuid.length() ? uuid.length() : length;
        return uuid.substring(0, endIndex);
    }

    public static String getSimpleString(Object obj) {
        String type = obj == null ? "" : "<" + obj.getClass().getSimpleName() + ">";
        return type + StrUtils.getString(obj);
    }

    public static String getString(int n, char c) {
        Object string = "";
        for (int i = 0; i < n; ++i) {
            string = (String)string + c;
        }
        return string;
    }

    public static String getString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Clob) {
            return StrUtils.getSubString((Clob)obj);
        }
        if (obj instanceof Date) {
            return TimeUtils.defaultString((Date)obj);
        }
        return obj.toString();
    }

    public static String getSubString(Clob clob) {
        try {
            long length = clob.length();
            if (length > 32767L) {
                return null;
            }
            return clob.getSubString(1L, (int)length);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getStringDelimitado(Object obj) {
        String string = StrUtils.getString(obj);
        if (string == null) {
            return null;
        }
        if (obj instanceof String) {
            return "'" + string + "'";
        }
        return string;
    }

    public static String getStringNoDelimitado(String delimitado) {
        String string = delimitado;
        if (string == null) {
            return string;
        }
        if (string.startsWith("'") && string.endsWith("'") || string.startsWith("(") && string.endsWith(")") || string.startsWith("[") && string.endsWith("]") || string.startsWith("{") && string.endsWith("}") || string.startsWith("<") && string.endsWith(">") || string.startsWith("\u00a1") && string.endsWith("!") || string.startsWith("\u00bf") && string.endsWith("?")) {
            string = string.substring(1, string.length() - 1).trim();
        }
        return string;
    }

    public static String getStringParametrizado(String patron, Object ... argumentos) {
        if (StringUtils.isBlank((String)patron)) {
            return null;
        }
        ArrayList<String> objetos = new ArrayList<String>();
        for (Object arg : argumentos) {
            objetos.add(StringUtils.trimToEmpty((String)StrUtils.getString(arg)));
        }
        return MessageFormat.format(patron, objetos.toArray());
    }

    public static String getStringStandard(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return NumUtils.format((Number)obj, Locale.US);
        }
        if (obj instanceof Date) {
            return TimeUtils.jdbcString((Date)obj);
        }
        return obj.toString();
    }

    public static String getStringSql(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return TimeUtils.jdbcString((Date)obj);
        }
        return obj.toString();
    }

    public static String getStringSqlDelimitado(Object obj) {
        String string = StrUtils.getStringSql(obj);
        if (string == null) {
            return null;
        }
        if (obj instanceof String) {
            return "'" + string + "'";
        }
        if (obj instanceof Date) {
            return "'" + string + "'";
        }
        return string;
    }

    public static String getStringSqlNoDelimitado(Object obj) {
        return StrUtils.getStringNoDelimitado(StrUtils.getStringSql(obj));
    }

    public static String getStringSqlParametrizado(String patron, Object ... argumentos) {
        if (StringUtils.isBlank((String)patron)) {
            return null;
        }
        ArrayList<String> objetos = new ArrayList<String>();
        for (Object arg : argumentos) {
            objetos.add(StringUtils.trimToEmpty((String)StrUtils.getStringSql(arg)));
        }
        return MessageFormat.format(patron, objetos.toArray());
    }

    public static String getString(ResourceBundle resourceBundle, String key) {
        return StrUtils.getString(resourceBundle, key, null, null);
    }

    public static String getString(ResourceBundle resourceBundle, String key, String left, String right) {
        if (resourceBundle == null || StringUtils.isBlank((String)key)) {
            return null;
        }
        try {
            return StrUtils.getNullStringWhenBlankOrEqualsToKey(resourceBundle.getString(key), key, left, right);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String getString(String equals, String separator, String open, String close, Object object) {
        if (ObjUtils.isBlank(object)) {
            return "";
        }
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            return StrUtils.getString(equals, separator, open, close, array);
        }
        if (object instanceof KVP) {
            KVP value = (KVP)object;
            return value.toString(equals, separator, open, close);
        }
        if (object instanceof String) {
            String value = (String)object;
            return StringUtils.trimToEmpty((String)value);
        }
        return StringUtils.trimToEmpty((String)object.toString());
    }

    public static String getString(String equals, String separator, String open, String close, Object ... objects) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object object : objects) {
            if (object == null) continue;
            strings.add(StrUtils.getString(equals, separator, open, close, object));
        }
        return StrUtils.enclose(StringUtils.join(strings, (String)separator), open, close);
    }

    public static String getNullStringWhenBlankOrEqualsToKey(String string, String key) {
        return StrUtils.getNullStringWhenBlankOrEqualsToKey(string, key, null, null);
    }

    public static String getNullStringWhenBlankOrEqualsToKey(String string, String key, String left, String right) {
        String s = StringUtils.trimToEmpty((String)string);
        String k = StringUtils.trimToEmpty((String)key);
        String l = StringUtils.trimToEmpty((String)left);
        String r = StringUtils.trimToEmpty((String)right);
        return StringUtils.isBlank((String)s) || s.equals(k) ? null : l + s + r;
    }

    public static boolean esIdentificadorSqlValido(String string) {
        return StringUtils.isNotBlank((String)string) && esIdentificadorSqlValido.matcher(string).matches();
    }

    public static boolean esIdentificadorArchivoValido(String string) {
        return StringUtils.isNotBlank((String)string) && esIdentificadorArchivoValido.matcher(string).matches();
    }

    public static String getIdentificadorSql(String string, int maxLength) {
        return StrUtils.getIdentificadorSql(null, string, null, maxLength);
    }

    public static String getIdentificadorSql(String prefix, String string, String suffix, int maxLength) {
        if (StringUtils.isBlank((String)string)) {
            return string;
        }
        if (SQL_ID_INFO) {
            StrUtils.infoIdentificadorSql(prefix, string, suffix, maxLength);
        }
        return StrUtils.getIdentificadorSql(prefix, string, suffix, maxLength, SQL_ID_HASH_CODE_AFFIX, SQL_ID_WARN);
    }

    private static String getIdentificadorSql(String prefix, String string, String suffix, int maxLength, boolean alpha) {
        return StrUtils.getIdentificadorSql(prefix, string, suffix, maxLength, alpha, false);
    }

    private static String getIdentificadorSql(String prefix, String string, String suffix, int maxLength, boolean alpha, boolean warn) {
        String endlessString;
        char separator = string.contains("$") ? (char)'$' : '_';
        String trimmedPrefix = StringUtils.trimToEmpty((String)prefix);
        String trimmedString = StringUtils.trimToEmpty((String)string);
        String trimmedSuffix = StringUtils.trimToEmpty((String)suffix);
        String shorterString = endlessString = trimmedPrefix + trimmedString + trimmedSuffix;
        if (maxLength > 0 && shorterString.length() > maxLength) {
            int averageChunkLength;
            String numericCode = separator + StrUtils.infijoIdentificadorSql(trimmedString, alpha, separator);
            String[] chunks = StringUtils.split((String)trimmedString, (char)separator);
            Object[] shorterChunks = new String[chunks.length];
            int chunkCount = chunks.length;
            int separators = chunkCount - 1;
            int available1 = maxLength - trimmedPrefix.length() - numericCode.length() - trimmedSuffix.length();
            int available2 = available1 - separators;
            int n = averageChunkLength = chunkCount > 1 ? available2 / chunkCount : available1;
            if (available1 > 0 && available2 > 0 && averageChunkLength > 0) {
                int chunkLength;
                String chunk;
                int overAverageChunkCount = 0;
                int lastOverAverageChunkIndex = 0;
                int used = 0;
                for (int i = 0; i < chunks.length; ++i) {
                    chunk = chunks[i];
                    chunkLength = chunk.length();
                    if (chunkLength > averageChunkLength) {
                        ++overAverageChunkCount;
                        lastOverAverageChunkIndex = i;
                        used += averageChunkLength;
                        continue;
                    }
                    used += chunkLength;
                }
                int free = available2 - used;
                int over = overAverageChunkCount == 0 ? 0 : Long.valueOf(Math.round((double)free / (double)overAverageChunkCount)).intValue();
                for (int i = 0; i < chunks.length; ++i) {
                    int size;
                    chunk = chunks[i];
                    chunkLength = chunk.length();
                    if (chunkLength > averageChunkLength) {
                        int plus;
                        int n2 = plus = averageChunkLength + over > chunkLength ? chunkLength - averageChunkLength : over;
                        if (i == lastOverAverageChunkIndex) {
                            size = averageChunkLength + free;
                            free = 0;
                        } else if (free < plus) {
                            size = averageChunkLength;
                        } else {
                            size = averageChunkLength + plus;
                            free -= plus;
                        }
                    } else {
                        size = chunkLength;
                    }
                    shorterChunks[i] = chunk.contains("_") ? StrUtils.getElementoIdentificadorSql(chunk, Math.min(size, chunkLength)) : chunk.substring(0, Math.min(size, chunkLength));
                }
                shorterString = trimmedPrefix + StringUtils.join((Object[])shorterChunks, (char)separator) + numericCode + trimmedSuffix;
            } else {
                shorterString = available1 > 0 ? trimmedPrefix + trimmedString.substring(0, available1) + numericCode + trimmedSuffix : (trimmedPrefix.isEmpty() ? StringUtils.remove((String)numericCode, (char)separator) + trimmedSuffix : trimmedPrefix + numericCode + trimmedSuffix);
            }
        }
        if (warn) {
            StrUtils.warnIdentificadorSql(endlessString, shorterString);
        }
        return shorterString;
    }

    private static String getElementoIdentificadorSql(String string, int maxLength) {
        String trimmedString;
        if (StringUtils.isBlank((String)string)) {
            return string;
        }
        char separator = '_';
        String shorterString = trimmedString = StringUtils.trimToEmpty((String)string);
        if (maxLength > 0 && shorterString.length() > maxLength) {
            int averageChunkLength;
            String[] chunks = StringUtils.split((String)trimmedString, (char)separator);
            Object[] shorterChunks = new String[chunks.length];
            int chunkCount = chunks.length;
            int separators = chunkCount - 1;
            int available1 = maxLength;
            int available2 = available1 - separators;
            int n = averageChunkLength = chunkCount > 1 ? available2 / chunkCount : available1;
            if (available1 > 0 && available2 > 0 && averageChunkLength > 0) {
                int chunkLength;
                String chunk;
                int overAverageChunkCount = 0;
                int lastOverAverageChunkIndex = 0;
                int used = 0;
                for (int i = 0; i < chunks.length; ++i) {
                    chunk = chunks[i];
                    chunkLength = chunk.length();
                    if (chunkLength > averageChunkLength) {
                        ++overAverageChunkCount;
                        lastOverAverageChunkIndex = i;
                        used += averageChunkLength;
                        continue;
                    }
                    used += chunkLength;
                }
                int free = available2 - used;
                int over = overAverageChunkCount == 0 ? 0 : Long.valueOf(Math.round((double)free / (double)overAverageChunkCount)).intValue();
                for (int i = 0; i < chunks.length; ++i) {
                    int size;
                    chunk = chunks[i];
                    chunkLength = chunk.length();
                    if (chunkLength > averageChunkLength) {
                        int plus;
                        int n2 = plus = averageChunkLength + over > chunkLength ? chunkLength - averageChunkLength : over;
                        if (i == lastOverAverageChunkIndex) {
                            size = averageChunkLength + free;
                            free = 0;
                        } else if (free < plus) {
                            size = averageChunkLength;
                        } else {
                            size = averageChunkLength + plus;
                            free -= plus;
                        }
                    } else {
                        size = chunkLength;
                    }
                    shorterChunks[i] = chunk.substring(0, Math.min(size, chunkLength));
                }
                shorterString = StringUtils.join((Object[])shorterChunks, (char)separator);
            } else {
                shorterString = available1 > 0 ? trimmedString.substring(0, available1) : trimmedString.substring(0, maxLength);
            }
        }
        return shorterString;
    }

    private static String infijoIdentificadorSql(String string, boolean alpha, char separator) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return alpha ? StrUtils.sqlAlphanumericInfix(string, separator) : StrUtils.sqlNumericInfix(string);
    }

    private static String sqlAlphanumericInfix(String string, char separator) {
        return Integer.toString(StrUtils.getHashCode(string), 36).replace('-', separator);
    }

    private static int getHashCode(String string) {
        int h = 0;
        int l = string.length();
        if (l > 0) {
            char[] val = string.toCharArray();
            for (int i = 0; i < l; ++i) {
                h = 31 * h + val[i];
            }
        }
        return h;
    }

    private static long getLongHashCode(String string) {
        long h = 0L;
        long l = string.length();
        if (l > 0L) {
            char[] val = string.toCharArray();
            int i = 0;
            while ((long)i < l) {
                h = 31L * h + (long)val[i];
                ++i;
            }
        }
        return h;
    }

    private static String sqlNumericInfix(String string) {
        String num = StrUtils.getNumericString(string);
        int digit = Damm.digit(num);
        char[] chars = string.trim().toCharArray();
        int len = chars.length;
        int sum = 0;
        for (char c : chars) {
            sum += c;
        }
        return digit + String.format("%02d", len % 100) + String.format("%02d", sum % 100);
    }

    private static String getNumericString(String string) {
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        char[] chars = string.trim().toCharArray();
        Object num = "";
        char[] cArray = chars;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c;
            char i2 = c = cArray[i];
            num = (String)num + String.format("%03d", i2);
        }
        return num;
    }

    private static void infoIdentificadorSql(String prefix, String string, String suffix, int maxLength) {
        String trimmedPrefix = StringUtils.trimToEmpty((String)prefix);
        String trimmedString = StringUtils.trimToEmpty((String)string);
        String trimmedSuffix = StringUtils.trimToEmpty((String)suffix);
        String endlessString = trimmedPrefix + trimmedString + trimmedSuffix;
        String numericString = StrUtils.getIdentificadorSql(prefix, string, suffix, maxLength, false);
        String hashingString = StrUtils.getIdentificadorSql(prefix, string, suffix, maxLength, true);
        if (!(endlessString.equals(numericString) && endlessString.equals(hashingString) || setIdentificadorSql.contains(endlessString))) {
            setIdentificadorSql.add(endlessString);
            String loggingNumber = String.format("%04d", ++setIdentificadorSqlCount);
            String endlessLength = String.format("%03d", endlessString.length());
            logger.info((Object)(SQLTAG + loggingNumber + HT + endlessLength + " " + endlessString));
            logger.info((Object)("\t\t" + String.format("%03d", numericString.length()) + " " + numericString));
            logger.info((Object)("\t\t" + String.format("%03d", hashingString.length()) + " " + hashingString));
        }
    }

    private static void warnIdentificadorSql(String endless, String shorter) {
        if (!endless.equals(shorter) && !setIdentificadorSql.contains(endless)) {
            setIdentificadorSql.add(endless);
            String loggingNumber = String.format("%04d", ++setIdentificadorSqlCount);
            String endlessLength = String.format("%03d", endless.length());
            String shorterLength = String.format("%03d", shorter.length());
            logger.warn((Object)(SQLTAG + loggingNumber + HT + endlessLength + " " + endless));
            logger.warn((Object)("\t\t" + shorterLength + " " + shorter));
        }
    }

    public static String getIdentificadorSql(String string) {
        return string == null ? null : StrUtils.getIdentifier(string);
    }

    public static String getIdentificadorSqlLowerCase(String string) {
        return string == null ? null : StrUtils.getIdentificadorSql(string).toLowerCase();
    }

    public static String getIdentificadorSqlUpperCase(String string) {
        return string == null ? null : StrUtils.getIdentificadorSql(string).toUpperCase();
    }

    public static String getArtifactName(String string) {
        return StrUtils.getArtifactName(string, "_");
    }

    public static String getArtifactName(String string, char separator) {
        return StrUtils.getArtifactName(string, "" + separator);
    }

    public static String getArtifactName(String string, String separator) {
        if (string == null) {
            return null;
        }
        String sep = separator == null ? "_" : separator.replaceAll(INVALID_SEPARATOR, "_");
        String invalidCharactersRegex = "[^a-zA-Z0-9]";
        String severalSeparatorsRegex = sep.length() == 0 ? null : Pattern.quote(sep) + "+";
        String dhxless = StrUtils.dhxless(string, sep, true, false, true, invalidCharactersRegex, severalSeparatorsRegex);
        return dhxless;
    }

    public static String getIdentifier(String string) {
        return StrUtils.getIdentifier(string, "_");
    }

    public static String getIdentifier(String string, char separator) {
        return StrUtils.getIdentifier(string, "" + separator);
    }

    public static String getIdentifier(String string, String separator) {
        if (string == null) {
            return null;
        }
        String sep = separator == null ? "_" : separator.replaceAll(INVALID_SEPARATOR, "_");
        String invalidCharactersRegex = "[^a-zA-Z0-9]";
        String severalSeparatorsRegex = sep.length() == 0 ? null : Pattern.quote(sep) + "+";
        String dhxless = StrUtils.dhxless(string, sep, invalidCharactersRegex, severalSeparatorsRegex);
        return dhxless;
    }

    public static String getLowerCaseIdentifier(String string) {
        return string == null ? null : StrUtils.getLowerCaseIdentifier(string, "_");
    }

    public static String getLowerCaseIdentifier(String string, char separator) {
        return StrUtils.getLowerCaseIdentifier(string, "" + separator);
    }

    public static String getLowerCaseIdentifier(String string, String separator) {
        return string == null ? null : StrUtils.getHumplessCase(StrUtils.getIdentifier(string, separator), separator).toLowerCase();
    }

    public static String getUpperCaseIdentifier(String string) {
        return string == null ? null : StrUtils.getUpperCaseIdentifier(string, "_");
    }

    public static String getUpperCaseIdentifier(String string, char separator) {
        return StrUtils.getUpperCaseIdentifier(string, "" + separator);
    }

    public static String getUpperCaseIdentifier(String string, String separator) {
        return string == null ? null : StrUtils.getHumplessCase(StrUtils.getIdentifier(string, separator), separator).toUpperCase();
    }

    public static String getMavenIdentifier(String string) {
        String fileName = StrUtils.getFileName(string);
        return fileName == null ? null : (mavenIdentifierPattern.matcher(fileName).matches() ? fileName : "x" + fileName);
    }

    public static String getMavenVersion(String string) {
        String DEFAULT_VERSION = "1.0-SNAPSHOT";
        String fileName = StrUtils.getFileName(string, ".");
        return fileName == null ? null : (mavenVersionPattern.matcher(fileName).matches() ? fileName : "1.0-SNAPSHOT");
    }

    public static String getOracleVersionNumber(String string) {
        String version;
        String string2 = version = StringUtils.isBlank((String)string) ? null : string.trim().toLowerCase();
        if (version != null && oracleVersionPattern.matcher(version).matches()) {
            char c = version.charAt(version.length() - 1);
            int cn = c - 97 + 1;
            return version.replace(c, '.') + cn;
        }
        return version;
    }

    public static String getFileName(String string) {
        return StrUtils.getFileName(string, null);
    }

    public static String getFileName(String string, String separator) {
        if (string == null) {
            return null;
        }
        String defaultSeparator = "-";
        String escapedSeparator = "\\_\\-\\.";
        String invalidSeparator = "[^\\_\\-\\.]";
        String prefixSeparators = "^[\\_\\-\\.]+";
        String suffixSeparators = "[\\_\\-\\.]+$";
        String sep = separator == null ? "-" : separator.replaceAll("[^\\_\\-\\.]", "-");
        String invalidCharactersRegex = "[^\\w\\-\\.]";
        String severalSeparatorsRegex = Pattern.quote(sep) + "+";
        String dhxless = StrUtils.dhxless(string, sep, invalidCharactersRegex, severalSeparatorsRegex);
        String trimmed = dhxless.replaceAll("^[\\_\\-\\.]+", "").replaceAll("[\\_\\-\\.]+$", "");
        return trimmed;
    }

    public static String getPageName(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        String str1 = StringUtils.substringAfterLast((String)("/" + url.trim()), (String)"/");
        String str2 = StringUtils.substringBefore((String)str1, (String)".");
        return str2;
    }

    private static String dhxless(String string, String separator, String ... expressions) {
        return StrUtils.dhxless(string, separator, true, true, true, expressions);
    }

    private static String dhxless(String string, String separator, boolean diacriticless, boolean humpless, boolean edgeless, String ... expressions) {
        String h;
        assert (string != null);
        assert (separator != null);
        String s = separator.replaceAll(INVALID_SEPARATOR, "_");
        String t = string.trim();
        String d = diacriticless ? StrUtils.diacriticless(t) : t;
        String x = h = humpless ? StrUtils.getHumplessCase(d, s) : d;
        if (expressions != null && expressions.length > 0) {
            for (String regex : expressions) {
                if (regex == null) continue;
                x = x.replaceAll(regex, s);
            }
        }
        String dhxless = edgeless ? StringUtils.removeStart((String)StringUtils.removeEnd((String)x, (String)s), (String)s) : x;
        return dhxless;
    }

    private static boolean isLetterOrDigit(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public static String getQualifiedName(String name, String qualifier) {
        if (StringUtils.isNotBlank((String)name)) {
            String n = name.trim();
            if (StringUtils.isNotBlank((String)qualifier)) {
                String q = qualifier.trim();
                return q + "." + n;
            }
            return n;
        }
        return null;
    }

    public static String getUnqualifiedName(String name, String qualifier) {
        if (StringUtils.isNotBlank((String)name)) {
            String n = name.trim();
            if (StringUtils.isNotBlank((String)qualifier)) {
                String q = qualifier.trim();
                n = StringUtils.removeStart((String)n, (String)(q + "."));
            }
            return n;
        }
        return null;
    }

    public static String getQualifiedShortName(String name, String qualifier) {
        if (StringUtils.isNotBlank((String)name)) {
            String n = name.trim();
            if (StringUtils.isNotBlank((String)qualifier)) {
                String q = qualifier.trim();
                n = StringUtils.removeStart((String)n, (String)(q + "."));
                n = StringUtils.removeStart((String)n, (String)(q + "_"));
                n = StringUtils.removeEnd((String)n, (String)("_" + q));
                return q + "." + n;
            }
            return n;
        }
        return null;
    }

    public static String getUnqualifiedShortName(String name, String qualifier) {
        if (StringUtils.isNotBlank((String)name)) {
            String n = name.trim();
            if (StringUtils.isNotBlank((String)qualifier)) {
                String q = qualifier.trim();
                n = StringUtils.removeStart((String)n, (String)(q + "."));
                n = StringUtils.removeStart((String)n, (String)(q + "_"));
                n = StringUtils.removeEnd((String)n, (String)("_" + q));
            }
            return n;
        }
        return null;
    }

    public static boolean isASCII(char c) {
        return StrUtils.isASCII("" + c);
    }

    public static boolean isASCII(String string) {
        return StringUtils.isNotBlank((String)string) && string.equals(StrUtils.ascii(string));
    }

    public static String ascii(String string) {
        return StrUtils.ascii(string, "_");
    }

    public static String ascii(String string, char replacement) {
        return StrUtils.ascii(string, "" + replacement);
    }

    public static String ascii(String string, String replacement) {
        String invalidCharacters = "[^ -~]";
        if (string == null) {
            return null;
        }
        String valid = replacement == null ? "_" : replacement.replaceAll("[^ -~]", "_");
        String ascii = StringUtils.trimToEmpty((String)string).replaceAll("[^ -~]", valid);
        return ascii;
    }

    public static String diacriticless(String string) {
        String with = "\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff";
        String sans = "AAAAAACEEEEIIIINOOOOOUUUUYaaaaaaceeeeiiiinooooouuuuyy";
        String dless = string == null ? null : StringUtils.replaceChars((String)StringUtils.trimToEmpty((String)string), (String)"\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d9\u00da\u00db\u00dc\u00dd\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f9\u00fa\u00fb\u00fc\u00fd\u00ff", (String)"AAAAAACEEEEIIIINOOOOOUUUUYaaaaaaceeeeiiiinooooouuuuyy");
        return dless;
    }

    public static String diacriticlessAscii(String string) {
        return StrUtils.diacriticlessAscii(string, "_");
    }

    public static String diacriticlessAscii(String string, String replacement) {
        return StrUtils.ascii(StrUtils.diacriticless(string), replacement);
    }

    public static String getStringAscii(String string) {
        if (string == null) {
            return null;
        }
        byte[] bytes = StrUtils.diacriticlessAscii(string).getBytes();
        String ascii = new String(bytes, StandardCharsets.US_ASCII);
        return ascii;
    }

    public static String getStringUtf8(String string) {
        if (string == null) {
            return null;
        }
        byte[] bytes = StringUtils.trimToEmpty((String)string).getBytes();
        String utf_8 = new String(bytes, StandardCharsets.UTF_8);
        return utf_8;
    }

    public static String encode(String string) {
        return string == null ? null : URLEncoder.encode(string, StandardCharsets.UTF_8);
    }

    public static String decode(String string) {
        return string == null ? null : URLDecoder.decode(string, StandardCharsets.UTF_8);
    }

    public static String getCamelCase(String string) {
        return StrUtils.getCamelCase(string, null);
    }

    public static String getCamelCase(String string, String gap) {
        return StrUtils.getCamelCase(string, gap, false);
    }

    public static String getCamelCase(String string, boolean toLowerCaseLess) {
        return StrUtils.getCamelCase(string, null, toLowerCaseLess);
    }

    public static String getCamelCase(String string, String gap, boolean toLowerCaseLess) {
        if (string == null) {
            return null;
        }
        String x = string.trim();
        Object y = "";
        String z = StringUtils.isBlank((String)gap) ? "" : gap.trim();
        boolean b = false;
        boolean g = false;
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (StrUtils.isLetterOrDigit(c)) {
                if (b) {
                    y = (String)y + (g ? z : "");
                    y = (String)y + Character.toUpperCase(c);
                } else {
                    y = (String)y + (toLowerCaseLess ? c : Character.toLowerCase(c));
                }
                b = false;
                g = true;
                continue;
            }
            b = true;
        }
        return y;
    }

    public static String getLowerCamelCase(String string) {
        return StrUtils.getCamelCase(string);
    }

    public static String getUpperCamelCase(String string) {
        return StrUtils.getCamelCase("_" + string.trim());
    }

    public static String getSpaceCamelCase(String string) {
        return StrUtils.getCamelCase("_" + string.trim(), " ");
    }

    public static String getSnakeCase(String string) {
        return StrUtils.getHumplessCase(string);
    }

    public static String getSnakeCase(String string, char hump) {
        return StrUtils.getHumplessCase(string, hump);
    }

    public static String getSnakeCase(String string, String hump) {
        return StrUtils.getHumplessCase(string, hump);
    }

    public static String getLowerSnakeCase(String string) {
        return StrUtils.getLowerHumplessCase(string);
    }

    public static String getUpperSnakeCase(String string) {
        return StrUtils.getUpperHumplessCase(string);
    }

    public static String getHumplessCase(String string) {
        return StrUtils.getHumplessCase(string, '_');
    }

    public static String getHumplessCase(String string, char hump) {
        return StrUtils.getHumplessCase(string, "" + hump);
    }

    public static String getHumplessCase(String string, String hump) {
        if (string == null) {
            return null;
        }
        if (hump == null) {
            return null;
        }
        if (StrUtils.isNotMixedCase(string)) {
            return string;
        }
        String x = string.trim();
        Object y = "";
        boolean b = false;
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (Character.isUpperCase(c)) {
                if (b) {
                    y = (String)y + hump;
                }
                y = (String)y + Character.toLowerCase(c);
            } else {
                y = (String)y + c;
            }
            b = StrUtils.isLetterOrDigit(c);
        }
        return y;
    }

    public static String getLowerHumplessCase(String string) {
        String humpless = StrUtils.getHumplessCase(string);
        return humpless == null ? null : humpless.toLowerCase();
    }

    public static String getUpperHumplessCase(String string) {
        String humpless = StrUtils.getHumplessCase(string);
        return humpless == null ? null : humpless.toUpperCase();
    }

    public static boolean isMixedCase(String string) {
        return !StrUtils.isNotMixedCase(string);
    }

    public static boolean isNotMixedCase(String string) {
        if ((string = StringUtils.trimToEmpty((String)string)).isEmpty()) {
            return true;
        }
        if ((string = string.replaceAll("[^a-zA-Z]", "")).isEmpty()) {
            return true;
        }
        return StringUtils.isAllLowerCase((String)string) || StringUtils.isAllUpperCase((String)string);
    }

    public static String getWordyString(String string) {
        return StringUtils.isBlank((String)string) ? "" : (StrUtils.isMixedCase(string) ? StrUtils.getHumplessCase(string, ' ') : string.toLowerCase().replace('_', ' ').replaceAll(" +", " ").trim());
    }

    public static String getUnderscoreless(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().replace('_', ' ');
    }

    public static String getStringHtml(String string) {
        return string == null ? null : StringEscapeUtils.escapeHtml((String)string);
    }

    public static String getStringJava(String string) {
        return string == null ? null : StringEscapeUtils.escapeJava((String)string).replace("\\/", "/");
    }

    public static String getStringXml(String string) {
        return string == null ? null : StringEscapeUtils.escapeXml((String)string);
    }

    public static String escapeBundleKey(String string) {
        return string == null ? null : string.trim().replace(" ", "\\ ").replace("=", "\\=").replace(":", "\\:");
    }

    public static String escapeMeta(String string) {
        char[] meta = new char[]{'\\', '^', '$', '.', '*', '+', '?', '|', '-', '&', '{', '}', '[', ']', '(', ')', '<', '>'};
        if (StringUtils.containsAny((String)string, (char[])meta)) {
            for (char c : meta) {
                String s = String.valueOf(c);
                if (!string.contains(s)) continue;
                string = string.replace(s, "\\" + s);
            }
        }
        return string;
    }

    public static String escapeDoubleQuotes(String string) {
        return StringUtils.replace((String)string, (String)DQ, (String)dq);
    }

    public static String escapeSlashedChars(String string) {
        return StringUtils.isBlank((String)string) ? string : StringUtils.replaceEach((String)string, (String[])slashedChars, (String[])replacements).trim();
    }

    public static String getToken(String string) {
        return StrUtils.getToken(string, 0);
    }

    public static String getToken(String string, int index) {
        return StrUtils.getToken(string, index, " ");
    }

    public static String getToken(String string, String regex) {
        return StrUtils.getToken(string, 0, regex);
    }

    public static String getToken(String string, int index, String regex) {
        if (string == null) {
            return null;
        }
        String[] tokens = string.split(regex);
        return tokens == null || tokens.length == 0 ? string : (index < tokens.length ? tokens[index] : tokens[tokens.length - 1]);
    }

    public static String getPatronParametrizado(String string) {
        String patron = StringUtils.trimToEmpty((String)string);
        String[] subs = StringUtils.substringsBetween((String)patron, (String)"{", (String)"}");
        int i = 0;
        for (String sub : subs) {
            patron = patron.replace("{" + sub + "}", "{" + i++ + "}");
        }
        return patron;
    }

    public static String[] getParametros(String string) {
        return StringUtils.substringsBetween((String)string, (String)"{", (String)"}");
    }

    public static Object getObjeto(String string) {
        String substr;
        String cadena = StringUtils.trimToNull((String)string);
        if (cadena == null) {
            return null;
        }
        Object objeto = null;
        if (StringUtils.isNumeric((String)StringUtils.removeStart((String)cadena, (String)"-")) && (objeto = StrUtils.getObjeto(cadena, Integer.class)) == null) {
            objeto = StrUtils.getObjeto(cadena, Long.class);
        }
        if (objeto == null && cadena.startsWith(Bundle.getString("id_prefix.string")) && StringUtils.isNumeric((String)StringUtils.removeStart((String)(substr = cadena.substring(1)), (String)"-"))) {
            objeto = StrUtils.getObjeto(substr, Long.class);
        }
        if (objeto == null) {
            objeto = StrUtils.getObjeto(cadena, BigDecimal.class);
        }
        if (objeto == null) {
            objeto = StrUtils.getObjeto(cadena, Date.class);
        }
        if (objeto == null) {
            objeto = StrUtils.getObjeto(cadena, String.class);
        }
        return objeto;
    }

    public static Object getObjeto(String string, String clazz) {
        if (StringUtils.isNotBlank((String)string)) {
            try {
                return StrUtils.getObjeto(string, Class.forName(clazz));
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }
        return null;
    }

    public static Object getObjeto(String string, Class<?> clazz) {
        if (string == null || clazz == null) {
            return null;
        }
        try {
            String value = StringUtils.trimToNull((String)string);
            if (value == null) {
                return null;
            }
            if (Character.class.isAssignableFrom(clazz)) {
                return Character.valueOf(value.charAt(0));
            }
            if (String.class.isAssignableFrom(clazz)) {
                return string;
            }
            if (Boolean.class.isAssignableFrom(clazz)) {
                return BitUtils.toBoolean(value);
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return NumUtils.toByte(value);
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return NumUtils.toShort(value);
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return NumUtils.toInteger(value);
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return NumUtils.toLong(value);
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return NumUtils.toFloat(value);
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return NumUtils.toDouble(value);
            }
            if (BigInteger.class.isAssignableFrom(clazz)) {
                return NumUtils.toBigInteger(value);
            }
            if (BigDecimal.class.isAssignableFrom(clazz)) {
                return NumUtils.toBigDecimal(value);
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return TimeUtils.parse(value);
            }
        }
        catch (RuntimeException e) {
            return null;
        }
        return null;
    }

    public static char newline() {
        return '\n';
    }

    public static char tab() {
        return '\t';
    }

    public static String tabs(int n) {
        return StringUtils.repeat((String)HT, (int)n);
    }

    public static boolean isDelimited(String string, char delimiter) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String s = StringUtils.trimToEmpty((String)string);
        int j = 1;
        int k = 2 * j;
        int l = s.length();
        int n = l - j;
        if (l >= k && s.charAt(0) == delimiter && s.charAt(n) == delimiter) {
            return l == k || s.substring(j, n).indexOf(delimiter) < 0;
        }
        return false;
    }

    public static boolean isDelimited(String string, String delimiter) {
        if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)delimiter)) {
            return false;
        }
        String s = StringUtils.trimToEmpty((String)string);
        int j = delimiter.length();
        int k = 2 * j;
        int l = s.length();
        int n = l - j;
        if (l >= k && s.startsWith(delimiter) && s.endsWith(delimiter)) {
            return l == k || !s.substring(j, n).contains(delimiter);
        }
        return false;
    }

    public static boolean isDelimited(String string, char open, char close) {
        return StrUtils.isDelimited(string, open, close, null);
    }

    public static boolean isDelimited(String string, char open, char close, char ... quotes) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        if (open == close) {
            return StrUtils.isDelimited(string, open);
        }
        String r = StrUtils.quotedStringRegex(quotes);
        String s = StringUtils.trimToEmpty((String)string);
        if (r != null) {
            s = s.replaceAll(r, "");
        }
        int j = 1;
        int k = 2 * j;
        int l = s.length();
        int n = l - j;
        if (l >= k && s.charAt(0) == open && s.charAt(n) == close) {
            if (r != null) {
                int opened = 0;
                int closed = 0;
                for (int x = 0; x < l; ++x) {
                    if (s.charAt(x) == open) {
                        ++opened;
                    } else if (s.charAt(x) == close) {
                        ++closed;
                    }
                    if (opened > closed) continue;
                    return opened == closed && x == n;
                }
            } else {
                return l == k || s.substring(j, n).indexOf(open) < 0 && s.substring(j, n).indexOf(close) < 0;
            }
        }
        return false;
    }

    public static boolean isDelimited(String string, String open, String close) {
        return StrUtils.isDelimited(string, open, close, null);
    }

    public static boolean isDelimited(String string, String open, String close, char ... quotes) {
        if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)open) || StringUtils.isBlank((String)close)) {
            return false;
        }
        if (open.equals(close)) {
            return StrUtils.isDelimited(string, open);
        }
        String r = StrUtils.quotedStringRegex(quotes);
        String s = StringUtils.trimToEmpty((String)string);
        if (r != null) {
            s = s.replaceAll(r, "");
        }
        int i = open.length();
        int j = close.length();
        int k = i + j;
        int l = s.length();
        int n = l - j;
        if (l >= k && s.startsWith(open) && s.endsWith(close)) {
            if (r != null) {
                int opened = 0;
                int closed = 0;
                int x = 0;
                while (x < l) {
                    int y = s.indexOf(open, x);
                    int z = s.indexOf(close, x);
                    if (y >= x && y < z) {
                        ++opened;
                        x = y + open.length();
                    } else if (z >= x) {
                        ++closed;
                        x = z + close.length();
                    }
                    if (opened > closed) continue;
                    return opened == closed && x == l;
                }
            } else {
                return l == k || !s.substring(i, n).contains(open) && !s.substring(i, n).contains(close);
            }
        }
        return false;
    }

    private static String quotedStringRegex(char ... quotes) {
        return quotes == null || quotes.length == 0 ? null : "(?:([" + new String(quotes) + "])[^\u0000]*?\\1)";
    }

    public static String enclose(String argument) {
        return argument == null ? null : StrUtils.enclose(argument, '(', ')');
    }

    public static String enclose(String argument, char delimiter) {
        return argument == null ? null : (StrUtils.isDelimited(argument, delimiter) ? argument : delimiter + argument + delimiter);
    }

    public static String enclose(String argument, char open, char close) {
        return argument == null ? null : (StrUtils.isDelimited(argument, open, close) ? argument : open + argument + close);
    }

    public static String enclose(String argument, String delimiter) {
        return argument == null ? null : (StrUtils.isDelimited(argument, delimiter) ? argument : delimiter + argument + delimiter);
    }

    public static String enclose(String argument, String open, String close) {
        return argument == null ? null : (StrUtils.isDelimited(argument, open, close) ? argument : open + argument + close);
    }

    public static String disclose(String argument) {
        return argument == null ? null : StrUtils.disclose(argument, '(', ')');
    }

    public static String disclose(String argument, char delimiter) {
        return argument == null ? null : (StrUtils.isDelimited(argument, delimiter) ? argument.substring(1, argument.length() - 1) : argument);
    }

    public static String disclose(String argument, char open, char close) {
        return argument == null ? null : (StrUtils.isDelimited(argument, open, close) ? argument.substring(1, argument.length() - 1) : argument);
    }

    public static String disclose(String argument, String delimiter) {
        return argument == null ? null : (StrUtils.isDelimited(argument, delimiter) ? argument.substring(delimiter.length(), argument.length() - delimiter.length()) : argument);
    }

    public static String disclose(String argument, String open, String close) {
        return argument == null ? null : (StrUtils.isDelimited(argument, open, close) ? argument.substring(open.length(), argument.length() - close.length()) : argument);
    }

    public static String encloseSqlExpression(String expression) {
        return StringUtils.isBlank((String)expression) ? expression : (StrUtils.esSqlEntreParentesis(expression) || StrUtils.esIdentificadorSqlCalificado(expression) || StrUtils.esInvocacionFuncionSql(expression) ? expression : StrUtils.enclose(expression, '(', ')'));
    }

    public static String discloseSqlExpression(String expression) {
        return StringUtils.isBlank((String)expression) ? expression : (StrUtils.esSqlEntreParentesis(expression) ? expression.substring(1, expression.length() - 1) : expression);
    }

    private static boolean esIdentificadorSqlCalificado(String string) {
        return esIdentificadorSqlCalificado.matcher(string).matches();
    }

    private static boolean esSqlEntreParentesis(String string) {
        return StrUtils.isDelimited(string, '(', ')', SQL_QUOTES);
    }

    private static boolean esInvocacionFuncionSql(String string) {
        int i;
        if (StringUtils.isNotBlank((String)string) && (i = string.indexOf(40)) > 0) {
            String name = string.substring(0, i);
            String rest = string.substring(i);
            return StrUtils.esIdentificadorSqlCalificado(name) && StrUtils.esSqlEntreParentesis(rest);
        }
        return false;
    }

    public static String removeAfter(String text, String search, String preceding) {
        return StrUtils.removeBetween(text, search, preceding, null);
    }

    public static String removeBefore(String text, String search, String following) {
        return StrUtils.removeBetween(text, search, null, following);
    }

    public static String removeBetween(String text, String search, String preceding, String following) {
        return StrUtils.replaceBetween(text, search, "", preceding, following);
    }

    public static String replaceAfter(String text, String search, String replacement, String preceding) {
        return StrUtils.replaceBetween(text, search, replacement, preceding, null);
    }

    public static String replaceBefore(String text, String search, String replacement, String following) {
        return StrUtils.replaceBetween(text, search, replacement, null, following);
    }

    public static String replaceBetween(String text, String search, String replacement, String preceding, String following) {
        String turbofan = "\t\r\b\f\n";
        if (text != null && search != null && replacement != null && text.length() > 0 && search.length() > 0 && text.contains(search)) {
            boolean followed;
            boolean preceded;
            boolean bl = preceded = preceding != null && preceding.length() > 0;
            if (preceded && !text.contains(preceding)) {
                return text;
            }
            boolean bl2 = followed = following != null && following.length() > 0;
            if (followed && !text.contains(following)) {
                return text;
            }
            if (preceded || followed) {
                String substring;
                String inBetween;
                String beforeFollowing;
                String afterPreceding;
                String searchless = text.replace(search, "\t\r\b\f\n");
                String beforePreceding = preceded ? StringUtils.substringBefore((String)searchless, (String)preceding) : "";
                String string = afterPreceding = preceded ? StringUtils.substringAfter((String)searchless, (String)preceding) : "";
                String string2 = followed ? StringUtils.substringBefore((String)(preceded ? afterPreceding : searchless), (String)following) : (beforeFollowing = "");
                String afterFollowing = followed ? StringUtils.substringAfter((String)(preceded ? afterPreceding : searchless), (String)following) : "";
                String string3 = inBetween = preceded && followed ? StringUtils.substringBetween((String)searchless, (String)preceding, (String)following) : "";
                String string4 = preceded && followed ? inBetween : (substring = preceded ? afterPreceding : beforeFollowing);
                if (StringUtils.contains((String)substring, (String)"\t\r\b\f\n")) {
                    String string5 = substring.replace("\t\r\b\f\n", replacement);
                    String concat = beforePreceding + (preceded ? preceding : "") + string5 + (followed ? following : "") + afterFollowing;
                    String result = concat.replace("\t\r\b\f\n", search);
                    return result;
                }
            } else {
                return text.replace(search, replacement);
            }
        }
        return text;
    }

    public static String removeWords(String string, Class<?> dataType) {
        return StrUtils.removeWords(string, dataType, null);
    }

    public static String removeWords(String string, Class<?> dataType, String separator) {
        if (string == null || dataType == null) {
            return string;
        }
        string = StrUtils.removeWords(string, dataType, 'p', separator);
        string = StrUtils.removeWords(string, dataType, 's', separator);
        string = StrUtils.removeWords(string, dataType, '*', separator);
        return string;
    }

    public static String removeWords(String string, Class<?> dataType, char affixType) {
        return StrUtils.removeWords(string, dataType, affixType, null);
    }

    public static String removeWords(String string, Class<?> dataType, char affixType, String separator) {
        if (string == null || dataType == null) {
            return string;
        }
        String tag = affixType == 'p' ? "name.prefix" : (affixType == 's' ? "name.suffix" : "name.infix");
        String key = dataType.getSimpleName() + "." + tag;
        String remove = Bundle.getTrimmedToNullString(key);
        return remove == null ? string : StrUtils.removeWords(string, remove, affixType, separator);
    }

    public static String removeWords(String string, String remove) {
        return StrUtils.removeWords(string, remove, null);
    }

    public static String removeWords(String string, String remove, String separator) {
        if (string == null || remove == null) {
            return string;
        }
        string = StrUtils.removeWords(string, remove, 'p', separator);
        string = StrUtils.removeWords(string, remove, 's', separator);
        string = StrUtils.removeWords(string, remove, '*', separator);
        return string;
    }

    public static String removeWords(String string, String remove, char affixType) {
        return StrUtils.removeWords(string, remove, affixType, null);
    }

    public static String removeWords(String string, String remove, char affixType, String separator) {
        String[] tokens;
        if (string == null || remove == null) {
            return string;
        }
        String separatorChars = ", ";
        for (String token : tokens = StringUtils.split((String)remove, (String)separatorChars)) {
            remove = StrUtils.getWordyString(token);
            string = StrUtils.removeWholeWord(string, remove, affixType, separator);
        }
        return string;
    }

    public static String removeWholeWord(String string, String remove) {
        return StrUtils.removeWholeWord(string, remove, null);
    }

    public static String removeWholeWord(String string, String remove, String separator) {
        if (string == null || remove == null) {
            return string;
        }
        string = StrUtils.removeWholeWord(string, remove, 'p', separator);
        string = StrUtils.removeWholeWord(string, remove, 's', separator);
        string = StrUtils.removeWholeWord(string, remove, '*', separator);
        return string;
    }

    public static String removeWholeWord(String string, String remove, char affixType) {
        return StrUtils.removeWholeWord(string, remove, affixType, null);
    }

    public static String removeWholeWord(String string, String remove, char affixType, String separator) {
        if (separator == null) {
            separator = " ";
        }
        return string == null || remove == null ? string : (affixType == 'p' ? StringUtils.removeStart((String)string, (String)(remove + separator)) : (affixType == 's' ? StringUtils.removeEnd((String)string, (String)(separator + remove)) : StringUtils.replace((String)string, (String)(separator + remove + separator), (String)separator)));
    }

    public static String replaceOnceRepeatedly(String text, String searchString, Object ... replacements) {
        if (StringUtils.isBlank((String)text) || StringUtils.isBlank((String)searchString) || replacements == null || replacements.length == 0) {
            return text;
        }
        for (Object obj : replacements) {
            String replacement = StringUtils.trimToEmpty((String)StrUtils.getString(obj));
            text = StringUtils.replaceOnce((String)text, (String)searchString, (String)replacement);
        }
        return text;
    }
}

