/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.velocity;

import adalid.commons.ProjectObjectModel;
import adalid.commons.ProjectObjectModelReader;
import adalid.commons.TLB;
import adalid.commons.bundles.Bundle;
import adalid.commons.enums.LoggingLevel;
import adalid.commons.i18n.EnglishNoun;
import adalid.commons.interfaces.Programmer;
import adalid.commons.interfaces.ProjectWriter;
import adalid.commons.interfaces.SubjectProject;
import adalid.commons.interfaces.Wrappable;
import adalid.commons.interfaces.Wrapper;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.ArrUtils;
import adalid.commons.util.BitUtils;
import adalid.commons.util.CSVUtils;
import adalid.commons.util.FilUtils;
import adalid.commons.util.IntUtils;
import adalid.commons.util.LogUtils;
import adalid.commons.util.LongUtils;
import adalid.commons.util.ManUtils;
import adalid.commons.util.MarkupUtils;
import adalid.commons.util.NumUtils;
import adalid.commons.util.ObjUtils;
import adalid.commons.util.PlantUML;
import adalid.commons.util.RunUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.commons.util.TimeUtils;
import adalid.commons.velocity.VelocityAid;
import adalid.commons.velocity.VelocityEngineer;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.velocity.VelocityContext;

public class Writer {
    private static Level _alertLevel = Level.OFF;
    private static Level _disabledLevel = Level.OFF;
    private static Level _excludedLevel = Level.OFF;
    private static Level _preservedLevel = Level.OFF;
    private static Level _detailLevel = Level.OFF;
    private static Level _trackingLevel = Level.OFF;
    private static final Logger logger = Logger.getLogger(Writer.class);
    private static final String PLATFORM_VERSION = "version";
    private static final String PROJECT_OBJECT_MODEL = "project.object.model";
    private static final String PROJECT_VERSION_REQUIREMENT = "project.version.requirement";
    private static final String FILE_RESOURCE_LOADER_PATH = "file.resource.loader.path";
    private static final String FILE_RESOURCE_LOADER_PATH_FILTER = "file.resource.loader.path.filter";
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String HOME_DIR = System.getProperty("user.home");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String FILE_SEPARATOR_CHARS = "/\\";
    private static final String[] FILE_SEPARATOR_STRINGS = new String[]{"/", "\\"};
    private static final String EOL = "\n";
    private static final String HINT = "\nhint: ";
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String CARET = "^";
    private static final String DOLLAR = "$";
    private static final String ASTERISK = "*";
    private static final String DO_CREATE_DIR = "do.create.dir";
    private static final String DO_CASCADED_DELETE = "do.cascaded.delete";
    private static final String DO_ISOLATED_DELETE = "do.isolated.delete";
    private static final String DOT_STRING = ".string";
    private static final String DOT_CLASS = ".class";
    private static final String DOT_INSTANCE = ".instance";
    private static final String DOT_PROGRAMMER = ".programmer";
    private static final String DOT_WRAPPER = ".wrapper";
    private static final String[] DOT_SUFFIXES = new String[]{".string", ".class", ".instance", ".programmer", ".wrapper"};
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final FileFilter propertiesFileFilter = FilUtils.nameEndsWithFilter(".properties");
    private static final IOFileFilter ignoreVersionControlFilter = FileFilterUtils.makeCVSAware((IOFileFilter)FileFilterUtils.makeSVNAware(null));
    private static final ExtendedProperties bootstrapping = PropertiesHandler.getBootstrapping();
    private static final File bootstrappingRootFolder = PropertiesHandler.getRootFolder();
    private static final File[] bootstrappingVelocityFolders = PropertiesHandler.getVelocityFolders();
    private static final File bootstrappingVelocityPropertiesFile = PropertiesHandler.getVelocityPropertiesFile();
    private static final File[] bootstrappingPlatformsFolders = PropertiesHandler.getPlatformsFolders();
    private static final boolean bootstrappingRootFolderNotVisible = FilUtils.isNotVisibleDirectory(bootstrappingRootFolder);
    private static final boolean bootstrappingVelocityPropertiesFileNotVisible = FilUtils.isNotVisibleFile(bootstrappingVelocityPropertiesFile);
    private static final boolean WINDOWS = StringUtils.containsIgnoreCase((String)OS_NAME, (String)"windows");
    private static final String TP_DISABLED = "disabled";
    private static final String TP_DISABLED_MISSING = "disabled-when-missing";
    private static final String TP_DISABLED_FOREIGN = "disabled-when-foreign";
    private static final String TP_DISABLED_PRIVATE = "disabled-when-private";
    private static final String TP_TEMPLATE = "template";
    private static final String TP_TYPE = "template-type";
    private static final String TP_TYPE_DOCUMENT = "document";
    private static final String TP_TYPE_VELOCITY = "velocity";
    private static final String[] TP_TYPE_ARRAY = new String[]{"document", "velocity"};
    private static final String TP_PATH = "path";
    private static final String TP_PACKAGE = "package";
    private static final String TP_FILE = "file";
    private static final String TP_PRESERVE = "preserve";
    private static final String TP_ENCODING = "template-encoding";
    private static final String TP_CHARSET = "file-encoding";
    private static final String TP_EXECUTE_COMMAND = "execute-" + (WINDOWS ? "windows" : "linux") + "-command";
    private static final String TP_EXECUTE_DIRECTORY = "execute-directory";
    private static final String TP_PROCESS_FILE_METHOD = "process-file-method";
    private static final String TP_FOR_EACH = "for-each";
    private static final String VC_PLATFORM = "platform";
    private static final String VC_PLATFORM_PROPERTIES = "platformProperties";
    private static final String VC_TEMPLATE = "template";
    private static final String VC_TEMPLATE_NAME = "templateName";
    private static final String VC_TEMPLATE_PATH = "templatePath";
    private static final String VC_TEMPLATE_TYPE = "templateType";
    private static final String VC_PATH = "path";
    private static final String VC_PACKAGE = "package";
    private static final String VC_FILE = "file";
    private static final String VC_FILE_ENCODING = "fileEncoding";
    private static final String VC_FILE_PRESERVE = "filePreserve";
    private static final String VC_BOOTSTRAPPING = "bootstrapping";
    private static final String VC_BUILD_DATE = "buildDate";
    private static final String VC_BUILD_TIMESTAMP = "buildTimestamp";
    private static final String VC_LINGUIST = "linguist";
    private static final String VC_VELOCITY_WRITER = "velocityWriter";
    private static final String VC_ROOT_PATH = "rootFolderPath";
    private static final String VC_ROOT_SLASHED_PATH = "rootFolderSlashedPath";
    private static final String VC_USER_PATH = "userFolderPath";
    private static final String VC_USER_SLASHED_PATH = "userFolderSlashedPath";
    private static final String VC_HOME_PATH = "homeFolderPath";
    private static final String VC_HOME_SLASHED_PATH = "homeFolderSlashedPath";
    private static final String VC_BASE_NAME = "baseFolderName";
    private static final String VC_BASE_PATH = "baseFolderPath";
    private static final String VC_BASE_SLASHED_PATH = "baseFolderSlashedPath";
    private static final String VC_FILE_PATH = "filePath";
    private static final String VC_FILE_NAME = "fileName";
    private static final String VC_FILE_PATH_NAME = "filePathName";
    private static final String VC_FILE_PATH_FILE = "filePathFile";
    private static final String VC_FILE_SLASHED_PATH = "fileSlashedPath";
    private Object subject;
    private String subjectKey;
    private String plataforma = "?";
    private int platforms = 0;
    private int templates = 0;
    private int disabledTemplates = 0;
    private int excludedFiles = 0;
    private int preservedFiles = 0;
    private int copiedFiles = 0;
    private int mergedFiles = 0;
    private int alerts = 0;
    private int warnings = 0;
    private int errors = 0;
    private List<Pattern> fileExclusionPatterns;
    private List<Pattern> filePreservationPatterns;
    private Set<String> availableResourceNames;
    private Set<String> foreignResourceNames;
    private Set<String> privateResourceNames;

    public static Level getAlertLevel() {
        return _alertLevel;
    }

    public static void setAlertLevel(Level level) {
        _excludedLevel = _preservedLevel = LogUtils.check(level, Level.WARN, Level.WARN);
        _disabledLevel = _preservedLevel;
        _alertLevel = _preservedLevel;
    }

    public static Level getDetailLevel() {
        return _detailLevel;
    }

    public static void setDetailLevel(Level level) {
        _detailLevel = LogUtils.check(level, Level.OFF, Level.INFO);
    }

    public static Level getTrackingLevel() {
        return _trackingLevel;
    }

    public static void setTrackingLevel(Level level) {
        _trackingLevel = LogUtils.check(level, Level.OFF, Level.INFO);
    }

    public static LoggingLevel getAlertLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_alertLevel);
    }

    public static void setAlertLoggingLevel(LoggingLevel logginglevel) {
        Writer.setAlertLevel(logginglevel.getLevel());
    }

    public static LoggingLevel getDetailLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_detailLevel);
    }

    public static void setDetailLoggingLevel(LoggingLevel logginglevel) {
        Writer.setDetailLevel(logginglevel.getLevel());
    }

    public static LoggingLevel getTrackingLoggingLevel() {
        return LoggingLevel.getLoggingLevel(_trackingLevel);
    }

    public static void setTrackingLoggingLevel(LoggingLevel logginglevel) {
        Writer.setTrackingLevel(logginglevel.getLevel());
    }

    public Object getSubject() {
        return this.subject;
    }

    ProjectWriter getProjectWriter() {
        return this.subject instanceof ProjectWriter ? (ProjectWriter)this.subject : null;
    }

    SubjectProject getSubjectProject() {
        return this.subject instanceof SubjectProject ? (SubjectProject)this.subject : null;
    }

    public String getSubjectKey() {
        return this.subjectKey;
    }

    public List<Pattern> getFileExclusionPatterns() {
        return this.fileExclusionPatterns;
    }

    public void setFileExclusionPatterns(List<Pattern> fileExclusionPatterns) {
        this.fileExclusionPatterns = fileExclusionPatterns;
    }

    public List<Pattern> getFilePreservationPatterns() {
        return this.filePreservationPatterns;
    }

    public void setFilePreservationPatterns(List<Pattern> filePreservationPatterns) {
        this.filePreservationPatterns = filePreservationPatterns;
    }

    public Set<String> getAvailableResourceNames() {
        return this.availableResourceNames;
    }

    public void setAvailableResourceNames(Set<String> availableResourceNames) {
        this.availableResourceNames = availableResourceNames;
    }

    public Set<String> getForeignResourceNames() {
        return this.foreignResourceNames;
    }

    public void setForeignResourceNames(Set<String> foreignResourceNames) {
        this.foreignResourceNames = foreignResourceNames;
    }

    public Set<String> getPrivateResourceNames() {
        return this.privateResourceNames;
    }

    public void setPrivateResourceNames(Set<String> privateResourceNames) {
        this.privateResourceNames = privateResourceNames;
    }

    public Writer() {
        this(null, null);
    }

    public Writer(Object subject) {
        this(subject, null);
    }

    public Writer(Object subject, String subjectKey) {
        this.subject = subject == null ? this : subject;
        this.subjectKey = StringUtils.isBlank((String)subjectKey) ? StringUtils.uncapitalize((String)this.subject.getClass().getSimpleName()) : subjectKey.trim();
        logger.info((Object)(subjectKey + "=" + subject));
    }

    public boolean write(String platform) {
        this.log(Level.INFO, "write", "platform=" + platform);
        this.resetCounters();
        if (this.isInvalidBootstrapping()) {
            return false;
        }
        ProjectWriter projectWriter = this.getProjectWriter();
        if (projectWriter != null && !projectWriter.beforeWriting()) {
            logger.error((Object)"generation aborted due to previous errors");
            return false;
        }
        String platformPropertiesFileName = platform + PROPERTIES_SUFFIX;
        for (File bootstrappingPlatformsFolder : bootstrappingPlatformsFolders) {
            File platformPropertiesFile = new File(bootstrappingPlatformsFolder, platformPropertiesFileName);
            if (!FilUtils.isVisibleFile(platformPropertiesFile)) continue;
            if (!this.checkPlatform(platformPropertiesFile)) {
                return false;
            }
            WriterContext basicWriterContext = this.newWriterContext();
            this.writePlatform(basicWriterContext, platformPropertiesFile);
            return this.errors == 0;
        }
        logger.error((Object)("platform properties file " + platformPropertiesFileName + " is missing or invalid"));
        ++this.errors;
        return false;
    }

    private boolean checkPlatform(File platformPropertiesFile) {
        Object versionEnumeration;
        ProjectObjectModelReader pom;
        Properties properties = PropertiesHandler.loadProperties(platformPropertiesFile);
        String propertiesFilePath = platformPropertiesFile.getPath();
        String platform = StringUtils.removeEndIgnoreCase((String)platformPropertiesFile.getName(), (String)PROPERTIES_SUFFIX);
        String platformVersion = properties.getProperty(PLATFORM_VERSION);
        String projectObjectModel = properties.getProperty(PROJECT_OBJECT_MODEL);
        String projectVersionRequirement = properties.getProperty(PROJECT_VERSION_REQUIREMENT);
        if (StringUtils.isBlank((String)projectVersionRequirement)) {
            logger.info((Object)"platform requires no specific version of ADALID");
            return true;
        }
        if (StringUtils.isBlank((String)projectObjectModel)) {
            pom = new ProjectObjectModel();
        } else {
            String hint = "\nhint: check property \"{0}\" at file \"{1}\"";
            String pattern = "failed to initialise {2}" + hint;
            String message = MessageFormat.format(pattern, PROJECT_OBJECT_MODEL, propertiesFilePath, projectObjectModel);
            Object obj = this.getNewInstanceForName(projectObjectModel, message);
            if (obj instanceof ProjectObjectModelReader) {
                pom = (ProjectObjectModelReader)obj;
            } else {
                logger.error((Object)message);
                ++this.errors;
                return false;
            }
        }
        String projectName = pom.getProjectName();
        String projectVersion = pom.getProjectVersion();
        String paddedProjectVersion = StringUtils.substringBefore((String)projectVersion, (String)"-") + ".0.0";
        String projectMajor = StringUtils.substringBefore((String)paddedProjectVersion, (String)DOT);
        String projectMinor = StringUtils.substringBetween((String)paddedProjectVersion, (String)DOT);
        String paddedProjectVersionRequirement = StringUtils.substringBefore((String)projectVersionRequirement, (String)"-") + ".0.0";
        String projectMajorRequirement = StringUtils.substringBefore((String)paddedProjectVersionRequirement, (String)DOT);
        String projectMinorRequirement = StringUtils.substringBetween((String)paddedProjectVersionRequirement, (String)DOT);
        String pattern1 = "platform {0} {1} requires {2} {3}";
        String pattern2 = "{2} {4} fails to meet the version requirement: major and/or minor versions mismatch";
        String pattern3 = "{2} {4} matches the required version";
        String pattern4 = "{2} {4} meets the version requirement";
        String pattern5 = "{2} {4} fails to meet the version requirement";
        ComparableVersion suppliedVersion = new ComparableVersion(projectVersion);
        ComparableVersion requiredVersion = new ComparableVersion(projectVersionRequirement);
        ComparableVersion suppliedMajorMinorVersion = new ComparableVersion(projectMajor + DOT + projectMinor);
        ComparableVersion requiredMajorMinorVersion = new ComparableVersion(projectMajorRequirement + DOT + projectMinorRequirement);
        boolean flexible = !StringUtils.containsIgnoreCase((String)projectVersionRequirement, (String)"SNAPSHOT");
        logger.trace((Object)("project.object.model=" + pom.getClass().getName()));
        logger.trace((Object)(projectName + ".version=" + projectVersion));
        logger.trace((Object)(projectName + ".version.requirement=" + projectVersionRequirement));
        SubjectProject project = this.getSubjectProject();
        if (project != null && (versionEnumeration = project.getVersionEnumeration()) != null) {
            String thisVersionCode = "V" + projectMajor + "R" + projectMinor;
            String lastVersionCode = project.getLastVersionCode();
            if (lastVersionCode != null) {
                if (lastVersionCode.startsWith(thisVersionCode)) {
                    String pattern = "project version code is {0}; it matches the last instance of {1}";
                    String message = MessageFormat.format(pattern, thisVersionCode, versionEnumeration);
                    logger.info((Object)message);
                } else {
                    String pattern = "version code mismatch: project version code is {0}; last instance of {1} is {2}";
                    String message = MessageFormat.format(pattern, thisVersionCode, versionEnumeration, lastVersionCode);
                    logger.fatal((Object)message);
                    ++this.errors;
                    return false;
                }
            }
        }
        Object message = MessageFormat.format(pattern1, platform, platformVersion, projectName, requiredVersion, suppliedVersion);
        if (suppliedMajorMinorVersion.compareTo(requiredMajorMinorVersion) != 0) {
            message = (String)message + "; " + MessageFormat.format(pattern2, platform, platformVersion, projectName, requiredVersion, suppliedVersion);
            logger.error(message);
            ++this.errors;
            return false;
        }
        int compareTo = suppliedVersion.compareTo(requiredVersion);
        if (compareTo == 0) {
            message = (String)message + "; " + MessageFormat.format(pattern3, platform, platformVersion, projectName, requiredVersion, suppliedVersion);
            logger.info(message);
            return true;
        }
        if (flexible && compareTo > 0) {
            message = (String)message + "; " + MessageFormat.format(pattern4, platform, platformVersion, projectName, requiredVersion, suppliedVersion);
            logger.info(message);
            return true;
        }
        message = (String)message + "; " + MessageFormat.format(pattern5, platform, platformVersion, projectName, requiredVersion, suppliedVersion);
        logger.error(message);
        ++this.errors;
        return false;
    }

    private void writePlatform(WriterContext basicWriterContext, File platformPropertiesFile) {
        logger.info((Object)("propertiesFile=" + platformPropertiesFile.getPath()));
        try {
            VelocityContext platformContext = basicWriterContext.getVelocityContextClone();
            String platform = StringUtils.removeEndIgnoreCase((String)platformPropertiesFile.getName(), (String)PROPERTIES_SUFFIX);
            platformContext.put(VC_PLATFORM, (Object)platform);
            TLB.setProgrammers(basicWriterContext.programmers);
            TLB.setWrapperClasses(basicWriterContext.wrapperClasses);
            this.putProperties(platformContext, platformPropertiesFile);
            Properties properties = this.mergeProperties(platformContext, platformPropertiesFile);
            this.putStrings(platformContext, properties);
            ExtendedProperties mergeExtendedProperties = this.mergeExtendedProperties(platformContext, platformPropertiesFile);
            this.createDirectories(mergeExtendedProperties);
            this.deletePreviouslyGeneratedFiles(mergeExtendedProperties);
            platformContext.put(VC_PLATFORM_PROPERTIES, (Object)mergeExtendedProperties);
            WriterContext platformWriterContext = this.newWriterContext(platformContext);
            File platformsFolder = platformPropertiesFile.getParentFile();
            ExtendedProperties platformExtendedProperties = PropertiesHandler.getExtendedProperties(platformPropertiesFile);
            String[] pathnames = platformExtendedProperties.getStringArray(FILE_RESOURCE_LOADER_PATH);
            String[] pathfilters = platformExtendedProperties.getStringArray(FILE_RESOURCE_LOADER_PATH_FILTER);
            LinkedHashMap<String, File> folders = new LinkedHashMap<String, File>();
            if (pathnames != null && pathnames.length != 0) {
                for (File file : bootstrappingPlatformsFolders) {
                    folders.putAll(FilUtils.directoriesMap(file, pathnames, file));
                }
            }
            if (pathfilters != null && pathfilters.length > 0) {
                String[] keyArray = folders.keySet().toArray((String[])ArrUtils.arrayOf(String.class));
                for (String pathfilter : pathfilters) {
                    String slashedFilter = pathfilter.replace(FILE_SEPARATOR, SLASH);
                    for (String key : keyArray) {
                        String slashedPath = key.replace(FILE_SEPARATOR, SLASH) + SLASH;
                        if (!StringUtils.containsIgnoreCase((String)slashedPath, (String)slashedFilter)) continue;
                        folders.remove(key);
                        logger.debug((Object)(pathfilter + " excludes " + key));
                    }
                }
            }
            String platformsFolderPath = platformsFolder.getPath();
            LinkedHashMap<String, String> processedTemplatePropertiesFileMap = new LinkedHashMap<String, String>();
            for (File folder : folders.values()) {
                this.log(_detailLevel, "write", "path=" + StringUtils.removeStart((String)folder.getPath(), (String)platformsFolderPath));
                Object[] templateFiles = folder.listFiles(propertiesFileFilter);
                Arrays.sort(templateFiles);
                for (Object templatePropertiesFile : templateFiles) {
                    String tpfnwox;
                    String message;
                    String pattern;
                    if (this.reject((File)templatePropertiesFile, pathfilters)) continue;
                    Properties templateProperties = this.mergeProperties(platformContext, (File)templatePropertiesFile);
                    String disabled = templateProperties.getProperty(TP_DISABLED, Boolean.FALSE.toString());
                    String string = templateProperties.getProperty(TP_DISABLED_MISSING);
                    String disabledForeign = templateProperties.getProperty(TP_DISABLED_FOREIGN);
                    String disabledPrivate = templateProperties.getProperty(TP_DISABLED_PRIVATE);
                    ++this.templates;
                    String template = this.getTemplate((File)templatePropertiesFile);
                    String prevPath = (String)processedTemplatePropertiesFileMap.get(template);
                    String currPath = ((File)templatePropertiesFile).getPath().replace(FILE_SEPARATOR, SLASH);
                    if (prevPath != null) {
                        pattern = "file \"{0}\" has been previously found at \"{1}\"; file at \"{2}\" has been ignored";
                        String prevDir = StringUtils.removeEnd((String)prevPath, (String)template);
                        String currDir = StringUtils.removeEnd((String)currPath, (String)template);
                        message = MessageFormat.format(pattern, template, prevDir, currDir);
                        this.log(Level.WARN, message);
                        ++this.warnings;
                        continue;
                    }
                    if (BitUtils.valueOf(disabled)) {
                        processedTemplatePropertiesFileMap.put(template, currPath);
                        ++this.disabledTemplates;
                        tpfnwox = StringUtils.removeEndIgnoreCase((String)((File)templatePropertiesFile).getName(), (String)PROPERTIES_SUFFIX);
                        pattern = "template \"{0}\" ignored, check property \"{1}\" at file \"{2}\"";
                        message = MessageFormat.format(pattern, tpfnwox, TP_DISABLED, templatePropertiesFile);
                        this.log(_disabledLevel, message);
                        ++this.alerts;
                        continue;
                    }
                    if (this.missing(string)) {
                        processedTemplatePropertiesFileMap.put(template, currPath);
                        ++this.disabledTemplates;
                        tpfnwox = StringUtils.removeEndIgnoreCase((String)((File)templatePropertiesFile).getName(), (String)PROPERTIES_SUFFIX);
                        pattern = "template \"{0}\" ignored because {3} is missing, check property \"{1}\" at file \"{2}\"";
                        message = MessageFormat.format(pattern, tpfnwox, TP_DISABLED_MISSING, templatePropertiesFile, string);
                        this.log(_disabledLevel, message);
                        ++this.alerts;
                        continue;
                    }
                    if (this.foreign(disabledForeign)) {
                        processedTemplatePropertiesFileMap.put(template, currPath);
                        ++this.disabledTemplates;
                        tpfnwox = StringUtils.removeEndIgnoreCase((String)((File)templatePropertiesFile).getName(), (String)PROPERTIES_SUFFIX);
                        pattern = "template \"{0}\" ignored because {3} is foreign, check property \"{1}\" at file \"{2}\"";
                        message = MessageFormat.format(pattern, tpfnwox, TP_DISABLED_FOREIGN, templatePropertiesFile, disabledForeign);
                        this.log(_disabledLevel, message);
                        ++this.alerts;
                        continue;
                    }
                    if (this.privado(disabledPrivate)) {
                        processedTemplatePropertiesFileMap.put(template, currPath);
                        ++this.disabledTemplates;
                        tpfnwox = StringUtils.removeEndIgnoreCase((String)((File)templatePropertiesFile).getName(), (String)PROPERTIES_SUFFIX);
                        pattern = "template \"{0}\" ignored because {3} is private, check property \"{1}\" at file \"{2}\"";
                        message = MessageFormat.format(pattern, tpfnwox, TP_DISABLED_PRIVATE, templatePropertiesFile, disabledPrivate);
                        this.log(_disabledLevel, message);
                        ++this.alerts;
                        continue;
                    }
                    processedTemplatePropertiesFileMap.put(template, currPath);
                    this.writeTemplate(platformWriterContext, (File)templatePropertiesFile);
                }
            }
            this.plataforma = platform;
            ++this.platforms;
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
        this.printSummary();
    }

    private boolean reject(File templatePropertiesFile, String[] pathfilters) {
        return !this.accept(templatePropertiesFile, pathfilters);
    }

    private boolean accept(File templatePropertiesFile, String[] pathfilters) {
        if (templatePropertiesFile == null) {
            return false;
        }
        if (pathfilters == null || pathfilters.length == 0) {
            return true;
        }
        String name = StringUtils.removeEndIgnoreCase((String)templatePropertiesFile.getName(), (String)PROPERTIES_SUFFIX);
        String lowerName = name.toLowerCase();
        String anything = ".*";
        String delimiters = "[\\W]";
        String word = "[\\w\\-]*";
        for (String pathfilter : pathfilters) {
            String fileFilter = pathfilter.replace(FILE_SEPARATOR, SLASH);
            fileFilter = fileFilter.toLowerCase();
            fileFilter = StringUtils.removeStart((String)fileFilter, (String)SLASH);
            if ((fileFilter = StringUtils.removeEnd((String)fileFilter, (String)SLASH)).isEmpty() || !fileFilter.matches(word)) continue;
            if (lowerName.matches(CARET + anything + delimiters + fileFilter + delimiters + anything + DOLLAR)) {
                logger.debug((Object)("filter *" + pathfilter + "* excludes " + name));
                return false;
            }
            if (lowerName.matches(CARET + fileFilter + delimiters + anything + DOLLAR)) {
                logger.debug((Object)("filter " + pathfilter + "* excludes " + name));
                return false;
            }
            if (lowerName.matches(CARET + anything + delimiters + fileFilter + DOLLAR)) {
                logger.debug((Object)("filter *" + pathfilter + " excludes " + name));
                return false;
            }
            if (!lowerName.matches(CARET + fileFilter + DOLLAR)) continue;
            logger.debug((Object)("filter " + pathfilter + " excludes " + name));
            return false;
        }
        return true;
    }

    private boolean missing(String resourceName) {
        return StringUtils.isNotBlank((String)resourceName) && this.availableResourceNames != null && !this.availableResourceNames.contains(resourceName);
    }

    private boolean foreign(String resourceName) {
        return StringUtils.isNotBlank((String)resourceName) && this.foreignResourceNames != null && this.foreignResourceNames.contains(resourceName);
    }

    private boolean privado(String resourceName) {
        return StringUtils.isNotBlank((String)resourceName) && this.privateResourceNames != null && this.privateResourceNames.contains(resourceName);
    }

    private void writeTemplate(WriterContext platformWriterContext, File templatePropertiesFile) {
        this.log(_trackingLevel, "write", "template=" + templatePropertiesFile);
        VelocityContext templateContext = platformWriterContext.getVelocityContextClone();
        TLB.setProgrammers(platformWriterContext.programmers);
        TLB.setWrapperClasses(platformWriterContext.wrapperClasses);
        this.putProperties(templateContext, templatePropertiesFile);
        WriterContext templateWriterContext = this.newWriterContext(templateContext);
        try {
            ForEach forEach = new ForEach(templatePropertiesFile);
            if (forEach.start == null) {
                this.writeFile(templateWriterContext, templatePropertiesFile);
            } else {
                this.writeTemplate(templateWriterContext, templatePropertiesFile, forEach.start, this.subject);
            }
        }
        catch (Throwable throwable) {
            this.error(throwable);
        }
    }

    private void writeTemplate(WriterContext templateWriterContext, File templatePropertiesFile, ForEachVariable v, Object o) {
        Object object = this.invoke(templatePropertiesFile, v, o);
        if (object instanceof Collection) {
            ArrayList collection = new ArrayList((Collection)object);
            if (collection.isEmpty()) {
                return;
            }
            if (v.predicate != null) {
                CollectionUtils.filter(collection, (Predicate)v.predicate);
                if (collection.isEmpty()) {
                    return;
                }
            }
            if (v.comparator != null && collection instanceof List) {
                List list = collection;
                Collections.sort(list, v.comparator);
            }
            for (Object element : collection) {
                this.writeTemplate(templateWriterContext, templatePropertiesFile, v, element, true);
            }
        } else if (object != null && (v.predicate == null || v.predicate.evaluate(object))) {
            this.writeTemplate(templateWriterContext, templatePropertiesFile, v, object, true);
        }
    }

    private void writeTemplate(WriterContext templateWriterContext, File templatePropertiesFile, ForEachVariable v, Object o, boolean b) {
        templateWriterContext.velocityContext.put(v.token, o);
        if (b) {
            logger.debug((Object)(v.token + "=" + o));
        }
        if (v.next == null) {
            this.writeFile(templateWriterContext, templatePropertiesFile);
        } else {
            this.writeTemplate(templateWriterContext, templatePropertiesFile, v.next, o);
        }
    }

    private void writeFile(WriterContext templateWriterContext, File templatePropertiesFile) {
        String pattern;
        File path;
        VelocityContext fileContext = templateWriterContext.getVelocityContextClone();
        TLB.setProgrammers(templateWriterContext.programmers);
        TLB.setWrapperClasses(templateWriterContext.wrapperClasses);
        Properties properties = this.mergeProperties(fileContext, templatePropertiesFile);
        this.putStrings(fileContext, properties);
        String userPath = this.pathString(USER_DIR);
        String temptype = StringUtils.defaultIfBlank((String)properties.getProperty(TP_TYPE), (String)TP_TYPE_VELOCITY);
        String template = StringUtils.trimToNull((String)properties.getProperty("template"));
        Object filePath = StringUtils.trimToNull((String)properties.getProperty("path"));
        String filePack = StringUtils.trimToNull((String)properties.getProperty("package"));
        String fileName = StringUtils.trimToNull((String)properties.getProperty("file"));
        String preserve = StringUtils.trimToNull((String)properties.getProperty(TP_PRESERVE));
        String charset1 = StringUtils.trimToNull((String)properties.getProperty(TP_ENCODING));
        String charset2 = StringUtils.trimToNull((String)properties.getProperty(TP_CHARSET));
        String pfmethod = StringUtils.trimToNull((String)properties.getProperty(TP_PROCESS_FILE_METHOD));
        String root = bootstrappingRootFolder.getPath();
        String raiz = root.replace(FILE_SEPARATOR, SLASH);
        String hint = "; check property \"{0}\" at file \"{1}\"";
        if (!ArrayUtils.contains((Object[])TP_TYPE_ARRAY, (Object)temptype)) {
            String pattern2 = "failed to obtain a valid template type" + hint;
            String message = MessageFormat.format(pattern2, TP_TYPE, templatePropertiesFile);
            logger.error((Object)message);
            ++this.errors;
            return;
        }
        if (template == null) {
            String pattern3 = "failed to obtain a valid template name" + hint;
            String message = MessageFormat.format(pattern3, "template", templatePropertiesFile);
            logger.error((Object)message);
            ++this.errors;
            return;
        }
        if (fileName == null) {
            String pattern4 = "failed to obtain a valid file name" + hint;
            String message = MessageFormat.format(pattern4, "file", templatePropertiesFile);
            logger.error((Object)message);
            ++this.errors;
            return;
        }
        String templatePathString = this.pathString(template);
        String templateName = StringUtils.substringAfterLast((String)templatePathString, (String)FILE_SEPARATOR);
        String templatePath = StringUtils.substringBeforeLast((String)templatePathString, (String)FILE_SEPARATOR);
        boolean preservar = BitUtils.valueOf(preserve);
        fileContext.put("template", (Object)StringEscapeUtils.escapeJava((String)templatePathString));
        fileContext.put(VC_TEMPLATE_NAME, (Object)StringEscapeUtils.escapeJava((String)templateName));
        fileContext.put(VC_TEMPLATE_PATH, (Object)StringUtils.replace((String)templatePath, (String)FILE_SEPARATOR, (String)SLASH));
        fileContext.put(VC_TEMPLATE_TYPE, (Object)temptype);
        fileContext.put("file", (Object)fileName);
        fileContext.put(VC_FILE_ENCODING, (Object)(charset2 == null ? VelocityEngineer.getDocumentEncoding(fileName) : charset2));
        fileContext.put(VC_FILE_PRESERVE, (Object)(preservar + " -> file will" + (preservar ? " not " : " ") + "be replaced when regenerating the project"));
        if (filePath == null) {
            filePath = userPath;
        } else if (this.isRelativePath((String)(filePath = this.pathString((String)filePath)))) {
            filePath = ((String)filePath).startsWith(FILE_SEPARATOR) ? userPath + (String)filePath : userPath + FILE_SEPARATOR + (String)filePath;
        }
        fileContext.put("path", (Object)StringEscapeUtils.escapeJava((String)filePath));
        if (filePack != null) {
            filePath = (String)filePath + FILE_SEPARATOR + this.pathString(StringUtils.replace((String)filePack, (String)DOT, (String)SLASH));
            fileContext.put("package", (Object)this.dottedString(filePack));
        }
        if ((path = new File((String)filePath)).exists()) {
            if (!path.isDirectory() || !path.canWrite()) {
                String pattern5 = "{2} is not a valid directory" + hint;
                String message = MessageFormat.format(pattern5, "path", templatePropertiesFile, path);
                logger.error((Object)message);
                ++this.errors;
                return;
            }
        } else if (!path.mkdirs()) {
            String pattern6 = "{2} is not a valid path" + hint;
            String message = MessageFormat.format(pattern6, "path", templatePropertiesFile, path);
            logger.error((Object)message);
            ++this.errors;
            return;
        }
        String fullname = path.getPath() + FILE_SEPARATOR + fileName;
        String slashedPath = fullname.replace(FILE_SEPARATOR, SLASH);
        File file = new File(fullname);
        if (file.exists()) {
            if (this.fileExclusionPatterns != null) {
                for (Pattern fxp : this.fileExclusionPatterns) {
                    regex = fxp.pattern();
                    if (!slashedPath.matches(regex)) continue;
                    ++this.excludedFiles;
                    String pattern7 = "file {0} will be deleted; it matches exclusion expression \"{1}\"";
                    String message = MessageFormat.format(pattern7, StringUtils.removeStartIgnoreCase((String)slashedPath, (String)raiz), regex);
                    this.log(_excludedLevel, message);
                    ++this.alerts;
                    FileUtils.deleteQuietly((File)file);
                    return;
                }
            }
            if (preservar) {
                ++this.preservedFiles;
                String pattern8 = "file {2} will not be replaced" + hint;
                String message = MessageFormat.format(pattern8, TP_PRESERVE, templatePropertiesFile, fullname);
                this.log(_preservedLevel, message);
                ++this.alerts;
                return;
            }
            if (this.filePreservationPatterns != null) {
                for (Pattern fxp : this.filePreservationPatterns) {
                    regex = fxp.pattern();
                    if (!slashedPath.matches(regex)) continue;
                    ++this.preservedFiles;
                    String pattern9 = "file {0} will not be replaced; it matches preservation expression \"{1}\"";
                    String message = MessageFormat.format(pattern9, StringUtils.removeStartIgnoreCase((String)slashedPath, (String)raiz), regex);
                    this.log(_preservedLevel, message);
                    ++this.alerts;
                    return;
                }
            }
        } else if (this.fileExclusionPatterns != null) {
            for (Pattern fxp : this.fileExclusionPatterns) {
                regex = fxp.pattern();
                if (!slashedPath.matches(regex)) continue;
                ++this.excludedFiles;
                String pattern10 = "file {0} will not be written; it matches exclusion expression \"{1}\"";
                String message = MessageFormat.format(pattern10, StringUtils.removeStartIgnoreCase((String)slashedPath, (String)raiz), regex);
                this.log(_excludedLevel, message);
                ++this.alerts;
                return;
            }
        }
        if (charset1 != null && !Charset.isSupported(charset1)) {
            pattern = "{2} is not a supported character set" + hint;
            String message = MessageFormat.format(pattern, TP_ENCODING, templatePropertiesFile, charset1);
            logger.error((Object)message);
            ++this.errors;
            return;
        }
        if (charset2 != null && !Charset.isSupported(charset2)) {
            pattern = "{2} is not a supported character set" + hint;
            String message = MessageFormat.format(pattern, TP_CHARSET, templatePropertiesFile, charset2);
            logger.error((Object)message);
            ++this.errors;
            return;
        }
        boolean pretty = "XmlUtils.toPrettyString".equals(pfmethod);
        fileContext.put(VC_FILE_PATH, (Object)StringEscapeUtils.escapeJava((String)filePath));
        fileContext.put(VC_FILE_NAME, (Object)StringEscapeUtils.escapeJava((String)fileName));
        fileContext.put(VC_FILE_PATH_NAME, (Object)StringEscapeUtils.escapeJava((String)fullname));
        fileContext.put(VC_FILE_PATH_FILE, (Object)path);
        fileContext.put(VC_FILE_SLASHED_PATH, (Object)((String)filePath).replace(FILE_SEPARATOR, SLASH));
        if (temptype.equals(TP_TYPE_VELOCITY)) {
            this.writeFile(fileContext, template, fullname, charset1, charset2, pretty);
        } else {
            this.writeFile(template, fullname);
        }
        this.processFile(fileContext, templatePropertiesFile, file);
        this.executeFile(fileContext, templatePropertiesFile);
    }

    private void writeFile(VelocityContext context, String template, String filename, String charset1, String charset2, boolean pretty) {
        this.log(_trackingLevel, "writeFile", "template=" + template, "filename=" + filename);
        this.log(Level.DEBUG, context);
        String message = "failed to write file \"" + filename + "\" using template \"" + template + "\"";
        try {
            VelocityEngineer.write(context, template, filename, charset1, charset2, pretty);
            ++this.mergedFiles;
        }
        catch (Exception ex) {
            throw new RuntimeException(message, ex);
        }
    }

    private void writeFile(String document, String filename) {
        this.log(_trackingLevel, "writeFile", "document=" + document, "filename=" + filename);
        String message = "failed to write file \"" + filename + "\" copying document \"" + document + "\"";
        String path = FILE_SEPARATOR + document.replaceAll(SLASH, "\\" + FILE_SEPARATOR);
        String[] fileResourceLoaderPathArray = VelocityEngineer.getFileResourceLoaderPathArray();
        if (fileResourceLoaderPathArray != null && fileResourceLoaderPathArray.length > 0) {
            try {
                for (String frlp : fileResourceLoaderPathArray) {
                    File source = new File(frlp + path);
                    if (!FilUtils.isVisibleFile(source)) continue;
                    File target = new File(filename);
                    FileUtils.copyFile((File)source, (File)target);
                    ++this.copiedFiles;
                    break;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(message, ex);
            }
        }
    }

    private void processFile(VelocityContext fileContext, File templatePropertiesFile, File file) {
        Properties properties = this.mergeProperties(fileContext, templatePropertiesFile);
        String method = StringUtils.trimToNull((String)properties.getProperty(TP_PROCESS_FILE_METHOD));
        if (method != null && file.exists()) {
            switch (method) {
                case "PlantUML.generateImage": {
                    PlantUML.generateImage(file);
                    break;
                }
                case "PlantUML.generateImageAndDeleteSourceFile": {
                    PlantUML.generateImage(file);
                    FileUtils.deleteQuietly((File)file);
                }
            }
        }
    }

    private void executeFile(VelocityContext fileContext, File templatePropertiesFile) {
        Properties properties = this.mergeProperties(fileContext, templatePropertiesFile);
        String command = StringUtils.trimToNull((String)properties.getProperty(TP_EXECUTE_COMMAND));
        String directory = StringUtils.trimToNull((String)properties.getProperty(TP_EXECUTE_DIRECTORY));
        if (command != null) {
            File dir;
            StrTokenizer tokenizer = new StrTokenizer(command);
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(tokenizer.getTokenArray());
            if (directory != null && (dir = new File(directory)).exists() && dir.isDirectory()) {
                if (dir.isAbsolute()) {
                    processBuilder.directory(dir);
                } else {
                    processBuilder.directory(dir.getAbsoluteFile());
                }
            }
            try {
                Process process = processBuilder.start();
                int w = process.waitFor();
                int x = process.exitValue();
                logger.info((Object)(command + " = " + w + "," + x));
            }
            catch (IOException | InterruptedException ex) {
                this.error(ex);
            }
        }
    }

    private WriterContext newWriterContext() {
        TLB.clearProgrammers();
        TLB.clearWrapperClasses();
        WriterContext context = new WriterContext();
        context.velocityContext = this.newVelocityContext();
        context.programmers = TLB.getProgrammers();
        context.wrapperClasses = TLB.getWrapperClasses();
        return context;
    }

    private WriterContext newWriterContext(VelocityContext velocityContext) {
        WriterContext context = new WriterContext();
        context.velocityContext = velocityContext;
        context.programmers = TLB.getProgrammersClone();
        context.wrapperClasses = TLB.getWrapperClassesClone();
        return context;
    }

    private VelocityContext newVelocityContext() {
        Object baseName;
        VelocityContext context = new VelocityContext();
        context.put("BACKSLASH", (Object)String.valueOf('\\'));
        context.put("DOLLAR", (Object)String.valueOf('$'));
        context.put("NOT", (Object)String.valueOf('!'));
        context.put("POUND", (Object)String.valueOf('#'));
        context.put("UNDERSCORE", (Object)String.valueOf('_'));
        context.put("TRUE", (Object)VelocityAid.TRUE());
        context.put("FALSE", (Object)VelocityAid.FALSE());
        context.put("EMPTY", (Object)VelocityAid.EMPTY());
        context.put("EOL", (Object)VelocityAid.EOL());
        context.put("TAB", (Object)VelocityAid.TAB());
        this.putClass(context, Bundle.class);
        this.putClass(context, BitUtils.class);
        this.putClass(context, CSVUtils.class);
        this.putClass(context, FilUtils.class);
        this.putClass(context, IntUtils.class);
        this.putClass(context, LongUtils.class);
        this.putClass(context, ManUtils.class);
        this.putClass(context, MarkupUtils.class);
        this.putClass(context, NumUtils.class);
        this.putClass(context, ObjUtils.class);
        this.putClass(context, StrUtils.class);
        this.putClass(context, TimeUtils.class);
        this.putClass(context, VelocityAid.class);
        this.putClass(context, ChoiceFormat.class);
        this.putClass(context, DateFormat.class);
        this.putClass(context, DateFormatSymbols.class);
        this.putClass(context, DecimalFormat.class);
        this.putClass(context, DecimalFormatSymbols.class);
        this.putClass(context, MessageFormat.class);
        this.putClass(context, NumberFormat.class);
        this.putClass(context, SimpleDateFormat.class);
        this.putClass(context, Arrays.class);
        this.putClass(context, Locale.class);
        this.putClass(context, ArrayUtils.class);
        this.putClass(context, StringEscapeUtils.class);
        this.putClass(context, StringUtils.class);
        this.putClass(context, WordUtils.class);
        this.putClass(context, Boolean.class);
        this.putClass(context, Byte.class);
        this.putClass(context, Character.class);
        this.putClass(context, Double.class);
        this.putClass(context, Float.class);
        this.putClass(context, Integer.class);
        this.putClass(context, Long.class);
        this.putClass(context, Short.class);
        this.putClass(context, String.class);
        this.putClass(context, System.class);
        this.putClass(context, BigDecimal.class);
        this.putClass(context, BigInteger.class);
        this.putClass(context, Date.class);
        this.putClass(context, Time.class);
        this.putClass(context, Timestamp.class);
        String path = bootstrappingRootFolder.getPath();
        context.put(this.subjectKey, this.subject);
        context.put(VC_BOOTSTRAPPING, (Object)bootstrapping);
        context.put(VC_BUILD_DATE, (Object)TimeUtils.simpleDateString(TimeUtils.actualDate()));
        context.put(VC_BUILD_TIMESTAMP, (Object)TimeUtils.simpleTimestampString(TimeUtils.actualTimestamp()));
        context.put(VC_LINGUIST, (Object)Bundle.getLinguist());
        context.put(VC_VELOCITY_WRITER, (Object)this);
        context.put(VC_ROOT_PATH, (Object)StringEscapeUtils.escapeJava((String)path));
        context.put(VC_ROOT_SLASHED_PATH, (Object)path.replace(FILE_SEPARATOR, SLASH));
        context.put(VC_USER_PATH, (Object)StringEscapeUtils.escapeJava((String)USER_DIR));
        context.put(VC_USER_SLASHED_PATH, (Object)USER_DIR.replace(FILE_SEPARATOR, SLASH));
        context.put(VC_HOME_PATH, (Object)StringEscapeUtils.escapeJava((String)HOME_DIR));
        context.put(VC_HOME_SLASHED_PATH, (Object)HOME_DIR.replace(FILE_SEPARATOR, SLASH));
        logger.info((Object)("homeFolderPath=" + HOME_DIR));
        logger.info((Object)("rootFolderPath=" + path));
        logger.info((Object)("userFolderPath=" + USER_DIR));
        SubjectProject project = this.getSubjectProject();
        Object object = baseName = project == null ? null : project.getBaseFolderName();
        if (StringUtils.isBlank((String)baseName)) {
            baseName = this.subject.getClass().getSimpleName() + DOT + StrUtils.getIdentifier(this.subjectKey);
        }
        File base = new File(bootstrappingRootFolder, (String)baseName);
        String basePath = base.getPath();
        context.put(VC_BASE_NAME, baseName);
        context.put(VC_BASE_PATH, (Object)StringEscapeUtils.escapeJava((String)basePath));
        context.put(VC_BASE_SLASHED_PATH, (Object)path.replace(FILE_SEPARATOR, SLASH));
        logger.log((Priority)Level.INFO, (Object)("baseFolderPath=" + basePath));
        return context;
    }

    private void putClass(VelocityContext context, Class<?> clazz) {
        context.put(clazz.getSimpleName(), clazz);
    }

    private void putProperties(VelocityContext context, File propertiesFile) {
        String hint = "\nhint: check property \"{0}\" at file \"{1}\"";
        String pattern1 = "failed to load {2}" + hint;
        String pattern2 = "failed to initialise {2}" + hint;
        String pattern3 = "{2} does not implement {3}" + hint;
        String pattern4 = "{2} is not a valid wrapper for {3}" + hint;
        Properties properties = PropertiesHandler.loadProperties(propertiesFile);
        Set<String> stringPropertyNames = properties.stringPropertyNames();
        for (String name : stringPropertyNames) {
            Object object2;
            String message;
            String velocityKey;
            String string2;
            String string1;
            this.checkPropertyName(name, propertiesFile);
            if (StringUtils.endsWithIgnoreCase((String)name, (String)DOT_STRING)) {
                string1 = StringUtils.removeEndIgnoreCase((String)name, (String)DOT_STRING);
                string2 = StringUtils.trimToEmpty((String)properties.getProperty(name));
                velocityKey = StrUtils.getCamelCase(string1, true);
                context.put(velocityKey, (Object)string2);
                continue;
            }
            if (StringUtils.endsWithIgnoreCase((String)name, (String)DOT_CLASS)) {
                string1 = StringUtils.removeEndIgnoreCase((String)name, (String)DOT_CLASS);
                string2 = StringUtils.trimToEmpty((String)properties.getProperty(name));
                message = MessageFormat.format(pattern1, name, propertiesFile, string2);
                object2 = this.getClassForName(string2, message);
                if (object2 != null) {
                    velocityKey = StrUtils.getCamelCase(string1, true);
                    context.put(velocityKey, object2);
                    continue;
                }
                throw new RuntimeException(message, new IllegalArgumentException(string2));
            }
            if (StringUtils.endsWithIgnoreCase((String)name, (String)DOT_INSTANCE)) {
                string1 = StringUtils.removeEndIgnoreCase((String)name, (String)DOT_INSTANCE);
                string2 = StringUtils.trimToEmpty((String)properties.getProperty(name));
                message = MessageFormat.format(pattern2, name, propertiesFile, string2);
                object2 = this.getNewInstanceForName(string2, message);
                if (object2 != null) {
                    velocityKey = StrUtils.getCamelCase(string1, true);
                    context.put(velocityKey, object2);
                    continue;
                }
                throw new RuntimeException(message, new IllegalArgumentException(string2));
            }
            if (StringUtils.endsWithIgnoreCase((String)name, (String)DOT_PROGRAMMER)) {
                string1 = StringUtils.removeEndIgnoreCase((String)name, (String)DOT_PROGRAMMER);
                string2 = StringUtils.trimToEmpty((String)properties.getProperty(name));
                message = MessageFormat.format(pattern2, name, propertiesFile, string2);
                object2 = this.getNewInstanceForName(string2, message);
                if (object2 != null) {
                    if (object2 instanceof Programmer) {
                        velocityKey = StrUtils.getCamelCase(string1, true);
                        context.put(velocityKey, object2);
                        TLB.setProgrammer(velocityKey, (Programmer)object2);
                        continue;
                    }
                    message = MessageFormat.format(pattern3, name, propertiesFile, string2, Programmer.class);
                }
                throw new RuntimeException(message, new IllegalArgumentException(string2));
            }
            if (!StringUtils.endsWithIgnoreCase((String)name, (String)DOT_WRAPPER)) continue;
            string1 = StringUtils.removeEndIgnoreCase((String)name, (String)DOT_WRAPPER);
            string2 = StringUtils.trimToEmpty((String)properties.getProperty(name));
            message = MessageFormat.format(pattern1, name, propertiesFile, string1);
            String argument = string1;
            Class<?> clazz1 = this.getClassForName(string1, message);
            if (clazz1 != null) {
                if (Wrappable.class.isAssignableFrom(clazz1)) {
                    message = MessageFormat.format(pattern1, name, propertiesFile, string2);
                    argument = string2;
                    Class<?> clazz2 = this.getClassForName(string2, message);
                    if (clazz2 != null) {
                        if (Wrapper.class.isAssignableFrom(clazz2)) {
                            Class<?> wrapperClass = clazz2;
                            Class<?> wrappableClass = clazz1;
                            Class<?> parameterType = this.getConstructorParameterType(wrapperClass, wrappableClass);
                            if (parameterType != null) {
                                TLB.setWrapperClass(wrappableClass, wrapperClass);
                                continue;
                            }
                            message = MessageFormat.format(pattern4, name, propertiesFile, wrapperClass, wrappableClass);
                        } else {
                            message = MessageFormat.format(pattern3, name, propertiesFile, string2, Wrapper.class);
                        }
                    }
                } else {
                    message = MessageFormat.format(pattern3, name, propertiesFile, string1, Wrappable.class);
                }
            }
            throw new RuntimeException(message, new IllegalArgumentException(argument));
        }
    }

    private Class<?> getConstructorParameterType(Class<?> wrapper, Class<?> wrappable) {
        Constructor<?>[] constructors;
        Class<?> parameterType = null;
        for (Constructor<?> constructor : constructors = wrapper.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(wrappable) || parameterType != null && !parameterType.isAssignableFrom(parameterTypes[0])) continue;
            parameterType = parameterTypes[0];
        }
        return parameterType;
    }

    private void checkPropertyName(String name, File file) {
        int endIndex;
        String pattern = "invalid property name \"{0}\" at file \"{1}\"";
        String message = MessageFormat.format(pattern, StringUtils.trimToEmpty((String)name), file);
        if (StringUtils.isBlank((String)name)) {
            throw new RuntimeException(message);
        }
        String low = name.toLowerCase();
        if (StringUtils.endsWithAny((String)low, (String[])DOT_SUFFIXES) && (endIndex = StringUtils.lastIndexOfAny((String)low, (String[])DOT_SUFFIXES)) == 0) {
            throw new RuntimeException(message);
        }
    }

    private Class<?> getClassForName(String className, String message) {
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(message, ex);
        }
    }

    private Object getNewInstanceForName(String className, String message) {
        Class<?> clazz = this.getClassForName(className, message);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(message, ex);
        }
    }

    private Properties mergeProperties(VelocityContext context, File propertiesFile) {
        String template = this.getTemplate(propertiesFile);
        StringWriter sw = this.mergeTemplate(context, template);
        if (sw != null) {
            byte[] buffer = sw.toString().getBytes();
            Properties properties = PropertiesHandler.loadProperties(buffer);
            return properties;
        }
        return null;
    }

    private ExtendedProperties mergeExtendedProperties(VelocityContext context, File propertiesFile) {
        String template = this.getTemplate(propertiesFile);
        StringWriter sw = this.mergeTemplate(context, template);
        if (sw != null) {
            byte[] buffer = sw.toString().getBytes();
            ExtendedProperties properties = PropertiesHandler.getExtendedProperties(buffer);
            return properties;
        }
        return null;
    }

    private String getTemplate(File propertiesFile) {
        String shortestPath = null;
        String propertiesFilePath = propertiesFile.getPath().replace(FILE_SEPARATOR, SLASH);
        String[] velocityFileResourceLoaderPathArray = VelocityEngineer.getFileResourceLoaderPathArray();
        if (velocityFileResourceLoaderPathArray != null && velocityFileResourceLoaderPathArray.length > 0) {
            for (String path : velocityFileResourceLoaderPathArray) {
                String slashedPath = StringUtils.removeEnd((String)path.replace(FILE_SEPARATOR, SLASH), (String)SLASH) + SLASH;
                if (!StringUtils.startsWithIgnoreCase((String)propertiesFilePath, (String)slashedPath) || shortestPath != null && slashedPath.length() >= shortestPath.length()) continue;
                shortestPath = slashedPath;
            }
        }
        if (shortestPath == null) {
            return propertiesFile.getName();
        }
        String template = StringUtils.removeStartIgnoreCase((String)propertiesFilePath, shortestPath);
        return template;
    }

    private StringWriter mergeTemplate(VelocityContext context, String template) {
        String message = "failed to merge \"" + template + "\"";
        try {
            return VelocityEngineer.merge(context, template);
        }
        catch (Exception ex) {
            throw new RuntimeException(message, ex);
        }
    }

    private void putStrings(VelocityContext context, Properties properties) {
        Set<String> stringPropertyNames = properties.stringPropertyNames();
        for (String name : stringPropertyNames) {
            if (!StringUtils.endsWithIgnoreCase((String)name, (String)DOT_STRING)) continue;
            String string1 = StringUtils.removeEndIgnoreCase((String)name, (String)DOT_STRING);
            String string2 = StringUtils.trimToEmpty((String)properties.getProperty(name));
            String velocityKey = StrUtils.getCamelCase(string1, true);
            context.put(velocityKey, (Object)string2);
        }
    }

    private void createDirectories(ExtendedProperties properties) {
        Set stringPropertyNames = properties.keySet();
        Iterator iterator = stringPropertyNames.iterator();
        while (iterator.hasNext()) {
            String name;
            switch (name = (String)iterator.next()) {
                case "do.create.dir": {
                    String[] stringArray = properties.getStringArray(name);
                    this.createDirectories(name, stringArray);
                }
            }
        }
    }

    private void createDirectories(String name, String[] stringArray) {
        String root = bootstrappingRootFolder.getPath();
        String raiz = root.replace(FILE_SEPARATOR, SLASH);
        String hint = "; check property: {0}={1}";
        Arrays.sort(stringArray);
        for (String string : stringArray) {
            Path path;
            String message;
            String pattern;
            if (StringUtils.isBlank((String)string)) {
                pattern = "directory name is missing" + hint;
                message = MessageFormat.format(pattern, name, string);
                this.log(_alertLevel, message);
                ++this.alerts;
                continue;
            }
            try {
                path = Paths.get(string, new String[0]);
            }
            catch (InvalidPathException e) {
                pattern = ThrowableUtils.getString(e) + hint;
                message = MessageFormat.format(pattern, name, string);
                this.log(_alertLevel, message);
                ++this.alerts;
                continue;
            }
            String rama = StringUtils.removeStartIgnoreCase((String)string, (String)raiz);
            this.log(_trackingLevel, "about to create directory " + rama);
            if (!path.toFile().mkdirs()) continue;
            this.log(Level.INFO, "directory " + rama + " was created, along with all necessary parent directories");
        }
    }

    private void deletePreviouslyGeneratedFiles(ExtendedProperties properties) {
        Set stringPropertyNames = properties.keySet();
        Iterator iterator = stringPropertyNames.iterator();
        while (iterator.hasNext()) {
            String name;
            switch (name = (String)iterator.next()) {
                case "do.cascaded.delete": {
                    String[] stringArray = properties.getStringArray(name);
                    this.deletePreviouslyGeneratedFiles(name, stringArray, true);
                    break;
                }
                case "do.isolated.delete": {
                    String[] stringArray = properties.getStringArray(name);
                    this.deletePreviouslyGeneratedFiles(name, stringArray, false);
                }
            }
        }
    }

    private void deletePreviouslyGeneratedFiles(String name, String[] stringArray, boolean recursive) {
        String root = bootstrappingRootFolder.getPath();
        String raiz = root.replace(FILE_SEPARATOR, SLASH);
        String recursively = recursive ? "and all its subdirectories" : "";
        String hint = "; check property: {0}={1}";
        IOFileFilter dirFilter = recursive ? ignoreVersionControlFilter : null;
        Arrays.sort(stringArray);
        for (String string : stringArray) {
            String message;
            Object pattern;
            String pathname = StringUtils.substringBeforeLast((String)string, (String)SLASH);
            if (StringUtils.isBlank((String)string) || !StringUtils.contains((String)string, (String)SLASH) || StringUtils.isBlank((String)pathname)) {
                pattern = "directory is missing or invalid" + hint;
                message = MessageFormat.format((String)pattern, name, string);
                this.log(_alertLevel, message);
                ++this.alerts;
                continue;
            }
            String wildcard = StringUtils.substringAfterLast((String)string, (String)SLASH);
            if (StringUtils.isBlank((String)wildcard)) {
                pattern = "wildcard is missing or invalid" + hint;
                message = MessageFormat.format((String)pattern, name, string);
                this.log(_alertLevel, message);
                ++this.alerts;
                continue;
            }
            File directory = new File(pathname);
            if (FilUtils.isNotWritableDirectory(directory)) {
                pattern = "{2} is not a writable directory" + hint;
                message = MessageFormat.format((String)pattern, name, string, StringUtils.removeStartIgnoreCase((String)pathname, (String)raiz));
                this.log(_alertLevel, message);
                ++this.alerts;
                continue;
            }
            this.log(_detailLevel, "deleting files " + wildcard + " from " + StringUtils.removeStartIgnoreCase((String)pathname, (String)raiz) + " " + recursively);
            WildcardFileFilter fileFilter = new WildcardFileFilter(wildcard);
            Collection matchingFiles = FileUtils.listFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
            for (File file : matchingFiles) {
                String path = file.getPath();
                String slashedPath = path.replace(FILE_SEPARATOR, SLASH);
                boolean delete = true;
                if (this.filePreservationPatterns != null) {
                    for (Pattern fxp : this.filePreservationPatterns) {
                        String regex = fxp.pattern();
                        if (!slashedPath.matches(regex)) continue;
                        delete = false;
                        pattern = "file {0} will not be deleted; it matches preservation expression \"{1}\"";
                        message = MessageFormat.format((String)pattern, StringUtils.removeStartIgnoreCase((String)slashedPath, (String)raiz), regex);
                        this.log(_alertLevel, message);
                        ++this.alerts;
                        break;
                    }
                }
                if (!delete) continue;
                logger.trace((Object)("deleting " + StringUtils.removeStartIgnoreCase((String)path, (String)root)));
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    private Object invoke(File templatePropertiesFile, ForEachVariable variable, Object object) {
        Object pattern = "failed to get a valid getter for for-each variable \"{0}\"";
        pattern = (String)pattern + "\nhint: a valid getter is a public zero-arguments method that returns either an object or a collection";
        if (variable.getter == null) {
            Set<String> getters = this.gettersOf(variable.token);
            String strip = StringUtils.strip((String)getters.toString(), (String)"[]");
            pattern = (String)pattern + HINT + object.getClass() + " doesn''t implement any of these: " + strip;
            pattern = (String)pattern + "\nhint: add property \"{0}.getter\" to file \"{1}\"";
            String message = MessageFormat.format((String)pattern, variable.token, templatePropertiesFile);
            return this.invoke(object, getters, message);
        }
        pattern = (String)pattern + "\nhint: check property \"{0}.getter\" at file \"{1}\"";
        String message = MessageFormat.format((String)pattern, variable.token, templatePropertiesFile);
        return this.invoke(object, variable.getter, message);
    }

    private Object invoke(Object object, Set<String> getters, String message) {
        Method[] methods = object.getClass().getMethods();
        block0: for (String getter : getters) {
            for (Method method : methods) {
                if (!getter.equals(method.getName()) || method.getParameterTypes().length != 0) continue;
                if (Void.TYPE.equals(method.getReturnType())) continue block0;
                return this.invoke(object, method);
            }
        }
        throw new RuntimeException(message, new NoSuchMethodException(this.hintless(message)));
    }

    private Object invoke(Object object, String method, String NoSuchMethodExceptionMessage) {
        try {
            return this.invoke(object, object.getClass().getMethod(method, new Class[0]));
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(NoSuchMethodExceptionMessage, ex);
        }
    }

    private Object invoke(Object object, Method method) {
        try {
            method.setAccessible(true);
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Set<String> gettersOf(String token) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(this.listGetterOf(token));
        set.add(this.pluralGetterOf(token));
        set.add(this.singularGetterOf(token));
        set.add(this.defaultGetterOf(token));
        return set;
    }

    private String listGetterOf(String token) {
        String symbol = this.pluralIdentifierOf(token);
        String getter = StrUtils.getCamelCase("get-" + symbol + "-list", true);
        return getter;
    }

    private String pluralGetterOf(String token) {
        String symbol = this.pluralIdentifierOf(token);
        String getter = StrUtils.getCamelCase("get-" + symbol, true);
        return getter;
    }

    private String singularGetterOf(String token) {
        String symbol = this.singularIdentifierOf(token);
        String getter = StrUtils.getCamelCase("get-" + symbol, true);
        return getter;
    }

    private String defaultGetterOf(String token) {
        String symbol = this.identifierOf(token);
        String getter = StrUtils.getCamelCase("get-" + symbol, true);
        return getter;
    }

    private String pluralIdentifierOf(String token) {
        String[] tokens = this.tokensOf(token);
        int i = tokens.length - 1;
        tokens[i] = EnglishNoun.pluralOf(tokens[i]);
        tokens[i] = StrUtils.getIdentifier(tokens[i], "");
        return this.identifierOf(tokens);
    }

    private String singularIdentifierOf(String token) {
        String[] tokens = this.tokensOf(token);
        int i = tokens.length - 1;
        tokens[i] = EnglishNoun.singularOf(tokens[i]);
        tokens[i] = StrUtils.getIdentifier(tokens[i], "");
        return this.identifierOf(tokens);
    }

    private String identifierOf(String token) {
        String[] tokens = this.tokensOf(token);
        return this.identifierOf(tokens);
    }

    private String identifierOf(String[] tokens) {
        String join = StringUtils.join((Object[])tokens, (char)'-');
        return StrUtils.getCamelCase(join);
    }

    private String[] tokensOf(String token) {
        String string = StrUtils.getCamelCase(token, true);
        String[] tokens = StringUtils.splitByCharacterTypeCamelCase((String)string);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = StrUtils.getIdentifier(tokens[i], "");
        }
        return tokens;
    }

    private String dottedString(String string) {
        return this.trimSplitJoin(string, FILE_SEPARATOR_CHARS, DOT);
    }

    private String pathString(String string) {
        String trimmed = StringUtils.trimToNull((String)string);
        if (trimmed == null) {
            return null;
        }
        String trimSplitJoin = this.trimSplitJoin(trimmed, FILE_SEPARATOR_CHARS, FILE_SEPARATOR);
        return StringUtils.startsWithAny((String)trimmed, (String[])FILE_SEPARATOR_STRINGS) ? FILE_SEPARATOR + trimSplitJoin : trimSplitJoin;
    }

    private String trimSplitJoin(Object object, String separatorChars, String separator) {
        String casted = object == null ? null : (object instanceof String ? (String)object : object.toString());
        String string = StringUtils.trimToNull(casted);
        if (string == null) {
            return null;
        }
        Object[] tokens = StringUtils.split((String)string, (String)separatorChars);
        String join = StringUtils.join((Object[])tokens, (String)separator);
        return join;
    }

    private boolean isAbsolutePath(String string) {
        String trimmed = StringUtils.trimToNull((String)string);
        if (trimmed == null) {
            return false;
        }
        if (WINDOWS) {
            String left = StringUtils.left((String)trimmed, (int)2);
            return left.matches("[a-zA-Z]\\:");
        }
        return StringUtils.startsWithAny((String)trimmed, (String[])FILE_SEPARATOR_STRINGS);
    }

    private boolean isRelativePath(String string) {
        return StringUtils.isNotBlank((String)string) && !this.isAbsolutePath(string);
    }

    private void printSummary() {
        if (this.platforms == 1) {
            logger.info((Object)("platform=" + this.plataforma));
        } else {
            logger.info((Object)("platforms=" + this.platforms));
        }
        logger.info((Object)("templates=" + this.templates));
        logger.info((Object)("disabled-templates=" + this.disabledTemplates));
        logger.info((Object)("enabled-templates=" + (this.templates - this.disabledTemplates)));
        logger.info((Object)("excluded-files=" + this.excludedFiles));
        logger.info((Object)("included-files=" + (this.preservedFiles + this.copiedFiles + this.mergedFiles)));
        logger.info((Object)("preserved-files=" + this.preservedFiles));
        logger.info((Object)("written-files=" + (this.copiedFiles + this.mergedFiles)));
        logger.info((Object)("copied-files=" + this.copiedFiles));
        logger.info((Object)("generated-files=" + this.mergedFiles));
        RunUtils.logMemory(logger);
        if (this.alerts != 0) {
            if (_alertLevel.equals((Object)Level.WARN)) {
                logger.warn((Object)("alerts=" + this.alerts));
            } else if (_alertLevel.equals((Object)Level.INFO)) {
                logger.info((Object)("alerts=" + this.alerts));
            }
        }
        if (this.warnings == 0) {
            logger.info((Object)("warnings=" + this.warnings));
        } else {
            logger.warn((Object)("warnings=" + this.warnings));
        }
        if (this.errors == 0) {
            logger.info((Object)("errors=" + this.errors));
        } else {
            logger.warn((Object)("errors=" + this.errors));
        }
    }

    private void resetCounters() {
        this.plataforma = "?";
        this.platforms = 0;
        this.templates = 0;
        this.disabledTemplates = 0;
        this.excludedFiles = 0;
        this.preservedFiles = 0;
        this.copiedFiles = 0;
        this.mergedFiles = 0;
        this.alerts = 0;
        this.warnings = 0;
        this.errors = 0;
    }

    private boolean isInvalidBootstrapping() {
        boolean invalid = false;
        if (bootstrappingRootFolderNotVisible) {
            logger.error((Object)"root folder is missing or invalid");
            invalid = true;
        }
        if (bootstrappingVelocityFolders == null || bootstrappingVelocityFolders.length == 0) {
            logger.error((Object)"velocity folder is missing or invalid");
            invalid = true;
        }
        if (bootstrappingVelocityPropertiesFileNotVisible) {
            logger.error((Object)"velocity properties file is missing or invalid");
            invalid = true;
        }
        if (bootstrappingPlatformsFolders == null || bootstrappingPlatformsFolders.length == 0) {
            logger.error((Object)"platforms folder is missing or invalid");
            invalid = true;
        }
        return invalid;
    }

    private void log(Level level, String message) {
        if (LogUtils.foul(logger, level)) {
            return;
        }
        logger.log((Priority)level, (Object)message);
    }

    private void log(Level level, String method, Object ... parameters) {
        if (LogUtils.foul(logger, level)) {
            return;
        }
        String message = this.signature(method, parameters);
        logger.log((Priority)level, (Object)message);
    }

    private void log(Level level, VelocityContext context) {
        if (LogUtils.foul(logger, level)) {
            return;
        }
        Object[] keys = context.getKeys();
        Arrays.sort(keys);
        logger.log((Priority)level, (Object)("context.keys.length=" + keys.length));
        int n = 0;
        for (Object key : keys) {
            Object value = context.get("" + key);
            logger.log((Priority)level, (Object)(key + "=" + value));
            ++n;
        }
        logger.log((Priority)level, (Object)("context.keys.listed=" + n));
    }

    private String hintless(String message) {
        int i = message == null ? 0 : message.indexOf(HINT);
        return message != null && i > 0 ? message.substring(0, i) : message;
    }

    private String signature(String method, Object ... parameters) {
        String pattern = "{0}({1})";
        return MessageFormat.format(pattern, method, StringUtils.join((Object[])parameters, (String)", "));
    }

    private void error(Throwable throwable) {
        Throwable cause = ThrowableUtils.getCause(throwable);
        String message = throwable.equals(cause) ? throwable.getClass().getSimpleName() : throwable.getMessage();
        logger.error((Object)message, cause);
        ++this.errors;
    }

    public void increaseWarningCount() {
        ++this.warnings;
    }

    public void increaseWarningCount(int count) {
        this.warnings += count;
    }

    public void increaseErrorCount() {
        ++this.errors;
    }

    public void increaseErrorCount(int count) {
        this.errors += count;
    }

    private class WriterContext {
        private VelocityContext velocityContext;
        Map<String, Programmer> programmers;
        Map<String, Class<? extends Wrapper>> wrapperClasses;

        private WriterContext() {
        }

        private VelocityContext getVelocityContextClone() {
            return (VelocityContext)this.velocityContext.clone();
        }
    }

    private class ForEach {
        private final String string;
        private ForEachVariable start;

        private ForEach(File templatePropertiesFile) {
            ExtendedProperties templateExtendedProperties = PropertiesHandler.getExtendedProperties(templatePropertiesFile);
            this.string = templateExtendedProperties.getString(Writer.TP_FOR_EACH);
            String[] tokens = StringUtils.split((String)this.string, (char)'.');
            if (tokens != null) {
                LinkedHashMap<String, ForEachVariable> variables = new LinkedHashMap<String, ForEachVariable>();
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (variables.containsKey(token)) {
                        String pattern = "{0} (token \"{1}\" is used more than once)";
                        String message = MessageFormat.format(pattern, this.string, token);
                        throw new IllegalArgumentException(message);
                    }
                    ForEachVariable variable = new ForEachVariable();
                    variable.token = token;
                    variable.getter = templateExtendedProperties.getString(token + ".getter");
                    variable.predicate = this.getPredicate(templateExtendedProperties, token);
                    variable.comparator = this.getComparator(templateExtendedProperties, token);
                    if (i == 0) {
                        this.start = variable;
                    } else {
                        ForEachVariable previous = (ForEachVariable)variables.get(tokens[i - 1]);
                        previous.next = variable;
                    }
                    variables.put(token, variable);
                }
            }
        }

        private Predicate getPredicate(ExtendedProperties properties, String keyPreffix) {
            Predicate p;
            String[] classNames;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            String key = keyPreffix + ".predicate";
            for (String name : classNames = properties.getStringArray(key)) {
                p = this.getPredicate(name);
                if (p == null) continue;
                predicates.add(p);
            }
            key = keyPreffix + ".not.predicate";
            for (String name : classNames = properties.getStringArray(key)) {
                p = this.getPredicate(name);
                if (p == null) continue;
                predicates.add(PredicateUtils.notPredicate((Predicate)p));
            }
            return predicates.isEmpty() ? null : this.getPredicate(properties, predicates, keyPreffix);
        }

        private Predicate getPredicate(String className) {
            String message = "failed to create a new instance of " + className;
            Object p = Writer.this.getNewInstanceForName(className, message);
            return p instanceof Predicate ? (Predicate)p : null;
        }

        private Predicate getPredicate(ExtendedProperties properties, List<Predicate> predicates, String keyPreffix) {
            String key = keyPreffix + ".predicate.join";
            String operator = properties.getString(key, "all");
            Object[] operators = new String[]{"all", "any", "none", "one"};
            int i = ArrayUtils.indexOf((Object[])operators, (Object)operator.toLowerCase());
            switch (i) {
                case 1: {
                    return PredicateUtils.anyPredicate(predicates);
                }
                case 2: {
                    return PredicateUtils.nonePredicate(predicates);
                }
                case 3: {
                    return PredicateUtils.onePredicate(predicates);
                }
            }
            return PredicateUtils.allPredicate(predicates);
        }

        private Comparator<?> getComparator(ExtendedProperties properties, String keyPreffix) {
            String key = keyPreffix + ".comparator";
            String[] classNames = properties.getStringArray(key);
            ArrayList comparators = new ArrayList();
            for (String name : classNames) {
                Comparator<?> c = this.getComparator(name);
                if (c == null) continue;
                comparators.add(c);
            }
            return comparators.isEmpty() ? null : ComparatorUtils.chainedComparator(comparators);
        }

        private Comparator<?> getComparator(String className) {
            String message = "failed to create a new instance of " + className;
            Object c = Writer.this.getNewInstanceForName(className, message);
            return c instanceof Comparator ? (Comparator)c : null;
        }

        public String toString() {
            return ForEach.class.getSimpleName() + "{" + this.string + "}";
        }
    }

    private class ForEachVariable {
        private String token;
        private String getter;
        private Predicate predicate;
        private Comparator comparator;
        private ForEachVariable next;

        private ForEachVariable() {
        }

        public String toString() {
            return ForEachVariable.class.getSimpleName() + "{token=" + this.token + ", getter=" + this.getter + "}";
        }
    }
}

