/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.ArrUtils;
import adalid.commons.util.StrUtils;
import adalid.core.AbstractPersistentEntity;
import adalid.core.Instance;
import adalid.core.InstanceField;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.XS1;
import adalid.core.annotations.BooleanEnumerationReference;
import adalid.core.annotations.DiscriminatorColumn;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityExportOperation;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntityReportOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.StateProperty;
import adalid.core.enums.BooleanDisplayType;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanEnumerationEntity;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.PersistentEnumerationEntityReference;
import adalid.core.interfaces.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

@EntityClass(resourceType=ResourceType.CONFIGURATION)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE, rowsLimit=0)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityReportOperation(enabled=Kleenean.FALSE)
@EntityExportOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.UNSPECIFIED)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
@EntityReferenceSearch(searchType=SearchType.LIST)
public abstract class AbstractPersistentEnumerationEntity
extends AbstractPersistentEntity
implements PersistentEnumerationEntityReference {
    private static final Logger logger = Logger.getLogger(Entity.class);
    private boolean _customTagging;
    private boolean _annotatedWithBooleanEnumerationReference;
    private BooleanDisplayType _booleanEnumerationDisplayType;
    private Instance[] _removeInstanceArray;
    private Instance[] _searchInstanceArray;

    public AbstractPersistentEnumerationEntity(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.check();
        }
        return ok;
    }

    private void check() {
        if (this.isRootInstance()) {
            if (this.getBusinessKeyProperty() == null) {
                String message = this.getName() + " does not have a busines key property";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
            this.checkInstances();
        }
    }

    private void checkInstances() {
        List<Instance> instances = this.getInstancesList();
        if (instances.isEmpty()) {
            logger.error((Object)("enumeration entity " + this.getFullName() + " has no instances"));
            Project.increaseParserErrorCount();
        } else {
            Object value;
            Set<Locale> supportedLocales = TLC.getProject().getSupportedLocales();
            if (supportedLocales != null && !supportedLocales.isEmpty()) {
                ArrayList<Object> labels = new ArrayList<Object>();
                Property businessKeyProperty = this.getBusinessKeyProperty();
                for (Locale locale : supportedLocales) {
                    labels.clear();
                    block1: for (Instance instance : instances) {
                        String name = instance.getFullName();
                        for (InstanceField field : instance.getInstanceFieldsList()) {
                            if (!businessKeyProperty.equals(field.getProperty())) continue;
                            value = field.getLocalizedValue(locale);
                            if (value == null) {
                                value = StrUtils.getWordyString(instance.getName());
                            }
                            if (labels.contains(value)) {
                                logger.error((Object)(name + " has duplicated business key \"" + (String)value + "\" for locale \"" + locale + "\""));
                                Project.increaseParserErrorCount();
                                continue block1;
                            }
                            labels.add(value);
                            continue block1;
                        }
                        logger.error((Object)(name + " has no business key value for locale \"" + locale + "\""));
                        Project.increaseParserErrorCount();
                    }
                }
            }
            if ((value = this) instanceof BooleanEnumerationEntity) {
                Instance falseInstance;
                BooleanEnumerationEntity booleanEnumeration = (BooleanEnumerationEntity)value;
                String name = this.getFullName();
                Instance trueInstance = booleanEnumeration.getTrueInstance();
                if (trueInstance == null) {
                    logger.error((Object)(name + " implements BooleanEnumeration but does not have a TRUE instance"));
                    Project.increaseParserErrorCount();
                }
                if ((falseInstance = booleanEnumeration.getFalseInstance()) == null) {
                    logger.error((Object)(name + " implements BooleanEnumeration but does not have a FALSE instance"));
                    Project.increaseParserErrorCount();
                } else if (falseInstance == trueInstance) {
                    logger.error((Object)(name + " implements BooleanEnumeration but its TRUE and FALSE instances are the same"));
                    Project.increaseParserErrorCount();
                }
                if (instances.size() > 2) {
                    logger.error((Object)(name + " implements BooleanEnumeration but has more than 2 instances"));
                    Project.increaseParserErrorCount();
                }
            }
            this._customTagging = true;
            for (Instance instance : instances) {
                this._customTagging &= instance.getCustomTag() != null;
            }
        }
    }

    public boolean isCustomTagging() {
        return this._customTagging;
    }

    @Override
    public boolean isInsertEnabled() {
        return false;
    }

    @Override
    public boolean isUpdateEnabled() {
        if (super.isUpdateEnabled()) {
            List<Property> list = this.getPropertiesList();
            for (Property property : list) {
                if (!property.isUpdateField() || !property.isTableField() && (!property.isDetailField() || !this.isDetailViewEnabled())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDeleteEnabled() {
        return false;
    }

    @Override
    void annotate(Class<?> type) {
        super.annotate(type);
        if (type != null) {
            this.annotateBooleanEnumerationReference(type);
        }
    }

    @Override
    void annotate(Field field) {
        super.annotate(field);
        if (field != null) {
            this.annotateBooleanEnumerationReference(field);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidTypeAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidTypeAnnotations();
        if (this instanceof BooleanEnumerationEntity) {
            valid.add(BooleanEnumerationReference.class);
        }
        return valid;
    }

    @Override
    protected List<Class<? extends Annotation>> getValidFieldAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidFieldAnnotations();
        if (this.isProperty()) {
            valid.add(DiscriminatorColumn.class);
            valid.add(StateProperty.class);
        }
        if (this instanceof BooleanEnumerationEntity) {
            valid.add(BooleanEnumerationReference.class);
        }
        return valid;
    }

    public boolean isAnnotatedWithBooleanEnumerationReference() {
        return this._annotatedWithBooleanEnumerationReference;
    }

    public BooleanDisplayType getBooleanEnumerationDisplayType() {
        return this._booleanEnumerationDisplayType;
    }

    public void setBooleanEnumerationDisplayType(BooleanDisplayType displayType) {
        this._booleanEnumerationDisplayType = displayType;
    }

    private void annotateBooleanEnumerationReference(Class<?> type) {
        BooleanEnumerationReference annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, BooleanEnumerationReference.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(BooleanEnumerationReference.class)) != null) {
            if (BooleanEnumerationEntity.class.isAssignableFrom(type)) {
                this._booleanEnumerationDisplayType = (BooleanDisplayType)this.specified(new BooleanDisplayType[]{annotation.displayType(), this._booleanEnumerationDisplayType});
                this._annotatedWithBooleanEnumerationReference = true;
            } else {
                boolean log;
                boolean bl = log = this.depth() == 0;
                if (log) {
                    logger.error((Object)(type + " is annotated with BooleanEnumerationReference but does implement BooleanEnumeration"));
                    Project.increaseParserErrorCount();
                }
            }
        }
    }

    private void annotateBooleanEnumerationReference(Field field) {
        this._annotatedWithBooleanEnumerationReference = field.isAnnotationPresent(BooleanEnumerationReference.class);
        if (this._annotatedWithBooleanEnumerationReference) {
            Class<?> type = field.getType();
            if (type != null && BooleanEnumerationEntity.class.isAssignableFrom(type)) {
                BooleanEnumerationReference annotation = field.getAnnotation(BooleanEnumerationReference.class);
                this._booleanEnumerationDisplayType = (BooleanDisplayType)this.specified(new BooleanDisplayType[]{annotation.displayType(), this._booleanEnumerationDisplayType});
            } else {
                boolean log;
                boolean bl = log = this.depth() == 0;
                if (log) {
                    logger.error((Object)(field + " is annotated with BooleanEnumerationReference but " + type + " does implement BooleanEnumeration"));
                    Project.increaseParserErrorCount();
                }
            }
        }
    }

    public boolean isSelectItemsWithFilter() {
        return this._removeInstanceArray != null && this._removeInstanceArray.length > 0 || this._searchInstanceArray != null && this._searchInstanceArray.length > 0;
    }

    public Instance[] getSelectItemsArray() {
        List<Instance> list = this.getSelectItemsList();
        Instance[] array = new Instance[list.size()];
        return list.toArray(array);
    }

    public List<Instance> getSelectItemsList() {
        List<Instance> list = this.getInstancesList();
        if (this._removeInstanceArray != null && this._removeInstanceArray.length > 0) {
            List<Instance> remove = Arrays.asList(this._removeInstanceArray);
            list.removeAll(remove);
        }
        if (this._searchInstanceArray != null && this._searchInstanceArray.length > 0) {
            List<Instance> retain = Arrays.asList(this._searchInstanceArray);
            list.retainAll(retain);
        }
        return list;
    }

    public Instance[] getRemoveInstanceArray() {
        return this._removeInstanceArray;
    }

    public void setRemoveInstanceArray(Instance ... instances) {
        this._removeInstanceArray = instances;
        this._searchInstanceArray = null;
    }

    public String[] getRemoveInstanceStringArray() {
        if (this._removeInstanceArray == null || this._removeInstanceArray.length == 0) {
            return null;
        }
        int n = this._removeInstanceArray.length;
        String[] strings = new String[n];
        for (int i = 0; i < n; ++i) {
            strings[i] = this._removeInstanceArray[i].getInstanceKeyValue().toString();
        }
        return strings;
    }

    public Instance[] getSearchInstanceArray() {
        if (this._searchInstanceArray == null && this._removeInstanceArray != null && this._removeInstanceArray.length > 0) {
            this._searchInstanceArray = this.getInsertableRowsList().toArray((Instance[])ArrUtils.arrayOf(Instance.class));
            for (Instance instance : this._removeInstanceArray) {
                this._searchInstanceArray = (Instance[])ArrayUtils.removeElement((Object[])this._searchInstanceArray, (Object)instance);
            }
        }
        return this._searchInstanceArray;
    }

    public void setSearchInstanceArray(Instance ... instances) {
        this._searchInstanceArray = instances;
        this._removeInstanceArray = null;
    }

    public String[] getSearchInstanceStringArray() {
        if (this._searchInstanceArray == null || this._searchInstanceArray.length == 0) {
            return null;
        }
        int n = this._searchInstanceArray.length;
        String[] strings = new String[n];
        for (int i = 0; i < n; ++i) {
            strings[i] = this._searchInstanceArray[i].getInstanceKeyValue().toString();
        }
        return strings;
    }
}

