/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.bundles.Bundle;
import adalid.core.AbstractArtifact;
import adalid.core.Display;
import adalid.core.EntityCollection;
import adalid.core.Step;
import adalid.core.StepField;
import adalid.core.Tab;
import adalid.core.TabField;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.DataArtifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.Property;
import adalid.core.sql.QueryTable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class DisplayField
extends AbstractArtifact
implements Comparable<DisplayField> {
    private static final String EOL = "\n";
    private final Display _display;
    private final DataArtifact _dataArtifact;
    private final EntityCollection _entityCollection;
    private final DisplayField _parent;
    private Step _step;
    private int _stepFieldIndex;
    private final Map<Tab, Integer> _tabs = new LinkedHashMap<Tab, Integer>();
    private boolean _foreignCode;
    private boolean _foreignName;
    private List<DisplayField> _children;

    public DisplayField(Display display, EntityCollection collection) {
        this._display = display;
        this._dataArtifact = null;
        this._entityCollection = collection;
        this._parent = null;
        String name = collection.getName() + "EntityCollection";
        this.init(name);
    }

    public DisplayField(Display display, Property property) {
        this(display, display.getQueryTable(), property, null);
    }

    public DisplayField(Display display, QueryTable queryTable, Property property, DisplayField parentField) {
        this._display = display;
        this._dataArtifact = property;
        this._entityCollection = null;
        this._parent = parentField;
        String name = this.name(queryTable, property);
        this.init(name);
    }

    public Display getDisplay() {
        return this._display;
    }

    public Artifact getArtifact() {
        return this._dataArtifact == null ? this._entityCollection : this._dataArtifact;
    }

    public DataArtifact getDataArtifact() {
        return this._dataArtifact;
    }

    public boolean isDataArtifact() {
        return this._dataArtifact != null;
    }

    public Parameter getParameter() {
        return this._dataArtifact instanceof Parameter ? (Parameter)this._dataArtifact : null;
    }

    public boolean isParameter() {
        return this.getParameter() != null;
    }

    public Property getProperty() {
        return this._dataArtifact instanceof Property ? (Property)this._dataArtifact : null;
    }

    public boolean isProperty() {
        return this.getProperty() != null;
    }

    public EntityCollection getEntityCollection() {
        return this._entityCollection;
    }

    public boolean isEntityCollection() {
        return this._entityCollection != null;
    }

    public DisplayField getParent() {
        return this._parent;
    }

    public Step getStep() {
        return this._step;
    }

    public int getStepFieldIndex() {
        return this._stepFieldIndex;
    }

    public Map<Tab, Integer> getTabs() {
        return this._tabs;
    }

    public boolean isInTab(Tab tab) {
        return tab != null && this._tabs.containsKey(tab);
    }

    public int getTabFieldIndex(Tab tab) {
        Integer index = tab == null ? null : this._tabs.get(tab);
        return index == null ? 0 : index;
    }

    public boolean isForeignCode() {
        return this._foreignCode;
    }

    public void setForeignCode(boolean indicator) {
        this._foreignCode = indicator;
    }

    public DisplayField getForeignCodeField() {
        if (this._children != null && !this._children.isEmpty()) {
            for (DisplayField child : this._children) {
                if (!child.isForeignCode()) continue;
                return child;
            }
        }
        return null;
    }

    public boolean isForeignName() {
        return this._foreignName;
    }

    public void setForeignName(boolean indicator) {
        this._foreignName = indicator;
    }

    public DisplayField getForeignNameField() {
        if (this._children != null && !this._children.isEmpty()) {
            for (DisplayField child : this._children) {
                if (!child.isForeignName()) continue;
                return child;
            }
        }
        return null;
    }

    public List<DisplayField> getChildren() {
        return this._children;
    }

    private String name(QueryTable queryTable, Property property) {
        String name = property.getName();
        if (queryTable != null) {
            String sqlAlias = queryTable.getSqlAlias(property);
            return sqlAlias == null ? name : sqlAlias;
        }
        return name;
    }

    private String alias(String name) {
        String prefix = this.string("prefix");
        String suffix = this.string("suffix");
        return prefix + name + suffix;
    }

    private String string(String keyword) {
        String uic = this.getClass().getSimpleName();
        String key = uic + ".name." + keyword;
        return Bundle.getTrimmedToEmptyString(key);
    }

    private void init(String name) {
        List<Tab> tabsList;
        Entity entity;
        List<Step> stepsList;
        this.setDeclared(name, this._display);
        String alias = this.alias(name);
        this.setAlias(alias);
        this._foreignCode = false;
        this._foreignName = false;
        this._children = new ArrayList<DisplayField>();
        if (this._parent != null) {
            this._parent.getChildren().add(this);
        }
        if (!(stepsList = (entity = this._display.getEntity()).getStepsList()).isEmpty()) {
            DataArtifact dataArtifact;
            DataArtifact dataArtifact2 = dataArtifact = this._parent == null ? this._dataArtifact : this._parent.getDataArtifact();
            if (this._entityCollection != null || dataArtifact != null && dataArtifact.isProperty()) {
                block0: for (Step step : stepsList) {
                    int index = 0;
                    for (StepField stepField : step.getStepFieldsList()) {
                        Property sfp = stepField.getProperty();
                        EntityCollection sfc = stepField.getEntityCollection();
                        if (sfp != null) {
                            if (sfp == dataArtifact) {
                                this._step = step;
                                this._stepFieldIndex = index;
                                break block0;
                            }
                        } else if (sfc != null && sfc == this._entityCollection) {
                            this._step = step;
                            this._stepFieldIndex = index;
                            break block0;
                        }
                        ++index;
                    }
                }
            }
        }
        if (!(tabsList = entity.getTabsList()).isEmpty()) {
            DataArtifact dataArtifact;
            DataArtifact dataArtifact3 = dataArtifact = this._parent == null ? this._dataArtifact : this._parent.getDataArtifact();
            if (this._entityCollection != null || dataArtifact != null && dataArtifact.isProperty()) {
                for (Tab tab : tabsList) {
                    int index = 0;
                    for (TabField tabField : tab.getTabFieldsList()) {
                        Property tfp = tabField.getProperty();
                        EntityCollection tfc = tabField.getEntityCollection();
                        if (tfp != null) {
                            if (tfp == dataArtifact) {
                                this._tabs.put(tab, index);
                            }
                        } else if (tfc != null && tfc == this._entityCollection) {
                            this._tabs.put(tab, index);
                        }
                        ++index;
                    }
                }
            }
        }
    }

    @Override
    public int compareTo(DisplayField o) {
        if (o != null) {
            DisplayField that = o;
            String thisName = StringUtils.trimToEmpty((String)this.getName());
            String thatName = StringUtils.trimToEmpty((String)that.getName());
            return thisName.compareTo(thatName);
        }
        return 0;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "display" + faa + this._display + foo;
            string = (String)string + fee + tab + "dataArtifact" + faa + this._dataArtifact + foo;
            if (this._parent != null) {
                string = (String)string + fee + tab + "parent" + faa + this._parent + foo;
                string = (String)string + fee + tab + "foreignCode" + faa + this._foreignCode + foo;
                string = (String)string + fee + tab + "foreignName" + faa + this._foreignName + foo;
            }
        }
        return string;
    }

    @Override
    protected String mapsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String foo = verbose ? EOL : ", ";
        Object string = super.mapsToString(n, key, verbose, fields, maps);
        if ((maps || verbose) && this._children != null && !this._children.isEmpty()) {
            string = (String)string + fee + tab + DisplayField.class.getSimpleName() + "[] children {" + foo;
            for (DisplayField field : this._children) {
                string = (String)string + field.toString(n + 2, null, verbose, fields, maps);
            }
            string = (String)string + fee + tab + "}";
        }
        return string;
    }
}

