/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.ColUtils;
import adalid.core.AbstractArtifact;
import adalid.core.Display;
import adalid.core.EntityCollectionAggregate;
import adalid.core.Project;
import adalid.core.Step;
import adalid.core.TLC;
import adalid.core.Tab;
import adalid.core.XS1;
import adalid.core.annotations.EntityCollectionField;
import adalid.core.annotations.OneToMany;
import adalid.core.enums.AggregateFunction;
import adalid.core.enums.CascadeType;
import adalid.core.enums.DataEntryFormat;
import adalid.core.enums.FetchType;
import adalid.core.enums.Kleenean;
import adalid.core.enums.PropertyAccess;
import adalid.core.interfaces.AnnotatableArtifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Property;
import adalid.core.primitives.BooleanPrimitive;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EntityCollection
extends AbstractArtifact
implements AnnotatableArtifact {
    private static final Logger logger = Logger.getLogger(EntityCollection.class);
    private static final CascadeType[] default_cascade_type = new CascadeType[]{CascadeType.PERSIST, CascadeType.REFRESH};
    private boolean _annotatedWithOneToMany;
    private boolean _annotatedWithEntityCollectionField;
    private Entity _sourceEntity;
    private Class<? extends Entity> _targetEntityClass = Entity.class;
    private Entity _targetEntity;
    private String _mappedByFieldName;
    private Field _mappedByField;
    private Property _mappedByProperty;
    private FetchType _fetchType = FetchType.UNSPECIFIED;
    private CascadeType[] _cascadeType = default_cascade_type;
    private List<CascadeType> _cascadeList = Arrays.asList(default_cascade_type);
    private Kleenean _orphanRemoval = Kleenean.UNSPECIFIED;
    private Kleenean _createField = Kleenean.UNSPECIFIED;
    private Kleenean _updateField = Kleenean.UNSPECIFIED;
    private Kleenean _removeField = Kleenean.UNSPECIFIED;
    private Kleenean _detailField = Kleenean.UNSPECIFIED;
    private boolean _renderingFilterReadOnly;
    private BooleanExpression _renderingFilter;
    private BooleanExpression _nullifyingFilter;
    private PropertyAccess _propertyAccess = PropertyAccess.UNSPECIFIED;
    private DataEntryFormat _dataEntryFormat = DataEntryFormat.UNSPECIFIED;
    private String _readingViewRowActionSnippetFileName = "";
    private String _readingViewRowStatusSnippetFileName = "";
    private String _readingViewRowNumberSnippetFileName = "";
    private String _writingViewRowActionSnippetFileName = "";
    private String _writingViewRowStatusSnippetFileName = "";
    private String _writingViewRowNumberSnippetFileName = "";
    private Step _step;
    private Tab _tab;
    private boolean _setDisplays = true;
    private Display _readingDisplay;
    private Display _readingTableDisplay;
    private Display _readingDetailDisplay;
    private Display _writingDisplay;
    private Display _writingTableDisplay;
    private Display _writingDetailDisplay;
    private Display _insertDisplay;
    private Display _updateDisplay;
    private Display _deleteDisplay;
    private final Map<Entity, Display> _extensionReadingDisplays = new LinkedHashMap<Entity, Display>();
    private final Map<Entity, Display> _extensionWritingDisplays = new LinkedHashMap<Entity, Display>();
    private final Map<String, EntityCollectionAggregate> _aggregates = new LinkedHashMap<String, EntityCollectionAggregate>();
    private final Map<Locale, String> _localizedRenderingFilterTag = new LinkedHashMap<Locale, String>();
    private final Map<Locale, String> _localizedNullifyingFilterTag = new LinkedHashMap<Locale, String>();

    public Entity getSourceEntity() {
        return this._sourceEntity;
    }

    public Class<? extends Entity> getTargetEntityClass() {
        return this._targetEntityClass;
    }

    public Entity getTargetEntity() {
        return this._targetEntity;
    }

    public String getMappedByFieldName() {
        return this._mappedByFieldName;
    }

    public Field getMappedByField() {
        return this._mappedByField;
    }

    public Property getMappedByProperty() {
        return this._mappedByProperty;
    }

    public boolean isOneToMany() {
        return this._annotatedWithOneToMany;
    }

    public FetchType getFetchType() {
        return FetchType.UNSPECIFIED.equals((Object)this._fetchType) ? (this.isUpdateField() ? FetchType.EAGER : FetchType.LAZY) : this._fetchType;
    }

    public void setFetchType(FetchType fetchType) {
        this._fetchType = fetchType == null ? FetchType.UNSPECIFIED : fetchType;
    }

    public CascadeType[] getCascadeType() {
        return this._cascadeType;
    }

    public void setCascadeType(CascadeType ... cascadeType) {
        this._cascadeType = this.cascadeTypeOf(cascadeType);
        this._cascadeList = Arrays.asList(this._cascadeType);
    }

    private CascadeType[] cascadeTypeOf(CascadeType ... cascadeType) {
        return cascadeType == null || cascadeType.length == 0 ? (this._cascadeType == null ? default_cascade_type : this._cascadeType) : cascadeType;
    }

    public String getCascadeTypeString() {
        if (ArrayUtils.contains((Object[])this._cascadeType, (Object)((Object)CascadeType.UNSPECIFIED))) {
            return null;
        }
        if (ArrayUtils.contains((Object[])this._cascadeType, (Object)((Object)CascadeType.ALL))) {
            return "CascadeType.ALL";
        }
        EnumSet<CascadeType> set = EnumSet.noneOf(CascadeType.class);
        if (this.cascadeListContainsAny(CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE)) {
            set.add(CascadeType.REFRESH);
        }
        set.addAll(this._cascadeList);
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (CascadeType ct : set) {
            list.add((CallSite)((Object)("CascadeType." + ct.name())));
        }
        return list.size() == 1 ? (String)list.get(0) : "{" + StringUtils.join(list, (String)", ") + "}";
    }

    public boolean isCascadeRefresh() {
        return this.cascadeListContainsAny(CascadeType.ALL, CascadeType.REFRESH, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE);
    }

    public boolean isCascadePersist() {
        return this.cascadeListContainsAny(CascadeType.ALL, CascadeType.PERSIST);
    }

    public boolean isCascadeMerge() {
        return this.cascadeListContainsAny(CascadeType.ALL, CascadeType.MERGE);
    }

    public boolean isCascadeRemove() {
        return this.cascadeListContainsAny(CascadeType.ALL, CascadeType.REMOVE);
    }

    private boolean cascadeListContainsAny(CascadeType ... types) {
        return !Collections.disjoint(this._cascadeList, Arrays.asList(types));
    }

    public boolean isOrphanRemoval() {
        return this._orphanRemoval.toBoolean(this.isUpdateField());
    }

    public void setOrphanRemoval(boolean remove) {
        this._orphanRemoval = Kleenean.valueOf(remove);
    }

    public boolean isCreateField() {
        boolean cascade = this.isCascadePersist();
        return cascade && this._createField.toBoolean(cascade);
    }

    public void setCreateField(boolean create) {
        this._createField = Kleenean.valueOf(create);
    }

    public boolean isUpdateField() {
        boolean cascade = this.isCascadeMerge();
        return cascade && this._updateField.toBoolean(cascade);
    }

    public void setUpdateField(boolean update) {
        this._updateField = Kleenean.valueOf(update);
    }

    protected boolean isRemoveField() {
        boolean cascade = this.isCascadeRemove();
        return cascade && this._removeField.toBoolean(cascade);
    }

    protected void setRemoveField(boolean remove) {
        this._removeField = Kleenean.valueOf(remove);
    }

    public boolean isDetailField() {
        boolean cascade = this.isCascadeRefresh();
        return cascade && this._detailField.toBoolean(cascade);
    }

    public void setDetailField(boolean detail) {
        this._detailField = Kleenean.valueOf(detail);
    }

    public boolean isAuditable() {
        return true;
    }

    public boolean isNullable() {
        return true;
    }

    public boolean isRenderingFilterReadOnly() {
        return this._renderingFilterReadOnly;
    }

    public BooleanExpression getRenderingFilter() {
        return this._renderingFilter;
    }

    public void setRenderingFilter(BooleanExpression renderingFilter) {
        this.setRenderingFilter(renderingFilter, false);
    }

    public void setRenderingFilter(BooleanExpression renderingFilter, boolean readOnly) {
        boolean log = this.depth() == 0;
        String message = "failed to set rendering filter of " + this.getFullName();
        if (renderingFilter == null) {
            if (log) {
                message = message + "; supplied expression is null";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else {
            this._renderingFilter = renderingFilter instanceof BooleanPrimitive ? renderingFilter.isTrue() : renderingFilter;
        }
        this._renderingFilterReadOnly = readOnly;
    }

    public BooleanExpression getNullifyingFilter() {
        return this._nullifyingFilter;
    }

    public void setNullifyingFilter(BooleanExpression nullifyingFilter) {
        boolean log = this.depth() == 0;
        String message = "failed to set nullifying filter of " + this.getFullName();
        if (nullifyingFilter == null) {
            if (log) {
                message = message + "; supplied expression is null";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
        } else {
            this._nullifyingFilter = nullifyingFilter instanceof BooleanPrimitive ? nullifyingFilter.isTrue() : nullifyingFilter;
        }
    }

    public PropertyAccess getPropertyAccess() {
        return this._propertyAccess;
    }

    public void setPropertyAccess(PropertyAccess access) {
        this._propertyAccess = access == null ? PropertyAccess.UNSPECIFIED : access;
    }

    public DataEntryFormat getDataEntryFormat() {
        return this._dataEntryFormat;
    }

    public void setDataEntryFormat(DataEntryFormat format) {
        this._dataEntryFormat = format == null ? DataEntryFormat.UNSPECIFIED : format;
    }

    public String getReadingViewRowActionSnippetFileName() {
        return this._readingViewRowActionSnippetFileName;
    }

    protected void setReadingViewRowActionSnippetFileName(String fileName) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (StringUtils.isBlank((String)fileName)) {
            this._readingViewRowActionSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._readingViewRowActionSnippetFileName = fileName;
        } else if (log) {
            logger.error((Object)(this.getName() + " reading table view collection row action snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getReadingViewRowStatusSnippetFileName() {
        return this._readingViewRowStatusSnippetFileName;
    }

    protected void setReadingViewRowStatusSnippetFileName(String fileName) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (StringUtils.isBlank((String)fileName)) {
            this._readingViewRowStatusSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._readingViewRowStatusSnippetFileName = fileName;
        } else if (log) {
            logger.error((Object)(this.getName() + " reading table view collection row status snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getReadingViewRowNumberSnippetFileName() {
        return this._readingViewRowNumberSnippetFileName;
    }

    protected void setReadingViewRowNumberSnippetFileName(String fileName) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (StringUtils.isBlank((String)fileName)) {
            this._readingViewRowNumberSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._readingViewRowNumberSnippetFileName = fileName;
        } else if (log) {
            logger.error((Object)(this.getName() + " reading table view collection row number snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getWritingViewRowActionSnippetFileName() {
        return this._writingViewRowActionSnippetFileName;
    }

    protected void setWritingViewRowActionSnippetFileName(String fileName) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (StringUtils.isBlank((String)fileName)) {
            this._writingViewRowActionSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._writingViewRowActionSnippetFileName = fileName;
        } else if (log) {
            logger.error((Object)(this.getName() + " writing table view collection row action snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getWritingViewRowStatusSnippetFileName() {
        return this._writingViewRowStatusSnippetFileName;
    }

    protected void setWritingViewRowStatusSnippetFileName(String fileName) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (StringUtils.isBlank((String)fileName)) {
            this._writingViewRowStatusSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._writingViewRowStatusSnippetFileName = fileName;
        } else if (log) {
            logger.error((Object)(this.getName() + " writing table view collection row status snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public String getWritingViewRowNumberSnippetFileName() {
        return this._writingViewRowNumberSnippetFileName;
    }

    protected void setWritingViewRowNumberSnippetFileName(String fileName) {
        boolean log;
        boolean bl = log = this.depth() == 0;
        if (StringUtils.isBlank((String)fileName)) {
            this._writingViewRowNumberSnippetFileName = "";
        } else if (this.isValidSnippetFileName(fileName)) {
            this._writingViewRowNumberSnippetFileName = fileName;
        } else if (log) {
            logger.error((Object)(this.getName() + " writing table view collection row number snippet is invalid "));
            Project.increaseParserErrorCount();
        }
    }

    public Step getStep() {
        return this._step;
    }

    void setStep(Step step) {
        this._step = step;
    }

    public Tab getTab() {
        return this._tab;
    }

    void setTab(Tab tab) {
        this._tab = tab;
    }

    public Display getDisplay(String pageDisplayMode) {
        return StringUtils.equalsIgnoreCase((String)pageDisplayMode, (String)"READING") ? this.getReadingDisplay() : this.getWritingDisplay();
    }

    public Display getTableDisplay(String pageDisplayMode) {
        return StringUtils.equalsIgnoreCase((String)pageDisplayMode, (String)"READING") ? this.getReadingTableDisplay() : this.getWritingTableDisplay();
    }

    public Display getDetailDisplay(String pageDisplayMode) {
        return StringUtils.equalsIgnoreCase((String)pageDisplayMode, (String)"READING") ? this.getReadingDetailDisplay() : this.getWritingDetailDisplay();
    }

    private Display getReadingDisplay() {
        this.setDisplays();
        return this._readingDisplay;
    }

    private Display getReadingTableDisplay() {
        this.setDisplays();
        return this._readingTableDisplay;
    }

    private Display getReadingDetailDisplay() {
        this.setDisplays();
        return this._readingDetailDisplay;
    }

    private Display getWritingDisplay() {
        this.setDisplays();
        return this._writingDisplay;
    }

    private Display getWritingTableDisplay() {
        this.setDisplays();
        return this._writingTableDisplay;
    }

    private Display getWritingDetailDisplay() {
        this.setDisplays();
        return this._writingDetailDisplay;
    }

    public Display getInsertDisplay() {
        this.setDisplays();
        return this._insertDisplay;
    }

    public Display getUpdateDisplay() {
        this.setDisplays();
        return this._updateDisplay;
    }

    public Display getDeleteDisplay() {
        this.setDisplays();
        return this._deleteDisplay;
    }

    private void setDisplays() {
        if (this._setDisplays && this._sourceEntity != null && this._targetEntity != null && this._mappedByProperty instanceof EntityReference) {
            EntityReference reference = (EntityReference)this._mappedByProperty;
            Project project = TLC.getProject();
            if (project != null) {
                this._readingTableDisplay = this.applicationDisplay(project.getReadingTableDisplayOf(this._targetEntity, this._sourceEntity, reference));
                this._readingDetailDisplay = this.applicationDisplay(project.getReadingDetailDisplayOf(this._targetEntity, this._sourceEntity, reference));
                this._readingDisplay = DataEntryFormat.TABLE_OR_DETAIL.equals((Object)this._dataEntryFormat) ? (this._readingTableDisplay == null ? this._readingDetailDisplay : this._readingTableDisplay) : (this._readingDetailDisplay == null ? this._readingTableDisplay : this._readingDetailDisplay);
                this._writingTableDisplay = this.applicationDisplay(project.getWritingTableDisplayOf(this._targetEntity, this._sourceEntity, reference));
                this._writingDetailDisplay = this.applicationDisplay(project.getWritingDetailDisplayOf(this._targetEntity, this._sourceEntity, reference));
                this._writingDisplay = DataEntryFormat.TABLE_OR_DETAIL.equals((Object)this._dataEntryFormat) ? (this._writingTableDisplay == null ? this._writingDetailDisplay : this._writingTableDisplay) : (this._writingDetailDisplay == null ? this._writingTableDisplay : this._writingDetailDisplay);
                this._insertDisplay = this._writingDetailDisplay;
                this._updateDisplay = this._writingDetailDisplay;
                this._deleteDisplay = this._writingDetailDisplay;
                if (this._writingDisplay == this._writingTableDisplay) {
                    if (this._targetEntity.isTableViewWithInsertEnabled()) {
                        this._insertDisplay = this._writingTableDisplay;
                    }
                    if (this._targetEntity.isTableViewWithUpdateEnabled()) {
                        this._updateDisplay = this._writingTableDisplay;
                    }
                    if (this._targetEntity.isTableViewWithDeleteEnabled()) {
                        this._deleteDisplay = this._writingTableDisplay;
                    }
                }
                this._setDisplays = false;
            }
        }
    }

    public Display getExtensionDisplay(Entity extension, String pageDisplayMode) {
        Entity root = extension == null ? null : extension.getRoot();
        return root == null ? null : this.extensionDisplay(root, pageDisplayMode);
    }

    private Display extensionDisplay(Entity extension, String pageDisplayMode) {
        Map<Entity, Display> map;
        Map<Entity, Display> map2 = map = StringUtils.equalsIgnoreCase((String)pageDisplayMode, (String)"READING") ? this._extensionReadingDisplays : this._extensionWritingDisplays;
        if (map.containsKey(extension)) {
            return map.get(extension);
        }
        Display readingDisplay = null;
        Display writingDisplay = null;
        if (this._sourceEntity != null && this._targetEntity != null && this._mappedByProperty instanceof EntityReference && extension != null && this._targetEntity.getClass().isAssignableFrom(extension.getClass())) {
            EntityReference reference = this.extensionReference(extension);
            Project project = TLC.getProject();
            if (project != null) {
                if (DataEntryFormat.TABLE_OR_DETAIL.equals((Object)this._dataEntryFormat)) {
                    readingDisplay = project.getReadingTableDisplayOf(extension, this._sourceEntity, reference);
                    if (readingDisplay == null) {
                        readingDisplay = project.getReadingDetailDisplayOf(extension, this._sourceEntity, reference);
                    }
                    if ((writingDisplay = project.getWritingTableDisplayOf(extension, this._sourceEntity, reference)) == null) {
                        writingDisplay = project.getWritingDetailDisplayOf(extension, this._sourceEntity, reference);
                    }
                } else {
                    readingDisplay = project.getReadingDetailDisplayOf(extension, this._sourceEntity, reference);
                    if (readingDisplay == null) {
                        readingDisplay = project.getReadingTableDisplayOf(extension, this._sourceEntity, reference);
                    }
                    if ((writingDisplay = project.getWritingDetailDisplayOf(extension, this._sourceEntity, reference)) == null) {
                        writingDisplay = project.getWritingTableDisplayOf(extension, this._sourceEntity, reference);
                    }
                }
                this._extensionReadingDisplays.put(extension, readingDisplay);
                this._extensionWritingDisplays.put(extension, writingDisplay);
            }
        }
        return StringUtils.equalsIgnoreCase((String)pageDisplayMode, (String)"READING") ? readingDisplay : writingDisplay;
    }

    private EntityReference extensionReference(Entity extension) {
        String mappedByPropertyName = this._mappedByProperty.getName();
        for (Property property : extension.getPropertiesList()) {
            if (!(property instanceof EntityReference) || !property.getName().equals(mappedByPropertyName)) continue;
            return (EntityReference)property;
        }
        return null;
    }

    private Display applicationDisplay(Display display) {
        return display != null && display.isApplicationDefaultLocation() ? display : null;
    }

    public List<EntityCollectionAggregate> getAggregatesList() {
        return ColUtils.toList(this._aggregates.values());
    }

    public EntityCollectionAggregate addCount(int minimum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, null);
    }

    public EntityCollectionAggregate addCount(int minimum, int maximum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, maximum);
    }

    public EntityCollectionAggregate addCount(String fieldName, int minimum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addCount(String fieldName, int minimum, int maximum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addSum(String fieldName, Number minimum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addSum(String fieldName, Number minimum, Number maximum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addAverage(String fieldName, Number minimum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addAverage(String fieldName, Number minimum, Number maximum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addCount(NumericExpression minimum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, null);
    }

    public EntityCollectionAggregate addCount(NumericExpression minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, maximum);
    }

    public EntityCollectionAggregate addCount(String fieldName, NumericExpression minimum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addCount(String fieldName, NumericExpression minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addSum(String fieldName, NumericExpression minimum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addSum(String fieldName, NumericExpression minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addAverage(String fieldName, NumericExpression minimum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, null);
    }

    public EntityCollectionAggregate addAverage(String fieldName, NumericExpression minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addCount(int minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, maximum);
    }

    public EntityCollectionAggregate addCount(NumericExpression minimum, int maximum) {
        return this.newAggregate(AggregateFunction.COUNT, "*", minimum, maximum);
    }

    public EntityCollectionAggregate addCount(String fieldName, int minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addCount(String fieldName, NumericExpression minimum, int maximum) {
        return this.newAggregate(AggregateFunction.COUNT, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addSum(String fieldName, Number minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addSum(String fieldName, NumericExpression minimum, Number maximum) {
        return this.newAggregate(AggregateFunction.SUM, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addAverage(String fieldName, Number minimum, NumericExpression maximum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, maximum);
    }

    public EntityCollectionAggregate addAverage(String fieldName, NumericExpression minimum, Number maximum) {
        return this.newAggregate(AggregateFunction.AVERAGE, fieldName, minimum, maximum);
    }

    private EntityCollectionAggregate newAggregate(AggregateFunction function, String fieldName, Object minimum, Object maximum) {
        String key = EntityCollectionAggregate.key(function, fieldName);
        EntityCollectionAggregate aggregate = new EntityCollectionAggregate(this, function, fieldName, minimum, maximum);
        this._aggregates.put(key, aggregate);
        return aggregate;
    }

    public String getRenderingFilterTag() {
        return this.getLocalizedRenderingFilterTag(null);
    }

    public void setRenderingFilterTag(String tag) {
        this.setLocalizedRenderingFilterTag(null, tag);
    }

    public String getNullifyingFilterTag() {
        return this.getLocalizedNullifyingFilterTag(null);
    }

    public void setNullifyingFilterTag(String tag) {
        this.setLocalizedNullifyingFilterTag(null, tag);
    }

    public String getLocalizedRenderingFilterTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedRenderingFilterTag.get(l);
    }

    public void setLocalizedRenderingFilterTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedRenderingFilterTag.remove(l);
        } else {
            this._localizedRenderingFilterTag.put(l, tag);
        }
    }

    public String getLocalizedNullifyingFilterTag(Locale locale) {
        Locale l = this.localeReadingKey(locale);
        return this._localizedNullifyingFilterTag.get(l);
    }

    public void setLocalizedNullifyingFilterTag(Locale locale, String tag) {
        Locale l = this.localeWritingKey(locale);
        if (tag == null) {
            this._localizedNullifyingFilterTag.remove(l);
        } else {
            this._localizedNullifyingFilterTag.put(l, tag);
        }
    }

    public boolean isEntityCollectionField() {
        return this.isDetailField() || this.isCreateField() || this.isUpdateField();
    }

    public boolean isEntityCollectionField(String pageDisplayMode) {
        return StringUtils.equalsIgnoreCase((String)pageDisplayMode, (String)"READING") ? this.isDetailField() : this.isDetailField() || this.isCreateField() || this.isUpdateField();
    }

    public boolean isEntityCollectionWithDisplay() {
        return this.isEntityCollectionWithReadingDisplay() || this.isEntityCollectionWithWritingDisplay();
    }

    public boolean isEntityCollectionWithDisplay(String pageDisplayMode) {
        return StringUtils.equalsIgnoreCase((String)pageDisplayMode, (String)"READING") ? this.isEntityCollectionWithReadingDisplay() : this.isEntityCollectionWithWritingDisplay();
    }

    public boolean isEntityCollectionWithReadingDisplay() {
        return this.getReadingDisplay() != null;
    }

    public boolean isEntityCollectionWithWritingDisplay() {
        return this.getWritingDisplay() != null;
    }

    @Override
    protected List<Class<? extends Annotation>> getValidFieldAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidFieldAnnotations();
        valid.add(OneToMany.class);
        valid.add(EntityCollectionField.class);
        return valid;
    }

    @Override
    void annotate(Field field) {
        super.annotate(field);
        if (field != null) {
            this.annotateOneToMany(field);
            this.annotateEntityCollectionField(field);
        }
    }

    private void annotateOneToMany(Field field) {
        this._annotatedWithOneToMany = field.isAnnotationPresent(OneToMany.class);
        if (this._annotatedWithOneToMany) {
            OneToMany annotation = field.getAnnotation(OneToMany.class);
            this._targetEntityClass = annotation.targetEntity();
            this._mappedByFieldName = annotation.mappedBy();
            this._fetchType = (FetchType)this.specified(new FetchType[]{annotation.fetch(), this._fetchType});
            this._cascadeType = this.cascadeTypeOf(annotation.cascade());
            this._cascadeList = Arrays.asList(this._cascadeType);
            this._orphanRemoval = (Kleenean)this.specified(new Kleenean[]{annotation.orphanRemoval(), this._orphanRemoval});
        }
    }

    private void annotateEntityCollectionField(Field field) {
        this._annotatedWithEntityCollectionField = field.isAnnotationPresent(EntityCollectionField.class);
        if (this._annotatedWithEntityCollectionField) {
            EntityCollectionField annotation = field.getAnnotation(EntityCollectionField.class);
            this._createField = (Kleenean)this.specified(new Kleenean[]{annotation.create(), this._createField});
            this._updateField = (Kleenean)this.specified(new Kleenean[]{annotation.update(), this._updateField});
            this._detailField = (Kleenean)this.specified(new Kleenean[]{annotation.detail(), this._detailField});
            this._propertyAccess = (PropertyAccess)this.specified(new PropertyAccess[]{annotation.access(), this._propertyAccess});
            this._dataEntryFormat = (DataEntryFormat)this.specified(new DataEntryFormat[]{annotation.format(), this._dataEntryFormat});
            String fileName = annotation.readingViewRowActionSnippet();
            if (StringUtils.isNotBlank((String)fileName)) {
                this.setReadingViewRowActionSnippetFileName(fileName);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.readingViewRowStatusSnippet()))) {
                this.setReadingViewRowStatusSnippetFileName(fileName);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.readingViewRowNumberSnippet()))) {
                this.setReadingViewRowNumberSnippetFileName(fileName);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.writingViewRowActionSnippet()))) {
                this.setWritingViewRowActionSnippetFileName(fileName);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.writingViewRowStatusSnippet()))) {
                this.setWritingViewRowStatusSnippetFileName(fileName);
            }
            if (StringUtils.isNotBlank((String)(fileName = annotation.writingViewRowNumberSnippet()))) {
                this.setWritingViewRowNumberSnippetFileName(fileName);
            }
            this.setInlineHelpType(annotation.inlineHelp());
        }
    }

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.finaliseOneToMany();
        }
        return ok;
    }

    private boolean finaliseOneToMany() {
        if (this.depth() > 0) {
            return true;
        }
        boolean log = this.depth() == 0;
        String fullName = this.getFullName();
        Entity declaringEntity = this.getDeclaringEntity();
        Field declaringField = this.getDeclaringField();
        if (declaringField == null) {
            String message = "no declaring field defined for " + fullName;
            logger.fatal((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        Class<?> declaringFieldClass = declaringField.getDeclaringClass();
        Entity declaringFieldDeclaringEntity = TLC.getProject().getEntity(declaringFieldClass);
        if (declaringFieldDeclaringEntity == null) {
            String message = "no declaring entity defined for " + declaringField;
            logger.fatal((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        if (!declaringFieldDeclaringEntity.equals(declaringEntity)) {
            declaringEntity = declaringFieldDeclaringEntity;
        }
        this._sourceEntity = declaringEntity;
        Entity entity = this._targetEntity = this._targetEntityClass == null || this._targetEntityClass == Entity.class ? null : TLC.getProject().getEntity(this._targetEntityClass);
        if (this._targetEntity == null) {
            String message = "no target entity defined for " + fullName + "; it has an invalid target entity class.";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        Class<?> declaringEntityClass = declaringEntity.getClass();
        String decName = declaringEntityClass.getCanonicalName();
        String message = "no mapping defined for " + fullName;
        if (StringUtils.isBlank((String)this._mappedByFieldName)) {
            List<Field> fields = XS1.getEntityFields(this._targetEntityClass, Entity.class, declaringEntityClass);
            int size = fields.size();
            if (size == 0) {
                message = message + "; it has no mapped-by field name and there is no suitable " + decName + " field in " + this._targetEntityClass;
            } else if (size > 1) {
                message = message + "; it has no mapped-by field name and there is more than one suitable field in the target entity class.";
            } else {
                this._mappedByField = fields.get(0);
                this._mappedByFieldName = this._mappedByField.getName();
            }
        }
        if (StringUtils.isBlank((String)this._mappedByFieldName)) {
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        if (this._mappedByField == null) {
            Object[] strings = new String[]{declaringEntity.getName(), this.getName(), "mappedBy"};
            String role = StringUtils.join((Object[])strings, (String)".");
            Class[] validTypes = new Class[]{declaringEntityClass};
            this._mappedByField = XS1.getField(log, role, this._mappedByFieldName, this._targetEntityClass, Entity.class, validTypes);
        }
        if (this._mappedByField == null) {
            message = "no mapping defined for " + fullName + "; it has an invalid mapped-by field name.";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        this._mappedByProperty = XS1.getProperty(this._mappedByField, this._targetEntity);
        if (this._mappedByProperty == null) {
            message = "no mapping defined for " + fullName + "; it has an invalid mapped-by property name.";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        if (this._mappedByProperty.isCalculable()) {
            message = "no mapping defined for " + fullName + "; it has an invalid (calculable) mapped-by property.";
            logger.error((Object)message);
            Project.increaseParserErrorCount();
            return false;
        }
        if (this._mappedByProperty instanceof EntityReference) {
            EntityReference reference = (EntityReference)this._mappedByProperty;
            reference.setMappedCollection(this);
        }
        if (this.isUpdateField()) {
            if (FetchType.LAZY.equals((Object)this.getFetchType())) {
                message = fullName + " is an updatable collection and therefore requires its fetch type set to EAGER.";
                logger.error((Object)message);
                Project.increaseParserErrorCount();
            }
            if (!this.isOrphanRemoval()) {
                message = fullName + " is an updatable collection but it will not allow deletions because its orphan removal option set to false.";
                logger.warn((Object)message);
                Project.increaseParserWarningCount();
            }
        }
        List<EntityCollectionAggregate> aggregates = this.getAggregatesList();
        for (EntityCollectionAggregate aggregate : aggregates) {
            aggregate.check();
        }
        return true;
    }
}

