/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.commons.util.TimeUtils;
import adalid.core.AbstractArtifact;
import adalid.core.InstanceField;
import adalid.core.InstanceTag;
import adalid.core.Project;
import adalid.core.XS1;
import adalid.core.annotations.InstanceDataGen;
import adalid.core.expressions.EntityScalarX;
import adalid.core.expressions.XB;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.PersistentEntityReference;
import adalid.core.interfaces.Property;
import adalid.core.properties.BigDecimalProperty;
import adalid.core.properties.BigIntegerProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.ByteProperty;
import adalid.core.properties.CharacterProperty;
import adalid.core.properties.DateProperty;
import adalid.core.properties.DoubleProperty;
import adalid.core.properties.FloatProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.ShortProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimeProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Instance
extends AbstractArtifact {
    private static final Logger logger = Logger.getLogger(Instance.class);
    private int _index;
    private InstanceTag _customTag;
    private final List<InstanceField> _instanceFieldsList = new ArrayList<InstanceField>();
    private boolean _usualArgumentInExpressions = false;
    private boolean _annotatedWithInstanceDataGen;
    private int _dataGenWeight = 1;

    public InstanceTag getCustomTag() {
        return this._customTag;
    }

    public void setCustomTag(InstanceTag tag) {
        this._customTag = tag;
    }

    public List<InstanceField> getInstanceFieldsList() {
        return this._instanceFieldsList;
    }

    public Class<?> getInstanceKeyType() {
        InstanceField field = this.getInstanceKeyField();
        return field == null ? null : field.getProperty().getDataType();
    }

    public Object getInstanceKeyValue() {
        InstanceField field = this.getInstanceKeyField();
        return field == null ? null : field.getValue();
    }

    public String getInstanceKeyLabel() {
        return this.getInstanceKeyLabel(null);
    }

    public String getInstanceKeyLabel(Locale locale) {
        return this.code(locale);
    }

    public String getInstanceKeyDescription() {
        return this.getInstanceKeyDescription(null);
    }

    public String getInstanceKeyDescription(Locale locale) {
        String name = this.name(locale);
        return name != null ? name : this.description(locale);
    }

    private String code(Locale locale) {
        Entity declaringEntity = this.getDeclaringEntity();
        StringProperty property = declaringEntity == null ? null : declaringEntity.getCharacterKeyProperty();
        return this.string(property, locale);
    }

    private String name(Locale locale) {
        Entity declaringEntity = this.getDeclaringEntity();
        StringProperty property = declaringEntity == null ? null : declaringEntity.getNameProperty();
        return this.string(property, locale);
    }

    private String description(Locale locale) {
        Entity declaringEntity = this.getDeclaringEntity();
        StringProperty property = declaringEntity == null ? null : declaringEntity.getDescriptionProperty();
        return this.string(property, locale);
    }

    private String string(Property property, Locale locale) {
        String name = property == null ? null : property.getName();
        Object object = name == null ? null : this.getInstanceFieldValue(name, locale);
        return object == null ? null : object.toString();
    }

    public Object getInstanceFieldValue(String name) {
        return name == null ? null : this.getInstanceFieldValue(name, null);
    }

    public Object getInstanceFieldValue(String name, Locale locale) {
        Property property;
        Instance instanceAtRoot;
        Instance instance = instanceAtRoot = name == null ? null : this.getInstanceAtRoot();
        if (instanceAtRoot != null && (property = instanceAtRoot.getDeclaringEntity().getProperty(name)) != null) {
            for (InstanceField field : instanceAtRoot.getInstanceFieldsList()) {
                if (!property.equals(field.getProperty())) continue;
                return property instanceof StringProperty && locale != null ? field.getLocalizedValue(locale) : field.getValue();
            }
        }
        return null;
    }

    private InstanceField getInstanceKeyField() {
        Instance instanceAtRoot = this.getInstanceAtRoot();
        if (instanceAtRoot != null) {
            Map<String, Class<?>> map = this.getKeysMap();
            for (String s : map.keySet()) {
                Class<?> c = map.get(s);
                for (InstanceField instanceField : instanceAtRoot.getInstanceFieldsList()) {
                    Property p = instanceField.getProperty();
                    if (!s.equals(p.getName()) || !c.equals(p.getDataType())) continue;
                    return instanceField;
                }
            }
        }
        return null;
    }

    public boolean isUsualArgumentInExpressions() {
        Instance instanceAtRoot = this.getInstanceAtRoot();
        return instanceAtRoot == null || instanceAtRoot == this ? this._usualArgumentInExpressions : instanceAtRoot.isUsualArgumentInExpressions();
    }

    public void setUsualArgumentInExpressions(boolean usual) {
        this._usualArgumentInExpressions = usual;
    }

    private Map<String, Class<?>> getKeysMap() {
        LinkedHashMap map = new LinkedHashMap();
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity != null) {
            this.putKeyProperty(map, declaringEntity.getPrimaryKeyProperty());
            this.putKeyProperty(map, declaringEntity.getSequenceProperty());
            this.putKeyProperty(map, declaringEntity.getNumericKeyProperty());
            this.putKeyProperty(map, declaringEntity.getCharacterKeyProperty());
        }
        return map;
    }

    private void putKeyProperty(Map<String, Class<?>> map, Property property) {
        if (property != null) {
            String name = property.getName();
            Class<?> clazz = property.getDataType();
            if (name != null && clazz != null) {
                map.put(name, clazz);
            }
        }
    }

    private Instance getInstanceAtRoot() {
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity != null) {
            if (declaringEntity.isRootInstance()) {
                return this;
            }
            String name = this.getName();
            if (name != null) {
                Entity root = declaringEntity.getRoot();
                List<Instance> list = root.getInstancesList();
                if (list.isEmpty()) {
                    return this.instanceAt(root);
                }
                for (Instance instance : list) {
                    if (!name.equals(instance.getName())) continue;
                    return instance;
                }
            }
        }
        return null;
    }

    private Instance instanceAt(Entity root) {
        Field field = XS1.getField(false, this.getName(), this.getName(), root.getClass(), Entity.class, Instance.class);
        if (field == null) {
            return null;
        }
        try {
            Object obj = field.get(root);
            return obj instanceof Instance ? (Instance)obj : null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return null;
        }
    }

    boolean finalise(int index) {
        boolean ok = super.finalise();
        if (ok) {
            this._index = index;
            this.finaliseInstanceMissingFields();
        }
        return ok;
    }

    private void finaliseInstanceMissingFields() {
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity instanceof PersistentEntity) {
            PersistentEntity pent = (PersistentEntity)declaringEntity;
            if (this.depth() == 0 && this.round() == 0) {
                Object dpv;
                String name = StringUtils.capitalize((String)StrUtils.getWordyString(this.getName()));
                String code = pent.getBusinessKeyValueOf(this);
                Date currentDate = TimeUtils.currentDate();
                Time currentTime = TimeUtils.currentTime();
                Timestamp currentTimestamp = TimeUtils.currentTimestamp();
                List<Property> columnsList = pent.getColumnsList();
                block0: for (Property property : columnsList) {
                    if (property.isNullable() || property.getDefaultValue() != null || !String.class.isAssignableFrom(property.getDataType())) continue;
                    for (InstanceField f : this._instanceFieldsList) {
                        if (!f.getProperty().equals(property)) continue;
                        if (f.getValue() != null) continue block0;
                        dpv = property.isKeyField() ? code : pent.getDefaultPropertyValueOf(this, property);
                        f.addLocalizedValue(null, dpv instanceof String ? (String)dpv : name);
                        continue block0;
                    }
                }
                for (Property property : columnsList) {
                    InstanceField instanceField;
                    if (property.isNullable() || property.getDefaultValue() != null || this.propertyAlreadyAdded(property)) continue;
                    Class<?> dataType = property.getDataType();
                    boolean keyField = property.isKeyField();
                    dpv = pent.getDefaultPropertyValueOf(this, property);
                    if (Boolean.class.isAssignableFrom(dataType)) {
                        Boolean logico = dpv instanceof Boolean ? (Boolean)dpv : false;
                        instanceField = new InstanceField(this, property, logico);
                        this._instanceFieldsList.add(instanceField);
                        continue;
                    }
                    if (Number.class.isAssignableFrom(dataType)) {
                        Integer number = keyField ? this._index : (dpv instanceof Integer ? (Integer)dpv : 0);
                        instanceField = new InstanceField(this, property, number);
                        this._instanceFieldsList.add(instanceField);
                        continue;
                    }
                    if (String.class.isAssignableFrom(dataType)) {
                        String string = keyField ? code : (dpv instanceof String ? (String)dpv : name);
                        instanceField = new InstanceField(this, property, string);
                        this._instanceFieldsList.add(instanceField);
                        continue;
                    }
                    if (Date.class.isAssignableFrom(dataType)) {
                        Date date = keyField ? TimeUtils.currentDate() : (dpv instanceof Date ? (Date)dpv : currentDate);
                        instanceField = new InstanceField(this, property, date);
                        this._instanceFieldsList.add(instanceField);
                        continue;
                    }
                    if (Time.class.isAssignableFrom(dataType)) {
                        Time time = keyField ? TimeUtils.currentTime() : (dpv instanceof Time ? (Time)dpv : currentTime);
                        instanceField = new InstanceField(this, property, time);
                        this._instanceFieldsList.add(instanceField);
                        continue;
                    }
                    if (!Timestamp.class.isAssignableFrom(dataType)) continue;
                    Timestamp timestamp = keyField ? TimeUtils.currentTimestamp() : (dpv instanceof Timestamp ? (Timestamp)dpv : currentTimestamp);
                    instanceField = new InstanceField(this, property, timestamp);
                    this._instanceFieldsList.add(instanceField);
                }
            }
        }
    }

    private boolean propertyAlreadyAdded(Property property) {
        for (InstanceField f : this._instanceFieldsList) {
            if (!f.getProperty().equals(property)) continue;
            return true;
        }
        return false;
    }

    public void newInstanceField(PersistentEntityReference property, Instance value) {
        InstanceField instanceField = new InstanceField(this, property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BooleanProperty property, Boolean value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(CharacterProperty property, Character value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(CharacterProperty property, String value) {
        if (value != null && value.length() == 1) {
            InstanceField instanceField = new InstanceField(this, (Property)property, value);
            this._instanceFieldsList.add(instanceField);
        } else {
            logger.error((Object)("invalid char value for field " + this.getFullName() + "." + property.getName()));
            Project.increaseParserErrorCount();
        }
    }

    public void newInstanceField(BigDecimalProperty property, BigDecimal value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigDecimalProperty property, BigInteger value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigDecimalProperty property, Long value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigDecimalProperty property, Integer value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigDecimalProperty property, Short value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigDecimalProperty property, Byte value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigIntegerProperty property, BigInteger value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigIntegerProperty property, Long value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigIntegerProperty property, Integer value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigIntegerProperty property, Short value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(BigIntegerProperty property, Byte value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(DoubleProperty property, Double value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(DoubleProperty property, Float value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(DoubleProperty property, Long value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(DoubleProperty property, Integer value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(DoubleProperty property, Short value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(DoubleProperty property, Byte value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(FloatProperty property, Float value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(FloatProperty property, Long value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(FloatProperty property, Integer value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(FloatProperty property, Short value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(FloatProperty property, Byte value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(LongProperty property, Long value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(LongProperty property, Integer value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(LongProperty property, Short value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(LongProperty property, Byte value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(IntegerProperty property, Integer value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(IntegerProperty property, Short value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(IntegerProperty property, Byte value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(ShortProperty property, Short value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(ShortProperty property, Byte value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(ByteProperty property, Byte value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(StringProperty property, String value) {
        this.newInstanceField(property, value, null);
    }

    public void newInstanceField(StringProperty property, String value, Locale locale) {
        for (InstanceField field : this._instanceFieldsList) {
            if (!property.equals(field.getProperty())) continue;
            field.addLocalizedValue(locale, value);
            return;
        }
        InstanceField instanceField = new InstanceField(this, property, value, locale);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(DateProperty property, Date value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(DateProperty property, String value) {
        java.util.Date valor = TimeUtils.jdbcObject(value, property.getDataType());
        if (valor instanceof Date) {
            Date date = (Date)valor;
            this.newInstanceField(property, date);
        } else {
            logger.error((Object)("invalid date value for field " + this.getFullName() + "." + property.getName()));
            Project.increaseParserErrorCount();
        }
    }

    public void newInstanceField(TimeProperty property, Time value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(TimeProperty property, String value) {
        java.util.Date valor = TimeUtils.jdbcObject(value, property.getDataType());
        if (valor instanceof Time) {
            Time time = (Time)valor;
            this.newInstanceField(property, time);
        } else {
            logger.error((Object)("invalid time value for field " + this.getFullName() + "." + property.getName()));
            Project.increaseParserErrorCount();
        }
    }

    public void newInstanceField(TimestampProperty property, Timestamp value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(TimestampProperty property, Time value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(TimestampProperty property, Date value) {
        InstanceField instanceField = new InstanceField(this, (Property)property, value);
        this._instanceFieldsList.add(instanceField);
    }

    public void newInstanceField(TimestampProperty property, String value) {
        java.util.Date valor = TimeUtils.jdbcObject(value, property.getDataType());
        if (valor instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)valor;
            this.newInstanceField(property, timestamp);
        } else if (valor instanceof Time) {
            Time time = (Time)valor;
            this.newInstanceField(property, time);
        } else if (valor instanceof Date) {
            Date date = (Date)valor;
            this.newInstanceField(property, date);
        } else {
            logger.error((Object)("invalid date/time value for field " + this.getFullName() + "." + property.getName()));
            Project.increaseParserErrorCount();
        }
    }

    public boolean isAnnotatedWithInstanceDataGen() {
        return this._annotatedWithInstanceDataGen;
    }

    public int getDataGenWeight() {
        return this._dataGenWeight;
    }

    @Override
    void annotate(Field field) {
        super.annotate(field);
        if (field != null) {
            this.annotateInstanceDataGen(field);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidFieldAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidFieldAnnotations();
        valid.add(InstanceDataGen.class);
        return valid;
    }

    private void annotateInstanceDataGen(Field field) {
        Class<InstanceDataGen> annotationClass = InstanceDataGen.class;
        this._annotatedWithInstanceDataGen = field.isAnnotationPresent(annotationClass);
        if (this._annotatedWithInstanceDataGen) {
            InstanceDataGen annotation = field.getAnnotation(InstanceDataGen.class);
            this._dataGenWeight = Math.min(100, Math.max(0, annotation.weight()));
        }
    }

    public EntityScalarX toEntityExpression() {
        return XB.toEntity(this);
    }
}

