/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.core.Display;
import adalid.core.PageField;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.DisplayType;
import adalid.core.interfaces.Entity;
import adalid.core.jee.JavaWebProject;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Page
extends Display {
    public static final String HREF = "href";

    public Page(String name) {
        super(name);
        this.init();
    }

    private void init() {
        this.setDisplayType(DisplayType.PAGE);
    }

    public String getLocation() {
        Project project = TLC.getProject();
        JavaWebProject jwp = this.jwp(project);
        String name = this.getName();
        String href = project.getStringKeyValuePairAttribute(Page.class, name, HREF);
        if (StringUtils.isNotBlank((String)href)) {
            return href;
        }
        if (jwp != null) {
            Project module = this.getModule();
            Entity entity = this.getEntity();
            DisplayMode mode = this.getDisplayMode();
            if (module != null && entity != null && mode != null) {
                String host = StringUtils.trimToEmpty((String)entity.getApplicationOrigin());
                String root = StringUtils.defaultIfBlank((String)entity.getApplicationContextRoot(), (String)jwp.getWebProjectName());
                String fdir = jwp.getWebPageFileDirectory();
                String fext = jwp.getWebPageFileExtension();
                String path = this.pagePath(module, entity, mode);
                return host + "/" + root + "/" + fdir + "/" + path + "/" + name + "." + fext;
            }
        }
        return null;
    }

    public String getLocationWithinApplicationContextRoot() {
        Project project = TLC.getProject();
        JavaWebProject jwp = this.jwp(project);
        String name = this.getName();
        String href = project.getStringKeyValuePairAttribute(Page.class, name, HREF);
        if (StringUtils.isNotBlank((String)href)) {
            String wrsp = "/" + jwp.getWebRequestServletPath() + "/";
            return href.contains(wrsp) ? wrsp + StringUtils.substringAfter((String)href, (String)wrsp) : href;
        }
        if (jwp != null) {
            Project module = this.getModule();
            Entity entity = this.getEntity();
            DisplayMode mode = this.getDisplayMode();
            if (module != null && entity != null && mode != null) {
                String fdir = jwp.getWebPageFileDirectory();
                String fext = jwp.getWebPageFileExtension();
                String path = this.pagePath(module, entity, mode);
                return "/" + fdir + "/" + path + "/" + name + "." + fext;
            }
        }
        return null;
    }

    private JavaWebProject jwp(Project project) {
        return project instanceof JavaWebProject ? (JavaWebProject)((Object)project) : null;
    }

    private String pagePath(Project module, Entity entity, DisplayMode mode) {
        if (mode != null) {
            String path = null;
            switch (mode) {
                case READING: {
                    path = entity.getApplicationReadingPath();
                    break;
                }
                case WRITING: {
                    path = entity.getApplicationWritingPath();
                    break;
                }
                case PROCESSING: {
                    path = entity.getApplicationConsolePath();
                }
            }
            if (StringUtils.isNotBlank(path)) {
                return path;
            }
        }
        return this.pagePath(module);
    }

    private String pagePath(Project module) {
        String path = StrUtils.getLowerCaseIdentifier(StringUtils.defaultIfBlank((String)module.getAlias(), (String)module.getName()), "/");
        return path;
    }

    public List<PageField> getFields() {
        return this.getFields(false);
    }

    public List<PageField> getFields(boolean hidden) {
        return null;
    }

    public List<PageField> getMasterHeadingFields() {
        return this.getMasterHeadingFields(false);
    }

    public List<PageField> getMasterHeadingFields(boolean hidden) {
        return null;
    }
}

