/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.core.AbstractArtifact;
import adalid.core.interfaces.State;
import java.util.Objects;

public class Transition
extends AbstractArtifact {
    private State _x;
    private State _y;

    public State getX() {
        return this._x;
    }

    public State getY() {
        return this._y;
    }

    public Transition() {
    }

    public Transition(State x, State y) {
        this.init(x, y);
    }

    private void init(State x, State y) {
        this._x = x;
        this._y = y;
        String name = StrUtils.getArtifactName(x + "_" + y);
        this.setName(name);
    }

    public void settle(State x, State y) {
        this._x = x;
        this._y = y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Transition) {
            Transition that = (Transition)obj;
            return Objects.equals(this._x, that._x) && Objects.equals(this._y, that._y);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this._x);
        hash = 37 * hash + Objects.hashCode(this._y);
        return hash;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            if (this._x != null) {
                string = (String)string + this._x.toString(n + 1, "x", false, fields, false);
            }
            if (this._y != null) {
                string = (String)string + this._y.toString(n + 1, "y", false, fields, false);
            }
        }
        return string;
    }
}

