/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ViewSelect {
    private final boolean _distinct;
    private final List<String> _columns;
    private final String _from;
    private final List<String> _filters;
    private final List<String> _groupBy;
    private final List<String> _orderBy;

    ViewSelect(boolean distinct, List<String> columns, String from, List<String> filters, List<String> groupBy, List<String> orderBy) {
        this._distinct = distinct;
        this._columns = columns;
        this._from = from;
        this._filters = filters;
        this._groupBy = groupBy;
        this._orderBy = orderBy;
    }

    public boolean isDistinct() {
        return this._distinct;
    }

    public List<String> getColumns() {
        return this._columns;
    }

    public String getFrom() {
        return this._from;
    }

    public List<String> getFilters() {
        return this._filters;
    }

    public List<String> getGroupBy() {
        return this._groupBy;
    }

    public List<String> getOrderBy() {
        return this._orderBy;
    }

    public String getStatement() {
        return "SELECT " + (this._distinct ? "DISTINCT " : "") + this.columns(this._columns) + " FROM " + this._from + this.filters(this._filters) + this.groupBy(this._groupBy) + this.orderBy(this._orderBy);
    }

    private String columns(List<String> list) {
        return list == null || list.isEmpty() ? "*" : StringUtils.join(list, (String)", ");
    }

    private String filters(List<String> list) {
        return list == null || list.isEmpty() ? "" : " WHERE (" + StringUtils.join(list, (String)" AND ") + ") ";
    }

    private String groupBy(List<String> list) {
        return list == null || list.isEmpty() ? "" : " GROUP BY " + StringUtils.join(list, (String)", ");
    }

    private String orderBy(List<String> list) {
        return list == null || list.isEmpty() ? "" : " ORDER BY " + StringUtils.join(list, (String)", ");
    }
}

