/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.properties.ext;

import adalid.core.enums.PhoneNumberFormat;
import adalid.core.properties.StringProperty;
import java.util.regex.Pattern;

public class LocalPhoneNumberProperty
extends StringProperty {
    public LocalPhoneNumberProperty() {
        this.setMaxLength(20);
        this.setPattern(Pattern.compile("^(?:\\d{1,4})(?:[-\\s]?\\d{6,10})$"));
        this.setSpecialValidatorName("localPhoneNumberValidator");
        this.setLocalizedDescription(ENGLISH, "this is a local phone number; it must be a global subscriber number or an area code and a subscriber number; for example: 4121234567, 412-1234567");
        this.setLocalizedDescription(SPANISH, "este es un n\u00famero de tel\u00e9fono local; debe ser un n\u00famero de suscriptor global o un c\u00f3digo de \u00e1rea y un n\u00famero de suscriptor; por ejemplo: 4121234567, 412-1234567");
        this.setLocalizedRegexErrorMessage(ENGLISH, "the phone number does not meet the required pattern; it must be a global subscriber number, i.e. a group of 7 to 14 digits; or it can be divided into area code, a group of 1 to 4 digits, and subscriber number, a group of 6 to 10 digits; the area code and subscriber number must be separated by a single blank space or hyphen; whatever their distribution among the groups, the total number of digits must be between 7 and 14.");
        this.setLocalizedRegexErrorMessage(SPANISH, "el n\u00famero de tel\u00e9fono no cumple con el patr\u00f3n requerido; \u00e9ste debe ser un n\u00famero de suscriptor global, es decir, un grupo de 7 hasta 14 d\u00edgitos; o se puede dividir en c\u00f3digo de \u00e1rea, un grupo de 1 hasta 4 d\u00edgitos, y n\u00famero de suscriptor, un grupo de 6 a 10 d\u00edgitos; el c\u00f3digo de \u00e1rea y el n\u00famero de suscriptor deben estar separados por un solo espacio en blanco o gui\u00f3n; cualquiera que sea su distribuci\u00f3n entre los grupos, el n\u00famero total de d\u00edgitos debe estar entre 7 y 14.");
    }

    public boolean isPhoneNumber() {
        return true;
    }

    public PhoneNumberFormat getPhoneNumberFormat() {
        return PhoneNumberFormat.LOCAL;
    }
}

