/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2.meta.proyecto.base;

import adalid.commons.util.BitUtils;
import adalid.commons.util.StrUtils;
import adalid.core.Project;
import adalid.core.enums.ProjectStage;
import adalid.core.enums.SecurityRealmType;
import adalid.core.enums.ShortMessageServiceProvider;
import adalid.core.interfaces.Entity;
import adalid.core.jee.JavaWebProject;
import adalid.core.programmers.AbstractJavaProgrammer;
import adalid.jee2.ImageFile;
import adalid.jee2.JobSchedule;
import adalid.jee2.ProjectModuleType;
import adalid.jee2.WebLoginAuthMethod;
import adalid.jee2.meta.proyecto.base.ProyectoBase;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import meta.entidad.comun.configuracion.basica.Aplicacion;
import meta.entidad.comun.configuracion.basica.ClaseRecurso;
import meta.entidad.comun.configuracion.basica.Dominio;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.configuracion.basica.FuncionParametro;
import meta.entidad.comun.configuracion.basica.GrupoProceso;
import meta.entidad.comun.configuracion.basica.Pagina;
import meta.entidad.comun.configuracion.basica.Parametro;
import meta.enumeracion.base.TipoModuloBase;
import meta.modulo.base.ModuloConsulta;
import meta.modulo.base.ModuloProcesamiento;
import meta.modulo.base.ModuloRegistro;
import meta.paquete.base.PaqueteBase;
import meta.paquete.comun.PaqueteConsultaRecursosBasicos;
import meta.paquete.comun.PaqueteProcesamientoRecursosBasicos;
import meta.paquete.comun.PaqueteRegistroRecursosBasicos;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class ProyectoJava1
extends ProyectoBase
implements JavaWebProject {
    private static final Logger logger = Logger.getLogger(Project.class);
    protected static final boolean TYPELESS_REALM_NAME = true;
    protected static final String CONTENT_ROOT_DIR_LINUX = "content.root.dir.linux";
    protected static final String CONTENT_ROOT_DIR_WINDOWS = "content.root.dir.windows";
    protected static final String DATABASE_HOME_DIR_LINUX = "database.home.dir.linux";
    protected static final String DATABASE_HOME_DIR_WINDOWS = "database.home.dir.windows";
    protected static final String JAVA_HOME_DIR_LINUX = "java.home.dir.linux";
    protected static final String JAVA_HOME_DIR_WINDOWS = "java.home.dir.windows";
    protected static final String JAVA_PLATFORM = "java.platform";
    protected static final String PLATAFORMA_JAVA = "java.platform";
    protected static final String JAVA_VERSION = "java.version";
    protected static final String VERSION_JAVA = "java.version";
    protected static final String QUICK_FILTER_SNIPPET = "/resources/snippets/base/panel/quickFilterPanel";
    protected static final WebLoginAuthMethod[] SUPPORTED_WEB_API_AUTH_METHODS = new WebLoginAuthMethod[]{WebLoginAuthMethod.BASIC, WebLoginAuthMethod.KEYCLOAK, WebLoginAuthMethod.OIDC};
    protected static final Map<String, String> ENBG = new LinkedHashMap<String, String>();
    protected static final Set<String> PAKS;
    protected ModuloConsulta consulta;
    protected ModuloProcesamiento procesamiento;
    protected ModuloRegistro registro;
    protected PaqueteConsultaRecursosBasicos consultaRecursosBasicos;
    protected PaqueteProcesamientoRecursosBasicos procesamientoRecursosBasicos;
    protected PaqueteRegistroRecursosBasicos registroRecursosBasicos;
    protected final ImageFile pageBookmarkIcon = new ImageFile("PBI");
    protected final ImageFile headerLeftBanner = new ImageFile("HLB");
    protected final ImageFile headerRightBanner = new ImageFile("HRB");
    protected final ImageFile welcomePageBanner = new ImageFile("WPB");
    protected final ImageFile changePasswordBanner = new ImageFile("CPB");
    protected final ImageFile helpPageLogo = new ImageFile("HPL");
    private final List<ImageFile> _headerBannerList = new ArrayList<ImageFile>();
    private final List<String> _predefinedHeaderBannerNames = new ArrayList<String>();
    protected final JobSchedule taskNotifierSchedule = new JobSchedule("taskNotifierSchedule");
    protected final JobSchedule dailyProcessSchedule = new JobSchedule("dailyProcessSchedule");
    protected final JobSchedule weeklyProcessSchedule = new JobSchedule("weeklyProcessSchedule");
    protected final JobSchedule monthlyProcessSchedule = new JobSchedule("monthlyProcessSchedule");
    private final List<JobSchedule> _jobScheduleList = new ArrayList<JobSchedule>();
    private final List<String> _predefinedJobScheduleNames = new ArrayList<String>();
    private final Map<ProjectModuleType, Map<String, String>> _contextParameters = new LinkedHashMap<ProjectModuleType, Map<String, String>>();
    private String _addOnsProjectName;
    private String _earProjectName;
    private String _ejbProjectName;
    private String _libProjectName;
    private String _libDirProjectName;
    private String _resourcesProjectName;
    private String _webProjectName;
    private String _webApiProjectName;
    private String _rootPackageName;
    private String _persistenceRootPackageName;
    private String _googleRecaptchaSiteKey;
    private String _googleRecaptchaSecretKey;
    private String _projectFilterSnippetPath;
    private int _projectChangeForgottenPasswordTimeout = 15;
    private boolean _multiApplication;
    private boolean _flushAfterEachInsert = true;
    private boolean _flushAfterEachUpdate = true;
    private boolean _flushAfterEachDelete = true;
    private boolean _internetAccessAllowed;
    private boolean _webServicesEnabled;
    private boolean _projectMailingEnabled;
    private boolean _projectMailDebuggingEnabled;
    private boolean _projectTextingEnabled;
    private boolean _projectTextDebuggingEnabled;
    private boolean _projectRecaptchaEnabled;
    private boolean _projectRecaptchaSiteVerificationEnabled;
    private boolean _projectAssignNewPasswordEnabled = true;
    private boolean _projectChangeOwnPasswordEnabled = true;
    private boolean _projectChangeForgottenPasswordEnabled = true;
    private boolean _projectChangeOwnEmailEnabled = true;
    private boolean _exporterShellEnabled;
    private boolean _reporterShellEnabled;
    private boolean _sqlAgentShellEnabled = true;
    private Boolean _operatingSystemShellKeepTempFiles;
    private ShortMessageServiceProvider _defaultSMSProvider = ShortMessageServiceProvider.UNSPECIFIED;
    private ProjectStage _projectStage;
    private WebLoginAuthMethod _webAuthMethod = WebLoginAuthMethod.FORM;
    private WebLoginAuthMethod _webApiAuthMethod = WebLoginAuthMethod.BASIC;
    private SecurityRealmType _securityRealmType = SecurityRealmType.JDBC;
    private String _securityRealmName;
    private String _roleBasedAccessControllerName;
    private String _webSecurityPrefix;
    private boolean _authenticatedUserAutomaticRegistrationEnabled = true;
    private boolean _authenticatedUserAutomaticSynchronizationEnabled = true;

    public static String getEntityNameBundleGetter(Entity entity) {
        return entity == null ? null : ProyectoJava1.getEntityNameBundleGetter(entity.getName());
    }

    public static String getEntityNameBundleGetter(String entityName) {
        return entityName == null ? null : ENBG.get(entityName);
    }

    public ProyectoJava1() {
        this.initializeContextParameters();
        this.initializeImageFiles();
        this.initializeJobSchedules();
    }

    private void initializeContextParameters() {
        this._contextParameters.put(ProjectModuleType.WEB, new LinkedHashMap());
        this._contextParameters.put(ProjectModuleType.WEB_API, new LinkedHashMap());
    }

    public void addWebContextParameter(String key, String value) {
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            this._contextParameters.get((Object)ProjectModuleType.WEB).put(key, value);
        }
    }

    public Map<String, String> getWebContextParameters() {
        return this._contextParameters.get((Object)ProjectModuleType.WEB);
    }

    public void addWebApiContextParameter(String key, String value) {
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            this._contextParameters.get((Object)ProjectModuleType.WEB_API).put(key, value);
        }
    }

    public Map<String, String> getWebApiContextParameters() {
        return this._contextParameters.get((Object)ProjectModuleType.WEB_API);
    }

    private void initializeImageFiles() {
        this.addImageFile(this.pageBookmarkIcon);
        this.addImageFile(this.headerLeftBanner);
        this.addImageFile(this.headerRightBanner);
        this.addImageFile(this.welcomePageBanner);
        this.addImageFile(this.changePasswordBanner);
        this.addImageFile(this.helpPageLogo);
        this.pageBookmarkIcon.path = "/resources/images/base/favicon.png";
        this.pageBookmarkIcon.height = 16;
        this.headerLeftBanner.path = "/resources/images/base/index_hlb.png";
        this.headerLeftBanner.height = 36;
        this.headerRightBanner.path = "/resources/images/base/index_hrb.png";
        this.headerRightBanner.height = 36;
        this.welcomePageBanner.path = "/resources/images/base/index.png";
        this.welcomePageBanner.height = 250;
        this.changePasswordBanner.path = "/resources/images/base/index.png";
        this.changePasswordBanner.width = 250;
        this.helpPageLogo.path = "/resources/images/base/logo.png";
        this.helpPageLogo.height = 60;
    }

    public List<ImageFile> getImageFileList() {
        return this._headerBannerList;
    }

    private void addImageFile(ImageFile imageFile) {
        this._headerBannerList.add(imageFile);
        this._predefinedHeaderBannerNames.add(imageFile.getImageFileName());
    }

    private void initializeJobSchedules() {
        this.addJobSchedule(this.taskNotifierSchedule);
        this.addJobSchedule(this.dailyProcessSchedule);
        this.addJobSchedule(this.weeklyProcessSchedule);
        this.addJobSchedule(this.monthlyProcessSchedule);
        this.taskNotifierSchedule.hour = "*";
        this.taskNotifierSchedule.minute = "*/15";
        this.taskNotifierSchedule.second = "30";
        this.dailyProcessSchedule.hour = "4";
        this.weeklyProcessSchedule.hour = "2";
        this.weeklyProcessSchedule.dayOfWeek = "Mon";
        this.monthlyProcessSchedule.hour = "0";
        this.monthlyProcessSchedule.dayOfMonth = "1";
    }

    public List<JobSchedule> getJobScheduleList() {
        return this._jobScheduleList;
    }

    private void addJobSchedule(JobSchedule jobSchedule) {
        this._jobScheduleList.add(jobSchedule);
        this._predefinedJobScheduleNames.add(jobSchedule.getJobScheduleName());
    }

    protected JobSchedule addJobSchedule(String name) {
        int size = 1 + this._jobScheduleList.size();
        Object scheduleName = "JobSchedule" + size;
        String remarks = "; the name of the added job schedule will be \"" + (String)scheduleName + "\"";
        String givenName = StringUtils.trimToNull((String)name);
        if (givenName == null) {
            logger.warn((Object)("the argument to addJobSchedule is null" + remarks));
        } else if (!givenName.matches("^[a-zA-Z][a-zA-Z0-9]*$")) {
            logger.warn((Object)("\"" + givenName + "\" is an invalid job schedule name" + remarks));
        } else if (this._predefinedJobScheduleNames.stream().anyMatch(givenName::equalsIgnoreCase)) {
            logger.warn((Object)("\"" + givenName + "\" is a predefined job schedule name" + remarks));
        } else {
            scheduleName = givenName;
        }
        for (JobSchedule jobSchedule : this._jobScheduleList) {
            String previousName = jobSchedule.getJobScheduleName();
            if (!((String)scheduleName).equalsIgnoreCase(previousName)) continue;
            logger.warn((Object)("job schedule \"" + previousName + "\" has already been added to the list; reusing the previously added one"));
            return jobSchedule;
        }
        JobSchedule jobSchedule = new JobSchedule((String)scheduleName);
        this._jobScheduleList.add(jobSchedule);
        return jobSchedule;
    }

    @Override
    public boolean analyze() {
        boolean analyzed = super.analyze();
        return analyzed &= this.analyzePackages();
    }

    private boolean analyzePackages() {
        boolean ok = true;
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        LinkedHashSet<String> consultas = new LinkedHashSet<String>();
        LinkedHashSet procesos = new LinkedHashSet();
        LinkedHashSet registros = new LinkedHashSet();
        List<? extends PaqueteBase> packages = this.getPackages();
        for (PaqueteBase paqueteBase : packages) {
            String alias = paqueteBase.getAlias();
            if (StringUtils.isBlank((String)alias)) {
                logger.error((Object)(paqueteBase + " is invalid; its alias is null"));
                ok = false;
            } else if (aliases.add(alias)) {
                String dotted = StrUtils.getLowerCaseIdentifier(alias, '.');
                String[] words = StringUtils.split((String)dotted, (char)'.');
                for (String word : words) {
                    for (String keyword : PAKS) {
                        if (!keyword.equalsIgnoreCase(word)) continue;
                        logger.error((Object)(paqueteBase + " is invalid; its alias contains keyword \"" + keyword + "\""));
                        ok = false;
                    }
                }
            } else {
                logger.error((Object)(paqueteBase + " is invalid; duplicate alias \"" + alias + "\""));
                ok = false;
            }
            Set<String> names = paqueteBase.getLocallyDeclaredEntityClassSimpleNames();
            if (names.isEmpty()) {
                logger.error((Object)(paqueteBase + " is invalid; it has no entities locally declared"));
                ok = false;
            }
            LinkedHashSet<String> allNames = null;
            TipoModuloBase tipo = paqueteBase.getTipo();
            if (tipo == null) {
                logger.error((Object)(paqueteBase + " is invalid; its type is null"));
                ok = false;
            } else {
                switch (tipo) {
                    case CONSULTA: {
                        allNames = consultas;
                        break;
                    }
                    case PROCESAMIENTO: {
                        allNames = procesos;
                        break;
                    }
                    case REGISTRO: {
                        allNames = registros;
                        break;
                    }
                    default: {
                        logger.error((Object)(paqueteBase + " is invalid; its type is " + tipo));
                        ok = false;
                    }
                }
            }
            if (allNames == null || names.isEmpty()) continue;
            for (String name : names) {
                if (allNames.add(name)) continue;
                logger.error((Object)(name + " is declared in more than one package of type " + tipo));
                ok = false;
            }
        }
        return ok;
    }

    private List<? extends PaqueteBase> getPackages() {
        ArrayList<PaqueteBase> packages = new ArrayList<PaqueteBase>();
        List<Project> modules = this.getModulesList();
        for (Project module : modules) {
            if (!(module instanceof PaqueteBase)) continue;
            PaqueteBase paquete = (PaqueteBase)module;
            packages.add(paquete);
        }
        return packages;
    }

    public void addBeanAttribute(String classSimpleName) {
        this.addBeanAttribute(classSimpleName, null);
    }

    public void addBeanAttribute(String classSimpleName, String beanName) {
        String key = "bean.name";
        if (StringUtils.isNotBlank((String)classSimpleName)) {
            String cn = StringUtils.capitalize((String)classSimpleName.trim());
            String bn = StringUtils.uncapitalize((String)StringUtils.defaultIfBlank((String)StringUtils.trim((String)beanName), (String)cn));
            this.addAttribute(cn + ".bean.name", (Object)bn);
        }
    }

    public String getAddOnsProjectName() {
        return StringUtils.defaultIfBlank((String)this._addOnsProjectName, (String)this.getDefaultAddOnsProjectName());
    }

    public void setAddOnsProjectName(String addOnsProjectName) {
        this._addOnsProjectName = StrUtils.getLowerCaseIdentifier(addOnsProjectName, '-');
    }

    @Override
    public String getEarProjectName() {
        return StringUtils.defaultIfBlank((String)this._earProjectName, (String)this.getDefaultEarProjectName());
    }

    public void setEarProjectName(String earProjectName) {
        this._earProjectName = StrUtils.getLowerCaseIdentifier(earProjectName, '-');
    }

    @Override
    public String getEjbProjectName() {
        return StringUtils.defaultIfBlank((String)this._ejbProjectName, (String)this.getDefaultEjbProjectName());
    }

    public void setEjbProjectName(String ejbProjectName) {
        this._ejbProjectName = StrUtils.getLowerCaseIdentifier(ejbProjectName, '-');
    }

    public String getLibProjectName() {
        return StringUtils.defaultIfBlank((String)this._libProjectName, (String)this.getDefaultLibProjectName());
    }

    public void setLibProjectName(String libProjectName) {
        this._libProjectName = StrUtils.getLowerCaseIdentifier(libProjectName, '-');
    }

    public String getLibDirProjectName() {
        return StringUtils.defaultIfBlank((String)this._libDirProjectName, (String)this.getDefaultLibDirProjectName());
    }

    public void setLibDirProjectName(String libDirProjectName) {
        this._libDirProjectName = StrUtils.getLowerCaseIdentifier(libDirProjectName, '-');
    }

    public String getResourcesProjectName() {
        return StringUtils.defaultIfBlank((String)this._resourcesProjectName, (String)this.getDefaultResourcesProjectName());
    }

    public void setResourcesProjectName(String resourcesProjectName) {
        this._resourcesProjectName = StrUtils.getLowerCaseIdentifier(resourcesProjectName, '-');
    }

    @Override
    public String getWebProjectName() {
        return StringUtils.defaultIfBlank((String)this._webProjectName, (String)this.getDefaultWebProjectName());
    }

    public void setWebProjectName(String webProjectName) {
        this._webProjectName = StrUtils.getLowerCaseIdentifier(webProjectName, '-');
    }

    @Override
    public String getWebApiProjectName() {
        return StringUtils.defaultIfBlank((String)this._webApiProjectName, (String)this.getDefaultWebApiProjectName());
    }

    public void setWebApiProjectName(String webApiProjectName) {
        this._webApiProjectName = StrUtils.getLowerCaseIdentifier(webApiProjectName, '-');
    }

    @Override
    public String getWebPageFileExtension() {
        return StringUtils.defaultIfBlank((String)this.getStringAttribute("web_pages_file_extension"), (String)"xhtml");
    }

    public String getRootPackageName() {
        return StringUtils.defaultIfBlank((String)this._rootPackageName, (String)this.getDefaultRootPackageName());
    }

    public void setRootPackageName(String packageName) {
        this._rootPackageName = StrUtils.getLowerCaseIdentifier(packageName, '.');
    }

    public String getPersistenceRootPackageName() {
        return StringUtils.defaultIfBlank((String)this._persistenceRootPackageName, (String)this.getDefaultPersistenceRootPackageName());
    }

    public void setPersistenceRootPackageName(String packageName) {
        this._persistenceRootPackageName = StrUtils.getLowerCaseIdentifier(packageName, '.');
    }

    public String getGoogleRecaptchaSiteKey() {
        return StringUtils.defaultIfBlank((String)this._googleRecaptchaSiteKey, (String)this.getDefaultGoogleRecaptchaSiteKey());
    }

    public void setGoogleRecaptchaSiteKey(String key) {
        this._googleRecaptchaSiteKey = key;
    }

    public String getGoogleRecaptchaSecretKey() {
        return StringUtils.defaultIfBlank((String)this._googleRecaptchaSecretKey, (String)this.getDefaultGoogleRecaptchaSecretKey());
    }

    public void setGoogleRecaptchaSecretKey(String key) {
        this._googleRecaptchaSecretKey = key;
    }

    @Override
    public String getProjectFilterSnippetPath() {
        return this._projectFilterSnippetPath;
    }

    public void setProjectFilterSnippetPath(String path) {
        this._projectFilterSnippetPath = StringUtils.trimToNull((String)path);
    }

    public boolean isSingleApplication() {
        return !this.isMultiApplication();
    }

    @Override
    public boolean isMultiApplication() {
        return this._multiApplication;
    }

    protected void setMultiApplication(boolean multiple) {
        this._multiApplication = multiple;
    }

    public boolean isFlushAfterEachInsert() {
        return this._flushAfterEachInsert;
    }

    public void setFlushAfterEachInsert(boolean enabled) {
        this._flushAfterEachInsert = enabled;
    }

    public boolean isFlushAfterEachUpdate() {
        return this._flushAfterEachUpdate;
    }

    public void setFlushAfterEachUpdate(boolean enabled) {
        this._flushAfterEachUpdate = enabled;
    }

    public boolean isFlushAfterEachDelete() {
        return this._flushAfterEachDelete;
    }

    public void setFlushAfterEachDelete(boolean enabled) {
        this._flushAfterEachDelete = enabled;
    }

    public boolean isInternetAccessAllowed() {
        return this._internetAccessAllowed;
    }

    public void setInternetAccessAllowed(boolean allowed) {
        this._internetAccessAllowed = allowed;
    }

    public boolean isWebServicesDisabled() {
        return !this.isWebServicesEnabled();
    }

    public boolean isWebServicesEnabled() {
        return this._webServicesEnabled;
    }

    public void setWebServicesEnabled(boolean enabled) {
        this._webServicesEnabled = enabled;
    }

    public boolean isProjectMailingEnabled() {
        return this._projectMailingEnabled;
    }

    public void setProjectMailingEnabled(boolean enabled) {
        this._projectMailingEnabled = enabled;
    }

    public boolean isProjectMailDebuggingEnabled() {
        return this._projectMailDebuggingEnabled;
    }

    public void setProjectMailDebuggingEnabled(boolean enabled) {
        this._projectMailDebuggingEnabled = enabled;
    }

    public boolean isProjectTextingEnabled() {
        return this._projectTextingEnabled;
    }

    public void setProjectTextingEnabled(boolean enabled) {
        this._projectTextingEnabled = enabled;
    }

    public boolean isProjectTextDebuggingEnabled() {
        return this._projectTextDebuggingEnabled;
    }

    public void setProjectTextDebuggingEnabled(boolean enabled) {
        this._projectTextDebuggingEnabled = enabled;
    }

    public boolean isProjectRecaptchaEnabled() {
        return this._internetAccessAllowed && this._projectRecaptchaEnabled;
    }

    public boolean isProjectRecaptchaDisabled() {
        return !this.isProjectRecaptchaEnabled();
    }

    public void setProjectRecaptchaEnabled(boolean enabled) {
        this._projectRecaptchaEnabled = enabled;
    }

    public boolean isProjectRecaptchaSiteVerificationEnabled() {
        return this._internetAccessAllowed && this._projectRecaptchaEnabled && this._projectRecaptchaSiteVerificationEnabled;
    }

    public boolean isProjectRecaptchaSiteVerificationDisabled() {
        return !this.isProjectRecaptchaSiteVerificationEnabled();
    }

    public void setProjectRecaptchaSiteVerificationEnabled(boolean enabled) {
        this._projectRecaptchaSiteVerificationEnabled = enabled;
    }

    public boolean isProjectAssignNewPasswordEnabled() {
        return this._projectAssignNewPasswordEnabled && SecurityRealmType.JDBC.equals((Object)this.getSecurityRealmType());
    }

    public void setProjectAssignNewPasswordEnabled(boolean enabled) {
        this._projectAssignNewPasswordEnabled = enabled;
    }

    public boolean isProjectChangeOwnPasswordEnabled() {
        return this._projectChangeOwnPasswordEnabled && SecurityRealmType.JDBC.equals((Object)this.getSecurityRealmType());
    }

    public void setProjectChangeOwnPasswordEnabled(boolean enabled) {
        this._projectChangeOwnPasswordEnabled = enabled;
    }

    public boolean isProjectChangeForgottenPasswordEnabled() {
        return this._projectChangeForgottenPasswordEnabled && this._internetAccessAllowed && this._projectMailingEnabled && SecurityRealmType.JDBC.equals((Object)this.getSecurityRealmType());
    }

    public void setProjectChangeForgottenPasswordEnabled(boolean enabled) {
        this._projectChangeForgottenPasswordEnabled = enabled;
    }

    public int getProjectChangeForgottenPasswordTimeout() {
        return this._projectChangeForgottenPasswordTimeout;
    }

    public void setProjectChangeForgottenPasswordTimeout(int timeout) {
        this._projectChangeForgottenPasswordTimeout = timeout < 5 ? 5 : (timeout > 60 ? 60 : timeout);
    }

    public boolean isProjectChangeOwnEmailEnabled() {
        return this._projectChangeOwnEmailEnabled && SecurityRealmType.JDBC.equals((Object)this.getSecurityRealmType());
    }

    public void setProjectChangeOwnEmailEnabled(boolean enabled) {
        this._projectChangeOwnEmailEnabled = enabled;
    }

    public boolean isExporterShellEnabled() {
        return this._exporterShellEnabled;
    }

    public void setExporterShellEnabled(boolean enabled) {
        this._exporterShellEnabled = enabled;
    }

    public boolean isReporterShellEnabled() {
        return this._reporterShellEnabled;
    }

    public void setReporterShellEnabled(boolean enabled) {
        this._reporterShellEnabled = enabled;
    }

    public boolean isSqlAgentShellEnabled() {
        return this._sqlAgentShellEnabled;
    }

    public void setSqlAgentShellEnabled(boolean enabled) {
        this._sqlAgentShellEnabled = enabled;
    }

    public boolean getOperatingSystemShellKeepTempFiles() {
        return BitUtils.valueOf(this._operatingSystemShellKeepTempFiles, this.getDefaultOperatingSystemShellKeepTempFiles());
    }

    public void setOperatingSystemShellKeepTempFiles(Boolean keep) {
        this._operatingSystemShellKeepTempFiles = keep;
    }

    public ShortMessageServiceProvider getDefaultSMSProvider() {
        return (ShortMessageServiceProvider)this.specified(new ShortMessageServiceProvider[]{this._defaultSMSProvider, this.getDefaultShortMessageServiceProvider()});
    }

    public boolean defaultSMSProviderIs(String name) {
        return this.getDefaultSMSProvider().name().equals(name);
    }

    public boolean defaultSMSProviderIsNot(String name) {
        return !this.defaultSMSProviderIs(name);
    }

    public void setDefaultSMSProvider(ShortMessageServiceProvider provider) {
        this._defaultSMSProvider = provider != null ? provider : ShortMessageServiceProvider.UNSPECIFIED;
    }

    public ProjectStage getProjectStage() {
        return this._projectStage == null ? this.getDefaultProjectStage() : this._projectStage;
    }

    public void setProjectStage(ProjectStage stage) {
        this._projectStage = stage;
    }

    public String getWebAuthMethod(String server) {
        boolean adaptado = StringUtils.equalsIgnoreCase((String)server, (String)"JBoss") || StringUtils.equalsIgnoreCase((String)server, (String)"WildFly");
        WebLoginAuthMethod method = this.getWebAuthMethod();
        WebLoginAuthMethod metodo = WebLoginAuthMethod.KEYCLOAK.equals((Object)method) ? (adaptado ? method : this.getDefaultWebAuthMethod()) : method;
        return metodo.getMethod();
    }

    public WebLoginAuthMethod getWebAuthMethod() {
        return this._webAuthMethod == null ? this.getDefaultWebAuthMethod() : this._webAuthMethod;
    }

    public void setWebAuthMethod(WebLoginAuthMethod method) {
        this._webAuthMethod = method;
    }

    public String getWebApiAuthMethod(String server) {
        boolean adaptado = StringUtils.equalsIgnoreCase((String)server, (String)"JBoss") || StringUtils.equalsIgnoreCase((String)server, (String)"WildFly");
        WebLoginAuthMethod method = this.getWebApiAuthMethod();
        WebLoginAuthMethod metodo = WebLoginAuthMethod.KEYCLOAK.equals((Object)method) ? (adaptado ? method : this.getDefaultWebApiAuthMethod()) : method;
        return metodo.getMethod();
    }

    public WebLoginAuthMethod getWebApiAuthMethod() {
        return this._webApiAuthMethod != null && ArrayUtils.contains((Object[])SUPPORTED_WEB_API_AUTH_METHODS, (Object)((Object)this._webApiAuthMethod)) ? this._webApiAuthMethod : this.getDefaultWebApiAuthMethod();
    }

    public void setWebApiAuthMethod(WebLoginAuthMethod method) {
        this._webApiAuthMethod = method;
    }

    public SecurityRealmType getSecurityRealmType() {
        return this._securityRealmType == null ? this.getDefaultSecurityRealmType() : this._securityRealmType;
    }

    public void setSecurityRealmType(SecurityRealmType securityRealmType) {
        this._securityRealmType = securityRealmType;
    }

    public String getSecurityRealmName() {
        return StringUtils.defaultIfBlank((String)this._securityRealmName, (String)this.getDefaultSecurityRealmName());
    }

    public void setSecurityRealmName(String securityRealmName) {
        this._securityRealmName = StrUtils.getLowerCaseIdentifier(securityRealmName, '-');
    }

    public String getRoleBasedAccessControllerName() {
        return StringUtils.defaultIfBlank((String)this._roleBasedAccessControllerName, (String)this.getDefaultRoleBasedAccessControllerName());
    }

    public void setRoleBasedAccessControllerName(String roleBasedAccessControllerName) {
        this._roleBasedAccessControllerName = StrUtils.getIdentifier(roleBasedAccessControllerName);
    }

    public void setRoleBasedAccessControllerName(SecurityRealmType securityRealmType) {
        String name = SecurityRealmType.JDBC.equals((Object)securityRealmType) ? this.getAlias() : securityRealmType.name();
        this.setRoleBasedAccessControllerName(name);
    }

    public String getWebSecurityPrefix() {
        return StringUtils.defaultIfBlank((String)this._webSecurityPrefix, (String)this.getWebProjectName());
    }

    public void setWebSecurityPrefix(String prefix) {
        this._webSecurityPrefix = StrUtils.getLowerCaseIdentifier(prefix, '-');
    }

    public boolean isAuthenticatedUserAutomaticRegistrationEnabled() {
        return this._authenticatedUserAutomaticRegistrationEnabled && !SecurityRealmType.JDBC.equals((Object)this.getSecurityRealmType());
    }

    public void setAuthenticatedUserAutomaticRegistrationEnabled(boolean enabled) {
        this._authenticatedUserAutomaticRegistrationEnabled = enabled;
    }

    public boolean isAuthenticatedUserAutomaticSynchronizationEnabled() {
        return this._authenticatedUserAutomaticSynchronizationEnabled && !SecurityRealmType.JDBC.equals((Object)this.getSecurityRealmType());
    }

    public void setAuthenticatedUserAutomaticSynchronizationEnabled(boolean enabled) {
        this._authenticatedUserAutomaticSynchronizationEnabled = enabled;
    }

    protected String getDefaultAddOnsProjectName() {
        return this.getAlias() + "-add-ons";
    }

    protected String getDefaultEarProjectName() {
        return this.getAlias();
    }

    protected String getDefaultEjbProjectName() {
        return this.getAlias() + "-ejb";
    }

    protected String getDefaultLibProjectName() {
        return this.getAlias() + "-lib";
    }

    protected String getDefaultLibDirProjectName() {
        return this.getAlias() + "-lib-dir";
    }

    protected String getDefaultResourcesProjectName() {
        return this.getAlias() + "-resources";
    }

    protected String getDefaultWebProjectName() {
        return this.getAlias() + "-war";
    }

    protected String getDefaultWebApiProjectName() {
        return this.getAlias() + "-war-api";
    }

    protected String getDefaultRootPackageName() {
        return this.getAlias();
    }

    protected String getDefaultPersistenceRootPackageName() {
        return this.getRootPackageName();
    }

    protected String getDefaultGoogleRecaptchaSiteKey() {
        return "6LeIxAcTAAAAAJcZVRqyHh71UMIEGNQ_MXjiZKhI";
    }

    protected String getDefaultGoogleRecaptchaSecretKey() {
        return "6LeIxAcTAAAAAGG-vFI1TnRWxMZNFuojJ4WifJWe";
    }

    protected boolean getDefaultOperatingSystemShellKeepTempFiles() {
        ProjectStage stage = this.getProjectStage();
        return ProjectStage.DEVELOPMENT.equals((Object)stage) || ProjectStage.TESTING.equals((Object)stage);
    }

    protected ShortMessageServiceProvider getDefaultShortMessageServiceProvider() {
        return this._projectTextingEnabled || this._projectTextDebuggingEnabled ? ShortMessageServiceProvider.TWILIO : ShortMessageServiceProvider.UNSPECIFIED;
    }

    protected ProjectStage getDefaultProjectStage() {
        return ProjectStage.DEVELOPMENT;
    }

    protected WebLoginAuthMethod getDefaultWebAuthMethod() {
        return WebLoginAuthMethod.FORM;
    }

    protected WebLoginAuthMethod getDefaultWebApiAuthMethod() {
        return WebLoginAuthMethod.BASIC;
    }

    protected SecurityRealmType getDefaultSecurityRealmType() {
        return SecurityRealmType.JDBC;
    }

    protected String getDefaultSecurityRealmName() {
        return this.getAlias() + "-auth-realm";
    }

    protected String getDefaultRoleBasedAccessControllerName() {
        return this.getAlias();
    }

    static {
        ENBG.put(Aplicacion.class.getSimpleName(), "BundleWebui.getNombreAplicacion");
        ENBG.put(ClaseRecurso.class.getSimpleName(), "BundleDominios.getNombreClaseRecurso");
        ENBG.put(Dominio.class.getSimpleName(), "BundleDominios.getNombreDominio");
        ENBG.put(Funcion.class.getSimpleName(), "BundleFunciones.getNombreFuncion");
        ENBG.put(FuncionParametro.class.getSimpleName(), "BundleParametros.getNombreFuncionParametro");
        ENBG.put(GrupoProceso.class.getSimpleName(), "BundleFunciones.getNombreGrupoProceso");
        ENBG.put(Pagina.class.getSimpleName(), "BundleWebui.getNombrePagina");
        ENBG.put(Parametro.class.getSimpleName(), "BundleParametros.getNombreParametro");
        PAKS = AbstractJavaProgrammer.getJavaKeywords();
        PAKS.add("context");
        PAKS.add("pages");
    }
}

