/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.map;

import adalid.util.map.EntityVertex;
import adalid.util.map.ReferenceArc;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class ReferencePath
implements Comparable<ReferencePath> {
    private final EntityVertex origin;
    private final List<EntityVertex> vertices = new ArrayList<EntityVertex>();
    private boolean circular;
    private boolean complete;
    private boolean original;

    public ReferencePath(ReferenceArc arc) {
        this.origin = arc.getSource();
        this.vertices.add(this.origin);
        this.add(arc.getTarget());
    }

    public ReferencePath(ReferencePath referencePath, EntityVertex vertex) {
        this.origin = referencePath.origin;
        this.vertices.addAll(referencePath.vertices);
        this.add(vertex);
    }

    private void add(EntityVertex vertex) {
        if (this.complete) {
            throw new IllegalArgumentException(this + " is complete so vertex " + vertex + " cannot be added");
        }
        if (this.vertices.contains(vertex)) {
            this.finalise();
        }
        this.vertices.add(vertex);
    }

    public EntityVertex getOrigin() {
        return this.origin;
    }

    public String getApplication() {
        return this.origin.getApplication();
    }

    public List<EntityVertex> getVertices() {
        return this.vertices;
    }

    public boolean isCircular() {
        return this.circular;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public void finalise() {
        this.circular = false;
        this.complete = true;
        this.original = true;
        String application = this.origin.getApplication();
        for (EntityVertex vertex : this.vertices) {
            if (application.equals(vertex.getApplication())) {
                if (this.original) continue;
                this.circular = true;
                break;
            }
            this.original = false;
        }
    }

    @Override
    public int compareTo(ReferencePath that) {
        return this.toString().compareTo(that.toString());
    }

    public boolean equals(Object that) {
        return that instanceof ReferencePath && this.toString().equals(that.toString());
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.origin);
        hash = 29 * hash + Objects.hashCode(this.vertices);
        hash = 29 * hash + (this.complete ? 1 : 0);
        hash = 29 * hash + (this.circular ? 1 : 0);
        return hash;
    }

    public String toString() {
        ArrayList<String> strings = new ArrayList<String>();
        for (EntityVertex vertice : this.vertices) {
            strings.add(vertice.toString());
        }
        return StringUtils.join(strings, (String)" > ");
    }
}

