/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.setup;

import adalid.commons.util.ThrowableUtils;
import adalid.util.Utility;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class FileDownloader
extends Utility {
    private static final Logger logger = Logger.getLogger(FileDownloader.class);
    private static final File UH = new File(System.getProperty("user.home"));
    private static final File DD;
    private static final File WS;
    private static final String VN;
    private static final String ZN;
    private static final String DROPBOX_LINK = "https://www.dropbox.com/sh/fwr81f73wjy1ybi/AAChePmVCL-vDFe2heL8iJPJa?dl=1";

    public static void main(String[] args) {
        FileDownloader.download();
    }

    public static void download() {
        boolean downloaded = FileDownloader.downloadDropboxFile(DROPBOX_LINK);
        if (downloaded) {
            FileDownloader.info("{0} downloaded", ZN);
        } else {
            FileDownloader.info("{0} download failed", ZN);
        }
        FileDownloader.updateProjectBuilderDictionary(FileDownloader.class);
    }

    private static boolean downloadDropboxFile(String spec) {
        return FileDownloader.downloadDropboxFile(spec, ZN);
    }

    private static boolean downloadDropboxFile(String spec, String file) {
        try {
            URL source = new URL(spec);
            File target = new File(WS, file);
            return FileDownloader.downloadDropboxFile(source, target);
        }
        catch (MalformedURLException ex) {
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            return false;
        }
    }

    private static boolean downloadDropboxFile(URL source, File target) {
        FileDownloader.info("downloading {0} to {1}", target.getName(), target.getParent());
        try {
            FileUtils.copyURLToFile((URL)source, (File)target);
            return true;
        }
        catch (IOException ex) {
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            return false;
        }
    }

    private static void info(String pattern, Object ... arguments) {
        logger.info((Object)MessageFormat.format(pattern, arguments));
    }

    static {
        WS = DD = new File(UH, "Downloads");
        VN = FileDownloader.getAdalidProjectVersion();
        ZN = "adalid-" + VN + ".zip";
        FileDownloader.logAdalidProjectVersion();
    }
}

