/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlColumn;
import adalid.util.sql.SqlReader;
import adalid.util.sql.SqlRoutine;
import adalid.util.sql.SqlTable;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class SqlRoutineParameter
extends SqlArtifact {
    private final SqlRoutine _routine;
    private int _position;
    private String _type;
    private String _sqlDataType;
    private boolean _required;
    private boolean _hidden;
    private String _default;
    private String _sqlDefaultValue;

    public SqlRoutineParameter(SqlRoutine routine) {
        this._routine = routine;
    }

    public SqlRoutine getRoutine() {
        return this._routine;
    }

    public int getPosition() {
        return this._position;
    }

    void setPosition(int position) {
        this._position = position;
    }

    public String getType() {
        return this._type;
    }

    void setType(String type) {
        this._type = type;
    }

    public String getSqlDataType() {
        return this._sqlDataType;
    }

    void setSqlDataType(String sqlDataType) {
        this._sqlDataType = sqlDataType;
    }

    public boolean isRequired() {
        return this._required;
    }

    void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public String getDefault() {
        return this._default;
    }

    void setDefault(String defaultValue) {
        this._default = defaultValue;
    }

    public String getSqlDefaultValue() {
        return this._sqlDefaultValue;
    }

    void setSqlDefaultValue(String sqlDefaultValue) {
        this._sqlDefaultValue = sqlDefaultValue;
    }

    public boolean matches(String type, String role) {
        if (StringUtils.isBlank((String)type) || StringUtils.isBlank((String)role)) {
            return false;
        }
        String name = this.getName();
        String table = this.getRoutine().getTable().getName();
        return this.matches(type, role, name, table);
    }

    private boolean matches(String type, String role, String name, String table) {
        return this._type.equals(type) && (name.equals(role) || name.equals(role + "_" + table) || name.equals(table + "_" + role));
    }

    public SqlTable getReferencedTable() {
        String name = this.getName();
        SqlColumn namesake = this.getNamesakeColumn();
        if (namesake != null && namesake.isForeign()) {
            return namesake.getForeignTable();
        }
        SqlReader reader = this.getRoutine().getTable().getReader();
        Collection<SqlTable> tables = reader.getTables();
        for (SqlTable sqlTable : tables) {
            String role;
            String type;
            String table = sqlTable.getName();
            SqlColumn pk = sqlTable.getPrimaryKey();
            if (pk == null || !this.matches(type = pk.getType(), role = this.remove(pk.getName(), table), name, table)) continue;
            return sqlTable;
        }
        return null;
    }

    public SqlColumn getNamesakeColumn() {
        String name = this.getName();
        return this.getNamesakeColumn(name);
    }

    public SqlColumn getNamesakeColumn(String name) {
        SqlColumn namesake = this.getRoutine().getTable().getSqlColumn(name);
        return namesake != null && namesake.getType().equals(this.getTrueType()) ? namesake : null;
    }

    public SqlTable getForeignTable() {
        SqlColumn namesake = this.getNamesakeColumn();
        return namesake == null ? null : namesake.getForeignTable();
    }

    public boolean isForeign() {
        SqlColumn namesake = this.getNamesakeColumn();
        return namesake != null && namesake.isForeign();
    }

    private String remove(String name, String table) {
        return StringUtils.removeStart((String)StringUtils.removeEnd((String)name, (String)("_" + table)), (String)(table + "_"));
    }

    public String getTrueType() {
        if (this._type.equals("integer") && this.getName().startsWith("es_")) {
            return "boolean";
        }
        if (this._type.equals("timestamp") && this.getName().startsWith("fecha") && !this.getName().startsWith("fecha_hora")) {
            return "date";
        }
        if (this._type.equals("timestamp") && this.getName().startsWith("hora")) {
            return "time";
        }
        return this._type;
    }

    public String getMetajavaType() {
        switch (this._type) {
            case "boolean": {
                return "BooleanParameter";
            }
            case "char": {
                return "CharacterParameter";
            }
            case "string": {
                return "StringParameter";
            }
            case "short": {
                return "ShortParameter";
            }
            case "integer": {
                return "IntegerParameter";
            }
            case "long": {
                return "LongParameter";
            }
            case "decimal": {
                return "BigDecimalParameter";
            }
            case "float": {
                return "FloatParameter";
            }
            case "double": {
                return "DoubleParameter";
            }
            case "date": {
                return "DateParameter";
            }
            case "time": {
                return "TimeParameter";
            }
            case "timestamp": {
                return "TimestampParameter";
            }
        }
        return "Parameter";
    }

    public String getQualifiedName() {
        return this.getRoutine().getName() + "." + this.getRoutine().getTable().getName() + "." + this.getName();
    }
}

