/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.ProcessOperation;
import adalid.core.Tab;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.EntityWarnings;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.QueryMapping;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UniformResourceLocator;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.CondicionEjeFun;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.configuracion.basica.GrupoProceso;
import meta.entidad.comun.configuracion.basica.SeveridadMensaje;
import meta.entidad.comun.configuracion.basica.TipoFuncion;
import meta.entidad.comun.configuracion.basica.TipoRastroFun;
import meta.entidad.comun.control.acceso.Usuario;
import meta.entidad.comun.operacion.basica.RecursoValor;

@EntityClass(independent=Kleenean.TRUE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE, sortOption=SortOption.DESC)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.FALSE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.TRUE, readingViewWesternToolbarSnippet="/resources/snippets/base/entity/RastroProceso/botonOpenCalendarioProcesos")
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
@EntityTriggers(afterValue=Kleenean.TRUE)
@EntityWarnings(aboutBusinessKey=Kleenean.FALSE)
public class RastroProceso
extends AbstractPersistentEntity {
    @PrimaryKey
    @PropertyField(hidden=Kleenean.FALSE, detail=Kleenean.TRUE, heading=Kleenean.TRUE)
    public LongProperty id;
    @ColumnField(nullable=Kleenean.FALSE, indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public TimestampProperty fechaHoraInicioEjecucion;
    public TimestampProperty fechaHoraFinEjecucion;
    @OwnerProperty
    @SegmentProperty
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    @QueryMapping(mapKeyProperties=Kleenean.FALSE)
    public Usuario usuario;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=254)
    public StringProperty codigoUsuario;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE, search=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty nombreUsuario;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    @QueryMapping(mapKeyProperties=Kleenean.FALSE)
    public Funcion funcion;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=200)
    public StringProperty codigoFuncion;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE, search=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    @StringField(maxLength=200)
    public StringProperty nombreFuncion;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE)
    @StringField(maxLength=0)
    public StringProperty descripcionFuncion;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayMode=DisplayMode.PROCESSING, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.FALSE, headertextless=Kleenean.TRUE)
    public StringProperty paginaFuncion;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    public TipoFuncion tipoFuncion;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    public TipoRastroFun tipoRastroFun;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idClaseRecursoValor;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(search=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty codigoClaseRecursoValor;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(search=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty nombreClaseRecursoValor;
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public RecursoValor recursoValor;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idRecurso;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty versionRecurso;
    @ColumnField(indexed=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE)
    public StringProperty codigoRecurso;
    @ColumnField(indexed=Kleenean.FALSE)
    @PropertyField(table=Kleenean.FALSE, report=Kleenean.TRUE, search=Kleenean.TRUE)
    public StringProperty nombreRecurso;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idPropietarioRecurso;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idSegmentoRecurso;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.FALSE, headertextless=Kleenean.TRUE)
    public StringProperty paginaRecurso;
    @StringField(maxLength=20)
    public StringProperty etiquetaLenguaje;
    private static final String BORPPSX1 = "/resources/snippets/base/entity/RastroProceso/botonOpenRastroProcesoPorSuperiorX1";
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE, readingTableSnippet="/resources/snippets/base/entity/RastroProceso/botonOpenRastroProcesoPorSuperiorX1")
    public CondicionEjeFun condicionEjeFun;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE, report=Kleenean.FALSE)
    public SeveridadMensaje severidadMensaje;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idRecursoObtenido;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(table=Kleenean.FALSE, report=Kleenean.FALSE, search=Kleenean.FALSE, headertextless=Kleenean.TRUE)
    public StringProperty paginaRecursoObtenido;
    @FileReference(loadField="fechaHoraInicioEjecucion")
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.FALSE)
    public StringProperty nombreArchivo;
    @PropertyField(hidden=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty codigoError;
    @StringField(maxLength=0)
    public StringProperty descripcionError;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE, report=Kleenean.FALSE)
    public GrupoProceso grupo;
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE, report=Kleenean.FALSE)
    public RastroProceso superior;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public CondicionEjeFun condicionEjeTem;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    public SeveridadMensaje severidadMensajeTem;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idRecursoObtenidoTem;
    @PropertyField(hidden=Kleenean.TRUE)
    @StringField(maxLength=-1000002001)
    public StringProperty nombreArchivoTem;
    @PropertyField(hidden=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty codigoErrorTem;
    @PropertyField(hidden=Kleenean.TRUE)
    @StringField(maxLength=0)
    public StringProperty descripcionErrorTem;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public CondicionEjeFun condicionEjeAnt;
    @ColumnField(indexed=Kleenean.TRUE)
    @StringField(maxLength=146)
    @PropertyField(hidden=Kleenean.TRUE)
    public StringProperty ultimaTransaccion;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public IntegerProperty transacciones;
    @ColumnField(nullable=Kleenean.FALSE)
    public BooleanProperty leido;
    @ColumnField(nullable=Kleenean.FALSE)
    public BooleanProperty descargado;
    @ColumnField(nullable=Kleenean.FALSE)
    public BooleanProperty procesoAsincrono;
    @ColumnField(nullable=Kleenean.FALSE)
    public BooleanProperty procesoCalendarizado;
    @ColumnField(nullable=Kleenean.FALSE)
    public BooleanProperty procesoNativo;
    @ColumnField(nullable=Kleenean.FALSE)
    public BooleanProperty procesoWeb;
    private static final String BORPPSX2 = "/resources/snippets/base/entity/RastroProceso/botonOpenRastroProcesoPorSuperiorX2";
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(readingDetailSnippet="/resources/snippets/base/entity/RastroProceso/botonOpenRastroProcesoPorSuperiorX2")
    public IntegerProperty subprocesos;
    @ColumnField(nullable=Kleenean.FALSE)
    public IntegerProperty subprocesosPendientes;
    @ColumnField(nullable=Kleenean.FALSE)
    public IntegerProperty subprocesosEnProgreso;
    @ColumnField(nullable=Kleenean.FALSE)
    public IntegerProperty subprocesosSinErrores;
    @ColumnField(nullable=Kleenean.FALSE)
    public IntegerProperty subprocesosConErrores;
    @ColumnField(nullable=Kleenean.FALSE)
    public IntegerProperty subprocesosCancelados;
    @StringField(maxLength=100)
    public StringProperty procedimientoAfterUpdate;
    protected Key ix_rastro_proceso_0001;
    protected Tab tab110;
    protected Tab tab120;
    protected Tab tab130;
    protected Segment finalizado;
    protected Segment pendiente;
    protected Segment pendienteActual;
    protected Segment sinSuperior;
    protected Segment conSuperior;
    protected Segment sinSubprocesos;
    protected Segment conSubprocesos;
    protected MarcarComoLeido marcarComoLeido;
    protected MarcarComoNoLeido marcarComoNoLeido;

    public RastroProceso(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "process audit trail");
        this.setLocalizedLabel(SPANISH, "rastro de auditor\u00eda de proceso");
        this.setLocalizedShortLabel(ENGLISH, "process trail");
        this.setLocalizedShortLabel(SPANISH, "rastro de proceso");
        this.setLocalizedCollectionLabel(ENGLISH, "Process Audit Trails");
        this.setLocalizedCollectionLabel(SPANISH, "Rastros de Auditor\u00eda de Procesos");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Process Trails");
        this.setLocalizedCollectionShortLabel(SPANISH, "Rastros de Procesos");
        this.setLocalizedCollectionLabel(ENGLISH, this.superior, "Subprocess Audit Trails by Parent Process Trail");
        this.setLocalizedCollectionLabel(SPANISH, this.superior, "Rastros de Auditor\u00eda de Subprocesos por Rastro de Proceso Superior");
        this.setLocalizedCollectionShortLabel(ENGLISH, this.superior, "Subprocess Trails");
        this.setLocalizedCollectionShortLabel(SPANISH, this.superior, "Rastros de Subprocesos");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Process Audit Trails") + " represents an audit trail of the execution of business and scheduled processes.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Rastros de Auditor\u00eda de Procesos") + " representa un rastro de auditor\u00eda de la ejecuci\u00f3n de procesos de negocio y calendarizados.");
        this.setLocalizedShortDescription(ENGLISH, "audit trail of the execution of business and scheduled processes");
        this.setLocalizedShortDescription(SPANISH, "rastro de auditor\u00eda de la ejecuci\u00f3n de procesos de negocio y calendarizados");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.fechaHoraInicioEjecucion.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraInicioEjecucion.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.descripcionFuncion.setCalculableValueExpression(this.funcion.descripcionFuncion);
        this.tipoRastroFun.setInitialValue(this.tipoRastroFun.NINGUNO);
        this.tipoRastroFun.setDefaultValue(this.tipoRastroFun.NINGUNO);
        this.condicionEjeFun.setInitialValue(this.condicionEjeFun.EJECUCION_PENDIENTE);
        this.condicionEjeFun.setDefaultValue(this.condicionEjeFun.EJECUCION_PENDIENTE);
        this.severidadMensaje.setDefaultValue(this.condicionEjeFun.isNull().then(SpecialEntityValue.NULL).otherwise(this.condicionEjeFun.isEqualTo(this.condicionEjeFun.EJECUCION_CANCELADA).then(this.severidadMensaje.FATAL).otherwise(this.condicionEjeFun.isEqualTo(this.condicionEjeFun.EJECUTADO_CON_ERRORES).then(this.severidadMensaje.ERROR).otherwise(this.severidadMensaje.INFORMATIVO))));
        this.condicionEjeTem.setInitialValue(this.condicionEjeTem.EJECUCION_PENDIENTE);
        this.condicionEjeTem.setDefaultValue(this.condicionEjeTem.EJECUCION_PENDIENTE);
        this.severidadMensajeTem.setDefaultValue(this.condicionEjeTem.isNull().then(SpecialEntityValue.NULL).otherwise(this.condicionEjeTem.isEqualTo(this.condicionEjeTem.EJECUCION_CANCELADA).then(this.severidadMensajeTem.FATAL).otherwise(this.condicionEjeTem.isEqualTo(this.condicionEjeTem.EJECUTADO_CON_ERRORES).then(this.severidadMensajeTem.ERROR).otherwise(this.severidadMensajeTem.INFORMATIVO))));
        this.transacciones.setInitialValue(0);
        this.transacciones.setDefaultValue(0);
        this.nombreArchivo.setFileDownloadStopFunction("hideDialogoMostrarStatusDownloadPlusRefresh");
        this.nombreArchivo.setFileViewerDialogReturnUpdate("mainForm", "northForm", "@(.xs-bar-updatable-component)");
        this.leido.setInitialValue(false);
        this.leido.setDefaultValue(false);
        this.descargado.setInitialValue(false);
        this.descargado.setDefaultValue(false);
        this.procesoAsincrono.setInitialValue(false);
        this.procesoAsincrono.setDefaultValue(false);
        this.procesoCalendarizado.setInitialValue(false);
        this.procesoCalendarizado.setDefaultValue(false);
        this.procesoNativo.setInitialValue(false);
        this.procesoNativo.setDefaultValue(false);
        this.procesoWeb.setInitialValue(false);
        this.procesoWeb.setDefaultValue(false);
        this.subprocesos.setInitialValue(0);
        this.subprocesos.setDefaultValue(0);
        this.subprocesosPendientes.setInitialValue(0);
        this.subprocesosPendientes.setDefaultValue(0);
        this.subprocesosEnProgreso.setInitialValue(0);
        this.subprocesosEnProgreso.setDefaultValue(0);
        this.subprocesosSinErrores.setInitialValue(0);
        this.subprocesosSinErrores.setDefaultValue(0);
        this.subprocesosConErrores.setInitialValue(0);
        this.subprocesosConErrores.setDefaultValue(0);
        this.subprocesosCancelados.setInitialValue(0);
        this.subprocesosCancelados.setDefaultValue(0);
        this.fechaHoraInicioEjecucion.setLocalizedLabel(ENGLISH, "start");
        this.fechaHoraInicioEjecucion.setLocalizedLabel(SPANISH, "inicio");
        this.fechaHoraFinEjecucion.setLocalizedLabel(ENGLISH, "end");
        this.fechaHoraFinEjecucion.setLocalizedLabel(SPANISH, "fin");
        this.usuario.setLocalizedLabel(ENGLISH, "user");
        this.usuario.setLocalizedLabel(SPANISH, "usuario");
        this.codigoUsuario.setLocalizedLabel(ENGLISH, "user");
        this.codigoUsuario.setLocalizedLabel(SPANISH, "usuario");
        this.nombreUsuario.setLocalizedLabel(ENGLISH, "user name");
        this.nombreUsuario.setLocalizedLabel(SPANISH, "nombre del usuario");
        this.funcion.setLocalizedLabel(ENGLISH, "function");
        this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.tipoFuncion.setLocalizedLabel(ENGLISH, "function type");
        this.tipoFuncion.setLocalizedLabel(SPANISH, "tipo de funci\u00f3n");
        this.tipoRastroFun.setLocalizedLabel(ENGLISH, "function trail type");
        this.tipoRastroFun.setLocalizedLabel(SPANISH, "tipo de rastro");
        this.codigoFuncion.setLocalizedLabel(ENGLISH, "function");
        this.codigoFuncion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.nombreFuncion.setLocalizedLabel(ENGLISH, "function name");
        this.nombreFuncion.setLocalizedLabel(SPANISH, "nombre de la funci\u00f3n");
        this.descripcionFuncion.setLocalizedLabel(ENGLISH, "function description");
        this.descripcionFuncion.setLocalizedLabel(SPANISH, "descripci\u00f3n de la funci\u00f3n");
        this.paginaFuncion.setLocalizedLabel(ENGLISH, "function page");
        this.paginaFuncion.setLocalizedLabel(SPANISH, "p\u00e1gina de la funci\u00f3n");
        this.paginaFuncion.setLocalizedTooltip(ENGLISH, "open the function's processing page");
        this.paginaFuncion.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina de procesamiento de la funci\u00f3n");
        this.idClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        this.idClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        this.codigoClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        this.codigoClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        this.nombreClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class name");
        this.nombreClaseRecursoValor.setLocalizedLabel(SPANISH, "nombre de la clase de recurso");
        this.recursoValor.setLocalizedLabel(ENGLISH, "resource");
        this.recursoValor.setLocalizedLabel(SPANISH, "recurso");
        this.idRecurso.setLocalizedLabel(ENGLISH, "resource");
        this.idRecurso.setLocalizedLabel(SPANISH, "recurso");
        this.versionRecurso.setLocalizedLabel(ENGLISH, "resource version");
        this.versionRecurso.setLocalizedLabel(SPANISH, "versi\u00f3n del recurso");
        this.codigoRecurso.setLocalizedDescription(ENGLISH, "code of the resource on which the process was executed");
        this.codigoRecurso.setLocalizedDescription(SPANISH, "c\u00f3digo del recurso sobre el que se ejecut\u00f3 el proceso");
        this.codigoRecurso.setLocalizedLabel(ENGLISH, "resource");
        this.codigoRecurso.setLocalizedLabel(SPANISH, "recurso");
        this.nombreRecurso.setLocalizedDescription(ENGLISH, "name of the resource on which the process was executed");
        this.nombreRecurso.setLocalizedDescription(SPANISH, "nombre del recurso sobre el que se ejecut\u00f3 el proceso");
        this.nombreRecurso.setLocalizedLabel(ENGLISH, "resource name");
        this.nombreRecurso.setLocalizedLabel(SPANISH, "nombre del recurso");
        this.idPropietarioRecurso.setLocalizedLabel(ENGLISH, "resource owner");
        this.idPropietarioRecurso.setLocalizedLabel(SPANISH, "propietario del recurso");
        this.idSegmentoRecurso.setLocalizedLabel(ENGLISH, "resource segment");
        this.idSegmentoRecurso.setLocalizedLabel(SPANISH, "segmento del recurso");
        this.paginaRecurso.setLocalizedLabel(ENGLISH, "resource page");
        this.paginaRecurso.setLocalizedLabel(SPANISH, "p\u00e1gina del recurso");
        this.paginaRecurso.setLocalizedTooltip(ENGLISH, "open the resource's registration page");
        this.paginaRecurso.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina de registro del recurso");
        this.etiquetaLenguaje.setLocalizedLabel(ENGLISH, "language tag");
        this.etiquetaLenguaje.setLocalizedLabel(SPANISH, "etiqueta de lenguaje");
        this.etiquetaLenguaje.setLocalizedShortLabel(ENGLISH, "language");
        this.etiquetaLenguaje.setLocalizedShortLabel(SPANISH, "lenguaje");
        this.condicionEjeFun.setLocalizedLabel(ENGLISH, "function execution condition");
        this.condicionEjeFun.setLocalizedLabel(SPANISH, "condici\u00f3n de ejecuci\u00f3n de funci\u00f3n");
        this.condicionEjeFun.setLocalizedShortLabel(ENGLISH, "condition");
        this.condicionEjeFun.setLocalizedShortLabel(SPANISH, "condici\u00f3n");
        this.severidadMensaje.setLocalizedLabel(ENGLISH, "message severity");
        this.severidadMensaje.setLocalizedLabel(SPANISH, "severidad de mensaje");
        this.severidadMensaje.setLocalizedShortLabel(ENGLISH, "severity");
        this.severidadMensaje.setLocalizedShortLabel(SPANISH, "severidad");
        this.severidadMensaje.setLocalizedDefaultValueTag(ENGLISH, "If " + this.b("condition") + " is EJECUCION CANCELADA, then FATAL; if " + this.b("condition") + " is EJECUTADO CON ERRORES, then ERROR; in all other cases, INFORMATIVO");
        this.severidadMensaje.setLocalizedDefaultValueTag(SPANISH, "Si " + this.b("condici\u00f3n") + " es EJECUCION CANCELADA, entonces FATAL; si " + this.b("condici\u00f3n") + " es EJECUTADO CON ERRORES, entonces ERROR; en los dem\u00e1s casos, INFORMATIVO");
        this.idRecursoObtenido.setLocalizedLabel(ENGLISH, "obtained resource");
        this.idRecursoObtenido.setLocalizedLabel(SPANISH, "recurso obtenido");
        this.paginaRecursoObtenido.setLocalizedLabel(ENGLISH, "obtained resource page");
        this.paginaRecursoObtenido.setLocalizedLabel(SPANISH, "p\u00e1gina recurso obtenido");
        this.paginaRecursoObtenido.setLocalizedTooltip(ENGLISH, "open the obtained resource page");
        this.paginaRecursoObtenido.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina del recurso obtenido");
        this.nombreArchivo.setLocalizedLabel(ENGLISH, "file");
        this.nombreArchivo.setLocalizedLabel(SPANISH, "archivo");
        this.nombreArchivo.setLocalizedTooltip(ENGLISH, "open the process file");
        this.nombreArchivo.setLocalizedTooltip(SPANISH, "abrir el archivo del proceso");
        this.codigoError.setLocalizedLabel(ENGLISH, "message code");
        this.codigoError.setLocalizedLabel(SPANISH, "c\u00f3digo del mensaje");
        this.descripcionError.setLocalizedLabel(ENGLISH, "message");
        this.descripcionError.setLocalizedLabel(SPANISH, "mensaje");
        this.grupo.setLocalizedLabel(ENGLISH, "process group");
        this.grupo.setLocalizedLabel(SPANISH, "grupo de procesos");
        this.superior.setLocalizedLabel(ENGLISH, "parent process trail");
        this.superior.setLocalizedLabel(SPANISH, "rastro de proceso superior");
        this.condicionEjeTem.setLocalizedLabel(ENGLISH, "function execution temporal condition");
        this.condicionEjeTem.setLocalizedLabel(SPANISH, "condici\u00f3n temporal de ejecuci\u00f3n de funci\u00f3n");
        this.condicionEjeTem.setLocalizedShortLabel(ENGLISH, "temporal condition");
        this.condicionEjeTem.setLocalizedShortLabel(SPANISH, "condici\u00f3n temporal");
        this.severidadMensajeTem.setLocalizedLabel(ENGLISH, "message temporal severity");
        this.severidadMensajeTem.setLocalizedLabel(SPANISH, "severidad temporal de mensaje");
        this.severidadMensajeTem.setLocalizedShortLabel(ENGLISH, "temporal severity");
        this.severidadMensajeTem.setLocalizedShortLabel(SPANISH, "severidad temporal");
        this.severidadMensajeTem.setLocalizedDefaultValueTag(ENGLISH, "If " + this.b("condition") + " is EJECUCION CANCELADA, then FATAL; if " + this.b("condition") + " is EJECUTADO CON ERRORES, then ERROR; in all other cases, INFORMATIVO");
        this.severidadMensajeTem.setLocalizedDefaultValueTag(SPANISH, "Si " + this.b("condici\u00f3n") + " es EJECUCION CANCELADA, entonces FATAL; si " + this.b("condici\u00f3n") + " es EJECUTADO CON ERRORES, entonces ERROR; en los dem\u00e1s casos, INFORMATIVO");
        this.idRecursoObtenido.setLocalizedLabel(ENGLISH, "temporal obtained resource");
        this.idRecursoObtenido.setLocalizedLabel(SPANISH, "recurso obtenido temporal");
        this.nombreArchivoTem.setLocalizedLabel(ENGLISH, "temporal file");
        this.nombreArchivoTem.setLocalizedLabel(SPANISH, "archivo temporal");
        this.codigoErrorTem.setLocalizedLabel(ENGLISH, "temporal message code");
        this.codigoErrorTem.setLocalizedLabel(SPANISH, "c\u00f3digo del mensaje temporal");
        this.descripcionErrorTem.setLocalizedLabel(ENGLISH, "temporal message");
        this.descripcionErrorTem.setLocalizedLabel(SPANISH, "mensaje temporal");
        this.condicionEjeAnt.setLocalizedLabel(ENGLISH, "function execution previous condition");
        this.condicionEjeAnt.setLocalizedLabel(SPANISH, "condici\u00f3n anterior de ejecuci\u00f3n de funci\u00f3n");
        this.condicionEjeAnt.setLocalizedShortLabel(ENGLISH, "previous condition");
        this.condicionEjeAnt.setLocalizedShortLabel(SPANISH, "condici\u00f3n anterior");
        this.ultimaTransaccion.setLocalizedLabel(ENGLISH, "last transaction");
        this.ultimaTransaccion.setLocalizedLabel(SPANISH, "\u00faltima transacci\u00f3n");
        this.transacciones.setLocalizedLabel(ENGLISH, "transaction count");
        this.transacciones.setLocalizedLabel(SPANISH, "cantidad de transacciones");
        this.leido.setLocalizedLabel(ENGLISH, "read");
        this.leido.setLocalizedLabel(SPANISH, "le\u00eddo");
        this.descargado.setLocalizedLabel(ENGLISH, "downloaded");
        this.descargado.setLocalizedLabel(SPANISH, "descargado");
        this.procesoAsincrono.setLocalizedLabel(ENGLISH, "asynchronous process");
        this.procesoAsincrono.setLocalizedLabel(SPANISH, "proceso as\u00edncrono");
        this.procesoCalendarizado.setLocalizedLabel(ENGLISH, "scheduled process");
        this.procesoCalendarizado.setLocalizedLabel(SPANISH, "proceso calendarizado");
        this.procesoNativo.setLocalizedLabel(ENGLISH, "native process");
        this.procesoNativo.setLocalizedLabel(SPANISH, "proceso nativo");
        this.procesoWeb.setLocalizedLabel(ENGLISH, "web service");
        this.procesoWeb.setLocalizedLabel(SPANISH, "servicio web");
        this.subprocesos.setLocalizedLabel(ENGLISH, "subprocesses");
        this.subprocesos.setLocalizedLabel(SPANISH, "subprocesos");
        this.subprocesosPendientes.setLocalizedLabel(ENGLISH, "pending subprocesses");
        this.subprocesosPendientes.setLocalizedLabel(SPANISH, "subprocesos pendientes");
        this.subprocesosEnProgreso.setLocalizedLabel(ENGLISH, "running subprocesses");
        this.subprocesosEnProgreso.setLocalizedLabel(SPANISH, "subprocesos en progreso");
        this.subprocesosSinErrores.setLocalizedLabel(ENGLISH, "subprocesses without errors");
        this.subprocesosSinErrores.setLocalizedLabel(SPANISH, "subprocesos sin errores");
        this.subprocesosConErrores.setLocalizedLabel(ENGLISH, "subprocesses with errors");
        this.subprocesosConErrores.setLocalizedLabel(SPANISH, "subprocesos con errores");
        this.subprocesosCancelados.setLocalizedLabel(ENGLISH, "cancelled subprocesses");
        this.subprocesosCancelados.setLocalizedLabel(SPANISH, "subprocesos cancelados");
        this.procedimientoAfterUpdate.setLocalizedLabel(ENGLISH, "final procedure");
        this.procedimientoAfterUpdate.setLocalizedLabel(SPANISH, "procedimiento final");
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.ix_rastro_proceso_0001.setUnique(false);
        this.ix_rastro_proceso_0001.newKeyField(this.idClaseRecursoValor, this.recursoValor);
    }

    @Override
    protected void settleTabs() {
        super.settleTabs();
        this.tab110.newTabField(this.id, this.superior, this.fechaHoraInicioEjecucion, this.fechaHoraFinEjecucion, this.leido, this.descargado, this.usuario, this.codigoUsuario, this.nombreUsuario, this.funcion, this.codigoFuncion, this.nombreFuncion, this.descripcionFuncion, this.paginaFuncion, this.idClaseRecursoValor, this.codigoClaseRecursoValor, this.nombreClaseRecursoValor, this.recursoValor, this.idRecurso, this.versionRecurso, this.codigoRecurso, this.nombreRecurso, this.idPropietarioRecurso, this.idSegmentoRecurso, this.paginaRecurso, this.condicionEjeFun, this.codigoError, this.descripcionError, this.severidadMensaje, this.paginaRecursoObtenido, this.nombreArchivo, this.etiquetaLenguaje);
        this.tab120.newTabField(this.funcion, this.codigoFuncion, this.nombreFuncion, this.descripcionFuncion, this.paginaFuncion, this.tipoFuncion, this.tipoRastroFun, this.grupo, this.procesoAsincrono, this.procesoCalendarizado, this.procesoNativo, this.procesoWeb, this.subprocesos);
        this.tab130.newTabField(this.subprocesos, this.subprocesosPendientes, this.subprocesosEnProgreso, this.subprocesosSinErrores, this.subprocesosConErrores, this.subprocesosCancelados, this.procedimientoAfterUpdate);
        this.tab110.setLocalizedLabel(ENGLISH, "general");
        this.tab110.setLocalizedLabel(SPANISH, "general");
        this.tab120.setLocalizedLabel(ENGLISH, "process");
        this.tab120.setLocalizedLabel(SPANISH, "proceso");
        this.tab130.setLocalizedLabel(ENGLISH, "subprocesses");
        this.tab130.setLocalizedLabel(SPANISH, "subprocesos");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.finalizado = this.condicionEjeFun.isIn(this.condicionEjeFun.EJECUTADO_SIN_ERRORES, this.condicionEjeFun.EJECUTADO_CON_ERRORES, this.condicionEjeFun.EJECUCION_CANCELADA);
        this.pendiente = RastroProceso.and(this.procesoAsincrono, this.superior.isNull(), this.finalizado, RastroProceso.not(this.leido), RastroProceso.not(this.descargado));
        this.pendienteActual = this.pendiente.and(this.codigoUsuario.isEqualTo(CURRENT_USER_CODE));
        this.sinSuperior = this.superior.isNull();
        this.conSuperior = this.superior.isNotNull();
        this.sinSubprocesos = this.subprocesos.isEqualTo(0);
        this.conSubprocesos = this.subprocesos.isGreaterThan(0);
        this.pendiente.setLocalizedCollectionLabel(ENGLISH, "all processes not read or downloaded by their owner user");
        this.pendiente.setLocalizedCollectionLabel(SPANISH, "todos los procesos no le\u00eddos ni descargados por su usuario propietario");
        this.pendiente.setLocalizedCollectionShortLabel(ENGLISH, "Processes not read nor downloaded");
        this.pendiente.setLocalizedCollectionShortLabel(SPANISH, "Procesos no le\u00eddos ni descargados");
        this.pendiente.setLocalizedDescription(ENGLISH, "the process has not been read or downloaded by its owner user");
        this.pendiente.setLocalizedDescription(SPANISH, "el proceso no ha sido le\u00eddo ni descargado por su usuario propietario");
        this.pendiente.setLocalizedErrorMessage(ENGLISH, "the process has already been read or downloaded by its owner user");
        this.pendiente.setLocalizedErrorMessage(SPANISH, "el proceso ya fue le\u00eddo o descargado por su usuario propietario");
        this.pendienteActual.setLocalizedCollectionLabel(ENGLISH, "all your processes not read nor downloaded by you");
        this.pendienteActual.setLocalizedCollectionLabel(SPANISH, "todos sus procesos no le\u00eddos ni descargados por usted");
        this.pendienteActual.setLocalizedCollectionShortLabel(ENGLISH, "My unread and undownloaded processes");
        this.pendienteActual.setLocalizedCollectionShortLabel(SPANISH, "Mis procesos no le\u00eddos ni descargados");
        this.pendienteActual.setLocalizedDescription(ENGLISH, "the process has not been read or downloaded by the current user");
        this.pendienteActual.setLocalizedDescription(SPANISH, "el proceso no ha sido le\u00eddo ni descargado por el usuario actual");
        this.pendienteActual.setLocalizedErrorMessage(ENGLISH, "the process has already been read or downloaded by you");
        this.pendienteActual.setLocalizedErrorMessage(SPANISH, "el proceso ya fue le\u00eddo o descargado por usted");
        this.sinSuperior.setLocalizedCollectionLabel(ENGLISH, "audit trails of main processes (processes without parent process)");
        this.sinSuperior.setLocalizedCollectionLabel(SPANISH, "rastros de auditor\u00eda de procesos principales (procesos sin proceso superior)");
        this.sinSuperior.setLocalizedCollectionShortLabel(ENGLISH, "trails of main processes");
        this.sinSuperior.setLocalizedCollectionShortLabel(SPANISH, "rastros de procesos principales");
        this.sinSuperior.setLocalizedDescription(ENGLISH, "the process has no parent process");
        this.sinSuperior.setLocalizedDescription(SPANISH, "el proceso no tiene proceso superior");
        this.sinSuperior.setLocalizedErrorMessage(ENGLISH, "the process has parent process");
        this.sinSuperior.setLocalizedErrorMessage(SPANISH, "el proceso tiene proceso superior");
        this.conSuperior.setLocalizedCollectionLabel(ENGLISH, "audit trails of subprocesses (processes with parent process)");
        this.conSuperior.setLocalizedCollectionLabel(SPANISH, "rastros de auditor\u00eda de subprocesos (procesos con proceso superior)");
        this.conSuperior.setLocalizedCollectionShortLabel(ENGLISH, "trails of subprocesses");
        this.conSuperior.setLocalizedCollectionShortLabel(SPANISH, "rastros de subprocesos");
        this.conSuperior.setLocalizedDescription(ENGLISH, "the process has parent process");
        this.conSuperior.setLocalizedDescription(SPANISH, "el proceso tiene proceso superior");
        this.conSuperior.setLocalizedErrorMessage(ENGLISH, "the process has no parent process");
        this.conSuperior.setLocalizedErrorMessage(SPANISH, "el proceso no tiene proceso superior");
        this.sinSubprocesos.setLocalizedCollectionLabel(ENGLISH, "audit trails of processes without subprocesses");
        this.sinSubprocesos.setLocalizedCollectionLabel(SPANISH, "rastros de auditor\u00eda de procesos sin subprocesos");
        this.sinSubprocesos.setLocalizedCollectionShortLabel(ENGLISH, "trails of processes without subprocesses");
        this.sinSubprocesos.setLocalizedCollectionShortLabel(SPANISH, "rastros de procesos sin subprocesos");
        this.sinSubprocesos.setLocalizedDescription(ENGLISH, "the process has no subprocesses");
        this.sinSubprocesos.setLocalizedDescription(SPANISH, "el proceso no tiene subprocesos");
        this.sinSubprocesos.setLocalizedErrorMessage(ENGLISH, "the process has subprocesses");
        this.sinSubprocesos.setLocalizedErrorMessage(SPANISH, "el proceso tiene subprocesos");
        this.conSubprocesos.setLocalizedCollectionLabel(ENGLISH, "audit trails of processes with one or more subprocesses");
        this.conSubprocesos.setLocalizedCollectionLabel(SPANISH, "rastros de auditor\u00eda de procesos con uno o m\u00e1s subprocesos");
        this.conSubprocesos.setLocalizedCollectionShortLabel(ENGLISH, "trails of processes with subprocesses");
        this.conSubprocesos.setLocalizedCollectionShortLabel(SPANISH, "rastros de procesos con subprocesos");
        this.conSubprocesos.setLocalizedDescription(ENGLISH, "the process has subprocesses");
        this.conSubprocesos.setLocalizedDescription(SPANISH, "el proceso tiene subprocesos");
        this.conSubprocesos.setLocalizedErrorMessage(ENGLISH, "the process has no subprocesses");
        this.conSubprocesos.setLocalizedErrorMessage(SPANISH, "el proceso no tiene subprocesos");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setMasterDetailFilter(this.superior.conSubprocesos);
        this.addSelectSegment(this.pendienteActual, false);
        this.addSelectSegment(this.pendiente, false);
        this.addSelectSegment(this.sinSuperior, this.conSuperior, this.sinSubprocesos, this.conSubprocesos);
        this.tab130.setRenderingFilter(this.conSubprocesos);
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    public class MarcarComoNoLeido
    extends ProcessOperation {
        @InstanceReference
        protected RastroProceso proceso;
        protected Check check101;
        protected Check check102;
        protected Check check103;
        protected Check check104;
        protected Check check105;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "mark as unread and undownloaded");
            this.setLocalizedLabel(SPANISH, "marcar como no le\u00eddo");
            this.setLocalizedDescription(ENGLISH, "mark process as unread and undownloaded");
            this.setLocalizedDescription(SPANISH, "marcar proceso como no le\u00eddo");
            this.setLocalizedSuccessMessage(ENGLISH, "the process was marked as unread and undownloaded");
            this.setLocalizedSuccessMessage(SPANISH, "el proceso fue marcado como no le\u00eddo");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.proceso.leido.setCurrentValue(false);
            this.proceso.descargado.setCurrentValue(false);
            this.proceso.setLocalizedLabel(ENGLISH, "process");
            this.proceso.setLocalizedLabel(SPANISH, "proceso");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.proceso.condicionEjeFun.isIn(this.proceso.condicionEjeFun.EJECUTADO_SIN_ERRORES, this.proceso.condicionEjeFun.EJECUTADO_CON_ERRORES, this.proceso.condicionEjeFun.EJECUCION_CANCELADA);
            this.check102 = this.proceso.codigoUsuario.isEqualTo(CURRENT_USER_CODE);
            this.check103 = this.proceso.leido.or(this.proceso.descargado);
            this.check104 = this.proceso.procesoAsincrono.isTrue();
            this.check105 = this.proceso.superior.isNull();
            this.check101.setLocalizedDescription(ENGLISH, "the process has finished");
            this.check101.setLocalizedDescription(SPANISH, "el proceso ha terminado");
            this.check101.setLocalizedErrorMessage(ENGLISH, "it is not allowed to mark as unread those processes that have not finished");
            this.check101.setLocalizedErrorMessage(SPANISH, "no se permite marcar como no le\u00eddos aquellos procesos que no hayan finalizado");
            this.check102.setLocalizedDescription(ENGLISH, "the process belongs to the current user");
            this.check102.setLocalizedDescription(SPANISH, "el proceso le pertenece al usuario actual");
            this.check102.setLocalizedErrorMessage(ENGLISH, "the process does not belong to your user");
            this.check102.setLocalizedErrorMessage(SPANISH, "el proceso no le pertenece a su usuario");
            this.check103.setLocalizedDescription(ENGLISH, "the process has been read or downloaded");
            this.check103.setLocalizedDescription(SPANISH, "el proceso ya fue le\u00eddo o descargado");
            this.check103.setLocalizedErrorMessage(ENGLISH, "the process has not been read nor downloaded");
            this.check103.setLocalizedErrorMessage(SPANISH, "el proceso no ha sido le\u00eddo ni descargado");
            this.check104.setLocalizedDescription(ENGLISH, "the process is asynchronous");
            this.check104.setLocalizedDescription(SPANISH, "el proceso es as\u00edncrono");
            this.check104.setLocalizedErrorMessage(ENGLISH, "the process is synchronous");
            this.check104.setLocalizedErrorMessage(SPANISH, "el proceso es sincronizado");
            this.check105.setLocalizedDescription(ENGLISH, "the process is not a subprocess");
            this.check105.setLocalizedDescription(SPANISH, "el proceso no es un subproceso");
            this.check105.setLocalizedErrorMessage(ENGLISH, "the process is a subprocess");
            this.check105.setLocalizedErrorMessage(SPANISH, "el proceso es un subproceso");
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    public class MarcarComoLeido
    extends ProcessOperation {
        @InstanceReference
        protected RastroProceso proceso;
        protected Check check101;
        protected Check check102;
        protected Check check103;
        protected Check check104;
        protected Check check105;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "mark as read");
            this.setLocalizedLabel(SPANISH, "marcar como le\u00eddo");
            this.setLocalizedDescription(ENGLISH, "mark process as read");
            this.setLocalizedDescription(SPANISH, "marcar proceso como le\u00eddo");
            this.setLocalizedSuccessMessage(ENGLISH, "the process was marked as read");
            this.setLocalizedSuccessMessage(SPANISH, "el proceso fue marcado como le\u00eddo");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.proceso.leido.setCurrentValue(true);
            this.proceso.setLocalizedLabel(ENGLISH, "process");
            this.proceso.setLocalizedLabel(SPANISH, "proceso");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.proceso.condicionEjeFun.isIn(this.proceso.condicionEjeFun.EJECUTADO_SIN_ERRORES, this.proceso.condicionEjeFun.EJECUTADO_CON_ERRORES, this.proceso.condicionEjeFun.EJECUCION_CANCELADA);
            this.check102 = this.proceso.codigoUsuario.isEqualTo(CURRENT_USER_CODE);
            this.check103 = MarcarComoLeido.not(this.proceso.leido.or(this.proceso.descargado));
            this.check104 = this.proceso.procesoAsincrono.isTrue();
            this.check105 = this.proceso.superior.isNull();
            this.check101.setLocalizedDescription(ENGLISH, "the process has finished");
            this.check101.setLocalizedDescription(SPANISH, "el proceso ha terminado");
            this.check101.setLocalizedErrorMessage(ENGLISH, "it is not allowed to mark as read those processes that have not finished");
            this.check101.setLocalizedErrorMessage(SPANISH, "no se permite marcar como le\u00eddos aquellos procesos que no hayan finalizado");
            this.check102.setLocalizedDescription(ENGLISH, "the process belongs to the current user");
            this.check102.setLocalizedDescription(SPANISH, "el proceso le pertenece al usuario actual");
            this.check102.setLocalizedErrorMessage(ENGLISH, "the process does not belong to your user");
            this.check102.setLocalizedErrorMessage(SPANISH, "el proceso no le pertenece a su usuario");
            this.check103.setLocalizedDescription(ENGLISH, "the process has not been read nor downloaded");
            this.check103.setLocalizedDescription(SPANISH, "el proceso no ha sido le\u00eddo ni descargado");
            this.check103.setLocalizedErrorMessage(ENGLISH, "the process has been read or downloaded");
            this.check103.setLocalizedErrorMessage(SPANISH, "el proceso ya fue le\u00eddo o descargado");
            this.check104.setLocalizedDescription(ENGLISH, "the process is asynchronous");
            this.check104.setLocalizedDescription(SPANISH, "el proceso es as\u00edncrono");
            this.check104.setLocalizedErrorMessage(ENGLISH, "the process is synchronous");
            this.check104.setLocalizedErrorMessage(SPANISH, "el proceso es sincronizado");
            this.check105.setLocalizedDescription(ENGLISH, "the process is not a subprocess");
            this.check105.setLocalizedDescription(SPANISH, "el proceso no es un subproceso");
            this.check105.setLocalizedErrorMessage(ENGLISH, "the process is a subprocess");
            this.check105.setLocalizedErrorMessage(SPANISH, "el proceso es un subproceso");
        }
    }
}

