/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.configuracion.basica;

import adalid.commons.util.StrUtils;
import adalid.core.AbstractPersistentEntity;
import adalid.core.Instance;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Property;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.SeveridadMensaje;
import org.apache.commons.lang.StringUtils;

@EntityClass(catalog=Kleenean.TRUE, independent=Kleenean.TRUE, resourceType=ResourceType.CONFIGURATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bpl=Kleenean.FALSE, bws=Kleenean.FALSE, fws=Kleenean.FALSE, gui=Kleenean.FALSE, sql=Kleenean.TRUE)
@EntitySelectOperation(enabled=Kleenean.TRUE, access=OperationAccess.PUBLIC, rowsLimit=0)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.FALSE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.TRUE)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class MensajeAplicacion
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @BusinessKey
    @PropertyField(table=Kleenean.FALSE)
    @StringField(maxLength=200)
    public StringProperty codigo;
    @NameProperty
    @StringField(maxLength=180)
    public StringProperty codigoMensaje;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE)
    @StringField(maxLength=20)
    public StringProperty codigoLenguaje;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty genero;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE, report=Kleenean.FALSE)
    public SeveridadMensaje severidad;
    @ColumnField(nullable=Kleenean.FALSE)
    public StringProperty patron;

    public MensajeAplicacion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    public String getBusinessKeyValueOf(Instance instance) {
        return instance == null ? null : this.codigoMensaje(instance) + "~" + this.codigoLenguaje(instance);
    }

    @Override
    public Object getDefaultPropertyValueOf(Instance instance, Property property) {
        return instance == null || property == null ? null : (property == this.codigoMensaje ? this.codigoMensaje(instance) : (property == this.codigoLenguaje ? this.codigoLenguaje(instance) : (property == this.patron ? this.patron(instance) : null)));
    }

    private String codigoMensaje(Instance instance) {
        return StringUtils.substringAfter((String)instance.getName(), (String)"_");
    }

    private String codigoLenguaje(Instance instance) {
        return StringUtils.substringBefore((String)instance.getName(), (String)"_");
    }

    private String patron(Instance instance) {
        return StringUtils.capitalize((String)StrUtils.getWordyString(this.codigoMensaje(instance)));
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "application message");
        this.setLocalizedLabel(SPANISH, "mensaje de la aplicaci\u00f3n");
        this.setLocalizedShortLabel(ENGLISH, "message");
        this.setLocalizedShortLabel(SPANISH, "mensaje");
        this.setLocalizedCollectionLabel(ENGLISH, "Application Messages");
        this.setLocalizedCollectionLabel(SPANISH, "Mensajes de la Aplicaci\u00f3n");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Messages");
        this.setLocalizedCollectionShortLabel(SPANISH, "Mensajes");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Application Messages") + " represents an application message.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Mensajes de la Aplicaci\u00f3n") + " representa un mensaje de la aplicaci\u00f3n.");
        this.setLocalizedShortDescription(ENGLISH, "application message");
        this.setLocalizedShortDescription(SPANISH, "mensaje de la aplicaci\u00f3n");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.setOrderBy((Property)this.codigo);
        this.codigo.setLocalizedLabel(ENGLISH, "application message code");
        this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo del mensaje");
        this.codigo.setLocalizedShortLabel(ENGLISH, "code");
        this.codigo.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.codigoMensaje.setLocalizedLabel(ENGLISH, "message");
        this.codigoMensaje.setLocalizedLabel(SPANISH, "mensaje");
        this.codigoLenguaje.setLocalizedLabel(ENGLISH, "language");
        this.codigoLenguaje.setLocalizedLabel(SPANISH, "lenguaje");
        this.genero.setLocalizedLabel(ENGLISH, "gender");
        this.genero.setLocalizedLabel(SPANISH, "g\u00e9nero");
        this.severidad.setLocalizedLabel(ENGLISH, "severity");
        this.severidad.setLocalizedLabel(SPANISH, "severidad");
        this.patron.setLocalizedLabel(ENGLISH, "pattern");
        this.patron.setLocalizedLabel(SPANISH, "patr\u00f3n");
    }
}

