/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ProcessOperation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.ConstructionOperationClass;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceDisplay;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.EntityReferenceStyle;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnConstructionOperationSuccess;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.parameters.StringParameter;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ClaseRecurso;
import meta.entidad.comun.control.acceso.ClaseFabricador;
import meta.entidad.comun.control.acceso.GrupoUsuario;
import meta.entidad.comun.control.acceso.Usuario;

@EntityClass(independent=Kleenean.TRUE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE, inserts=Kleenean.TRUE, updates=Kleenean.TRUE, quickFilter=Kleenean.TRUE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE)
@EntityReferenceDisplay(style=EntityReferenceStyle.NAME_AND_CHARACTER_KEY)
public class ConjuntoSegmento
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @BusinessKey
    @StringField(maxLength=200)
    public StringProperty codigoConjuntoSegmento;
    @NameProperty
    @StringField(maxLength=200)
    public StringProperty nombreConjuntoSegmento;
    @DescriptionProperty
    @StringField(maxLength=0)
    public StringProperty descripcionConjuntoSegmento;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(heading=Kleenean.TRUE, overlay=Kleenean.TRUE, update=Kleenean.FALSE)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.CHARACTER_KEY)
    public ClaseRecurso claseRecurso;
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public Usuario usuarioSupervisor;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.CHARACTER_KEY)
    public ClaseFabricador claseFabricador;
    @PropertyField(hidden=Kleenean.TRUE, defaultCondition=DefaultCondition.UNCONDITIONALLY, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    @StringField(maxLength=200, regex="([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*", validator="fcssValidator")
    public StringProperty nombreClaseFabricador;
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE)
    public BooleanProperty esConjuntoEspecial;
    @SegmentProperty
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.CHARACTER_KEY_AND_NAME, displayMode=DisplayMode.WRITING)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(view=MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.TRUE, required=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public GrupoUsuario grupo;
    protected Segment modificables;
    protected Segment ordinarios;
    protected Check check101;
    protected Check check201;
    protected BooleanExpression claim201;
    protected Copiar copiar;

    public ConjuntoSegmento(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "segment set");
        this.setLocalizedLabel(SPANISH, "conjunto de segmentos");
        this.setLocalizedShortLabel(ENGLISH, "segment set");
        this.setLocalizedShortLabel(SPANISH, "conjunto");
        this.setLocalizedCollectionLabel(ENGLISH, "Segment Sets");
        this.setLocalizedCollectionLabel(SPANISH, "Conjuntos de Segmentos");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Segment Sets");
        this.setLocalizedCollectionShortLabel(SPANISH, "Conjuntos");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Segment Sets") + " represents a set of instances of a resource class, which typically corresponds to a set of rows of a table in the database.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Conjuntos de Segmentos") + " representa un conjunto de instancias de una clase de recursos, lo cual normalmente corresponde a un conjunto de filas de una tabla en la base de datos.");
        this.setLocalizedShortDescription(ENGLISH, "set of instances of a resource class, which typically corresponds to a set of rows of a table in the database");
        this.setLocalizedShortDescription(SPANISH, "conjunto de instancias de una clase de recursos, lo cual normalmente corresponde a un conjunto de filas de una tabla en la base de datos");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.setOrderBy((Property)this.codigoConjuntoSegmento);
        this.nombreClaseFabricador.setInitialValue(this.claseFabricador.nombreClaseFabricador);
        this.nombreClaseFabricador.setDefaultValue(this.claseFabricador.nombreClaseFabricador);
        this.esConjuntoEspecial.setInitialValue(false);
        this.esConjuntoEspecial.setDefaultValue(false);
        this.codigoConjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set code");
        this.codigoConjuntoSegmento.setLocalizedLabel(SPANISH, "c\u00f3digo del conjunto de segmentos");
        this.codigoConjuntoSegmento.setLocalizedShortLabel(ENGLISH, "code");
        this.codigoConjuntoSegmento.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.nombreConjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set name");
        this.nombreConjuntoSegmento.setLocalizedLabel(SPANISH, "nombre del conjunto de segmentos");
        this.nombreConjuntoSegmento.setLocalizedShortLabel(ENGLISH, "name");
        this.nombreConjuntoSegmento.setLocalizedShortLabel(SPANISH, "nombre");
        this.descripcionConjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set description");
        this.descripcionConjuntoSegmento.setLocalizedLabel(SPANISH, "descripci\u00f3n del conjunto de segmentos");
        this.descripcionConjuntoSegmento.setLocalizedShortLabel(ENGLISH, "description");
        this.descripcionConjuntoSegmento.setLocalizedShortLabel(SPANISH, "descripci\u00f3n");
        this.claseRecurso.setLocalizedLabel(ENGLISH, "resource class");
        this.claseRecurso.setLocalizedLabel(SPANISH, "clase de recurso");
        this.claseRecurso.setLocalizedShortLabel(ENGLISH, "class");
        this.claseRecurso.setLocalizedShortLabel(SPANISH, "clase");
        this.usuarioSupervisor.setLocalizedLabel(ENGLISH, "supervisor");
        this.usuarioSupervisor.setLocalizedLabel(SPANISH, "usuario supervisor");
        this.claseFabricador.setLocalizedDescription(ENGLISH, "Java class used to determine the authorized segments; the class must implement interface FabricadorConjuntoSegmentos");
        this.claseFabricador.setLocalizedDescription(SPANISH, "clase Java utilizada para determinar los segmentos autorizados; la clase debe implementar la interfaz FabricadorConjuntoSegmentos");
        this.claseFabricador.setLocalizedLabel(ENGLISH, "factory class");
        this.claseFabricador.setLocalizedLabel(SPANISH, "clase fabricador");
        this.nombreClaseFabricador.setLocalizedDescription(ENGLISH, "name of the Java class used to determine the authorized segments; the class must implement interface FabricadorConjuntoSegmentos");
        this.nombreClaseFabricador.setLocalizedDescription(SPANISH, "nombre de la clase Java utilizada para determinar los segmentos autorizados; la clase debe implementar la interfaz FabricadorConjuntoSegmentos");
        this.nombreClaseFabricador.setLocalizedLabel(ENGLISH, "factory class name");
        this.nombreClaseFabricador.setLocalizedLabel(SPANISH, "nombre clase fabricador");
        this.nombreClaseFabricador.setLocalizedRegexErrorMessage(ENGLISH, "factory class does not meet the required pattern; it must be a valid fully qualified Java class name");
        this.nombreClaseFabricador.setLocalizedRegexErrorMessage(SPANISH, "clase fabricador no cumple con el patr\u00f3n requerido; debe ser un nombre completo y v\u00e1lido de clase Java");
        this.esConjuntoEspecial.setLocalizedLabel(ENGLISH, "special set");
        this.esConjuntoEspecial.setLocalizedLabel(SPANISH, "conjunto especial");
        this.grupo.setLocalizedLabel(ENGLISH, "user group");
        this.grupo.setLocalizedLabel(SPANISH, "grupo de usuarios");
        this.grupo.setLocalizedShortLabel(ENGLISH, "group");
        this.grupo.setLocalizedShortLabel(SPANISH, "grupo");
        this.grupo.setLocalizedDescription(ENGLISH, "group to which this set belongs");
        this.grupo.setLocalizedDescription(SPANISH, "grupo al que pertenece este conjunto");
        this.grupo.setLocalizedTooltip(ENGLISH, "code of the group to which this set belongs");
        this.grupo.setLocalizedTooltip(SPANISH, "c\u00f3digo del grupo al que pertenece este conjunto");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.modificables = ConjuntoSegmento.not(this.esConjuntoEspecial);
        this.ordinarios = this.modificables.and(this.claseFabricador.isNull().or(this.claseFabricador.elemental));
        this.check101 = this.claseRecurso.esClaseRecursoSegmento.isTrue();
        this.claim201 = this.claseFabricador.codigoClaseRecurso.isEqualTo(this.claseRecurso.codigoClaseRecurso);
        this.check201 = this.claseFabricador.isNotNull().implies(this.claim201);
        this.modificables.setLocalizedDescription(ENGLISH, "the set is not a basic configuration set");
        this.modificables.setLocalizedDescription(SPANISH, "el conjunto no es un conjunto de configuraci\u00f3n b\u00e1sica del sistema");
        this.modificables.setLocalizedErrorMessage(ENGLISH, "the set is a basic configuration set; it can't be modified or deleted");
        this.modificables.setLocalizedErrorMessage(SPANISH, "el conjunto es un conjunto de configuraci\u00f3n b\u00e1sica del sistema; no se permite modificarlo ni eliminarlo");
        this.ordinarios.setLocalizedDescription(ENGLISH, "the set is not a basic configuration set and its elements are explicitly specified");
        this.ordinarios.setLocalizedDescription(SPANISH, "el conjunto no es un conjunto de configuraci\u00f3n b\u00e1sica del sistema y sus elementos son especificados expl\u00edcitamente");
        this.ordinarios.setLocalizedErrorMessage(ENGLISH, "the set is a basic configuration set or its elements are determined by a factory class that does not uses elements; it cannot be modified or deleted, and its elements cannot be explicitly specified");
        this.ordinarios.setLocalizedErrorMessage(SPANISH, "el conjunto es un conjunto de configuraci\u00f3n b\u00e1sica del sistema o sus elementos son determinados por una clase de fabricador que no usa elementos; no se permite modificarlo ni eliminarlo, y sus elementos no pueden ser especificados expl\u00edcitamente");
        this.check101.setLocalizedLabel(ENGLISH, "verify resource class");
        this.check101.setLocalizedLabel(SPANISH, "chequear clase de recurso");
        this.check101.setLocalizedDescription(ENGLISH, "the resource class must be a class used to segment");
        this.check101.setLocalizedDescription(SPANISH, "la clase de recurso debe ser una clase utilizada para segmentar");
        this.check101.setLocalizedErrorMessage(ENGLISH, "the resource class is not a class used to segment");
        this.check101.setLocalizedErrorMessage(SPANISH, "la clase de recurso no es una clase utilizada para segmentar");
        this.check201.setLocalizedLabel(ENGLISH, "verify factory class");
        this.check201.setLocalizedLabel(SPANISH, "chequear clase de fabricador");
        this.check201.setLocalizedDescription(ENGLISH, "the factory class must be a class used to segment the resource class");
        this.check201.setLocalizedDescription(SPANISH, "la clase de fabricador debe ser una clase utilizada para segmentar la clase de recurso");
        this.check201.setLocalizedErrorMessage(ENGLISH, "the factory class is not a class used to segment the resource class");
        this.check201.setLocalizedErrorMessage(SPANISH, "la clase de fabricador no es una clase utilizada para segmentar la clase de recurso");
        this.claim201.setLocalizedLabel(ENGLISH, "verify factory class");
        this.claim201.setLocalizedLabel(SPANISH, "chequear clase de fabricador");
        this.claim201.setLocalizedDescription(ENGLISH, "the factory class must be a class used to segment the resource class");
        this.claim201.setLocalizedDescription(SPANISH, "la clase de fabricador debe ser una clase utilizada para segmentar la clase de recurso");
        this.claim201.setLocalizedErrorMessage(ENGLISH, "the factory class is not a class used to segment the resource class");
        this.claim201.setLocalizedErrorMessage(SPANISH, "la clase de fabricador no es una clase utilizada para segmentar la clase de recurso");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setUpdateFilter(this.modificables);
        this.setDeleteFilter(this.modificables);
        this.claseRecurso.setSearchQueryFilter(this.check101);
        this.claseFabricador.setSearchQueryFilter(this.claim201);
    }

    @ProcessOperationClass
    @ConstructionOperationClass(type=ConjuntoSegmento.class, onsuccess=OnConstructionOperationSuccess.DISPLAY_NEW_INSTANCE)
    public class Copiar
    extends ProcessOperation {
        @InstanceReference
        protected ConjuntoSegmento conjunto;
        @ParameterField(required=Kleenean.TRUE)
        @StringField(maxLength=200)
        protected StringParameter codigo;
        @ParameterField(required=Kleenean.FALSE)
        @StringField(maxLength=200)
        protected StringParameter nombre;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "copy");
            this.setLocalizedLabel(SPANISH, "copiar");
            this.setLocalizedDescription(ENGLISH, "copy a segment set with another code and name; the copy includes the elements of the original segment set");
            this.setLocalizedDescription(SPANISH, "copiar un conjunto de segmentos con otro c\u00f3digo y nombre; la copia incluye los elementos del conjunto de segmentos original");
            this.setLocalizedSuccessMessage(ENGLISH, "the segment set was successfully copied");
            this.setLocalizedSuccessMessage(SPANISH, "el conjunto de segmentos fue copiado con \u00e9xito");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.conjunto.setLocalizedLabel(ENGLISH, "segment set");
            this.conjunto.setLocalizedLabel(SPANISH, "conjunto de segmentos");
            this.conjunto.setLocalizedDescription(ENGLISH, "Code of the segment set you want to copy; it is a required field and has no default value");
            this.conjunto.setLocalizedDescription(SPANISH, "C\u00f3digo del conjunto de segmentos que desea copiar; es un dato obligatorio y no tiene valor por omisi\u00f3n");
            this.codigo.setLocalizedLabel(ENGLISH, "code");
            this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo");
            this.codigo.setLocalizedDescription(ENGLISH, "Code of the new segment set produced when copying; it is a required field and has no default value");
            this.codigo.setLocalizedDescription(SPANISH, "C\u00f3digo del nuevo conjunto de segmentos que produce la copia; es un dato obligatorio y no tiene valor por omisi\u00f3n");
            this.nombre.setLocalizedLabel(ENGLISH, "name");
            this.nombre.setLocalizedLabel(SPANISH, "nombre");
            this.nombre.setLocalizedDescription(ENGLISH, "Name of the new segment set produced when copying; it is an optional field; by default, the name of the original segment set is used");
            this.nombre.setLocalizedDescription(SPANISH, "Nombre del nuevo conjunto de segmentos que produce la copia; es un dato opcional; por omisi\u00f3n se utiliza el nombre del conjunto de segmentos original");
        }
    }
}

