/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.operacion.compleja;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceDisplay;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.MasterSequence;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.EntityReferenceStyle;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.NextValueRule;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.expressions.BooleanOrderedPairX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.EntityReference;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ext.Funcion;
import meta.entidad.comun.operacion.compleja.RutinaUsuario;
import meta.entidad.comun.operacion.compleja.VariableRutina;

@EntityClass(base=Kleenean.TRUE, independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class PasoRutina
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(main=Kleenean.TRUE, navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable=Kleenean.FALSE)
    public RutinaUsuario rutina;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE, required=Kleenean.FALSE)
    @MasterSequence(masterField="rutina", start=10, step=10, nextValueRule=NextValueRule.CEILING)
    public IntegerProperty numero;
    @DescriptionProperty
    @PropertyField(create=Kleenean.TRUE)
    @StringField(maxLength=0)
    public StringProperty descripcion;
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE, required=Kleenean.TRUE)
    public Funcion funcion;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE)
    public RutinaUsuario subrutina;
    @PropertyField(create=Kleenean.TRUE)
    @StringField(maxLength=0)
    public StringProperty precondiciones;
    @PropertyField(create=Kleenean.TRUE)
    @StringField(maxLength=0)
    public StringProperty poscondiciones;
    @PropertyField(create=Kleenean.TRUE)
    @StringField(maxLength=0)
    public StringProperty invariantes;
    @PropertyField(create=Kleenean.TRUE)
    public StringProperty filtro;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty condicionado;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty filtrado;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE)
    public IntegerProperty hasta;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE, required=Kleenean.TRUE)
    public IntegerProperty desde;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty coleccion;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE)
    @EntityReferenceDisplay(style=EntityReferenceStyle.NAME)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
    public VariableRutina para;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE)
    @EntityReferenceDisplay(style=EntityReferenceStyle.NAME)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME, displayMode=DisplayMode.WRITING)
    public VariableRutina variable;
    Key key1;
    BooleanExpression assert0101;
    BooleanExpression assert0102;
    BooleanExpression assert0103;
    BooleanExpression assert0301;
    BooleanExpression assert0401;
    Check check0101;
    Check check0102;
    Check check0103;
    Check check0201;
    Check check0301;
    Check check0401;

    public PasoRutina(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("funcion.tipoFuncion", "funcion.rango", "para.rutina", "variable.rutina", "variable.claseRecurso");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "user routine step");
        this.setLocalizedLabel(SPANISH, "paso de rutina de usuario");
        this.setLocalizedShortLabel(ENGLISH, "routine step");
        this.setLocalizedShortLabel(SPANISH, "paso de rutina");
        this.setLocalizedCollectionLabel(ENGLISH, "User Routine Steps");
        this.setLocalizedCollectionLabel(SPANISH, "Pasos de Rutina de Usuario");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Steps");
        this.setLocalizedCollectionShortLabel(SPANISH, "Pasos");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("User Routine Steps") + " represents a user routine step that implements a specific action in the path a user follows through your website interface to complete a task.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Pasos de Rutina de Usuario") + " representa un paso de una rutina de usuario que implementa una acci\u00f3n espec\u00edfica en la ruta que sigue un usuario a trav\u00e9s de la interfaz de su sitio web para completar una tarea.");
        this.setLocalizedShortDescription(ENGLISH, "user routine step that implements a specific action in the path a user follows through your website interface to complete a task");
        this.setLocalizedShortDescription(SPANISH, "paso de una rutina de usuario que implementa una acci\u00f3n espec\u00edfica en la ruta que sigue un usuario a trav\u00e9s de la interfaz de su sitio web para completar una tarea");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.setOrderBy(this.rutina, this.numero, this.id);
        BooleanOrderedPairX iterable = this.funcion.esConstructor.or(this.funcion.tipoFuncion.isEqualTo(this.funcion.tipoFuncion.CONSULTA));
        this.numero.setMinValue(0);
        this.numero.setMaxValue(10000);
        this.condicionado.setCalculableValueExpression(this.precondiciones.isNotNull().or(this.invariantes.isNotNull()));
        this.filtrado.setCalculableValueExpression(this.filtro.isNotNull());
        this.hasta.setInitialValue(1);
        this.hasta.addInitialValueReferencedProperties(this.funcion, this.subrutina);
        this.hasta.setMinValue(1);
        this.hasta.setMaxValue(iterable.then(Integer.MAX_VALUE).otherwise(1));
        this.desde.setInitialValue(1);
        this.desde.addInitialValueReferencedProperties(this.funcion, this.subrutina);
        this.desde.setDefaultValue(1);
        this.desde.setMinValue(0);
        this.desde.setMaxValue(iterable.then(this.hasta.coalesce(Integer.MAX_VALUE)).otherwise(1));
        this.coleccion.setCalculableValueExpression(this.hasta.isNullOrGreaterThan(1));
        this.coleccion.setInitialValue(this.hasta.isNullOrGreaterThan(1));
        this.rutina.setLocalizedLabel(ENGLISH, "routine");
        this.rutina.setLocalizedLabel(SPANISH, "rutina");
        this.rutina.setLocalizedDescription(ENGLISH, "A user routine automates the path a user follows through your website interface to complete a task: make a reservation, purchase a product, subscribe to something. ");
        this.rutina.setLocalizedDescription(SPANISH, "Una rutina de usuario automatiza la ruta que sigue un usuario a trav\u00e9s de la interfaz de su sitio web para completar una tarea: hacer una reserva, comprar un producto, suscribirse a algo.");
        this.numero.setLocalizedLabel(ENGLISH, "step number");
        this.numero.setLocalizedLabel(SPANISH, "n\u00famero del paso");
        this.numero.setLocalizedShortLabel(ENGLISH, "number");
        this.numero.setLocalizedShortLabel(SPANISH, "n\u00famero");
        this.descripcion.setLocalizedLabel(ENGLISH, "routine step description");
        this.descripcion.setLocalizedLabel(SPANISH, "descripci\u00f3n del paso de rutina");
        this.descripcion.setLocalizedShortLabel(ENGLISH, "description");
        this.descripcion.setLocalizedShortLabel(SPANISH, "descripci\u00f3n");
        this.funcion.setLocalizedLabel(ENGLISH, "function");
        this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.subrutina.setLocalizedLabel(ENGLISH, "subroutine");
        this.subrutina.setLocalizedLabel(SPANISH, "subrutina");
        this.subrutina.setLocalizedDescription(ENGLISH, "A user routine automates the path a user follows through your website interface to complete a task: make a reservation, purchase a product, subscribe to something. ");
        this.subrutina.setLocalizedDescription(SPANISH, "Una rutina de usuario automatiza la ruta que sigue un usuario a trav\u00e9s de la interfaz de su sitio web para completar una tarea: hacer una reserva, comprar un producto, suscribirse a algo.");
        this.precondiciones.setLocalizedLabel(ENGLISH, "preconditions");
        this.precondiciones.setLocalizedLabel(SPANISH, "precondiciones");
        this.precondiciones.setLocalizedDescription(ENGLISH, "conditions that must be met to execute this step");
        this.precondiciones.setLocalizedDescription(SPANISH, "condiciones que se deben cumplir para ejecutar este paso");
        this.poscondiciones.setLocalizedLabel(ENGLISH, "postconditions");
        this.poscondiciones.setLocalizedLabel(SPANISH, "poscondiciones");
        this.poscondiciones.setLocalizedDescription(ENGLISH, "conditions that should be met after executing this step");
        this.poscondiciones.setLocalizedDescription(SPANISH, "condiciones que deber\u00edan cumplirse despu\u00e9s de ejecutar este paso");
        this.invariantes.setLocalizedLabel(ENGLISH, "invariants");
        this.invariantes.setLocalizedLabel(SPANISH, "invariantes");
        this.invariantes.setLocalizedDescription(ENGLISH, "conditions that should be met before and after executing this step");
        this.invariantes.setLocalizedDescription(SPANISH, "condiciones que deber\u00edan cumplirse antes y despu\u00e9s de ejecutar este paso");
        this.filtro.setLocalizedLabel(ENGLISH, "filter");
        this.filtro.setLocalizedLabel(SPANISH, "filtro");
        this.filtro.setLocalizedDescription(ENGLISH, "criteria to be met by the instance(s) added and/or selected by the function");
        this.filtro.setLocalizedDescription(SPANISH, "criterios que debe(n) cumplir la(s) instancia(s) agregada(s) y/o seleccionada(s) por la funci\u00f3n");
        this.condicionado.setLocalizedLabel(ENGLISH, "conditioned");
        this.condicionado.setLocalizedLabel(SPANISH, "condicionado");
        this.filtrado.setLocalizedLabel(ENGLISH, "filtered");
        this.filtrado.setLocalizedLabel(SPANISH, "filtrado");
        this.hasta.setLocalizedLabel(ENGLISH, "up to");
        this.hasta.setLocalizedLabel(SPANISH, "hasta");
        this.hasta.setLocalizedDescription(ENGLISH, "maximum number of times the step can be executed; if not specified, the step could be executed any number of times, starting from the specified minimum");
        this.hasta.setLocalizedDescription(SPANISH, "m\u00e1ximo n\u00famero de veces que se puede ejecutar el paso; si no se especifica, el paso podr\u00e1 ser ejecutado cualquier n\u00famero de veces, a partir del m\u00ednimo especificado");
        this.hasta.setLocalizedRangeErrorMessage(ENGLISH, "maximum number of times the step can be executed out of range {1} : {2}");
        this.hasta.setLocalizedRangeErrorMessage(SPANISH, "m\u00e1ximo n\u00famero de veces que se puede ejecutar el paso fuera del rango {1} : {2}");
        this.desde.setLocalizedLabel(ENGLISH, "from");
        this.desde.setLocalizedLabel(SPANISH, "desde");
        this.desde.setLocalizedDescription(ENGLISH, "minimum number of times the step must be executed; is a number from 0 to the value of \"up to\"; 0 means it is an optional step");
        this.desde.setLocalizedDescription(SPANISH, "m\u00ednimo n\u00famero de veces que se debe ejecutar el paso; es un n\u00famero del 0 al valor de \"hasta\"; el 0 significa que es un paso opcional");
        this.desde.setLocalizedRangeErrorMessage(ENGLISH, "minimum number of times the step must be executed out of range {1} : {2}");
        this.desde.setLocalizedRangeErrorMessage(SPANISH, "m\u00ednimo n\u00famero de veces que se debe ejecutar el paso fuera del rango {1} : {2}");
        this.coleccion.setLocalizedLabel(ENGLISH, "collection");
        this.coleccion.setLocalizedLabel(SPANISH, "colecci\u00f3n");
        this.coleccion.setLocalizedDescription(ENGLISH, "indicator that shows whether or not the variable is a collection of instances of the specified class");
        this.coleccion.setLocalizedDescription(SPANISH, "indicador que muestra si la variable es, o no, una colecci\u00f3n de instancias de la clase especificada");
        this.para.setLocalizedLabel(ENGLISH, "for");
        this.para.setLocalizedLabel(SPANISH, "para");
        this.para.setLocalizedDescription(ENGLISH, "variable that stores the instance(s) for which the step should be executed");
        this.para.setLocalizedDescription(SPANISH, "variable que almacena la(s) instancia(s) para la(s) que se debe ejecutar el paso");
        this.variable.setLocalizedLabel(ENGLISH, "variable");
        this.variable.setLocalizedLabel(SPANISH, "variable");
        this.variable.setLocalizedDescription(ENGLISH, "variable where the result of the step execution is stored");
        this.variable.setLocalizedDescription(SPANISH, "variable donde se almacena el resultado de la ejecuci\u00f3n del paso");
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.key1.setUnique(false);
        this.key1.newKeyField(this.rutina, this.numero);
    }

    @Override
    protected void settleTabs() {
        super.settleTabs();
    }

    @Override
    protected void settleViews() {
        super.settleViews();
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.assert0101 = this.funcion.esConstructor.or(this.funcion.tipoFuncion.isEqualTo(this.funcion.tipoFuncion.CONSULTA));
        this.assert0102 = PasoRutina.not(this.funcion.esProgramatica).and(this.funcion.tipoFuncion.isNotEqualTo(this.funcion.tipoFuncion.ELIMINACION));
        this.assert0103 = this.subrutina.isNotEqualTo(this.rutina);
        this.assert0301 = this.para.rutina.isEqualTo(this.rutina).and(this.para.coleccion.isFalse().or(this.hasta.isEqualTo(1)));
        this.assert0401 = this.variable.rutina.isEqualTo(this.rutina).and(this.variable.claseRecurso.isEqualTo(this.funcion.rango)).and(this.variable.coleccion.xnor(this.hasta.isNullOrGreaterThan(1)));
        this.check0101 = this.funcion.isNull().xor(this.subrutina.isNull());
        this.check0102 = this.funcion.isNull().or(this.assert0102);
        this.check0103 = this.subrutina.isNull().or(this.assert0103);
        this.check0201 = this.hasta.isNull().or(this.desde.isLessOrEqualTo(this.hasta));
        this.check0301 = this.para.isNull().or(this.assert0301);
        this.check0401 = this.variable.isNull().or(this.assert0401);
        this.check0101.setLocalizedDescription(ENGLISH, "function and subroutine are mutually exclusive");
        this.check0101.setLocalizedDescription(SPANISH, "funci\u00f3n y subrutina son mutuamente excluyentes");
        this.check0101.setLocalizedErrorMessage(ENGLISH, "function and subroutine are mutually exclusive");
        this.check0101.setLocalizedErrorMessage(SPANISH, "funci\u00f3n y subrutina son mutuamente excluyentes");
        this.check0102.setLocalizedDescription(ENGLISH, "function cannot be a delete function");
        this.check0102.setLocalizedDescription(SPANISH, "funci\u00f3n no puede ser una funci\u00f3n de eliminaci\u00f3n");
        this.check0102.setLocalizedErrorMessage(ENGLISH, "function is a delete function");
        this.check0102.setLocalizedErrorMessage(SPANISH, "funci\u00f3n es una funci\u00f3n de eliminaci\u00f3n");
        this.check0103.setLocalizedDescription(ENGLISH, "routine and subroutine must be different and subroutine must not execute routine");
        this.check0103.setLocalizedDescription(SPANISH, "rutina y subrutina deben ser diferentes y subrutina no debe ejecutar rutina");
        this.check0103.setLocalizedErrorMessage(ENGLISH, "routine and subroutine are the same or subroutine executes routine");
        this.check0103.setLocalizedErrorMessage(SPANISH, "rutina y subrutina son iguales o subrutina ejecuta rutina");
        this.check0201.setLocalizedDescription(ENGLISH, "\"from\" must be less than or equal to \"up to\"");
        this.check0201.setLocalizedDescription(SPANISH, "\"desde\" debe ser menor o igual que \"hasta\"");
        this.check0201.setLocalizedErrorMessage(ENGLISH, "\"from\" is greater than \"up to\"");
        this.check0201.setLocalizedErrorMessage(SPANISH, "\"desde\" es mayor que \"hasta\"");
        this.check0301.setLocalizedDescription(ENGLISH, "\"for\" must be a variable set by a previous step in the same routine and it cannot be a collection if the step can be executed more than once");
        this.check0301.setLocalizedDescription(SPANISH, "\"para\" debe ser una variable establecida por un paso anterior de la misma rutina y no puede ser una colecci\u00f3n si el paso se puede ejecutar mas de una vez");
        this.check0301.setLocalizedErrorMessage(ENGLISH, "\"for\" is not a variable set by a previous step in the same routine or it is a collection and the step can be executed more than once");
        this.check0301.setLocalizedErrorMessage(SPANISH, "\"para\" no es una variable establecida por un paso anterior de la misma rutinao es una colecci\u00f3n y el paso se puede ejecutar mas de una vez");
        this.check0401.setLocalizedDescription(ENGLISH, "\"variable\" must be a variable of the same class and cardinality of the function and step");
        this.check0401.setLocalizedDescription(SPANISH, "\"variable\" debe ser una variable de la misma clase y cardinalidad de la funci\u00f3n y el paso");
        this.check0401.setLocalizedErrorMessage(ENGLISH, "\"variable\" is not a variable of the same class and cardinality of the function and step");
        this.check0401.setLocalizedErrorMessage(SPANISH, "\"variable\" no es una variable de la misma clase y cardinalidad de la funci\u00f3n y el paso");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.filtro.setRenderingFilter(this.assert0101, true);
        this.filtro.setModifyingFilter(this.assert0101);
        this.filtro.setNullifyingFilter(PasoRutina.not(this.assert0101));
        this.hasta.setModifyingFilter(this.assert0101);
        this.variable.setRenderingFilter(this.assert0101, true);
        this.variable.setRequiringFilter(this.assert0101);
        this.variable.setModifyingFilter(this.assert0101);
        this.variable.setNullifyingFilter(PasoRutina.not(this.assert0101));
        this.funcion.setSearchQueryFilter(this.assert0102);
        this.subrutina.setSearchQueryFilter(this.assert0103);
        this.para.setSearchQueryFilter(this.assert0301);
        this.variable.setSearchQueryFilter(this.assert0401);
        this.variable.addSearchValueFilterProperty((EntityReference)this.variable.rutina, this.rutina);
        this.variable.addSearchValueFilterProperty((EntityReference)this.variable.claseRecurso, this.funcion.rango);
        this.variable.addSearchValueFilterProperty(this.variable.coleccion, this.coleccion);
    }

    @Override
    protected void settleOperations() {
        super.settleOperations();
    }
}

