/*
 * Copyright 2017 Jorge Campins y David Uzcategui
 *
 * Este archivo forma parte de Adalid.
 *
 * Adalid es software libre; usted puede redistribuirlo y/o modificarlo bajo los terminos de la
 * licencia "GNU General Public License" publicada por la Fundacion "Free Software Foundation".
 * Adalid se distribuye con la esperanza de que pueda ser util, pero SIN NINGUNA GARANTIA; sin
 * siquiera las garantias implicitas de COMERCIALIZACION e IDONEIDAD PARA UN PROPOSITO PARTICULAR.
 *
 * Para mas detalles vea la licencia "GNU General Public License" en http://www.gnu.org/licenses
 */
package adalid.core.constants;

import adalid.core.TrustedSites;

/**
 * @author Jorge Campins
 */
public class GoogleMapsConstants {

    public static final String EMBED_MAPS = TrustedSites.EMBED_MAPS;

    public static final String GOOGLE_MAPS = TrustedSites.GOOGLE_MAPS;

    public static final String GOOGLE_MAPS_LINK = TrustedSites.GOOGLE_MAPS_LINK;

    public static final String GOOGLE_MAPS_EMBED_CONVERTER = "convertidorGoogleMapsEmbed";

    public static final String GOOGLE_MAPS_EMBED_ENGLISH_SHORT_DESCRIPTION = ""
        + "Map provided by Google. "
        + "";

    public static final String GOOGLE_MAPS_EMBED_SPANISH_SHORT_DESCRIPTION = ""
        + "Mapa provisto por Google. "
        + "";

    public static final String GOOGLE_MAPS_EMBED_ENGLISH_TOOLTIP = ""
        + "To insert a map, write the name of the place, its address or geographic coordinates. "
        + "You can also click the Search button of this field to open Google Maps and search for the place. "
        + "If the place is marked on the map, click on its name or its mark to open the side panel with its information. "
        + "If the address is in that panel, click the \"Copy address\" icon and return to this page to paste it. "
        + "If the place is not marked, or if the address is not in the panel, right-click the point on the map where the place is located; "
        + "in the context menu click on the coordinates to copy them to the clipboard and return to this page to paste them. "
        + "Alternatively, on the map you want to insert, click the menu in the upper left corner; "
        + "select the option \"Share or embed map\" and then click \"Embed a map\"; "
        + "finally click \"COPY HTML\" to copy the code and return to this page to paste it. "
        + "";

    public static final String GOOGLE_MAPS_EMBED_SPANISH_TOOLTIP = ""
        + "Para insertar un mapa, escriba el nombre del lugar, su dirección o coordenadas geográficas. "
        + "También puede hacer clic en el botón Buscar de este campo para abrir Google Maps y buscar el lugar. "
        + "Si el lugar está señalado en el mapa, haga clic en su nombre o su señal para abrir el panel lateral con su información. "
        + "Si en ese panel está la dirección; haga clic en el icono \"Copiar la dirección\" y regrese a esta página para pegarla. "
        + "Si el lugar no está señalado, o si la dirección no está en el panel, haga clic con el botón derecho en el punto del mapa donde se encuentra el lugar; "
        + "en el menú de contexto haga clic en las coordenadas para copiarlas al portapapeles y regrese a esta página para pegarlas. "
        + "Alternativamente, en el mapa que desea insertar, haga clic en el menú que está en la esquina superior izquierda; "
        + "seleccione la opción \"Compartir o insertar el mapa\" y luego haga clic en \"Insertar un mapa\"; "
        + "finalmente haga clic en \"COPIAR HTML\" para copiar el código y regrese a esta página para pegarlo. "
        + "";

    public static final String GOOGLE_MAPS_EMBED_ENGLISH_DESCRIPTION = ""
        + "Map provided by Google. "
        + "To insert a map, write the name of the place, its address or its geographical coordinates. "
        + "You can also search for the place on Google Maps and then paste its address or coordinates into this field. "
        + "To open Google Maps, click the Search button of this field. "
        + "In Google Maps, find the place whose map you want to insert. "
        + "If the place is marked on the map, click on its name or its mark to open the side panel with the place information. "
        + "In that panel you will usually find the address; click the \"Copy address\" icon and return to this page to paste it. "
        + "If the place is not marked, or if the address is not in the panel, right-click the point on the map where the place is located; "
        + "in the context menu click on the coordinates to copy them to the clipboard and return to this page to paste them. "
        + "Alternatively, on the map you want to insert, click the menu in the upper left corner; "
        + "select the option \"Share or embed map\" and then click \"Embed a map\"; "
        + "finally click \"COPY HTML\" to copy the code and return to this page to paste it. "
        + "";

    public static final String GOOGLE_MAPS_EMBED_SPANISH_DESCRIPTION = ""
        + "Mapa provisto por Google. "
        + "Para insertar un mapa, escriba el nombre del lugar, su dirección o sus coordenadas geográficas. "
        + "También puede buscar el lugar en Google Maps y luego pegar su dirección o sus coordenadas en este campo. "
        + "Para abrir Google Maps, haga clic en el botón Buscar de este campo. "
        + "En Google Maps, busque el lugar cuyo mapa desea insertar. "
        + "Si el lugar está señalado en el mapa, haga clic en su nombre o su señal para abrir el panel lateral con la información del lugar. "
        + "En ese panel generalmente se encuentra la dirección; haga clic en el icono \"Copiar la dirección\" y regrese a esta página para pegarla. "
        + "Si el lugar no está señalado, o si la dirección no está en el panel, haga clic con el botón derecho en el punto del mapa donde se encuentra el lugar; "
        + "en el menú de contexto haga clic en las coordenadas para copiarlas al portapapeles y regrese a esta página para pegarlas. "
        + "Alternativamente, en el mapa que desea insertar, haga clic en el menú que está en la esquina superior izquierda; "
        + "seleccione la opción \"Compartir o insertar el mapa\" y luego haga clic en \"Insertar un mapa\"; "
        + "finalmente haga clic en \"COPIAR HTML\" para copiar el código y regrese a esta página para pegarlo. "
        + "";

}
