/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons;

import adalid.commons.interfaces.Programmer;
import adalid.commons.interfaces.Wrappable;
import adalid.commons.interfaces.Wrapper;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class TLB {
    private static final ThreadLocal<Map<String, Programmer>> _programmers = new ThreadLocal();
    private static final ThreadLocal<Map<String, Class<? extends Wrapper>>> _wrapperClasses = new ThreadLocal();

    static void init() {
        TLB.setProgrammers(new LinkedHashMap<String, Programmer>());
        TLB.setWrapperClasses(new LinkedHashMap<String, Class<? extends Wrapper>>());
    }

    public static Map<String, Programmer> getProgrammers() {
        return _programmers.get();
    }

    public static void setProgrammers(Map<String, Programmer> programmers) {
        if (programmers == null) {
            TLB.removeProgrammers();
        } else {
            _programmers.set(programmers);
        }
    }

    private static void removeProgrammers() {
        _programmers.remove();
    }

    public static void clearProgrammers() {
        TLB.getProgrammers().clear();
    }

    public static Map<String, Programmer> getProgrammersClone() {
        return new LinkedHashMap<String, Programmer>(TLB.getProgrammers());
    }

    public static Programmer getProgrammer(Class<? extends Programmer> clazz) {
        if (clazz == null) {
            return null;
        }
        Object[] keys = TLB.getProgrammers().keySet().toArray();
        Arrays.sort(keys);
        for (Object key : keys) {
            Programmer programmer = TLB.getProgrammers().get(key.toString());
            if (!clazz.isAssignableFrom(programmer.getClass())) continue;
            return programmer;
        }
        return null;
    }

    public static Programmer getProgrammer(String key) {
        return key == null ? null : TLB.getProgrammers().get(key);
    }

    public static void setProgrammer(String key, Programmer programmer) {
        if (key != null) {
            if (programmer == null) {
                TLB.removeProgrammer(key);
            } else {
                TLB.getProgrammers().put(key, programmer);
            }
        }
    }

    static void removeProgrammer(String key) {
        if (key != null) {
            TLB.getProgrammers().remove(key);
        }
    }

    public static Map<String, Class<? extends Wrapper>> getWrapperClasses() {
        return _wrapperClasses.get();
    }

    public static void setWrapperClasses(Map<String, Class<? extends Wrapper>> wrappers) {
        if (wrappers == null) {
            TLB.removeWrapperClasses();
        } else {
            _wrapperClasses.set(wrappers);
        }
    }

    private static void removeWrapperClasses() {
        _wrapperClasses.remove();
    }

    public static void clearWrapperClasses() {
        TLB.getWrapperClasses().clear();
    }

    public static Map<String, Class<? extends Wrapper>> getWrapperClassesClone() {
        return new LinkedHashMap<String, Class<? extends Wrapper>>(TLB.getWrapperClasses());
    }

    public static Class<? extends Wrapper> getWrapperClass(Class<? extends Wrappable> clazz) {
        return clazz == null ? null : TLB.getWrapperClass(clazz.getName());
    }

    private static Class<? extends Wrapper> getWrapperClass(String key) {
        return key == null ? null : TLB.getWrapperClasses().get(key);
    }

    public static void setWrapperClass(Class<? extends Wrappable> clazz, Class<? extends Wrapper> wrapper) {
        TLB.setWrapperClass(clazz.getName(), wrapper);
    }

    private static void setWrapperClass(String key, Class<? extends Wrapper> wrapper) {
        if (key != null) {
            if (wrapper == null) {
                TLB.removeWrapperClass(key);
            } else {
                TLB.getWrapperClasses().put(key, wrapper);
            }
        }
    }

    static void removeWrapperClass(String key) {
        if (key != null) {
            TLB.getWrapperClasses().remove(key);
        }
    }

    static {
        TLB.init();
    }
}

