/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import adalid.commons.bundles.Bundle;
import adalid.commons.enums.EnumBitLabelSet;

public class BitUtils {
    public static Boolean getAsBoolean(Object o) {
        return o == null ? null : BitUtils.toBoolean(o);
    }

    public static String getAsString(Object o) {
        return o == null ? null : BitUtils.toBoolean(o).toString();
    }

    public static boolean valueOf(Boolean b, boolean value) {
        return b != null ? b : value;
    }

    public static boolean valueOf(Boolean b) {
        return b != null && b != false;
    }

    public static boolean valueOf(Character c) {
        return c != null && BitUtils.valueOf(c.charValue());
    }

    public static boolean valueOf(char c) {
        return c != ' ' && c != 'n' && c != 'N' && c != '0';
    }

    public static boolean valueOf(String s) {
        if (s == null || s.trim().isEmpty()) {
            return false;
        }
        if (s.length() == 1) {
            return BitUtils.valueOf(s.charAt(0));
        }
        return !s.equalsIgnoreCase("false") && !s.equalsIgnoreCase(Bundle.getString("bit.no")) && !s.equalsIgnoreCase(Bundle.getString("bit.inactive")) && !s.equalsIgnoreCase(Bundle.getString("bit.off")) && !s.equalsIgnoreCase(Bundle.getString("bit.negative")) && !s.equalsIgnoreCase(Bundle.getString("bit.absent")) && !s.equalsIgnoreCase(Bundle.getString("bit.false"));
    }

    public static boolean valueOf(Number n) {
        return n != null && n.longValue() != 0L;
    }

    public static boolean valueOf(Object o) {
        if (o instanceof Boolean) {
            Boolean pdq = (Boolean)o;
            return pdq;
        }
        if (o instanceof Character) {
            Character pdq = (Character)o;
            return BitUtils.valueOf(pdq);
        }
        if (o instanceof String) {
            String pdq = (String)o;
            return BitUtils.valueOf(pdq);
        }
        if (o instanceof Number) {
            Number pdq = (Number)o;
            return BitUtils.valueOf(pdq);
        }
        return o != null;
    }

    public static String getLabel(Boolean b) {
        return BitUtils.getLabel(b, EnumBitLabelSet.YES_OR_NO);
    }

    public static String getLabel(Boolean b, EnumBitLabelSet bls) {
        if (b == null) {
            return Bundle.getString("bit.null");
        }
        return switch (bls) {
            case EnumBitLabelSet.YES_OR_NO -> {
                if (b.booleanValue()) {
                    yield Bundle.getString("bit.yes");
                }
                yield Bundle.getString("bit.no");
            }
            case EnumBitLabelSet.ACTIVE_OR_INACTIVE -> {
                if (b.booleanValue()) {
                    yield Bundle.getString("bit.active");
                }
                yield Bundle.getString("bit.inactive");
            }
            case EnumBitLabelSet.ON_OR_OFF -> {
                if (b.booleanValue()) {
                    yield Bundle.getString("bit.on");
                }
                yield Bundle.getString("bit.off");
            }
            case EnumBitLabelSet.POSITIVE_OR_NEGATIVE -> {
                if (b.booleanValue()) {
                    yield Bundle.getString("bit.positive");
                }
                yield Bundle.getString("bit.negative");
            }
            case EnumBitLabelSet.PRESENT_OR_ABSENT -> {
                if (b.booleanValue()) {
                    yield Bundle.getString("bit.present");
                }
                yield Bundle.getString("bit.absent");
            }
            case EnumBitLabelSet.TRUE_OR_FALSE -> {
                if (b.booleanValue()) {
                    yield Bundle.getString("bit.true");
                }
                yield Bundle.getString("bit.false");
            }
            default -> b != false ? Bundle.getString("bit.yes") : Bundle.getString("bit.no");
        };
    }

    public static Boolean newBoolean(Object obj) {
        return obj == null ? null : Boolean.valueOf(obj instanceof Boolean ? (Boolean)obj : BitUtils.valueOf(obj));
    }

    public static Boolean toBoolean(Object obj) {
        return obj == null ? null : Boolean.valueOf(obj instanceof Boolean ? (Boolean)obj : BitUtils.valueOf(obj));
    }
}

