/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import adalid.commons.util.ThrowableUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.SourceStringReader;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PlantUML {
    private static final Logger logger = Logger.getLogger(PlantUML.class);

    public static File generateImage(File file) {
        return PlantUML.generateImage(file, null);
    }

    public static File generateImage(File file, String format) {
        return file == null ? null : ("svg".equalsIgnoreCase(format) ? PlantUML.svg(file) : PlantUML.png(file));
    }

    private static File svg(File file) {
        try {
            String output = StringUtils.substringBeforeLast((String)file.getName(), (String)".") + ".svg";
            File outputFile = new File(file.getAbsoluteFile().getParent(), output);
            String string = Files.readString(file.toPath(), StandardCharsets.UTF_8);
            SourceStringReader reader = new SourceStringReader(string);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                reader.outputImage((OutputStream)outputStream, 0, new FileFormatOption(FileFormat.SVG));
                String top = outputStream.toString("UTF-8");
                String svg = top.replace("target=\"_top\"", "target=\"_parent\"");
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
                    writer.write(svg);
                    writer.close();
                }
            }
            return outputFile;
        }
        catch (IOException ex) {
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            return null;
        }
    }

    private static File png(File file) {
        try {
            SourceFileReader reader = new SourceFileReader(file, file.getAbsoluteFile().getParentFile(), StandardCharsets.UTF_8.name());
            List list = reader.getGeneratedImages();
            return list == null || list.isEmpty() ? null : ((GeneratedImage)list.get(0)).getPngFile();
        }
        catch (IOException ex) {
            logger.fatal((Object)ThrowableUtils.getString(ex), (Throwable)ex);
            return null;
        }
    }
}

