/*
 * Decompiled with CFR 0.152.
 */
package adalid.commons.util;

import adalid.commons.bundles.Bundle;
import adalid.commons.enums.EnumTemporalFormat;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TimeUtils {
    private static final Logger logger = Logger.getLogger(TimeUtils.class);
    private static long currentTimeMillis = 0L;
    private static long lastTimeMillis = 0L;
    private static long lastTimeMicros = 0L;
    private static long lastTimeNanos = 0L;
    private static long micros = 0L;
    private static long nanos = 0L;
    private static final ThreadLocal<SimpleDateFormat> dateFormatter = new ThreadLocal();
    private static final ThreadLocal<SimpleDateFormat> timeFormatter = new ThreadLocal();
    private static final ThreadLocal<SimpleDateFormat> timestampFormatter = new ThreadLocal();
    private static final String BUNDLE_KEY_PREFIX = TimeUtils.class.getName() + ".";
    private static final Map<Locale, String> _dateFormatMap = new LinkedHashMap<Locale, String>();
    private static final Map<Locale, String> _timeFormatMap = new LinkedHashMap<Locale, String>();
    private static final Map<Locale, String> _timestampFormatMap = new LinkedHashMap<Locale, String>();
    private static final Calendar fie = TimeUtils.calendar(1970, 3, 16, 15, 30, 40, 360);
    private static final Timestamp fih = new Timestamp(fie.getTimeInMillis());
    private static final SimpleDateFormat foh = new SimpleDateFormat("yyyy-MM-dd\u00b7HH:mm:ss.SSS");
    private static final String fum = foh.format(fih);
    private static final String DEFAULT_DATE_FORMAT = "dd/MM/yyyy";
    private static final String DEFAULT_TIME_FORMAT = "hh:mm a";
    private static final String DEFAULT_TIMESTAMP_FORMAT = "dd/MM/yyyy hh:mm:ss a";
    private static final String JDBC_DATE_FORMAT = "yyyy-MM-dd";
    private static final String JDBC_TIME_FORMAT = "HH:mm:ss";
    private static final String JDBC_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat JDBC_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat JDBC_TIME_FORMATTER = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat JDBC_TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String SIMPLE_DATE_FORMAT = "yyyyMMdd";
    public static final String SIMPLE_TIME_FORMAT = "HHmmss";
    public static final String SIMPLE_TIMESTAMP_FORMAT = "yyyyMMdd-HHmmss-SSS";
    public static final SimpleDateFormat SIMPLE_DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat SIMPLE_TIME_FORMATTER = new SimpleDateFormat("HHmmss");
    public static final SimpleDateFormat SIMPLE_TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    private static final Calendar EPOCH = Calendar.getInstance();

    public static synchronized java.sql.Date actualDate() {
        Calendar c = TimeUtils.actualDateCalendar();
        return new java.sql.Date(c.getTimeInMillis());
    }

    public static synchronized Time actualTime() {
        Calendar c = TimeUtils.actualTimeCalendar();
        return new Time(c.getTimeInMillis());
    }

    public static synchronized Timestamp actualTimestamp() {
        return Timestamp.from(Instant.now());
    }

    public static synchronized int actualYear() {
        return TimeUtils.actualDateCalendar().get(1);
    }

    public static synchronized int actualMonth() {
        return TimeUtils.actualDateCalendar().get(2) + 1;
    }

    public static synchronized int actualDayOfMonth() {
        return TimeUtils.actualDateCalendar().get(5);
    }

    public static synchronized Calendar actualDateCalendar() {
        Calendar c = TimeUtils.actualTimestampCalendar();
        TimeUtils.setCalendarFields(c, 0, 0, 0, 0);
        return c;
    }

    public static synchronized Calendar actualTimeCalendar() {
        Calendar c = TimeUtils.actualTimestampCalendar();
        TimeUtils.setCalendarFields(c, 1970, 0, 1);
        return c;
    }

    public static synchronized Calendar actualTimestampCalendar() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Instant.now().toEpochMilli());
        return c;
    }

    public static java.sql.Date firstDateOfYear(int year) {
        Calendar c = TimeUtils.calendar(year, 0, 1);
        return new java.sql.Date(c.getTimeInMillis());
    }

    public static java.sql.Date lastDateOfYear(int year) {
        Calendar c = TimeUtils.calendar(year, 11, 31);
        return new java.sql.Date(c.getTimeInMillis());
    }

    public static Time firstTimeOfDate(Date date) {
        Calendar c = TimeUtils.calendar(date);
        if (c == null) {
            return null;
        }
        TimeUtils.setCalendarFields(c, 0, 0, 0, 0);
        return new Time(c.getTimeInMillis());
    }

    public static Time lastTimeOfDate(Date date) {
        Calendar c = TimeUtils.calendar(date);
        if (c == null) {
            return null;
        }
        TimeUtils.setCalendarFields(c, 23, 59, 59, 999);
        return new Time(c.getTimeInMillis());
    }

    public static Time firstTimeOfDay() {
        Calendar c = TimeUtils.calendar(0, 0, 0, 0);
        return new Time(c.getTimeInMillis());
    }

    public static Time lastTimeOfDay() {
        Calendar c = TimeUtils.calendar(23, 59, 59, 999);
        return new Time(c.getTimeInMillis());
    }

    public static Timestamp firstTimestampOfYear(int year) {
        Calendar c = TimeUtils.calendar(year, 0, 1);
        return new Timestamp(c.getTimeInMillis());
    }

    public static Timestamp lastTimestampOfYear(int year) {
        Calendar c = TimeUtils.calendar(year, 11, 31, 23, 59, 59, 999);
        return new Timestamp(c.getTimeInMillis());
    }

    private static Calendar calendar(Date date) {
        return date == null ? null : TimeUtils.calendar(date.getTime());
    }

    private static Calendar calendar(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        return c;
    }

    private static Calendar calendar(int year, int month, int day) {
        return TimeUtils.calendar(year, month, day, 0, 0, 0, 0);
    }

    private static Calendar calendar(int hour, int minute, int second, int millisecond) {
        return TimeUtils.calendar(1970, 0, 1, hour, minute, second, millisecond);
    }

    private static Calendar calendar(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        Calendar c = Calendar.getInstance();
        TimeUtils.setCalendarFields(c, year, month, day);
        TimeUtils.setCalendarFields(c, hour, minute, second, millisecond);
        return c;
    }

    private static void setCalendarFields(Calendar c, int year, int month, int day) {
        c.set(5, 1);
        c.set(1, year);
        c.set(2, month);
        c.set(5, day);
    }

    private static void setCalendarFields(Calendar c, int hour, int minute, int second, int millisecond) {
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, millisecond);
    }

    public static synchronized long currentTimeMillis() {
        currentTimeMillis = System.currentTimeMillis();
        lastTimeMillis = lastTimeMillis < currentTimeMillis ? currentTimeMillis : ++lastTimeMillis;
        lastTimeMicros = lastTimeMillis * 1000L;
        lastTimeNanos = lastTimeMicros * 1000L;
        micros = 0L;
        nanos = 0L;
        return lastTimeMillis;
    }

    public static synchronized long currentTimeMicros() {
        currentTimeMillis = System.currentTimeMillis();
        if (lastTimeMillis < currentTimeMillis) {
            TimeUtils.currentTimeMillis();
        } else if (++micros < 1000L) {
            lastTimeNanos = ++lastTimeMicros * 1000L;
            nanos = 0L;
        } else {
            TimeUtils.currentTimeMillis();
        }
        return lastTimeMicros;
    }

    public static synchronized long currentTimeNanos() {
        currentTimeMillis = System.currentTimeMillis();
        if (lastTimeMillis < currentTimeMillis) {
            TimeUtils.currentTimeMillis();
        } else if (++nanos < 1000L) {
            ++lastTimeNanos;
        } else {
            TimeUtils.currentTimeMicros();
        }
        return lastTimeNanos;
    }

    public static synchronized java.sql.Date currentDate() {
        Calendar c = TimeUtils.calendar(TimeUtils.currentTimeMillis());
        TimeUtils.setCalendarFields(c, 0, 0, 0, 0);
        return new java.sql.Date(c.getTimeInMillis());
    }

    public static synchronized Time currentTime() {
        Calendar c = TimeUtils.calendar(TimeUtils.currentTimeMillis());
        TimeUtils.setCalendarFields(c, 1970, 0, 1);
        return new Time(c.getTimeInMillis());
    }

    public static synchronized Timestamp currentTimestamp() {
        return new Timestamp(TimeUtils.currentTimeMillis());
    }

    public static synchronized java.sql.Date getDate() {
        return TimeUtils.currentDate();
    }

    public static synchronized java.sql.Date getDate(Date date) {
        Calendar c = TimeUtils.calendar(date);
        if (c == null) {
            return TimeUtils.currentDate();
        }
        TimeUtils.setCalendarFields(c, 0, 0, 0, 0);
        return new java.sql.Date(c.getTimeInMillis());
    }

    public static synchronized Time getTime() {
        return TimeUtils.currentTime();
    }

    public static synchronized Time getTime(Date date) {
        Calendar c = TimeUtils.calendar(date);
        if (c == null) {
            return TimeUtils.currentTime();
        }
        TimeUtils.setCalendarFields(c, 1970, 0, 1);
        return new Time(c.getTimeInMillis());
    }

    public static synchronized Timestamp getTimestamp() {
        return TimeUtils.currentTimestamp();
    }

    public static synchronized Timestamp getTimestamp(java.sql.Date date) {
        return date == null ? TimeUtils.currentTimestamp() : new Timestamp(date.getTime());
    }

    private static SimpleDateFormat dateFormatter(EnumTemporalFormat format) {
        if (format == null) {
            return TimeUtils.dateFormatter();
        }
        return switch (format) {
            case EnumTemporalFormat.JDBC -> JDBC_DATE_FORMATTER;
            case EnumTemporalFormat.SIMPLE -> SIMPLE_DATE_FORMATTER;
            default -> TimeUtils.dateFormatter();
        };
    }

    private static SimpleDateFormat dateFormatter() {
        SimpleDateFormat formatter = dateFormatter.get();
        if (formatter == null) {
            formatter = new SimpleDateFormat(TimeUtils.getDateFormat());
            formatter.setLenient(false);
            dateFormatter.set(formatter);
        }
        return formatter;
    }

    private static SimpleDateFormat timeFormatter(EnumTemporalFormat format) {
        if (format == null) {
            return TimeUtils.timeFormatter();
        }
        return switch (format) {
            case EnumTemporalFormat.JDBC -> JDBC_TIME_FORMATTER;
            case EnumTemporalFormat.SIMPLE -> SIMPLE_TIME_FORMATTER;
            default -> TimeUtils.timeFormatter();
        };
    }

    private static SimpleDateFormat timeFormatter() {
        SimpleDateFormat formatter = timeFormatter.get();
        if (formatter == null) {
            formatter = new SimpleDateFormat(TimeUtils.getTimeFormat());
            formatter.setLenient(false);
            timeFormatter.set(formatter);
        }
        return formatter;
    }

    private static SimpleDateFormat timestampFormatter(EnumTemporalFormat format) {
        if (format == null) {
            return TimeUtils.timestampFormatter();
        }
        return switch (format) {
            case EnumTemporalFormat.JDBC -> JDBC_TIMESTAMP_FORMATTER;
            case EnumTemporalFormat.SIMPLE -> SIMPLE_TIMESTAMP_FORMATTER;
            default -> TimeUtils.timestampFormatter();
        };
    }

    private static SimpleDateFormat timestampFormatter() {
        SimpleDateFormat formatter = timestampFormatter.get();
        if (formatter == null) {
            formatter = new SimpleDateFormat(TimeUtils.getTimestampFormat());
            formatter.setLenient(false);
            timestampFormatter.set(formatter);
        }
        return formatter;
    }

    public static String getDateFormat() {
        Locale locale = Bundle.getLocale();
        if (_dateFormatMap.containsKey(locale)) {
            return _dateFormatMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "date.pattern");
        String format = StringUtils.defaultIfBlank((String)string, (String)DEFAULT_DATE_FORMAT);
        return format;
    }

    public static void setDateFormat(Locale locale, String format) {
        if (locale != null) {
            if (StringUtils.isBlank((String)format)) {
                _dateFormatMap.remove(locale);
            } else {
                _dateFormatMap.put(locale, format);
                logger.trace((Object)TimeUtils.sample(locale, format, "Date-only"));
            }
        }
    }

    public static String getTimeFormat() {
        Locale locale = Bundle.getLocale();
        if (_timeFormatMap.containsKey(locale)) {
            return _timeFormatMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "time.pattern");
        String format = StringUtils.defaultIfBlank((String)string, (String)DEFAULT_TIME_FORMAT);
        return format;
    }

    public static void setTimeFormat(Locale locale, String format) {
        if (locale != null) {
            if (StringUtils.isBlank((String)format)) {
                _timeFormatMap.remove(locale);
            } else {
                _timeFormatMap.put(locale, format);
                logger.trace((Object)TimeUtils.sample(locale, format, "Time-only"));
            }
        }
    }

    public static String getTimestampFormat() {
        Locale locale = Bundle.getLocale();
        if (_timestampFormatMap.containsKey(locale)) {
            return _timestampFormatMap.get(locale);
        }
        String string = Bundle.getTrimmedToNullString(BUNDLE_KEY_PREFIX + "both.pattern");
        String format = StringUtils.defaultIfBlank((String)string, (String)DEFAULT_TIMESTAMP_FORMAT);
        return format;
    }

    public static void setTimestampFormat(Locale locale, String format) {
        if (locale != null) {
            if (StringUtils.isBlank((String)format)) {
                _timestampFormatMap.remove(locale);
            } else {
                _timestampFormatMap.put(locale, format);
                logger.trace((Object)TimeUtils.sample(locale, format, "Date+time"));
            }
        }
    }

    private static String sample(Locale locale, String format, String label) {
        String string = new SimpleDateFormat(format).format(fih);
        String prefix = label + " formatting example: ";
        return prefix + "value=" + fum + ", locale=\"" + locale + "\", format=\"" + format + "\" --> \"" + string + "\"";
    }

    public static Date defaultObject(String string) {
        return TimeUtils.parse(string, EnumTemporalFormat.DEFAULT);
    }

    public static Date defaultObject(String string, Class<? extends Date> clazz) {
        if (StringUtils.isBlank((String)string) || clazz == null) {
            return null;
        }
        if (java.sql.Date.class.isAssignableFrom(clazz)) {
            return TimeUtils.defaultDate(string);
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return TimeUtils.defaultTime(string);
        }
        return TimeUtils.defaultTimestamp(string);
    }

    public static java.sql.Date defaultDate(String string) {
        return TimeUtils.newDate(TimeUtils.parse(string, EnumTemporalFormat.DEFAULT));
    }

    public static Time defaultTime(String string) {
        return TimeUtils.newTime(TimeUtils.parse(string, EnumTemporalFormat.DEFAULT));
    }

    public static Timestamp defaultTimestamp(String string) {
        return TimeUtils.newTimestamp(TimeUtils.parse(string, EnumTemporalFormat.DEFAULT));
    }

    public static String defaultString(Date util) {
        if (util == null) {
            return null;
        }
        if (util instanceof java.sql.Date) {
            return TimeUtils.defaultDateString(util);
        }
        if (util instanceof Time) {
            return TimeUtils.defaultTimeString(util);
        }
        if (util instanceof Timestamp) {
            return TimeUtils.defaultTimestampString(util);
        }
        return TimeUtils.defaultString(TimeUtils.getSqlExtension(util));
    }

    public static String defaultDateString() {
        return TimeUtils.defaultDateString(TimeUtils.currentDate());
    }

    public static String defaultDateString(Object object) {
        Date date = object instanceof Date ? (Date)object : null;
        return date == null ? null : TimeUtils.defaultDateString(date);
    }

    public static String defaultDateString(Date date) {
        return date == null ? null : TimeUtils.dateFormatter().format(date);
    }

    public static String defaultTimeString() {
        return TimeUtils.defaultTimeString(TimeUtils.currentTime());
    }

    public static String defaultTimeString(Object object) {
        Date date = object instanceof Date ? (Date)object : null;
        return date == null ? null : TimeUtils.defaultTimeString(date);
    }

    public static String defaultTimeString(Date date) {
        return date == null ? null : TimeUtils.timeFormatter().format(date);
    }

    public static String defaultTimestampString() {
        return TimeUtils.defaultTimestampString(TimeUtils.currentTimestamp());
    }

    public static String defaultTimestampString(Object object) {
        Date date = object instanceof Date ? (Date)object : null;
        return date == null ? null : TimeUtils.defaultTimestampString(date);
    }

    public static String defaultTimestampString(Date date) {
        return date == null ? null : TimeUtils.timestampFormatter().format(date);
    }

    public static String defaultTemporalString(Object object) {
        boolean timeless;
        Date date;
        Date date2 = date = object instanceof Date ? (Date)object : null;
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.getTime());
        int dd = c.get(1);
        int MM = c.get(2);
        int yy = c.get(5);
        int hh = c.get(11);
        int mm = c.get(12);
        int ss = c.get(13);
        int ms = c.get(14);
        boolean dateless = dd == 1 && MM == 0 && yy == 1970;
        boolean bl = timeless = hh + mm + ss + ms == 0;
        return timeless ? TimeUtils.defaultDateString(date) : (dateless ? TimeUtils.defaultTimeString(date) : TimeUtils.defaultTimestampString(date));
    }

    public static Date jdbcObject(String string) {
        return TimeUtils.parse(string, EnumTemporalFormat.JDBC);
    }

    public static Date jdbcObject(String string, Class<? extends Date> clazz) {
        if (StringUtils.isBlank((String)string) || clazz == null) {
            return null;
        }
        if (java.sql.Date.class.isAssignableFrom(clazz)) {
            return TimeUtils.jdbcDate(string);
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return TimeUtils.jdbcTime(string);
        }
        return TimeUtils.jdbcTimestamp(string);
    }

    public static java.sql.Date jdbcDate(String string) {
        return TimeUtils.newDate(TimeUtils.parse(string, EnumTemporalFormat.JDBC));
    }

    public static Time jdbcTime(String string) {
        return TimeUtils.newTime(TimeUtils.parse(string, EnumTemporalFormat.JDBC));
    }

    public static Timestamp jdbcTimestamp(String string) {
        return TimeUtils.newTimestamp(TimeUtils.parse(string, EnumTemporalFormat.JDBC));
    }

    public static String jdbcString(Date util) {
        if (util == null) {
            return null;
        }
        if (util instanceof java.sql.Date) {
            return TimeUtils.jdbcDateString(util);
        }
        if (util instanceof Time) {
            return TimeUtils.jdbcTimeString(util);
        }
        if (util instanceof Timestamp) {
            return TimeUtils.jdbcTimestampString(util);
        }
        return TimeUtils.jdbcString(TimeUtils.getSqlExtension(util));
    }

    public static String jdbcDateString() {
        return TimeUtils.jdbcDateString(TimeUtils.currentDate());
    }

    public static String jdbcDateString(Object object) {
        Date date = object instanceof Date ? (Date)object : null;
        return date == null ? null : TimeUtils.jdbcDateString(date);
    }

    public static String jdbcDateString(Date date) {
        return date == null ? null : JDBC_DATE_FORMATTER.format(date);
    }

    public static String jdbcTimeString() {
        return TimeUtils.jdbcTimeString(TimeUtils.currentTime());
    }

    public static String jdbcTimeString(Object object) {
        Date date = object instanceof Date ? (Date)object : null;
        return date == null ? null : TimeUtils.jdbcTimeString(date);
    }

    public static String jdbcTimeString(Date date) {
        return date == null ? null : JDBC_TIME_FORMATTER.format(date);
    }

    public static String jdbcTimestampString() {
        return TimeUtils.jdbcTimestampString(TimeUtils.currentTimestamp());
    }

    public static String jdbcTimestampString(Object object) {
        Date date = object instanceof Date ? (Date)object : null;
        return date == null ? null : TimeUtils.jdbcTimestampString(date);
    }

    public static String jdbcTimestampString(Date date) {
        return date == null ? null : JDBC_TIMESTAMP_FORMATTER.format(date);
    }

    public static String jdbcTemporalString(Object object) {
        boolean timeless;
        Date date;
        Date date2 = date = object instanceof Date ? (Date)object : null;
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.getTime());
        int dd = c.get(1);
        int MM = c.get(2);
        int yy = c.get(5);
        int hh = c.get(11);
        int mm = c.get(12);
        int ss = c.get(13);
        int ms = c.get(14);
        boolean dateless = dd == 1 && MM == 0 && yy == 1970;
        boolean bl = timeless = hh + mm + ss + ms == 0;
        return timeless ? TimeUtils.jdbcDateString(date) : (dateless ? TimeUtils.jdbcTimeString(date) : TimeUtils.jdbcTimestampString(date));
    }

    public static Date simpleObject(String string) {
        return TimeUtils.parse(string, EnumTemporalFormat.SIMPLE);
    }

    public static Date simpleObject(String string, Class<? extends Date> clazz) {
        if (StringUtils.isBlank((String)string) || clazz == null) {
            return null;
        }
        if (java.sql.Date.class.isAssignableFrom(clazz)) {
            return TimeUtils.simpleDate(string);
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return TimeUtils.simpleTime(string);
        }
        return TimeUtils.simpleTimestamp(string);
    }

    public static java.sql.Date simpleDate(String string) {
        return TimeUtils.newDate(TimeUtils.parse(string, EnumTemporalFormat.SIMPLE));
    }

    public static Time simpleTime(String string) {
        return TimeUtils.newTime(TimeUtils.parse(string, EnumTemporalFormat.SIMPLE));
    }

    public static Timestamp simpleTimestamp(String string) {
        return TimeUtils.newTimestamp(TimeUtils.parse(string, EnumTemporalFormat.SIMPLE));
    }

    public static String simpleDateString() {
        return TimeUtils.simpleDateString(TimeUtils.currentDate());
    }

    public static String simpleDateString(Object object) {
        Date date = object instanceof Date ? (Date)object : null;
        return date == null ? null : TimeUtils.simpleDateString(date);
    }

    public static String simpleDateString(Date date) {
        return date == null ? null : SIMPLE_DATE_FORMATTER.format(date);
    }

    public static String simpleTimeString() {
        return TimeUtils.simpleTimeString(TimeUtils.currentTime());
    }

    public static String simpleTimeString(Object object) {
        Date date = object instanceof Date ? (Date)object : null;
        return date == null ? null : TimeUtils.simpleTimeString(date);
    }

    public static String simpleTimeString(Date date) {
        return date == null ? null : SIMPLE_TIME_FORMATTER.format(date);
    }

    public static String simpleTimestampString() {
        return TimeUtils.simpleTimestampString(TimeUtils.currentTimestamp());
    }

    public static String simpleTimestampString(Object object) {
        Date date = object instanceof Date ? (Date)object : null;
        return date == null ? null : TimeUtils.simpleTimestampString(date);
    }

    public static String simpleTimestampString(Date date) {
        return date == null ? null : SIMPLE_TIMESTAMP_FORMATTER.format(date);
    }

    public static String simpleTemporalString(Object object) {
        boolean timeless;
        Date date;
        Date date2 = date = object instanceof Date ? (Date)object : null;
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.getTime());
        int dd = c.get(1);
        int MM = c.get(2);
        int yy = c.get(5);
        int hh = c.get(11);
        int mm = c.get(12);
        int ss = c.get(13);
        int ms = c.get(14);
        boolean dateless = dd == 1 && MM == 0 && yy == 1970;
        boolean bl = timeless = hh + mm + ss + ms == 0;
        return timeless ? TimeUtils.simpleDateString(date) : (dateless ? TimeUtils.simpleTimeString(date) : TimeUtils.simpleTimestampString(date));
    }

    public static java.sql.Date newDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return TimeUtils.newDate(TimeUtils.parse(pdq));
        }
        if (obj instanceof Date) {
            Date pdq = (Date)obj;
            return TimeUtils.newDate(pdq);
        }
        throw new IllegalArgumentException("(" + obj.getClass() + ")" + obj + " is not an instance of java.util.Date ");
    }

    public static Time newTime(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return TimeUtils.newTime(TimeUtils.parse(pdq));
        }
        if (obj instanceof Date) {
            Date pdq = (Date)obj;
            return TimeUtils.newTime(pdq);
        }
        throw new IllegalArgumentException("(" + obj.getClass() + ")" + obj + " is not an instance of java.util.Date ");
    }

    public static Timestamp newTimestamp(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String pdq = (String)obj;
            return TimeUtils.newTimestamp(TimeUtils.parse(pdq));
        }
        if (obj instanceof Date) {
            Date pdq = (Date)obj;
            return TimeUtils.newTimestamp(pdq);
        }
        throw new IllegalArgumentException("(" + obj.getClass() + ")" + obj + " is not an instance of java.util.Date ");
    }

    public static java.sql.Date newDate(Date date) {
        return date == null ? null : new java.sql.Date(TimeUtils.newDateCalendar(date).getTimeInMillis());
    }

    public static Calendar newDateCalendar(Date date) {
        Calendar c = TimeUtils.calendar(date);
        if (c == null) {
            return null;
        }
        TimeUtils.setCalendarFields(c, 0, 0, 0, 0);
        return c;
    }

    public static Time newTime(Date date) {
        return date == null ? null : new Time(TimeUtils.newTimeCalendar(date).getTimeInMillis());
    }

    public static Calendar newTimeCalendar(Date date) {
        Calendar c = TimeUtils.calendar(date);
        if (c == null) {
            return null;
        }
        TimeUtils.setCalendarFields(c, 1970, 0, 1);
        return c;
    }

    public static Timestamp newTimestamp(Date date) {
        return date == null ? null : new Timestamp(date.getTime());
    }

    public static Calendar newCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(date.getTime());
        return c;
    }

    public static Date toJavaDate(Object object, Class<? extends Date> targetClass) {
        if (object == null) {
            return null;
        }
        Class<?> sourceClass = object.getClass();
        if (targetClass == null || targetClass.isAssignableFrom(sourceClass)) {
            return (Date)object;
        }
        if (targetClass.equals(java.sql.Date.class)) {
            return TimeUtils.toDate(object);
        }
        if (targetClass.equals(Time.class)) {
            return TimeUtils.toTime(object);
        }
        if (targetClass.equals(Timestamp.class)) {
            return TimeUtils.toTimestamp(object);
        }
        return (Date)object;
    }

    public static java.sql.Date toDate(Object obj) {
        return obj == null ? null : (obj instanceof java.sql.Date ? (java.sql.Date)obj : TimeUtils.newDate(obj));
    }

    public static Time toTime(Object obj) {
        return obj == null ? null : (obj instanceof Time ? (Time)obj : TimeUtils.newTime(obj));
    }

    public static Timestamp toTimestamp(Object obj) {
        return obj == null ? null : (obj instanceof Timestamp ? (Timestamp)obj : TimeUtils.newTimestamp(obj));
    }

    public static Date parse(String pdq) {
        return TimeUtils.parse(pdq, null);
    }

    public static Date parse(String pdq, EnumTemporalFormat format) {
        if (StringUtils.isBlank((String)pdq)) {
            return null;
        }
        String string = pdq.trim();
        SimpleDateFormat timestampParser = TimeUtils.timestampFormatter(format);
        ParsePosition position = new ParsePosition(0);
        Date util = timestampParser.parse(string, position);
        int i = position.getIndex();
        int l = string.length();
        if (util != null && i == l) {
            return new Timestamp(util.getTime());
        }
        SimpleDateFormat dateParser = TimeUtils.dateFormatter(format);
        SimpleDateFormat timeParser = TimeUtils.timeFormatter(format);
        position.setIndex(0);
        util = dateParser.parse(string, position);
        i = position.getIndex();
        if (util != null) {
            if (i == l) {
                return new java.sql.Date(util.getTime());
            }
            Date time = timeParser.parse(string, position);
            i = position.getIndex();
            if (time != null && i == l) {
                return TimeUtils.merge(util, time);
            }
        }
        position.setIndex(0);
        util = timeParser.parse(string, position);
        i = position.getIndex();
        if (util != null && i == l) {
            return new Time(util.getTime());
        }
        return null;
    }

    private static Timestamp merge(Date date, Date time) {
        Calendar d = Calendar.getInstance();
        Calendar t = Calendar.getInstance();
        d.setTimeInMillis(date.getTime());
        t.setTimeInMillis(time.getTime());
        d.set(11, t.get(11));
        d.set(12, t.get(12));
        d.set(13, t.get(13));
        d.set(14, t.get(14));
        return new Timestamp(d.getTimeInMillis());
    }

    public static Date getSqlExtension(Date util) {
        return util == null || util instanceof java.sql.Date || util instanceof Time || util instanceof Timestamp ? util : TimeUtils.getFittestSqlExtension(util);
    }

    public static Date getFittestSqlExtension(Date util) {
        if (util == null) {
            return null;
        }
        long milliseconds = util.getTime();
        java.sql.Date date = TimeUtils.newDate(util);
        if (date.getTime() == milliseconds) {
            return date;
        }
        Time time = TimeUtils.newTime(util);
        if (time.getTime() == milliseconds) {
            return time;
        }
        return new Timestamp(milliseconds);
    }

    public static java.sql.Date addDate(Date date, int addend, char unit) {
        if (date == null) {
            return null;
        }
        Calendar c = TimeUtils.newDateCalendar(date);
        if (addend != 0) {
            switch (unit) {
                case 'Y': {
                    c.add(1, addend);
                    break;
                }
                case 'M': {
                    c.add(2, addend);
                    break;
                }
                case 'D': {
                    c.add(5, addend);
                }
            }
        }
        return new java.sql.Date(c.getTimeInMillis());
    }

    public static Time addTime(Date date, int addend, char unit) {
        if (date == null) {
            return null;
        }
        Calendar c = TimeUtils.newTimeCalendar(date);
        if (addend != 0) {
            switch (unit) {
                case 'h': {
                    c.add(10, addend);
                    break;
                }
                case 'm': {
                    c.add(12, addend);
                    break;
                }
                case 's': {
                    c.add(13, addend);
                }
            }
        }
        return new Time(c.getTimeInMillis());
    }

    public static Timestamp addTimestamp(Date date, int addend, char unit) {
        if (date == null) {
            return null;
        }
        Calendar c = TimeUtils.newCalendar(date);
        if (addend != 0) {
            switch (unit) {
                case 'Y': {
                    c.add(1, addend);
                    break;
                }
                case 'M': {
                    c.add(2, addend);
                    break;
                }
                case 'D': {
                    c.add(5, addend);
                    break;
                }
                case 'h': {
                    c.add(10, addend);
                    break;
                }
                case 'm': {
                    c.add(12, addend);
                    break;
                }
                case 's': {
                    c.add(13, addend);
                }
            }
        }
        return new Timestamp(c.getTimeInMillis());
    }

    public static long epochMillis() {
        return EPOCH.getTimeInMillis();
    }

    static {
        EPOCH.set(1, 1970);
        EPOCH.set(2, 0);
        EPOCH.set(5, 1);
        EPOCH.set(11, 0);
        EPOCH.set(12, 0);
        EPOCH.set(13, 0);
        EPOCH.set(14, 0);
    }
}

