/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.LogUtils;
import adalid.commons.util.ThrowableUtils;
import adalid.core.AbstractArtifact;
import adalid.core.Instance;
import adalid.core.Operation;
import adalid.core.Primitive;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.Transition;
import adalid.core.enums.ComparisonOp;
import adalid.core.enums.ExpressionUsage;
import adalid.core.enums.OperationKind;
import adalid.core.expressions.BooleanComparisonX;
import adalid.core.expressions.VariantX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.ComparisonX;
import adalid.core.interfaces.ConditionalX;
import adalid.core.interfaces.DataAggregateX;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityExpression;
import adalid.core.interfaces.EnumerationEntity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NamedValue;
import adalid.core.interfaces.NaryExpression;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.OrderedPairX;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.RowsAggregateX;
import adalid.core.interfaces.ScalarX;
import adalid.core.interfaces.SpecialValue;
import adalid.core.interfaces.State;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.interfaces.TypedArtifact;
import adalid.core.properties.DateProperty;
import adalid.core.properties.TimestampProperty;
import adalid.core.sql.QueryJoin;
import adalid.core.sql.QueryTable;
import adalid.core.wrappers.ExpressionWrapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractExpression
extends AbstractArtifact
implements NaryExpression {
    private static final Logger logger = Logger.getLogger(Expression.class);
    private static final String EOL = "\n";
    private static final String TAB = "\t";
    private Class<?> _dataType;
    private Expression _parentExpression;
    private Field _foreignExpressionField;
    private final Map<ExpressionUsage, Set<Artifact>> _verifiedUsages = new LinkedHashMap<ExpressionUsage, Set<Artifact>>();
    private boolean _logicalTautology;
    private Property _transitionTimestamp;
    Set<String> crossReferencedExpressionsSet;
    private Instance _matchingInstance;
    private Instance _stateInstance;

    public List<Operation> getInitialStateBusinessOperationsList() {
        Entity declaringEntity;
        ArrayList<Operation> list = new ArrayList<Operation>();
        if (this instanceof State && (declaringEntity = this.getDeclaringEntity()) != null) {
            for (Operation operation : declaringEntity.getBusinessOperationsList()) {
                if (!OperationKind.INSTANCE.equals((Object)operation.getOperationKind())) continue;
                for (Transition transition : operation.getTransitionsList()) {
                    State state;
                    if (transition == null || !this.equals(state = transition.getX()) || list.contains(operation)) continue;
                    list.add(operation);
                }
            }
        }
        return list;
    }

    public List<Operation> getFinalStateBusinessOperationsList() {
        Entity declaringEntity;
        ArrayList<Operation> list = new ArrayList<Operation>();
        if (this instanceof State && (declaringEntity = this.getDeclaringEntity()) != null) {
            for (Operation operation : declaringEntity.getBusinessOperationsList()) {
                if (!OperationKind.INSTANCE.equals((Object)operation.getOperationKind())) continue;
                for (Transition transition : operation.getTransitionsList()) {
                    State state;
                    if (transition == null || !this.equals(state = transition.getY()) || list.contains(operation)) continue;
                    list.add(operation);
                }
            }
        }
        return list;
    }

    @Override
    public Class<?> getDataType() {
        return this._dataType;
    }

    protected void setDataType(Class<?> dataType) {
        this._dataType = dataType;
    }

    @Override
    public Expression getParentExpression() {
        return this._parentExpression;
    }

    private void setParentExpression(Expression parentExpression) {
        if (parentExpression == null || this.getDeclaringArtifact() == null) {
            this._parentExpression = parentExpression;
            Object[] operands = this.getOperands();
            if (operands != null) {
                for (Object operand : operands) {
                    if (!(operand instanceof AbstractExpression)) continue;
                    AbstractExpression childExpression = (AbstractExpression)operand;
                    childExpression.setParentExpression(this);
                }
            }
        }
    }

    public Field getForeignExpressionField() {
        return this._foreignExpressionField;
    }

    protected void setForeignExpressionField(Field foreignExpressionField) {
        this._foreignExpressionField = foreignExpressionField;
    }

    public String getForeignExpressionName() {
        return this._foreignExpressionField == null ? null : this._foreignExpressionField.getName();
    }

    public Class<?> getForeignExpressionType() {
        return this._foreignExpressionField == null ? null : this._foreignExpressionField.getDeclaringClass();
    }

    @Override
    public List<ExpressionUsage> getVerifiedUsages() {
        return new ArrayList<ExpressionUsage>(this._verifiedUsages.keySet());
    }

    @Override
    public Map<ExpressionUsage, Set<Artifact>> getVerifiedUsageMap() {
        return this._verifiedUsages;
    }

    @Override
    public Set<Artifact> getVerifiedUsers(ExpressionUsage usage) {
        Set<Artifact> users = this._verifiedUsages.get((Object)usage);
        if (users == null) {
            users = new LinkedHashSet<Artifact>();
            this._verifiedUsages.put(usage, users);
        }
        return users;
    }

    @Override
    public Set<Artifact> addVerifiedUsage(ExpressionUsage usage, Artifact user) {
        Set<Artifact> users = this.getVerifiedUsers(usage);
        if (user != null) {
            users.add(user);
        }
        return users;
    }

    public boolean isLogicalTautology() {
        return this._logicalTautology;
    }

    public void setLogicalTautology(boolean tautology) {
        this.checkScope();
        if (this instanceof BooleanExpression) {
            this._logicalTautology = tautology;
        }
    }

    public Property getTransitionTimestamp() {
        return this._transitionTimestamp;
    }

    public void setTransitionTimestamp(TimestampProperty timestamp) {
        this.checkScope();
        this._transitionTimestamp = timestamp;
    }

    public void setTransitionDate(DateProperty date) {
        this.checkScope();
        this._transitionTimestamp = date;
    }

    @Override
    public Set<String> getStringsSet() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Object[] operands = this.getOperands();
        if (operands != null) {
            for (Object operand : operands) {
                if (operand instanceof String) {
                    set.add(operand.toString());
                    continue;
                }
                if (!(operand instanceof Expression)) continue;
                Expression expression = (Expression)operand;
                set.addAll(expression.getStringsSet());
            }
        }
        return set;
    }

    @Override
    public List<Property> getReferencedColumnsList() {
        return new ArrayList<Property>(this.getReferencedColumnsMap().values());
    }

    public List<Property> getCorrespondingReferencedColumnsList(QueryTable searchQueryTable1, QueryTable searchQueryTable2) {
        Level level = Level.TRACE;
        String trace = this.getTrace();
        logger.log((Priority)level, (Object)(this.getFullName() + "/" + trace));
        List<Property> referencedColumnsList1 = this.getReferencedColumnsList();
        ArrayList<Property> referencedColumnsList2 = new ArrayList<Property>();
        for (Property property1 : referencedColumnsList1) {
            String alias = searchQueryTable1.getSqlAlias(property1);
            logger.log((Priority)level, (Object)("\t-" + searchQueryTable1.getName() + "/" + alias + " -> " + property1.getFullName()));
            Property property2 = searchQueryTable2.getProperty(alias);
            logger.log((Priority)level, (Object)("\t+" + searchQueryTable2.getName() + "/" + alias + " -> " + (property2 == null ? null : property2.getFullName())));
            if (property2 == null) continue;
            referencedColumnsList2.add(property2);
        }
        return referencedColumnsList2;
    }

    @Override
    public Map<String, Property> getReferencedColumnsMap() {
        LinkedHashMap<String, Property> map = new LinkedHashMap<String, Property>();
        Object[] operands = this.getOperands();
        if (operands != null) {
            for (Object operand : operands) {
                if (operand instanceof Property) {
                    Property property = (Property)operand;
                    map.put(property.getPathString(), property);
                    continue;
                }
                if (!(operand instanceof Expression)) continue;
                Expression expression = (Expression)operand;
                map.putAll(expression.getReferencedColumnsMap());
            }
        }
        return map;
    }

    @Override
    public List<QueryJoin> getReferencedJoinsList() {
        return new ArrayList<QueryJoin>(this.getReferencedJoinsMap().values());
    }

    @Override
    public List<QueryJoin> getReferencedJoinsList(QueryTable queryTable) {
        return new ArrayList<QueryJoin>(this.getReferencedJoinsMap(queryTable).values());
    }

    @Override
    public Map<String, QueryJoin> getReferencedJoinsMap() {
        Entity declaringEntity = this.getDeclaringEntity();
        if (declaringEntity instanceof PersistentEntity) {
            PersistentEntity pent = (PersistentEntity)declaringEntity;
            QueryTable queryTable = pent.getQueryTable();
            return this.getReferencedJoinsMap(queryTable);
        }
        return new LinkedHashMap<String, QueryJoin>();
    }

    @Override
    public Map<String, QueryJoin> getReferencedJoinsMap(QueryTable queryTable) {
        List<Property> columns = this.getReferencedColumnsList();
        return queryTable.getReferencedJoinsMap(columns);
    }

    @Override
    public Set<String> getCrossReferencedExpressionsSet() {
        return this.getCrossReferencedExpressionsSet(this.getDeclaringEntity());
    }

    @Override
    public Set<String> getCrossReferencedExpressionsSet(Entity declaringEntity) {
        if (this.crossReferencedExpressionsSet == null) {
            Object[] operands;
            this.crossReferencedExpressionsSet = new LinkedHashSet<String>();
            if (declaringEntity != null && (operands = this.getOperands()) != null) {
                for (Object operand : operands) {
                    if (operand instanceof Primitive || !(operand instanceof Expression)) continue;
                    Expression expression = (Expression)operand;
                    Entity expressionDeclaringEntity = expression.getDeclaringEntity();
                    if (expressionDeclaringEntity == null || expressionDeclaringEntity.equals(declaringEntity)) {
                        this.crossReferencedExpressionsSet.addAll(expression.getCrossReferencedExpressionsSet(declaringEntity));
                        continue;
                    }
                    String key = expression.getCrossReferencedExpressionsKey();
                    if (key == null) continue;
                    this.crossReferencedExpressionsSet.add(key);
                }
            }
        }
        return this.crossReferencedExpressionsSet;
    }

    @Override
    public String getCrossReferencedExpressionsKey() {
        Entity declaringEntity = this.getDeclaringEntity();
        String key = declaringEntity == null ? null : declaringEntity.getRoot().getName() + "." + this.getName();
        return key;
    }

    @Override
    public boolean isCrossReferencedExpression() {
        return TLC.getProject().containsCrossReferencedExpression(this);
    }

    @Override
    public boolean isSingleEntityExpression() {
        Entity declaringEntity = this.getDeclaringEntity();
        return declaringEntity != null && this.isSingleEntityExpression(declaringEntity);
    }

    @Override
    public boolean isSingleEntityExpression(Entity declaringEntity) {
        if (declaringEntity == null) {
            return false;
        }
        Object[] operands = this.getOperands();
        if (operands != null) {
            for (Object operand : operands) {
                if (!(operand instanceof Expression)) continue;
                Expression expression = (Expression)operand;
                if (operand instanceof RowsAggregateX) {
                    return false;
                }
                Entity expressionDeclaringEntity = expression.getDeclaringEntity();
                if ((expressionDeclaringEntity == null || expressionDeclaringEntity.equals(declaringEntity)) && expression.isSingleEntityExpression(declaringEntity)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBooleanExpression() {
        return this instanceof BooleanExpression;
    }

    public boolean isCharacterExpression() {
        return this instanceof CharacterExpression;
    }

    public boolean isEntityExpression() {
        return this instanceof EntityExpression;
    }

    public boolean isNumericExpression() {
        return this instanceof NumericExpression;
    }

    public boolean isTemporalExpression() {
        return this instanceof TemporalExpression;
    }

    public boolean isComparisonExpression() {
        return this instanceof ComparisonX;
    }

    public boolean isConditionalExpression() {
        return this instanceof ConditionalX;
    }

    public boolean isDataAggregateExpression() {
        return this instanceof DataAggregateX;
    }

    public boolean isOrderedPairExpression() {
        return this instanceof OrderedPairX;
    }

    public boolean isRowsAggregateExpression() {
        return this instanceof RowsAggregateX;
    }

    public boolean isScalarExpression() {
        return this instanceof ScalarX;
    }

    public boolean isVariantExpression() {
        return this instanceof VariantX;
    }

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.checkArguments();
            this.checkStateAttributes();
            this.setParentExpression(null);
        }
        return ok;
    }

    protected void checkArguments() {
        Level level;
        String name = this.getName();
        Artifact da = this.getDeclaringArtifact();
        boolean b1 = da instanceof Entity && da.depth() == 0;
        boolean b2 = da instanceof Operation;
        Entity declaringEntity = b1 ? (Entity)da : (b2 ? ((Operation)da).getDeclaringEntity() : null);
        boolean unusual = declaringEntity != null && declaringEntity.isUnusualExpressionsWarningsEnabled();
        Object object = level = unusual ? Project.getUnusualExpressionLevel() : null;
        if (LogUtils.fair(level)) {
            String expression = StringUtils.isBlank((String)name) ? " of " + da : " " + da + "." + name;
            this.checkUnusualArguments(expression, level);
        }
    }

    protected void checkUnusualArguments(String expression, Level level) {
        for (Object operand : this.getOperands()) {
            if (operand instanceof Instance) {
                Instance instance = (Instance)operand;
                this.checkUnusualInstance(expression, level, instance);
                continue;
            }
            if (!(operand instanceof AbstractExpression)) continue;
            AbstractExpression abstractExpression = (AbstractExpression)operand;
            abstractExpression.checkUnusualArguments(expression, level);
        }
    }

    protected void checkUnusualInstance(String expression, Level level, Instance argument) {
        boolean ok;
        boolean bl = ok = argument.getDeclaringEntity() instanceof EnumerationEntity || argument.isUsualArgumentInExpressions();
        if (!ok) {
            String message = "unusual " + argument + " in expression" + expression + "; expressions usually include only instances of enumeration entities";
            logger.log((Priority)level, (Object)message);
            if (Level.ERROR.equals((Object)level) || Level.FATAL.equals((Object)level)) {
                Project.increaseParserErrorCount();
            } else if (Level.WARN.equals((Object)level)) {
                Project.increaseParserWarningCount();
            }
        }
    }

    protected void checkStateAttributes() {
        Entity tsEntity;
        Artifact tsDA;
        String myEntityName;
        Entity myEntity;
        Artifact myDA;
        if (this instanceof State && this._transitionTimestamp != null && (myDA = this.getDeclaringArtifact()) instanceof Entity && (myEntity = (Entity)myDA).depth() == 0 && (myEntityName = myEntity.getName()) != null && (!((tsDA = this._transitionTimestamp.getDeclaringArtifact()) instanceof Entity) || (tsEntity = (Entity)tsDA).depth() != 0 || !tsEntity.isAssignableFrom(myEntity))) {
            String me = this.toString("State");
            String ts = this._transitionTimestamp.getDataType().getSimpleName();
            String message = "transition " + ts + " of " + me + " is not a property of " + myEntityName;
            logger.error((Object)message);
            Project.increaseParserErrorCount();
        }
    }

    protected void copyDataType(Object object) {
        this.setDataType(this.getObjectDataType(object));
    }

    protected Class<?> getObjectDataType(Object object) {
        if (object == null) {
            return Object.class;
        }
        if (object instanceof TypedArtifact) {
            TypedArtifact artifact = (TypedArtifact)object;
            return artifact.getDataType();
        }
        if (object instanceof Instance) {
            Instance instance = (Instance)object;
            Entity entity = instance.getDeclaringEntity();
            return entity != null ? entity.getDataType() : object.getClass();
        }
        if (object instanceof SpecialValue) {
            SpecialValue special = (SpecialValue)object;
            return special.getDataType();
        }
        return object.getClass();
    }

    public Expression getForeignExpression() {
        Entity foreignEntity;
        if (this._foreignExpressionField == null) {
            return null;
        }
        String errmsg = "failed to get foreign expression \"" + this._foreignExpressionField + "\" at " + this;
        Class<?> declaringClass = this._foreignExpressionField.getDeclaringClass();
        Entity declaringEntity = declaringClass == null ? null : this.getDeclaringEntity();
        Project declaringProject = declaringEntity == null ? null : declaringEntity.getDeclaringProject();
        Entity entity = foreignEntity = declaringProject == null ? null : declaringProject.getEntity(declaringClass);
        if (foreignEntity == null) {
            logger.error((Object)errmsg);
            logger.error((Object)("\tforeign expression field declaring class = " + declaringClass));
            logger.error((Object)("\tdeclaring entity = " + declaringEntity));
            logger.error((Object)("\tdeclaring project = " + declaringProject));
            logger.error((Object)("\tforeign entity = " + foreignEntity));
            Project.increaseParserErrorCount();
        } else {
            try {
                Object foreignExpression = this._foreignExpressionField.get(foreignEntity);
                if (foreignExpression instanceof Expression) {
                    Expression expression = (Expression)foreignExpression;
                    return expression;
                }
                logger.error((Object)errmsg);
                logger.error((Object)(TAB + this._foreignExpressionField + " = " + foreignExpression));
                Project.increaseParserErrorCount();
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                logger.error((Object)errmsg, ThrowableUtils.getCause(ex));
                Project.increaseParserErrorCount();
            }
        }
        return null;
    }

    public Class<? extends ExpressionWrapper> getDefaultWrapperClass() {
        return ExpressionWrapper.class;
    }

    @Override
    public String getLocalizedLabel(Locale locale) {
        Instance instance;
        String localizedLabel = super.getLocalizedLabel(locale);
        if (localizedLabel == null && (instance = this.getMatchingInstance()) != null && (localizedLabel = instance.getLocalizedLabel(locale)) == null && (instance = this.getStateInstance()) != null) {
            localizedLabel = instance.getInstanceKeyLabel(locale);
        }
        return localizedLabel;
    }

    @Override
    public String getLocalizedShortLabel(Locale locale) {
        Instance instance;
        String localizedShortLabel = super.getLocalizedShortLabel(locale);
        if (localizedShortLabel == null && (instance = this.getMatchingInstance()) != null && (localizedShortLabel = instance.getLocalizedShortLabel(locale)) == null && (instance = this.getStateInstance()) != null) {
            localizedShortLabel = instance.getInstanceKeyLabel(locale);
        }
        return localizedShortLabel;
    }

    @Override
    public String getLocalizedCollectionLabel(Locale locale) {
        Instance instance;
        String localizedCollectionLabel = super.getLocalizedCollectionLabel(locale);
        if (localizedCollectionLabel == null && (instance = this.getMatchingInstance()) != null) {
            localizedCollectionLabel = instance.getLocalizedCollectionLabel(locale);
        }
        return localizedCollectionLabel;
    }

    @Override
    public String getLocalizedCollectionShortLabel(Locale locale) {
        Instance instance;
        String localizedCollectionShortLabel = super.getLocalizedCollectionShortLabel(locale);
        if (localizedCollectionShortLabel == null && (instance = this.getMatchingInstance()) != null) {
            localizedCollectionShortLabel = instance.getLocalizedCollectionShortLabel(locale);
        }
        return localizedCollectionShortLabel;
    }

    @Override
    public String getLocalizedDescription(Locale locale) {
        Instance instance;
        String localizedDescription = super.getLocalizedDescription(locale);
        if (localizedDescription == null && (instance = this.getMatchingInstance()) != null && (localizedDescription = instance.getLocalizedDescription(locale)) == null) {
            localizedDescription = instance.getInstanceKeyDescription(locale);
        }
        return localizedDescription;
    }

    @Override
    public String getLocalizedShortDescription(Locale locale) {
        Instance instance;
        String localizedShortDescription = super.getLocalizedShortDescription(locale);
        if (localizedShortDescription == null && (instance = this.getMatchingInstance()) != null && (localizedShortDescription = instance.getLocalizedShortDescription(locale)) == null) {
            localizedShortDescription = instance.getInstanceKeyDescription(locale);
        }
        return localizedShortDescription;
    }

    private Instance getMatchingInstance() {
        Object object;
        BooleanComparisonX bcx;
        AbstractExpression abstractExpression;
        if (this._matchingInstance == null && (abstractExpression = this) instanceof BooleanComparisonX && ComparisonOp.EQ.equals((bcx = (BooleanComparisonX)abstractExpression).getOperator()) && (object = bcx.getX()) instanceof Entity) {
            Instance instance;
            Entity entity = (Entity)object;
            object = bcx.getY();
            if (object instanceof Instance && this.sameDataTypeSimpleName(entity, (instance = (Instance)object).getDeclaringEntity())) {
                this._matchingInstance = instance;
            }
        }
        return this._matchingInstance;
    }

    private Instance getStateInstance() {
        AbstractExpression abstractExpression;
        if (this._stateInstance == null && (abstractExpression = this) instanceof BooleanComparisonX) {
            Instance instance;
            Object object;
            Entity stateProperty;
            BooleanComparisonX bcx = (BooleanComparisonX)abstractExpression;
            Entity declaringEntity = this.getDeclaringEntity();
            if (declaringEntity != null && (stateProperty = declaringEntity.getStateProperty()) != null && ComparisonOp.EQ.equals(bcx.getOperator()) && bcx.getX() == stateProperty && (object = bcx.getY()) instanceof Instance && this.sameDataTypeSimpleName(stateProperty, (instance = (Instance)object).getDeclaringEntity())) {
                this._stateInstance = instance;
            }
        }
        return this._stateInstance;
    }

    @Override
    public String getExpressionString() {
        Object string;
        Operator operator = this.getOperator();
        Object[] operands = this.getOperands();
        Object object = string = operator == null ? "" : operator.name();
        if (operands != null && operands.length != 0) {
            Object[] strings = new String[operands.length];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = this.operandString(operands[i]);
            }
            string = (String)string + "(" + StringUtils.join((Object[])strings, (String)", ") + ")";
        }
        return string;
    }

    private String operandString(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Entity) {
            return ((Artifact)operand).getFullName();
        }
        if (operand instanceof Instance) {
            return ((Artifact)operand).getFullName();
        }
        if (operand instanceof NamedValue) {
            NamedValue namedValue = (NamedValue)operand;
            return namedValue.name();
        }
        if (operand instanceof Expression) {
            Expression expression = (Expression)operand;
            return expression.getExpressionString();
        }
        if (operand instanceof Artifact) {
            Artifact artifact = (Artifact)operand;
            return artifact.getFullName();
        }
        return "" + operand;
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "type" + faa + this._dataType + foo;
            string = (String)string + fee + tab + "parentExpression" + faa + this._parentExpression + foo;
        }
        return string;
    }
}

