/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.core.enums.LetterCase;
import java.awt.Color;

public class InstanceTag {
    public static final InstanceTag PLAIN_TEXT = new InstanceTag(null, null, null);
    public static final InstanceTag COLORLESS = new InstanceTag(null, null);
    public static final InstanceTag BLUE = new InstanceTag(Color.decode("#2196F3"), Color.decode("#FFFFFF"));
    public static final InstanceTag BLUISH = new InstanceTag(Color.decode("#B3E5FC"), Color.decode("#23547B"));
    public static final InstanceTag GREEN = new InstanceTag(Color.decode("#689F38"), Color.decode("#FFFFFF"));
    public static final InstanceTag GREENISH = new InstanceTag(Color.decode("#C8E6C9"), Color.decode("#256029"));
    public static final InstanceTag LIGHT_GREEN = new InstanceTag(Color.decode("#90EE90"), Color.decode("#212529"));
    public static final InstanceTag ORANGE = new InstanceTag(Color.decode("#FF9900"), Color.decode("#212529"));
    public static final InstanceTag ORANGISH = new InstanceTag(Color.decode("#FFAD33"), Color.decode("#212529"));
    public static final InstanceTag SANDY_BEACH = new InstanceTag(Color.decode("#FFD8B2"), Color.decode("#212529"));
    public static final InstanceTag PURPLE = new InstanceTag(Color.decode("#694382"), Color.decode("#FFFFFF"));
    public static final InstanceTag PURPLISH = new InstanceTag(Color.decode("#ECCFFF"), Color.decode("#694382"));
    public static final InstanceTag RED = new InstanceTag(Color.decode("#D32F2F"), Color.decode("#FFFFFF"));
    public static final InstanceTag REDISH = new InstanceTag(Color.decode("#FFCDD2"), Color.decode("#C63737"));
    public static final InstanceTag YELLOW = new InstanceTag(Color.decode("#FBC02D"), Color.decode("#212529"));
    public static final InstanceTag YELLOWISH = new InstanceTag(Color.decode("#FEEDAF"), Color.decode("#8A5340"));
    private LetterCase _letterCase;
    private boolean _pillShaped;
    private Color _backgroundColor;
    private Color _textColor;

    public static InstanceTag copy(InstanceTag tag) {
        return tag == null ? null : tag.copy();
    }

    public static InstanceTag of(Color backgroundColor, Color textColor) {
        return new InstanceTag(backgroundColor, textColor);
    }

    public static InstanceTag of(Color backgroundColor, Color textColor, LetterCase letterCase) {
        return new InstanceTag(backgroundColor, textColor, letterCase);
    }

    private InstanceTag(Color backgroundColor, Color textColor) {
        this(backgroundColor, textColor, LetterCase.UPPER);
    }

    private InstanceTag(Color backgroundColor, Color textColor, LetterCase letterCase) {
        this(backgroundColor, textColor, letterCase, false);
    }

    private InstanceTag(Color backgroundColor, Color textColor, LetterCase letterCase, boolean pillShaped) {
        this._backgroundColor = backgroundColor;
        this._textColor = textColor;
        this._letterCase = letterCase;
        this._pillShaped = pillShaped;
    }

    public InstanceTag copy() {
        return new InstanceTag(this._backgroundColor, this._textColor, this._letterCase, this._pillShaped);
    }

    public LetterCase getLetterCase() {
        return this._letterCase == null ? LetterCase.UNSPECIFIED : this._letterCase;
    }

    public InstanceTag setLetterCase(LetterCase letterCase) {
        this._letterCase = letterCase;
        return this;
    }

    public boolean isPillShaped() {
        return this._pillShaped;
    }

    public InstanceTag setPillShaped(boolean pillShaped) {
        this._pillShaped = pillShaped;
        return this;
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public InstanceTag setBackgroundColor(Color color) {
        this._backgroundColor = color;
        return this;
    }

    public String getHtmlBackgroundColor() {
        return this.htmlColor(this._backgroundColor);
    }

    public Color getTextColor() {
        return this._textColor;
    }

    public InstanceTag setTextColor(Color color) {
        this._textColor = color;
        return this;
    }

    public String getHtmlTextColor() {
        return this.htmlColor(this._textColor);
    }

    private String htmlColor(Color color) {
        return color == null ? "UNSPECIFIED" : "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
    }
}

