/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.StrUtils;
import adalid.core.AbstractArtifact;
import adalid.core.Report;
import adalid.core.ReportGroup;
import adalid.core.ViewField;
import adalid.core.data.types.StringData;
import adalid.core.enums.ViewFieldAggregation;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.JavaProgrammer;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.Property;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.sql.QueryTable;
import org.apache.commons.lang.StringUtils;

public class ReportField
extends AbstractArtifact
implements Comparable<ReportField> {
    private static final String EOL = "\n";
    private final ReportGroup _group;
    private final Property _property;
    private Property _parentProperty;
    private final ViewField _viewField;
    private int _pixels;
    private boolean _resizeable;

    static ReportField addReportField(ReportGroup group, String name) {
        return new ReportField(group, name);
    }

    static ReportField addReportField(ReportGroup group, Property property) {
        return new ReportField(group, property);
    }

    static ReportField addReportField(ReportGroup group, ViewField field) {
        return new ReportField(group, field);
    }

    private ReportField(ReportGroup group, String name) {
        this._group = group;
        this._property = null;
        this._viewField = null;
        if (group != null && name != null) {
            this.declare(name, group);
            this.add();
        }
    }

    private ReportField(ReportGroup group, Property property) {
        this._group = group;
        this._property = property;
        this._viewField = null;
        if (group != null && property != null) {
            Report report = group.getReport();
            PersistentEntity entity = report == null ? null : report.getEntity();
            QueryTable queryTable = entity == null ? null : entity.getQueryTable();
            String sqlAlias = queryTable == null ? null : queryTable.getSqlAlias(property);
            this.initPixels(property.isReportField() ? property.getPixels() : 0);
            if (sqlAlias != null) {
                this.declare(sqlAlias, group);
                this.add();
            }
        }
    }

    private ReportField(ReportGroup group, ViewField field) {
        this._group = group;
        this._property = field == null ? null : field.getColumn();
        this._viewField = field;
        if (group != null && field != null) {
            Report report = group.getReport();
            PersistentEntity entity = report == null ? null : report.getEntity();
            QueryTable queryTable = entity == null ? null : entity.getQueryTable();
            String sqlAlias = queryTable == null ? null : queryTable.getSqlAlias(this._property);
            Integer pixels = field.getPixels();
            this.initPixels(pixels == null ? (this._property == null ? 0 : this._property.getPixels()) : pixels);
            if (sqlAlias != null) {
                this.declare(sqlAlias, group);
                this.add();
            }
        }
    }

    private void initPixels(int pixels) {
        this._pixels = pixels;
        this._resizeable = pixels > 120;
    }

    private void declare(String name, ReportGroup group) {
        this.setDeclared(name, group);
    }

    private void add() {
        this._group.getFields().add(this);
        if (this._pixels > 0) {
            this._group.increaseVisibleFieldsCount();
        }
    }

    public int getIndex() {
        return this._group == null ? 0 : this._group.getFields().indexOf(this) + 1;
    }

    public int getCompositeIndex() {
        int groupIndex = this._group.getIndex();
        if (groupIndex < 0) {
            return -1;
        }
        int fieldIndex = this.getIndex();
        if (fieldIndex < 0) {
            return -1;
        }
        return 1000 * groupIndex + fieldIndex;
    }

    public String getLabel() {
        String etiqueta = this._property == null ? this.getName() : this._property.getDefaultShortLabel();
        return etiqueta == null ? null : StrUtils.getStringJava(etiqueta);
    }

    public Integer getSequence() {
        return this.getIndex();
    }

    public ReportGroup getReportGroup() {
        return this._group;
    }

    public Property getProperty() {
        return this._property;
    }

    public Property getParentProperty() {
        return this._parentProperty;
    }

    void setParentProperty(Property parent) {
        this._parentProperty = parent;
    }

    public ViewField getViewField() {
        return this._viewField;
    }

    public ViewFieldAggregation getAggregation() {
        return this._viewField == null ? null : this._viewField.getAggregation();
    }

    public int getPixels() {
        return this._pixels;
    }

    void setPixels(int pixels) {
        this._pixels = pixels;
    }

    public boolean isResizeable() {
        return this._resizeable;
    }

    void setResizeable(boolean resizeable) {
        this._resizeable = resizeable;
    }

    public String getDataClassName() {
        Entity entity = this._property instanceof Entity ? (Entity)((Object)this._property) : null;
        Property dataArtifact = entity != null ? entity.getPrimaryKeyProperty() : this._property;
        Class<?> dataClass = dataArtifact == null ? null : dataArtifact.getDataClass();
        return dataClass == null ? StringData.class.getSimpleName() : dataClass.getSimpleName();
    }

    public String getJavaClassName() {
        Entity entity = this._property instanceof Entity ? (Entity)((Object)this._property) : null;
        Property dataArtifact = entity != null ? entity.getPrimaryKeyProperty() : this._property;
        JavaProgrammer javaProgrammer = dataArtifact == null ? null : ChiefProgrammer.getJavaProgrammer();
        return javaProgrammer == null ? String.class.getName() : javaProgrammer.getJavaTypeName(dataArtifact);
    }

    public boolean aggregationAtHand(ViewFieldAggregation aggregation) {
        if (aggregation == null) {
            return false;
        }
        switch (aggregation) {
            case COUNT: {
                return this.isCountAtHand();
            }
            case MINIMUM: {
                return this.isMinAtHand();
            }
            case MAXIMUM: {
                return this.isMaxAtHand();
            }
            case SUM: {
                return this.isSumAtHand();
            }
            case AVERAGE: {
                return this.isAverageAtHand();
            }
            case DEVIATION: {
                return this.isDeviationAtHand();
            }
        }
        return false;
    }

    public boolean isCountAtHand() {
        ViewFieldAggregation aggregation = this.getAggregation();
        if (aggregation == null) {
            return false;
        }
        switch (aggregation) {
            case COUNT: 
            case COUNT_MINIMUM_MAXIMUM: 
            case SUM_COUNT_AVERAGE: 
            case SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM: {
                return true;
            }
        }
        return false;
    }

    public boolean isMinAtHand() {
        ViewFieldAggregation aggregation = this.getAggregation();
        if (aggregation == null) {
            return false;
        }
        switch (aggregation) {
            case MINIMUM: 
            case COUNT_MINIMUM_MAXIMUM: 
            case SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM: 
            case MINIMUM_MAXIMUM: 
            case AVERAGE_DEVIATION_MINIMUM_MAXIMUM: {
                return true;
            }
        }
        return false;
    }

    public boolean isMaxAtHand() {
        ViewFieldAggregation aggregation = this.getAggregation();
        if (aggregation == null) {
            return false;
        }
        switch (aggregation) {
            case MAXIMUM: 
            case COUNT_MINIMUM_MAXIMUM: 
            case SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM: 
            case MINIMUM_MAXIMUM: 
            case AVERAGE_DEVIATION_MINIMUM_MAXIMUM: {
                return true;
            }
        }
        return false;
    }

    public boolean isSumAtHand() {
        ViewFieldAggregation aggregation = this.getAggregation();
        if (aggregation == null) {
            return false;
        }
        switch (aggregation) {
            case SUM: 
            case SUM_COUNT_AVERAGE: 
            case SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM: {
                return true;
            }
        }
        return false;
    }

    public boolean isAverageAtHand() {
        ViewFieldAggregation aggregation = this.getAggregation();
        if (aggregation == null) {
            return false;
        }
        switch (aggregation) {
            case AVERAGE: 
            case SUM_COUNT_AVERAGE: 
            case SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM: 
            case AVERAGE_DEVIATION_MINIMUM_MAXIMUM: 
            case AVERAGE_DEVIATION: {
                return true;
            }
        }
        return false;
    }

    public boolean isDeviationAtHand() {
        ViewFieldAggregation aggregation = this.getAggregation();
        if (aggregation == null) {
            return false;
        }
        switch (aggregation) {
            case DEVIATION: 
            case SUM_COUNT_AVERAGE_DEVIATION_MINIMUM_MAXIMUM: 
            case AVERAGE_DEVIATION_MINIMUM_MAXIMUM: 
            case AVERAGE_DEVIATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(ReportField that) {
        return that == null ? 0 : this.getSequence().compareTo(that.getSequence());
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            string = (String)string + fee + tab + "pixels" + faa + this._pixels + foo;
            string = (String)string + fee + tab + "resizeable" + faa + this._resizeable + foo;
        }
        return string;
    }
}

