/*
 * Decompiled with CFR 0.152.
 */
package adalid.core;

import adalid.commons.util.ColorUtils;
import adalid.core.Operation;
import adalid.core.Project;
import adalid.core.Report;
import adalid.core.View;
import adalid.core.XS1;
import adalid.core.annotations.ReportOperationClass;
import adalid.core.enums.ReportChartType;
import adalid.core.enums.ReportFileType;
import adalid.core.enums.ReportQueryType;
import adalid.core.enums.SortOption;
import adalid.core.interfaces.Entity;
import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class ReportOperation
extends Operation {
    private static final Logger logger = Logger.getLogger(Operation.class);
    private boolean _annotatedWithReportOperationClass;
    private String _reportName;
    private String _viewName = "";
    private String _viewFieldName = "";
    private Field _viewField;
    private View _view;
    private ReportQueryType _queryType = ReportQueryType.DYNAMIC;
    private ReportFileType[] _fileTypes = new ReportFileType[]{ReportFileType.PDF};
    private int _rowsLimit = 10000;
    private int _detailRowsLimit = 10000;
    private int _summaryRowsLimit = 10000;
    private int _chartRowsLimit = 10000;
    private SortOption _sortOption = SortOption.ASC;
    private ReportChartType[] _chartTypes = new ReportChartType[]{ReportChartType.BAR};
    private final List<Color> _chartColorList = new ArrayList<Color>(Arrays.asList(ColorUtils.chartColorPalette()));
    private Report _report;

    @Override
    public boolean finalise() {
        boolean ok = super.finalise();
        if (ok) {
            this.checkChartTypes();
        }
        return ok;
    }

    private void checkChartTypes() {
        if (this._view != null && this._view.getPenultimateControlField() == null) {
            for (ReportChartType chartType : this._chartTypes) {
                if (!"seriesByGroup".equals(chartType.getJasperChartSubtype())) continue;
                logger.error((Object)("view of operation " + this.getFullName() + " does not have enough groups to generate series-by-group charts like " + chartType));
                Project.increaseParserErrorCount();
                break;
            }
        }
    }

    public boolean isAnnotatedWithReportOperationClass() {
        return this._annotatedWithReportOperationClass;
    }

    @Override
    public String getProperName() {
        return this._reportName;
    }

    public String getReportName() {
        return this._reportName;
    }

    public String getViewName() {
        return this._viewName;
    }

    public String getViewFieldName() {
        return this._viewFieldName;
    }

    public Field getViewField() {
        return this._viewField;
    }

    public View getView() {
        return this._view;
    }

    public ReportQueryType getQueryType() {
        return this._queryType;
    }

    public ReportFileType[] getFileTypes() {
        return this._fileTypes;
    }

    public List<ReportFileType> getFileTypesList() {
        return Arrays.asList(this._fileTypes);
    }

    public int getRowsLimit() {
        return this._rowsLimit;
    }

    public int getDetailRowsLimit() {
        return this._detailRowsLimit;
    }

    public int getSummaryRowsLimit() {
        return this._summaryRowsLimit;
    }

    public int getChartRowsLimit() {
        return this._chartRowsLimit;
    }

    public SortOption getSortOption() {
        return this._sortOption;
    }

    public ReportChartType[] getChartTypes() {
        return this._chartTypes;
    }

    public List<ReportChartType> getChartTypesList() {
        return Arrays.asList(this._chartTypes);
    }

    public List<Color> getChartColorList() {
        return this._chartColorList;
    }

    public void clearChartColorList() {
        this._chartColorList.clear();
    }

    public void addChartColor(Color ... colors) {
        this._chartColorList.addAll(Arrays.asList(colors));
    }

    public Report getOperationViewReport() {
        if (this._report == null && this._view != null) {
            this._report = new Report(this._view);
        }
        return this._report;
    }

    @Override
    public boolean isAsynchronous() {
        return true;
    }

    @Override
    void initializeAnnotations() {
        super.initializeAnnotations();
        this._reportName = StringUtils.defaultIfBlank((String)this._reportName, (String)this.getName());
    }

    @Override
    void annotate(Class<?> type) {
        super.annotate(type);
        if (type != null) {
            this.annotateReportOperationClass(type);
        }
    }

    @Override
    protected List<Class<? extends Annotation>> getValidTypeAnnotations() {
        List<Class<? extends Annotation>> valid = super.getValidTypeAnnotations();
        valid.add(ReportOperationClass.class);
        return valid;
    }

    private void annotateReportOperationClass(Class<?> type) {
        ReportOperationClass annotation;
        Class<?> annotatedClass = XS1.getAnnotatedClass(type, ReportOperationClass.class);
        if (annotatedClass != null && (annotation = annotatedClass.getAnnotation(ReportOperationClass.class)) != null) {
            String name = annotation.name();
            if (StringUtils.isNotBlank((String)name)) {
                this._reportName = name;
            }
            this._viewName = annotation.view();
            this._viewFieldName = annotation.viewField();
            this._queryType = annotation.type();
            this._fileTypes = annotation.fileTypes();
            this._rowsLimit = Math.max(0, annotation.rowsLimit());
            this._detailRowsLimit = Math.max(0, annotation.detailRowsLimit());
            this._summaryRowsLimit = Math.max(0, annotation.summaryRowsLimit());
            this._chartRowsLimit = Math.max(0, annotation.chartRowsLimit());
            this._sortOption = annotation.sortOption();
            this._chartTypes = annotation.chartTypes();
            this._annotatedWithReportOperationClass = true;
            if (StringUtils.isNotBlank((String)this._viewFieldName)) {
                ReportOperation declaringOperation = this;
                Entity declaringEntity = declaringOperation.getDeclaringEntity();
                Class[] validTypes = new Class[]{View.class};
                Object[] strings = new String[]{declaringOperation.getName(), this.getName(), "viewField"};
                String role = StringUtils.join((Object[])strings, (String)".");
                this._viewField = XS1.getField(true, role, this._viewFieldName, declaringEntity.getClass(), Entity.class, validTypes);
                if (this._viewField != null) {
                    this._view = XS1.getView(this._viewField, declaringEntity);
                }
            }
        }
    }
}

