/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.data.types;

import adalid.core.primitives.NumericPrimitive;
import java.math.BigDecimal;

public abstract class AbstractBigNumber
extends NumericPrimitive {
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    private int _precision = -1;
    private int _scale = -1;

    public int getRawPrecision() {
        return this._precision;
    }

    public int getRawScale() {
        return this._scale;
    }

    public int getPrecision() {
        int d = 16;
        int m = 60;
        int p = this._precision < 1 ? 16 : (this._precision > 60 ? 60 : this._precision);
        return p;
    }

    public void setPrecision(int precision) {
        this.checkScope();
        this._precision = precision;
        this.setMinMaxNumbers();
    }

    public int getScale() {
        int d = 2;
        int p = this.getPrecision();
        int s = this._scale < 0 ? (p > 2 ? 2 : p) : (this._scale > p ? p : this._scale);
        return s;
    }

    void setScale(int scale) {
        this._scale = scale;
        this.setMinMaxNumbers();
    }

    void setMinMaxNumbers() {
        int p = this.getPrecision();
        int s = this.getScale();
        BigDecimal one = BigDecimal.ONE.divide(BigDecimal.TEN.pow(s));
        BigDecimal max = BigDecimal.TEN.pow(p - s).subtract(one);
        BigDecimal min = BigDecimal.ZERO.subtract(max);
        this.setMinNumber(min);
        this.setMaxNumber(max);
    }
}

