/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.data.types;

import adalid.core.XS2;
import adalid.core.enums.AvatarDefault;
import adalid.core.enums.AvatarShape;
import adalid.core.enums.FetchType;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.primitives.BinaryPrimitive;

public class BinaryData
extends BinaryPrimitive {
    public static final String EMPTY = "";
    private int _largeDisplayWidth;
    private int _largeDisplayHeight;
    private int _mediumDisplayWidth;
    private int _mediumDisplayHeight;
    private int _smallDisplayWidth;
    private int _smallDisplayHeight;
    private FetchType _fetchType;
    private AvatarShape _avatarShape;
    private AvatarDefault _avatarDefault;
    private int _avatarWidth;
    private int _avatarHeight;
    private boolean _resizable;

    public BinaryData() {
        XS2.setDataClass(this, BinaryData.class);
        XS2.setDataType(this, byte[].class);
        this._largeDisplayWidth = 288;
        this._largeDisplayHeight = 288;
        this._mediumDisplayWidth = 192;
        this._mediumDisplayHeight = 192;
        this._smallDisplayWidth = 96;
        this._smallDisplayHeight = 96;
        this._fetchType = FetchType.EAGER;
        this._avatarShape = AvatarShape.NONE;
        this._avatarDefault = AvatarDefault.NONE;
        this._avatarWidth = 36;
        this._avatarHeight = 36;
        this._resizable = true;
    }

    public int getLargeDisplayWidth() {
        return this._largeDisplayWidth;
    }

    public void setLargeDisplayWidth(int width) {
        this.checkScope();
        this._largeDisplayWidth = width;
    }

    public int getLargeDisplayHeight() {
        return this._largeDisplayHeight;
    }

    public void setLargeDisplayHeight(int height) {
        this.checkScope();
        this._largeDisplayHeight = height;
    }

    public int getMediumDisplayWidth() {
        return this._mediumDisplayWidth;
    }

    public void setMediumDisplayWidth(int width) {
        this.checkScope();
        this._mediumDisplayWidth = width;
    }

    public int getMediumDisplayHeight() {
        return this._mediumDisplayHeight;
    }

    public void setMediumDisplayHeight(int height) {
        this.checkScope();
        this._mediumDisplayHeight = height;
    }

    public int getSmallDisplayWidth() {
        return this._smallDisplayWidth;
    }

    public void setSmallDisplayWidth(int width) {
        this.checkScope();
        this._smallDisplayWidth = width;
    }

    public int getSmallDisplayHeight() {
        return this._smallDisplayHeight;
    }

    public void setSmallDisplayHeight(int height) {
        this.checkScope();
        this._smallDisplayHeight = height;
    }

    public int[] getDisplayWidth() {
        return new int[]{this._largeDisplayWidth, this._mediumDisplayWidth, this._smallDisplayWidth};
    }

    public int[] getDisplayHeight() {
        return new int[]{this._largeDisplayHeight, this._mediumDisplayHeight, this._smallDisplayHeight};
    }

    public FetchType getFetchType() {
        return this._fetchType;
    }

    public void setFetchType(FetchType fetchType) {
        this._fetchType = fetchType;
    }

    public CharacterExpression fileReferenceCalculableValueExpression() {
        return this.isNotNull().then(this.getName());
    }

    @Override
    protected boolean isImplicitOverlayImageProperty() {
        return super.isImplicitOverlayImageProperty() && AvatarShape.NONE.equals((Object)this._avatarShape);
    }

    public AvatarShape getAvatarShape() {
        return this._avatarShape;
    }

    public void setAvatarShape(AvatarShape shape) {
        this.checkScope();
        this._avatarShape = shape == null ? AvatarShape.NONE : shape;
    }

    public AvatarDefault getAvatarDefault() {
        return this._avatarDefault;
    }

    public void setAvatarDefault(AvatarDefault defaultAvatar) {
        this.checkScope();
        this._avatarDefault = defaultAvatar == null ? AvatarDefault.NONE : defaultAvatar;
    }

    public int getAvatarWidth() {
        return this._avatarWidth;
    }

    public void setAvatarWidth(int size) {
        this.checkScope();
        this._avatarWidth = size < 24 || size > 96 ? 36 : size;
    }

    public int getAvatarHeight() {
        return this._avatarHeight;
    }

    public void setAvatarHeight(int size) {
        this.checkScope();
        this._avatarHeight = size < 24 || size > 96 ? 36 : size;
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void setResizable(boolean resizable) {
        this.checkScope();
        this._resizable = resizable;
    }
}

