/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.expressions;

import adalid.core.AbstractExpression;
import adalid.core.enums.ScalarOp;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NamedValue;
import adalid.core.interfaces.NaryExpression;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.ScalarX;
import adalid.core.interfaces.TemporalExpression;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractScalarX
extends AbstractExpression
implements ScalarX {
    private static final String EOL = "\n";
    private final ScalarOp _operator;
    private final Object _operand;

    protected AbstractScalarX(ScalarOp operator, Object operand) {
        this._operator = operator;
        this._operand = operand;
        this.initDataType();
    }

    @Override
    public ScalarOp getOperator() {
        return this._operator;
    }

    @Override
    public Object[] getOperands() {
        Object[] objectArray;
        if (this._operand == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this._operand;
        }
        return objectArray;
    }

    @Override
    public Object getOperand() {
        return this._operand;
    }

    @Override
    public Expression unwrapBooleanExpression() {
        if (this._operator != null && this._operand instanceof BooleanExpression) {
            switch (this._operator) {
                case TO_BOOLEAN: {
                    return (BooleanExpression)this._operand;
                }
            }
        }
        return this;
    }

    @Override
    public Expression unwrapCharacterExpression() {
        if (this._operator != null && this._operand instanceof CharacterExpression) {
            switch (this._operator) {
                case TO_CHARACTER: 
                case TO_STRING: {
                    return (CharacterExpression)this._operand;
                }
            }
        }
        return this;
    }

    @Override
    public Expression unwrapNumericExpression() {
        if (this._operator != null && this._operand instanceof NumericExpression) {
            switch (this._operator) {
                case TO_BYTE: 
                case TO_SHORT: 
                case TO_INTEGER: 
                case TO_LONG: 
                case TO_FLOAT: 
                case TO_DOUBLE: 
                case TO_BIG_INTEGER: 
                case TO_BIG_DECIMAL: {
                    return (NumericExpression)this._operand;
                }
            }
        }
        return this;
    }

    @Override
    public Expression unwrapTemporalExpression() {
        if (this._operator != null && this._operand instanceof TemporalExpression) {
            switch (this._operator) {
                case TO_DATE: 
                case TO_TIME: 
                case TO_TIMESTAMP: {
                    return (TemporalExpression)this._operand;
                }
            }
        }
        return this;
    }

    @Override
    public Expression unwrapValueExpression() {
        if (this._operator != null) {
            if (this._operand instanceof BooleanExpression) {
                return this.unwrapBooleanExpression();
            }
            if (this._operand instanceof CharacterExpression) {
                return this.unwrapCharacterExpression();
            }
            if (this._operand instanceof NumericExpression) {
                return this.unwrapNumericExpression();
            }
            if (this._operand instanceof TemporalExpression) {
                return this.unwrapTemporalExpression();
            }
        }
        return this;
    }

    protected static ScalarX coalesceDataType(ScalarX ... scalarX) {
        if (scalarX != null) {
            for (ScalarX sx : scalarX) {
                if (sx == null || sx.getDataType() == null) continue;
                return sx;
            }
        }
        return null;
    }

    private void initDataType() {
        if (this._operator == null) {
            this.copyDataType(this._operand);
        } else {
            switch (this._operator) {
                case SELF: 
                case DEFAULT_WHEN_NULL: 
                case NULL_WHEN_DEFAULT: {
                    this.copyDataType(this._operand);
                    break;
                }
                case NOT: {
                    this.setDataType(Boolean.class);
                    break;
                }
                case ASCII: 
                case DIACRITICLESS: 
                case DIACRITICLESS_ASCII: 
                case LOWER: 
                case UPPER: 
                case CAPITALIZE: 
                case UNCAPITALIZE: 
                case TRIM: 
                case LTRIM: 
                case RTRIM: {
                    this.setDataType(String.class);
                    break;
                }
                case MODULUS: 
                case OPPOSITE: {
                    this.copyDataType(this._operand);
                    break;
                }
                case RECIPROCAL: {
                    this.setDataType(BigDecimal.class);
                    break;
                }
                case YEAR: 
                case MONTH: 
                case DAY: 
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    this.setDataType(Integer.class);
                    break;
                }
                case FIRST_DATE_OF_MONTH: 
                case FIRST_DATE_OF_QUARTER: 
                case FIRST_DATE_OF_SEMESTER: 
                case FIRST_DATE_OF_YEAR: 
                case LAST_DATE_OF_MONTH: 
                case LAST_DATE_OF_QUARTER: 
                case LAST_DATE_OF_SEMESTER: 
                case LAST_DATE_OF_YEAR: {
                    this.setDataType(Date.class);
                    break;
                }
                case TO_BOOLEAN: {
                    this.setDataType(Boolean.class);
                    break;
                }
                case TO_CHARACTER: {
                    this.setDataType(Character.class);
                    break;
                }
                case TO_STRING: 
                case TO_LOCALE_STRING: {
                    this.setDataType(String.class);
                    break;
                }
                case TO_BYTE: {
                    this.setDataType(Byte.class);
                    break;
                }
                case TO_SHORT: {
                    this.setDataType(Short.class);
                    break;
                }
                case TO_INTEGER: {
                    this.setDataType(Integer.class);
                    break;
                }
                case TO_LONG: {
                    this.setDataType(Long.class);
                    break;
                }
                case TO_FLOAT: {
                    this.setDataType(Float.class);
                    break;
                }
                case TO_DOUBLE: {
                    this.setDataType(Double.class);
                    break;
                }
                case TO_BIG_INTEGER: {
                    this.setDataType(BigInteger.class);
                    break;
                }
                case TO_BIG_DECIMAL: {
                    this.setDataType(BigDecimal.class);
                    break;
                }
                case TO_DATE: {
                    this.setDataType(Date.class);
                    break;
                }
                case TO_TIME: {
                    this.setDataType(Time.class);
                    break;
                }
                case TO_TIMESTAMP: {
                    this.setDataType(Timestamp.class);
                    break;
                }
                default: {
                    this.copyDataType(this._operand);
                }
            }
        }
    }

    @Override
    public String toString() {
        String nombre = this._operand instanceof NamedValue ? ((NamedValue)this._operand).name() : null;
        return nombre != null && (this._operator == null || this._operator.equals(ScalarOp.SELF)) ? nombre : super.toString();
    }

    @Override
    protected String fieldsToString(int n, String key, boolean verbose, boolean fields, boolean maps) {
        String tab = verbose ? StringUtils.repeat((String)" ", (int)4) : "";
        String fee = verbose ? StringUtils.repeat((String)tab, (int)n) : "";
        String faa = " = ";
        String foo = verbose ? EOL : ", ";
        Object string = super.fieldsToString(n, key, verbose, fields, maps);
        if ((fields || verbose) && verbose) {
            if (this._operator != null) {
                string = (String)string + fee + tab + "operator" + faa + this._operator + foo;
            }
            if (this._operand instanceof NaryExpression) {
                Expression valor = (Expression)this._operand;
                string = (String)string + valor.toString(n + 1, "operand");
            } else {
                string = (String)string + fee + tab + "operand" + faa + this.getValueString(this._operand) + foo;
            }
        }
        return string;
    }
}

