/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.jee;

import adalid.commons.util.ColUtils;
import adalid.core.DisplaySet;
import adalid.core.Page;
import adalid.core.comparators.ByEntityName;
import adalid.core.comparators.ByPageName;
import adalid.core.enums.DisplayFormat;
import adalid.core.enums.DisplayMode;
import adalid.core.enums.EntityViewType;
import adalid.core.enums.MasterDetailView;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EntityReference;
import adalid.core.interfaces.Property;
import adalid.core.jee.AbstractJavaModule;
import adalid.core.jee.ConsoleJavaServerPage;
import adalid.core.jee.CrudJavaServerPage;
import adalid.core.jee.JavaModuleType;
import adalid.core.jee.JavaWebModule;
import adalid.core.predicates.IsConsoleViewDisplay;
import adalid.core.predicates.IsPersistentEntityWithTable;
import adalid.core.predicates.IsProcessingDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractJavaWebModule
extends AbstractJavaModule
implements JavaWebModule {
    private static final Logger logger = Logger.getLogger(JavaWebModule.class);
    private static final String BY = "Por";
    private final Map<String, Page> _pages = new LinkedHashMap<String, Page>();
    private final Map<String, DisplaySet> _pageSets = new LinkedHashMap<String, DisplaySet>();
    private final Map<String, Entity> _displayableEntities = new LinkedHashMap<String, Entity>();

    public AbstractJavaWebModule() {
        this.init();
    }

    private void init() {
        this.setModuleType(JavaModuleType.WEB);
    }

    @Override
    protected boolean assemble() {
        boolean compiled = super.assemble();
        if (compiled) {
            this.buildPagesMap();
            this.buildPageSetsMap();
            this.buildDisplayableEntitiesMap();
        }
        return compiled;
    }

    public List<Page> getDisplaysList() {
        return this.getPagesList();
    }

    public Map<String, Page> getDisplaysMap() {
        return this.getPagesMap();
    }

    @Override
    public List<Page> getPagesList() {
        return new ArrayList<Page>(this.getPagesMap().values());
    }

    public Map<String, Page> getPagesMap() {
        return this._pages;
    }

    @Override
    public List<DisplaySet> getPageSetsList() {
        return new ArrayList<DisplaySet>(this.getPageSetsMap().values());
    }

    public Map<String, DisplaySet> getPageSetsMap() {
        return this._pageSets;
    }

    @Override
    public List<Entity> getDisplayableEntitiesList() {
        return new ArrayList<Entity>(this.getDisplayableEntitiesMap().values());
    }

    public Map<String, Entity> getDisplayableEntitiesMap() {
        return this._displayableEntities;
    }

    private void buildPagesMap() {
        this._pages.clear();
        IsPersistentEntityWithTable isPersistentEntityWithTable = new IsPersistentEntityWithTable();
        ByEntityName byEntityName = new ByEntityName();
        List<Entity> entities = this.getEntitiesList();
        Collection<Entity> validEntities = ColUtils.filter(entities, (Predicate)isPersistentEntityWithTable);
        validEntities = ColUtils.sort(validEntities, byEntityName);
        for (Entity entity : validEntities) {
            if (!entity.isGuiCodeGenEnabled()) continue;
            this.put(entity);
        }
    }

    private void buildPageSetsMap() {
        this._pageSets.clear();
        List<Page> pagesList = this.getPagesList();
        for (Page page : pagesList) {
            DisplaySet set;
            DisplayFormat format;
            DisplayMode mode = page.getDisplayMode();
            if (!DisplayMode.READING.equals((Object)mode) && !DisplayMode.WRITING.equals((Object)mode) || !DisplayFormat.TABLE.equals((Object)(format = page.getDisplayFormat())) && !DisplayFormat.DETAIL.equals((Object)format)) continue;
            String pageName = page.getName();
            Entity entity = page.getEntity();
            EntityReference reference = page.getReference();
            Entity master = page.getMaster();
            String pageSetName = this.pageSetName(entity, reference);
            if (this._pageSets.containsKey(pageSetName)) {
                set = this._pageSets.get(pageSetName);
                set.getDisplaysMap().put(pageName, page);
                page.setDisplaySet(set);
                continue;
            }
            set = new DisplaySet(pageSetName);
            set.setEntity(entity);
            set.setReference(reference);
            set.setMaster(master);
            set.getDisplaysMap().put(pageName, page);
            this._pageSets.put(pageSetName, set);
            page.setDisplaySet(set);
        }
    }

    private void buildDisplayableEntitiesMap() {
        List<Page> list = this.getPagesList();
        IsConsoleViewDisplay isConsoleViewDisplay = new IsConsoleViewDisplay();
        IsProcessingDisplay isProcessingDisplay = new IsProcessingDisplay();
        ByPageName byPageName = new ByPageName();
        Collection<Page> pages = ColUtils.noneFilter(list, isConsoleViewDisplay, isProcessingDisplay);
        Collection<Page> sortedPages = ColUtils.sort(pages, byPageName);
        this._displayableEntities.clear();
        for (Page page : sortedPages) {
            Entity master;
            Entity entity = page.getEntity();
            if (entity != null) {
                this._displayableEntities.put(entity.getName(), entity);
            }
            if ((master = page.getMaster()) == null) continue;
            this._displayableEntities.put(master.getName(), master);
        }
    }

    private void put(Entity entity) {
        this.putReadingPages(entity);
        this.putWritingPages(entity);
        this.putConsolePages(entity);
        List<Property> properties = entity.getReferencesList();
        for (Property property : properties) {
            Class<?> declaring;
            Entity detail;
            EntityReference reference = (EntityReference)property;
            if (!reference.isManyToOne() && !reference.isOneToOne() || (detail = (declaring = reference.getDeclaringEntity().getClass()) == null ? null : this.getEntity(declaring)) == null) continue;
            this.putMasterDetailPages(detail, reference, entity);
        }
    }

    private boolean putReadingPages(Entity entity) {
        EntityViewType entityViewType;
        boolean put = false;
        if (entity.isSelectEnabled() && (EntityViewType.INDEPENDENT.equals((Object)(entityViewType = entity.getEntityViewType())) || EntityViewType.BOTH.equals((Object)entityViewType))) {
            if (entity.isTableViewEnabled()) {
                put |= this.putPage(entity, DisplayMode.READING, DisplayFormat.TABLE);
            }
            if (entity.isDetailViewEnabled()) {
                put |= this.putPage(entity, DisplayMode.READING, DisplayFormat.DETAIL);
            }
            if (entity.isTreeViewEnabled() && entity.getParentProperty() != null) {
                put |= this.putPage(entity, DisplayMode.READING, DisplayFormat.TREE);
            }
        }
        return put;
    }

    private boolean putWritingPages(Entity entity) {
        EntityViewType entityViewType;
        boolean put = false;
        if ((entity.isInsertEnabled() || entity.isUpdateEnabled() || entity.isDeleteEnabled() || entity.isWritingPageMaster()) && (EntityViewType.INDEPENDENT.equals((Object)(entityViewType = entity.getEntityViewType())) || EntityViewType.BOTH.equals((Object)entityViewType))) {
            if (entity.isTableViewEnabled()) {
                put |= this.putPage(entity, DisplayMode.WRITING, DisplayFormat.TABLE);
            }
            if (entity.isDetailViewEnabled()) {
                put |= this.putPage(entity, DisplayMode.WRITING, DisplayFormat.DETAIL);
            }
            if (entity.isTreeViewEnabled() && entity.getParentProperty() != null) {
                put |= this.putPage(entity, DisplayMode.WRITING, DisplayFormat.TREE);
            }
        }
        return put;
    }

    private boolean putConsolePages(Entity entity) {
        boolean put = false;
        if (entity.isConsoleViewEnabled() && !entity.getBusinessOperationsList().isEmpty()) {
            put |= this.putPage(entity, DisplayMode.PROCESSING, DisplayFormat.CONSOLE);
        }
        return put;
    }

    private boolean putMasterDetailPages(Entity detail, EntityReference reference, Entity master) {
        EntityViewType entityViewType;
        boolean put = false;
        if (detail.isGuiCodeGenEnabled() && (EntityViewType.MASTER_DETAIL.equals((Object)(entityViewType = detail.getEntityViewType())) || EntityViewType.BOTH.equals((Object)entityViewType))) {
            if (reference.isOneToOne() && reference.isOneToOneDetailView()) {
                if (detail.isSelectEnabled()) {
                    put |= this.putPage(detail, reference, master, DisplayMode.READING, DisplayFormat.DETAIL);
                }
                if (detail.isInsertEnabled() || detail.isUpdateEnabled() || detail.isDeleteEnabled()) {
                    put |= this.putPage(detail, reference, master, DisplayMode.WRITING, DisplayFormat.DETAIL);
                }
            }
            if (reference.isManyToOne()) {
                MasterDetailView masterDetailView = reference.getMasterDetailView();
                if (detail.isSelectEnabled()) {
                    switch (masterDetailView) {
                        case TABLE: {
                            put |= this.putPage(detail, reference, master, DisplayMode.READING, DisplayFormat.TABLE);
                            break;
                        }
                        case TABLE_AND_DETAIL: {
                            put |= this.putPage(detail, reference, master, DisplayMode.READING, DisplayFormat.TABLE);
                            put |= this.putPage(detail, reference, master, DisplayMode.READING, DisplayFormat.DETAIL);
                        }
                    }
                }
                if (detail.isInsertEnabled() || detail.isUpdateEnabled() || detail.isDeleteEnabled()) {
                    switch (masterDetailView) {
                        case TABLE: {
                            put |= this.putPage(detail, reference, master, DisplayMode.WRITING, DisplayFormat.TABLE);
                            break;
                        }
                        case TABLE_AND_DETAIL: {
                            put |= this.putPage(detail, reference, master, DisplayMode.WRITING, DisplayFormat.TABLE);
                            put |= this.putPage(detail, reference, master, DisplayMode.WRITING, DisplayFormat.DETAIL);
                        }
                    }
                }
            }
        }
        return put;
    }

    private boolean putPage(Entity entity, DisplayMode mode, DisplayFormat format) {
        return this.putPage(entity, null, null, mode, format);
    }

    private boolean putPage(Entity entity, EntityReference reference, Entity master, DisplayMode mode, DisplayFormat format) {
        String pageName = this.pageName(entity, reference, mode, format);
        Page page = switch (format) {
            case DisplayFormat.TABLE, DisplayFormat.DETAIL, DisplayFormat.TREE -> new CrudJavaServerPage(pageName);
            case DisplayFormat.CONSOLE -> new ConsoleJavaServerPage(pageName);
            default -> new Page(pageName);
        };
        page.setModule(this);
        page.setEntity(entity);
        page.setReference(reference);
        page.setMaster(master);
        page.setDisplayMode(mode);
        page.setDisplayFormat(format);
        if (entity != null && master != null && reference != null) {
            page.setMasterDetailViewSequence(reference.getMasterDetailViewSequence());
        }
        this._pages.put(pageName, page);
        return true;
    }

    private String pageName(Entity entity, EntityReference reference, DisplayMode mode, DisplayFormat format) {
        String name = entity.getName() + mode.ordinal() + format.ordinal();
        if (reference != null) {
            name = name + BY + StringUtils.capitalize((String)reference.getName());
        }
        logger.debug((Object)("page=" + name));
        return name;
    }

    private String pageSetName(Entity entity, EntityReference reference) {
        Object name = entity.getName();
        if (reference != null) {
            name = (String)name + BY + StringUtils.capitalize((String)reference.getName());
        }
        logger.debug((Object)("pageset=" + (String)name));
        return name;
    }
}

