/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.programmers;

import adalid.commons.util.BitUtils;
import adalid.commons.util.IntUtils;
import adalid.commons.util.StrUtils;
import adalid.commons.util.TimeUtils;
import adalid.core.Primitive;
import adalid.core.Project;
import adalid.core.TLC;
import adalid.core.TemporalAddend;
import adalid.core.data.types.BigDecimalData;
import adalid.core.data.types.BigIntegerData;
import adalid.core.data.types.BinaryData;
import adalid.core.data.types.BooleanData;
import adalid.core.data.types.ByteData;
import adalid.core.data.types.CharacterData;
import adalid.core.data.types.DateData;
import adalid.core.data.types.DoubleData;
import adalid.core.data.types.FloatData;
import adalid.core.data.types.IntegerData;
import adalid.core.data.types.LongData;
import adalid.core.data.types.ShortData;
import adalid.core.data.types.StringData;
import adalid.core.data.types.TimeData;
import adalid.core.data.types.TimestampData;
import adalid.core.enums.ComparisonOp;
import adalid.core.enums.DataAggregateOp;
import adalid.core.enums.NaryVectorOp;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OrderedPairOp;
import adalid.core.enums.ScalarOp;
import adalid.core.enums.SqlQualifierType;
import adalid.core.expressions.XB;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.BooleanExpression;
import adalid.core.interfaces.CalculableProperty;
import adalid.core.interfaces.CharacterExpression;
import adalid.core.interfaces.DataAggregateX;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Expression;
import adalid.core.interfaces.NaryVectorX;
import adalid.core.interfaces.NumericExpression;
import adalid.core.interfaces.Operator;
import adalid.core.interfaces.OrderedPairX;
import adalid.core.interfaces.PersistentEntityReference;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.ScalarX;
import adalid.core.interfaces.TemporalExpression;
import adalid.core.primitives.BooleanPrimitive;
import adalid.core.programmers.AbstractSqlProgrammer;
import adalid.core.programmers.ParameterizedExpression;
import adalid.core.properties.IntegerProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OracleProgrammer
extends AbstractSqlProgrammer {
    private static final Logger logger = Logger.getLogger(OracleProgrammer.class);
    private static final String ORACLE_VERSION = "oracle.version";
    private final String[] NEVER_NULL = new String[]{"current_user", "current_user_code()", "current_user_id()", "current_date", "current_time", "current_timestamp", "localtimestamp"};
    protected static final boolean AVOID_LONG_IDENTIFIERS = BitUtils.valueOf(bootstrapping.getString("oracle.database.avoid.long.identifiers", "false"));
    protected static final boolean NATIONAL_CHARACTER_SET = BitUtils.valueOf(bootstrapping.getString("oracle.database.national.character.set", "false"));
    protected static final boolean EXTENDED_MAX_STRING_SIZE = BitUtils.valueOf(bootstrapping.getString("oracle.database.extended.max.string.size", "false"));
    protected static final int MAX_DECIMAL_DIGITS = 38;
    protected static final int MAX_UNICODE_LENGTH = EXTENDED_MAX_STRING_SIZE ? 16383 : 2000;
    protected static final int MAX_NON_UNI_LENGTH = EXTENDED_MAX_STRING_SIZE ? Short.MAX_VALUE : 4000;
    protected static final int MAX_VARCHAR_LENGTH = NATIONAL_CHARACTER_SET ? MAX_UNICODE_LENGTH : MAX_NON_UNI_LENGTH;
    private int maxIdentifierLength;
    protected static final String BINARY = "blob";
    protected static final String BOOLEANX = "varchar2";
    protected static final String BOOLEAN = "varchar2(5)";
    protected static final String CHARX = NATIONAL_CHARACTER_SET ? "nchar" : "char";
    protected static final String CHAR = CHARX + "(1)";
    protected static final String VARCHARX = NATIONAL_CHARACTER_SET ? "nvarchar2" : "varchar2";
    protected static final String VARCHAR = VARCHARX + "({0})";
    protected static final String TEXT = VARCHARX + "(" + MAX_VARCHAR_LENGTH + ")";
    protected static final String CLOB = NATIONAL_CHARACTER_SET ? "nclob" : "clob";
    protected static final String BYTE = "number(3)";
    protected static final String SMALLINT = "number(5)";
    protected static final String INTEGER = "number(10)";
    protected static final String LONG = "number(19)";
    protected static final String FLOAT = "number";
    protected static final String DOUBLE = "number";
    protected static final String BIGINT = "number({0})";
    protected static final String DECIMAL = "number({0},{1})";
    protected static final String NUMERIC = "number";
    protected static final String DATE = "date";
    protected static final String TIMEX = "timestamp";
    protected static final String TIME = "timestamp({0})";
    protected static final String TIMESTAMPX = "timestamp";
    protected static final String TIMESTAMP = "timestamp({0})";
    protected static final String RECORD = "record";
    protected static final String VOID = "void";
    private static final String YM_INTERVAL_ADDEND_PATTERN = "{0} {1} TO_YMINTERVAL(''{2}-{3}'')";
    private static final String DS_INTERVAL_ADDEND_PATTERN = "{0} {1} TO_DSINTERVAL(''{2} {3}:{4}:{5}'')";

    @Override
    public String getDBMS() {
        return "Oracle";
    }

    @Override
    protected String[] neverNull() {
        return this.NEVER_NULL;
    }

    @Override
    protected boolean validExpressionOperator(ComparisonOp operator) {
        switch (operator) {
            case IS_NULL: 
            case IS_NOT_NULL: 
            case IS_NULL_OR_TRUE: 
            case IS_NULL_OR_FALSE: 
            case IS_NULL_OR_EQ: 
            case IS_NULL_OR_NEQ: 
            case IS_NULL_OR_GT: 
            case IS_NULL_OR_LTEQ: 
            case IS_NULL_OR_GTEQ: 
            case IS_NULL_OR_LT: 
            case IS_NULL_OR_STARTS_WITH: 
            case IS_NULL_OR_NOT_STARTS_WITH: 
            case IS_NULL_OR_CONTAINS: 
            case IS_NULL_OR_NOT_CONTAINS: 
            case IS_NULL_OR_ENDS_WITH: 
            case IS_NULL_OR_NOT_ENDS_WITH: 
            case IS_NULL_OR_IN: 
            case IS_NULL_OR_NOT_IN: 
            case IS_NULL_OR_BETWEEN: 
            case IS_NULL_OR_NOT_BETWEEN: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected String primitiveIsTruePattern() {
        return "{0} = 'true'";
    }

    @Override
    protected String primitiveIsFalsePattern() {
        return "{0} = 'false'";
    }

    @Override
    protected String getRestricted() {
        return null;
    }

    @Override
    protected String getCascade() {
        return "cascade";
    }

    @Override
    protected String getNullify() {
        return "set null";
    }

    @Override
    protected String getNoAction() {
        return null;
    }

    @Override
    protected String getTrue() {
        return "'true'";
    }

    @Override
    protected String getFalse() {
        return "'false'";
    }

    @Override
    protected String getCurrentDate() {
        return "current_date";
    }

    @Override
    protected String getCurrentTime() {
        return "localtimestamp";
    }

    @Override
    protected String getCurrentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public int getMaxIdentifierLength() {
        if (this.maxIdentifierLength == 0) {
            if (AVOID_LONG_IDENTIFIERS) {
                this.maxIdentifierLength = 30;
            } else {
                Object version;
                Project project = TLC.getProject();
                if (project != null && StringUtils.isNotBlank((String)(version = project.getEnvironmentVariable(ORACLE_VERSION)))) {
                    version = this.dottedVersionNumber((String)version);
                    int major = IntUtils.valueOf(StringUtils.substringBefore((String)(version = (String)version + ".0.0"), (String)"."), (Integer)0);
                    if (major > 0) {
                        int minor = IntUtils.valueOf(StringUtils.substringBetween((String)version, (String)"."), (Integer)0);
                        this.maxIdentifierLength = major < 12 || major == 12 && minor < 2 ? 30 : 128;
                        logger.info((Object)("oracle.version.max.identifier.length=" + this.maxIdentifierLength));
                        return this.maxIdentifierLength;
                    }
                }
                return 30;
            }
        }
        return this.maxIdentifierLength;
    }

    private String dottedVersionNumber(String version) {
        String v1 = version.trim().toLowerCase();
        logger.info((Object)("oracle.version=" + v1));
        String v2 = StrUtils.getOracleVersionNumber(v1);
        if (v1.equals(v2)) {
            return v1;
        }
        logger.info((Object)("oracle.version=" + v2));
        return v2;
    }

    @Override
    public int getMaxVarcharLength() {
        return MAX_VARCHAR_LENGTH;
    }

    @Override
    protected String getVariablesPrefix() {
        return "x$";
    }

    @Override
    protected String getVariablesSuffix() {
        return "";
    }

    @Override
    public String getString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return TimeUtils.jdbcTimestampString(obj);
        }
        return super.getString(obj);
    }

    @Override
    public String getDelimitedString(Object obj) {
        String string = this.getString(obj);
        if (string == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? this.getTrue() : this.getFalse();
        }
        if (obj instanceof String) {
            return "'" + string + "'";
        }
        if (obj instanceof Date) {
            return "date'" + string + "'";
        }
        if (obj instanceof Time) {
            return "timestamp'" + string + "'";
        }
        if (obj instanceof java.util.Date) {
            return "timestamp'" + string + "'";
        }
        return super.getDelimitedString(obj);
    }

    @Override
    public String getDelimitedString(TemporalAddend addend) {
        String base;
        if (addend == null || addend.isBadValue()) {
            return null;
        }
        int anys = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int quantity = addend.getQuantity();
        int absolute = Math.abs(quantity);
        char sign = quantity < 0 ? (char)'-' : '+';
        char unit = addend.getUnitCode();
        boolean b = false;
        switch (unit) {
            case 'A': 
            case 'Y': {
                base = "CURRENT_DATE";
                anys = absolute;
                b = true;
                break;
            }
            case 'M': {
                base = "CURRENT_DATE";
                anys = absolute / 12;
                months = absolute % 12;
                b = true;
                break;
            }
            case 'D': {
                base = "CURRENT_DATE";
                days = absolute;
                break;
            }
            case 'h': {
                base = "LOCALTIMESTAMP";
                days = absolute / 24;
                hours = absolute % 24;
                break;
            }
            case 'm': {
                base = "LOCALTIMESTAMP";
                days = absolute / 1440;
                int remainder = absolute % 1440;
                hours = remainder / 60;
                minutes = remainder % 60;
                break;
            }
            case 's': {
                base = "LOCALTIMESTAMP";
                days = absolute / 86400;
                int remainder = absolute % 86400;
                hours = remainder / 3600;
                minutes = (remainder %= 3600) / 60;
                seconds = remainder % 60;
                break;
            }
            default: {
                return null;
            }
        }
        String string = absolute == 0 ? base : (b ? MessageFormat.format(YM_INTERVAL_ADDEND_PATTERN, base, Character.valueOf(sign), "" + anys, months) : MessageFormat.format(DS_INTERVAL_ADDEND_PATTERN, base, Character.valueOf(sign), "" + days, hours, minutes, seconds));
        return absolute == 0 ? string : StrUtils.encloseSqlExpression(string);
    }

    @Override
    public String getSqlParameterType(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (artifact instanceof BinaryData) {
            return BINARY;
        }
        if (artifact instanceof BooleanData) {
            return BOOLEANX;
        }
        if (artifact instanceof CharacterData) {
            return CHARX;
        }
        if (artifact instanceof StringData) {
            return VARCHARX;
        }
        if (artifact instanceof ByteData) {
            return "number";
        }
        if (artifact instanceof ShortData) {
            return "number";
        }
        if (artifact instanceof IntegerData) {
            return "number";
        }
        if (artifact instanceof LongData) {
            return "number";
        }
        if (artifact instanceof FloatData) {
            return "number";
        }
        if (artifact instanceof DoubleData) {
            return "number";
        }
        if (artifact instanceof BigIntegerData) {
            return "number";
        }
        if (artifact instanceof BigDecimalData) {
            return "number";
        }
        if (artifact instanceof DateData) {
            return DATE;
        }
        if (artifact instanceof TimeData) {
            return "timestamp";
        }
        if (artifact instanceof TimestampData) {
            return "timestamp";
        }
        if (artifact instanceof Entity) {
            return "number";
        }
        return null;
    }

    @Override
    public String getSqlType(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        if (artifact instanceof BinaryData) {
            return BINARY;
        }
        if (artifact instanceof BooleanData) {
            return BOOLEAN;
        }
        if (artifact instanceof CharacterData) {
            return CHAR;
        }
        if (artifact instanceof StringData) {
            StringData data = (StringData)artifact;
            int l = IntUtils.valueOf(data.getMaxLength());
            return l < 1 || l > MAX_VARCHAR_LENGTH ? CLOB : OracleProgrammer.format(VARCHAR, l);
        }
        if (artifact instanceof ByteData) {
            return BYTE;
        }
        if (artifact instanceof ShortData) {
            return SMALLINT;
        }
        if (artifact instanceof IntegerData) {
            return INTEGER;
        }
        if (artifact instanceof LongData) {
            return LONG;
        }
        if (artifact instanceof FloatData) {
            return "number";
        }
        if (artifact instanceof DoubleData) {
            return "number";
        }
        if (artifact instanceof BigIntegerData) {
            BigIntegerData data = (BigIntegerData)artifact;
            int p = data.getPrecision();
            return OracleProgrammer.format(BIGINT, p > 38 ? 38 : p);
        }
        if (artifact instanceof BigDecimalData) {
            BigDecimalData data = (BigDecimalData)artifact;
            int p = data.getPrecision();
            int s = data.getScale();
            if (p > 38) {
                p = 38;
                if (s > 38) {
                    s = 38;
                }
            }
            return OracleProgrammer.format(DECIMAL, p, s);
        }
        if (artifact instanceof DateData) {
            return DATE;
        }
        if (artifact instanceof TimeData) {
            TimeData data = (TimeData)artifact;
            int p = IntUtils.valueOf(data.getPrecision(), 3);
            return OracleProgrammer.format("timestamp({0})", p);
        }
        if (artifact instanceof TimestampData) {
            TimestampData data = (TimestampData)artifact;
            int p = IntUtils.valueOf(data.getPrecision(), 3);
            return OracleProgrammer.format("timestamp({0})", p);
        }
        if (artifact instanceof Expression) {
            return this.getExpressionType((Expression)artifact);
        }
        if (artifact instanceof Entity) {
            return this.getEntityReferenceType((Entity)artifact);
        }
        return null;
    }

    protected String getExpressionType(Expression expression) {
        Class<?> clazz = expression.getDataType();
        if (clazz == null) {
            return VOID;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return BINARY;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return BOOLEAN;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return CHAR;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return TEXT;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return BYTE;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return SMALLINT;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return INTEGER;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return LONG;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return "number";
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return "number";
        }
        if (BigInteger.class.isAssignableFrom(clazz)) {
            return "number";
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return "number";
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return OracleProgrammer.format("timestamp({0})", 3);
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return OracleProgrammer.format("timestamp({0})", 3);
        }
        if (expression instanceof BooleanExpression) {
            return BOOLEAN;
        }
        if (expression instanceof CharacterExpression) {
            return TEXT;
        }
        if (expression instanceof NumericExpression) {
            return "number";
        }
        if (expression instanceof TemporalExpression) {
            return OracleProgrammer.format("timestamp({0})", 3);
        }
        return TEXT;
    }

    protected String getEntityReferenceType(Entity entity) {
        return entity.getPrimaryKeyProperty() instanceof IntegerProperty ? INTEGER : LONG;
    }

    @Override
    public String getSqlOnDeleteAction(PersistentEntityReference entity) {
        if (entity == null) {
            return null;
        }
        OnDeleteAction onDeleteAction = entity.getOnDeleteAction();
        if (onDeleteAction == null) {
            return null;
        }
        switch (onDeleteAction) {
            case CASCADE: {
                return this.getCascade();
            }
            case NULLIFY: {
                return this.getNullify();
            }
        }
        return null;
    }

    @Override
    public String getSqlOnUpdateAction(PersistentEntityReference entity) {
        if (entity == null) {
            return null;
        }
        OnUpdateAction onUpdateAction = entity.getOnUpdateAction();
        if (onUpdateAction == null) {
            return null;
        }
        switch (onUpdateAction) {
            case CASCADE: {
                return this.getCascade();
            }
            case NULLIFY: {
                return this.getNullify();
            }
        }
        return null;
    }

    @Override
    protected String getSqlDataAggregateExpression(DataAggregateX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        DataAggregateOp operator = expression.getOperator();
        Object[] operands = expression.getOperands();
        if (operator == null || operands == null || operands.length < 2) {
            return null;
        }
        String[] arguments = new String[operands.length];
        String[] booleanArguments = new String[operands.length];
        for (int i = 0; i < operands.length; ++i) {
            arguments[i] = this.getSqlExpression(operands[i], queryObject, qualifier, px, false);
            Object bcxi = operands[i] instanceof BooleanPrimitive ? XB.Boolean.Comparison.isTrue((BooleanPrimitive)operands[i]) : operands[i];
            booleanArguments[i] = this.getSqlExpression(bcxi, queryObject, qualifier, px, true);
        }
        return switch (operator) {
            case DataAggregateOp.COALESCE -> this.call("coalesce", arguments);
            case DataAggregateOp.MAXIMUM -> this.call("greatest", arguments);
            case DataAggregateOp.MINIMUM -> this.call("least", arguments);
            case DataAggregateOp.AND -> this.and(booleanArguments);
            case DataAggregateOp.NAND -> this.not(this.and(booleanArguments));
            case DataAggregateOp.OR -> this.or(booleanArguments);
            case DataAggregateOp.NOR -> this.not(this.or(booleanArguments));
            case DataAggregateOp.NAXOR -> this.xor(booleanArguments);
            case DataAggregateOp.NAXNOR -> this.not(this.xor(booleanArguments));
            case DataAggregateOp.NOR_OR_NAXOR -> this.or(this.not(this.or(booleanArguments)), this.xor(booleanArguments));
            default -> super.getSqlDataAggregateExpression(expression, queryObject, qualifier, px);
        };
    }

    @Override
    protected String getSqlNaryVectorExpression(NaryVectorX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        int length;
        NaryVectorOp operator = expression.getOperator();
        Object[] operands = expression.getOperands();
        int n = length = operands == null ? 0 : operands.length;
        if (operator == null || length == 0) {
            return null;
        }
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = this.getSqlExpression(operands[i], queryObject, qualifier, px, true);
        }
        Object[] arguments = new Object[length];
        for (int i = 0; i < length; ++i) {
            arguments[i] = StrUtils.discloseSqlExpression(strings[i]);
        }
        return OracleProgrammer.format(switch (operator) {
            case NaryVectorOp.SUBSTR -> length > 1 ? this.call((Operator)operator, length) : "null";
            default -> this.call((Operator)operator, length);
        }, arguments);
    }

    @Override
    protected String getSqlOrderedPairExpression(OrderedPairX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        OrderedPairOp operator = expression.getOperator();
        Object x = expression.getX();
        Object y = expression.getY();
        if (operator == null || x == null || y == null) {
            return null;
        }
        String arg1 = this.getSqlExpression(x, queryObject, qualifier, px, true);
        String arg2 = this.getSqlExpression(y, queryObject, qualifier, px, true);
        Object bcx1 = x instanceof BooleanPrimitive ? XB.Boolean.Comparison.isTrue((BooleanPrimitive)x) : x;
        Object bcx2 = y instanceof BooleanPrimitive ? XB.Boolean.Comparison.isTrue((BooleanPrimitive)y) : y;
        String boo1 = this.getSqlExpression(bcx1, queryObject, qualifier, px, true);
        String boo2 = this.getSqlExpression(bcx2, queryObject, qualifier, px, true);
        return OracleProgrammer.format(switch (operator) {
            case OrderedPairOp.COALESCE -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "coalesce({0}, {1})";
            }
            case OrderedPairOp.NULLIF -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "nullif({0}, {1})";
            }
            case OrderedPairOp.MAXIMUM -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "greatest({0}, {1})";
            }
            case OrderedPairOp.MINIMUM -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "least({0}, {1})";
            }
            case OrderedPairOp.AND -> {
                arg1 = boo1;
                arg2 = boo2;
                yield "{0} and {1}";
            }
            case OrderedPairOp.NAND -> {
                arg1 = boo1;
                arg2 = boo2;
                yield "not({0} and {1})";
            }
            case OrderedPairOp.OR -> {
                arg1 = boo1;
                arg2 = boo2;
                yield "{0} or {1}";
            }
            case OrderedPairOp.NOR -> {
                arg1 = boo1;
                arg2 = boo2;
                yield "not({0} or {1})";
            }
            case OrderedPairOp.XOR -> {
                arg1 = boo1;
                arg2 = boo2;
                yield "not({0} and {1}) and ({0} or {1})";
            }
            case OrderedPairOp.XNOR -> {
                arg1 = boo1;
                arg2 = boo2;
                yield "not({0} or {1}) or ({0} and {1})";
            }
            case OrderedPairOp.X_IMPLIES_Y -> {
                arg1 = boo1;
                arg2 = boo2;
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "not({0}) or {1}";
            }
            case OrderedPairOp.ASCII -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_ascii_string_2({0}, {1})";
            }
            case OrderedPairOp.DIACRITICLESS_ASCII -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_diacriticless_ascii_2({0}, {1})";
            }
            case OrderedPairOp.CONCAT -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "concat({0}, {1})";
            }
            case OrderedPairOp.CONCATENATE -> "{0} || {1}";
            case OrderedPairOp.FORMAT -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_string_format({0}, {1})";
            }
            case OrderedPairOp.LEFT -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "substr({0}, 1, {1})";
            }
            case OrderedPairOp.RIGHT -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "substr({0}, 0-({1}))";
            }
            case OrderedPairOp.SUBSTR -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "substr({0}, {1})";
            }
            case OrderedPairOp.TO_ZERO_PADDED_STRING -> this.toZeroPaddedStringPattern(x, y);
            case OrderedPairOp.X_PLUS_Y -> "{0} + {1}";
            case OrderedPairOp.X_MINUS_Y -> "{0} - {1}";
            case OrderedPairOp.X_MULTIPLIED_BY_Y -> "{0} * {1}";
            case OrderedPairOp.X_DIVIDED_INTO_Y -> "{0} / {1}";
            case OrderedPairOp.X_RAISED_TO_THE_Y -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "power({0}, {1})";
            }
            case OrderedPairOp.ADD_YEARS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_dateadd({0}, {1}, 'years')";
            }
            case OrderedPairOp.ADD_MONTHS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_dateadd({0}, {1}, 'months')";
            }
            case OrderedPairOp.ADD_WEEKS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_dateadd({0}, {1}, 'weeks')";
            }
            case OrderedPairOp.ADD_DAYS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_dateadd({0}, {1}, 'days')";
            }
            case OrderedPairOp.ADD_HOURS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_dateadd({0}, {1}, 'hours')";
            }
            case OrderedPairOp.ADD_MINUTES -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_dateadd({0}, {1}, 'minutes')";
            }
            case OrderedPairOp.ADD_SECONDS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_dateadd({0}, {1}, 'seconds')";
            }
            case OrderedPairOp.DIFF_IN_YEARS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_datediff({0}, {1}, 'years')";
            }
            case OrderedPairOp.DIFF_IN_MONTHS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_datediff({0}, {1}, 'months')";
            }
            case OrderedPairOp.DIFF_IN_WEEKS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_datediff({0}, {1}, 'weeks')";
            }
            case OrderedPairOp.DIFF_IN_DAYS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_datediff({0}, {1}, 'days')";
            }
            case OrderedPairOp.DIFF_IN_HOURS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_datediff({0}, {1}, 'hours')";
            }
            case OrderedPairOp.DIFF_IN_MINUTES -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_datediff({0}, {1}, 'minutes')";
            }
            case OrderedPairOp.DIFF_IN_SECONDS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "util_datediff({0}, {1}, 'seconds')";
            }
            case OrderedPairOp.TO_TIMESTAMP -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "case when {0} is null or {1} is null then null else to_timestamp(to_char({0}, 'YYYY-MM-DD')||'-'||to_char({1}, 'HH24:MI:SS'), 'YYYY-MM-DD-HH24:MI:SS') end";
            }
            default -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield this.call((Operator)operator, 2);
            }
        }, arg1, arg2);
    }

    @Override
    protected String getSqlScalarExpression(ScalarX expression, Object queryObject, SqlQualifierType qualifier, ParameterizedExpression px) {
        ScalarOp operator = expression.getOperator();
        Object operand = expression.getOperand();
        if (operand == null) {
            return null;
        }
        String arg1 = this.getSqlExpression(operand, queryObject, qualifier, px, false);
        String arg2 = this.getSqlExpressionDefaultValue(expression);
        if (operator == null || operator.equals(ScalarOp.SELF)) {
            return arg1;
        }
        boolean varchar = operand instanceof String || operand instanceof CharacterExpression;
        return OracleProgrammer.format((String)(switch (operator) {
            case ScalarOp.DEFAULT_WHEN_NULL -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "coalesce({0}, {1})";
            }
            case ScalarOp.NULL_WHEN_DEFAULT -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                arg2 = StrUtils.discloseSqlExpression(arg2);
                yield "nullif({0}, {1})";
            }
            case ScalarOp.TO_BOOLEAN -> "cast({0} as varchar2(5))";
            case ScalarOp.TO_CHARACTER -> "cast({0} as " + CHAR + ")";
            case ScalarOp.TO_STRING, ScalarOp.TO_LOCALE_STRING -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield this.toCharStringPattern(operand);
            }
            case ScalarOp.TO_BYTE -> "cast({0} as number(5))";
            case ScalarOp.TO_SHORT -> "cast({0} as number(5))";
            case ScalarOp.TO_INTEGER -> "cast({0} as number(10))";
            case ScalarOp.TO_LONG -> "cast({0} as number(19))";
            case ScalarOp.TO_FLOAT -> "cast({0} as number)";
            case ScalarOp.TO_DOUBLE -> "cast({0} as number)";
            case ScalarOp.TO_BIG_INTEGER -> "cast({0} as number)";
            case ScalarOp.TO_BIG_DECIMAL -> "cast({0} as number)";
            case ScalarOp.TO_DATE -> {
                if (varchar) {
                    arg1 = StrUtils.discloseSqlExpression(arg1);
                }
                yield this.getCurrentDate().equals(arg1) ? arg1 : (varchar ? "util_cast_varchar_as_date({0})" : "cast({0} as date)");
            }
            case ScalarOp.TO_TIME -> {
                if (varchar) {
                    arg1 = StrUtils.discloseSqlExpression(arg1);
                }
                yield this.getCurrentTime().equals(arg1) ? arg1 : (varchar ? "util_cast_varchar_as_time({0})" : "cast({0} as timestamp)");
            }
            case ScalarOp.TO_TIMESTAMP -> {
                if (varchar) {
                    arg1 = StrUtils.discloseSqlExpression(arg1);
                }
                yield this.getCurrentTimestamp().equals(arg1) ? arg1 : (varchar ? "util_cast_varchar_as_timestamp({0})" : "cast({0} as timestamp)");
            }
            case ScalarOp.NOT -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                String is_true = operand instanceof Primitive ? this.primitiveIsTruePattern() : this.expressionIsTruePattern();
                yield "not(" + is_true + ")";
            }
            case ScalarOp.ASCII -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_ascii_string_1({0})";
            }
            case ScalarOp.DIACRITICLESS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_diacriticless({0})";
            }
            case ScalarOp.DIACRITICLESS_ASCII -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_diacriticless_ascii_1({0})";
            }
            case ScalarOp.LOWER -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "lower({0})";
            }
            case ScalarOp.UPPER -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "upper({0})";
            }
            case ScalarOp.CAPITALIZE -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "initcap({0})";
            }
            case ScalarOp.UNCAPITALIZE -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "uncap({0})";
            }
            case ScalarOp.TRIM -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "trim({0})";
            }
            case ScalarOp.LTRIM -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "ltrim({0})";
            }
            case ScalarOp.RTRIM -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "rtrim({0})";
            }
            case ScalarOp.MODULUS -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "abs({0})";
            }
            case ScalarOp.OPPOSITE -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "-({0})";
            }
            case ScalarOp.RECIPROCAL -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "1/({0})";
            }
            case ScalarOp.YEAR, ScalarOp.MONTH, ScalarOp.DAY, ScalarOp.HOUR, ScalarOp.MINUTE, ScalarOp.SECOND -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "extract(" + operator.name().toLowerCase() + " from {0})";
            }
            case ScalarOp.FIRST_DATE_OF_MONTH -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_first_date_of_month({0})";
            }
            case ScalarOp.FIRST_DATE_OF_QUARTER -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_first_date_of_quarter({0})";
            }
            case ScalarOp.FIRST_DATE_OF_SEMESTER -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_first_date_of_semester({0})";
            }
            case ScalarOp.FIRST_DATE_OF_YEAR -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_first_date_of_year({0})";
            }
            case ScalarOp.LAST_DATE_OF_MONTH -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_last_date_of_month({0})";
            }
            case ScalarOp.LAST_DATE_OF_QUARTER -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_last_date_of_quarter({0})";
            }
            case ScalarOp.LAST_DATE_OF_SEMESTER -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_last_date_of_semester({0})";
            }
            case ScalarOp.LAST_DATE_OF_YEAR -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield "util_last_date_of_year({0})";
            }
            default -> {
                arg1 = StrUtils.discloseSqlExpression(arg1);
                yield this.call((Operator)operator, 1);
            }
        }), arg1, arg2);
    }

    @Override
    protected String getSqlExpressionDefaultValue(Expression expression) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = expression == null ? null : expression.getDataType();
        if (clazz == null) {
            return this.getNull();
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE + this.getZeroDate();
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return "time" + this.getZeroTime();
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return "timestamp" + this.getZeroTimestamp();
        }
        return super.getSqlExpressionDefaultValue(expression);
    }

    @Override
    protected String fixCalculableColumnValueExpression(String expression, Property property) {
        Object calculableValue;
        if (expression != null && !expression.equals(this.getNull()) && property instanceof CalculableProperty && (calculableValue = ((CalculableProperty)property).getCalculableValue()) instanceof BooleanExpression && !(calculableValue instanceof BooleanPrimitive)) {
            return OracleProgrammer.format(this.getCaseWhenThenElsePattern(), expression, this.getTrue(), this.getFalse());
        }
        return super.fixCalculableColumnValueExpression(expression, property);
    }

    @Override
    protected String defaultCharStringPattern() {
        return "to_char({0})";
    }

    @Override
    protected String defaultZeroPaddedStringPattern(int width) {
        return "lpad({0}, " + width + ", '0')";
    }

    @Override
    protected String concat(String ... strings) {
        if (strings == null || strings.length < 2) {
            return this.getNull();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        for (String string : strings) {
            arguments.add(StrUtils.discloseSqlExpression(string));
        }
        String[] arg = arguments.toArray(strings);
        String concatenation = this.concatXY(arg[0], arg[1]);
        for (int i = 2; i < arg.length; ++i) {
            concatenation = this.concatXY(concatenation, arg[i]);
        }
        return concatenation;
    }

    private String concatXY(String x, String y) {
        return "concat(" + x + ", " + y + ")";
    }
}

