/*
 * Decompiled with CFR 0.152.
 */
package adalid.core.sql;

import adalid.core.Primitive;
import adalid.core.Project;
import adalid.core.enums.QueryJoinOp;
import adalid.core.enums.VirtualEntityType;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.PersistentEntity;
import adalid.core.interfaces.PersistentEntityReference;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.sql.QueryJoin;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class QueryTable {
    private PersistentEntity _entity;
    private String _name;
    private String _alias;
    private String _trace;
    private String _prefix;
    private String _suffix;
    private String _sufijo;
    private VirtualEntityType _virtualEntityType;
    private QueryTable _leftTable;
    private PersistentEntity _joinedEntity;
    private Entity _joiningEntity;
    private boolean _line;
    private boolean _star;
    private int _maxDepth;
    private int _depth;
    private int _index;
    private int _subqueryIndex;
    private List<Property> _columns;
    private List<QueryJoin> _joins;
    private SqlProgrammer _sqlProgrammer;

    public PersistentEntity getEntity() {
        return this._entity;
    }

    public String getName() {
        return this._name;
    }

    public String getAlias() {
        return this._alias;
    }

    public String getTrace() {
        return this._trace == null ? "" : this._trace.trim();
    }

    public void setTrace(String trace) {
        this._trace = trace;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getSuffix() {
        return this._suffix;
    }

    private String getSufijo() {
        return this._sufijo;
    }

    public VirtualEntityType getVirtualEntityType() {
        return this._virtualEntityType;
    }

    public int getMaxDepth() {
        return this._maxDepth;
    }

    public int getDepth() {
        return this._depth;
    }

    public int getIndex() {
        return this._index;
    }

    public int getSubqueryIndex() {
        return this._subqueryIndex;
    }

    private void setSubqueryIndex(int index) {
        this._subqueryIndex = index;
        for (QueryJoin j : this._joins) {
            j.getRightTable().setSubqueryIndex(index);
        }
    }

    public List<Property> getColumns() {
        return this._columns;
    }

    public List<QueryJoin> getJoins() {
        return this._joins;
    }

    public SqlProgrammer getSqlProgrammer() {
        return this._sqlProgrammer;
    }

    public QueryTable(PersistentEntity entity, int maxDepth, VirtualEntityType virtualEntityType) {
        this(entity, maxDepth, virtualEntityType, 0, null, null, null);
        int index = 0;
        for (QueryJoin j : this._joins) {
            j.getRightTable().setSubqueryIndex(++index);
        }
    }

    private QueryTable(PersistentEntity entity, int maxDepth, VirtualEntityType virtualEntityType, int depth, QueryTable leftTable, PersistentEntity joinedEntity, Entity joiningEntity) {
        List<Property> properties;
        PersistentEntity rightEntity;
        if (entity == null) {
            throw new IllegalArgumentException("null entity");
        }
        this._sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        if (this._sqlProgrammer == null) {
            throw new RuntimeException("null sql programmer");
        }
        this._entity = entity;
        this._maxDepth = maxDepth;
        this._depth = depth;
        this._leftTable = leftTable;
        this._joinedEntity = joinedEntity;
        this._joiningEntity = joiningEntity;
        this._index = this.getReferenceIndex(entity);
        this._name = this._sqlProgrammer.getSqlSchemaQualifiedShortTableName(entity);
        this._alias = this._sqlProgrammer.getSqlSchemaUnqualifiedShortTableName(entity);
        if (leftTable == null) {
            this._prefix = "";
            this._suffix = "";
            this._sufijo = "";
            this._virtualEntityType = virtualEntityType;
        } else {
            this._prefix = "";
            this._sufijo = leftTable.getSufijo() + "_" + this._index;
            if (this._sufijo.equals("_0")) {
                this._sufijo = "";
            }
            if (joinedEntity == null) {
                this._suffix = this._sufijo;
            } else {
                this._suffix = leftTable.getSuffix();
                this._sufijo = StringUtils.removeEnd((String)this._sufijo, (String)"_0");
                if (this._index == 0) {
                    this._index = leftTable.getIndex();
                }
            }
            this._virtualEntityType = leftTable.getVirtualEntityType();
            int l1 = this._alias.length();
            int l2 = this._suffix.length();
            int l3 = this._sqlProgrammer.getMaxIdentifierLength();
            String a = l1 + l2 > l3 ? this._alias.substring(0, l3 - l2) : this._alias;
            this._alias = a + this._suffix;
        }
        this._columns = new ArrayList<Property>();
        this._joins = new ArrayList<QueryJoin>();
        this.initJoinFlags();
        if (entity.isJoinedTable()) {
            Property leftColumn = entity.getPrimaryKeyProperty();
            PersistentEntity leftEntity = entity;
            Entity baseEntity = leftEntity.getBaseRoot();
            rightEntity = leftEntity.getBaseTableRoot();
            if (joinedEntity == null) {
                properties = entity.getJoinedTablePropertiesList();
                if (this._line) {
                    this.addJoin(leftColumn, rightEntity, maxDepth, depth, entity, baseEntity, true);
                }
            } else {
                properties = joinedEntity.getJoinedTableMatchingPropertiesList(entity.getJoinedTablePropertiesMap());
                if (this._line) {
                    this.addJoin(leftColumn, rightEntity, maxDepth, depth, joinedEntity, baseEntity, true);
                }
            }
        } else if (joinedEntity != null) {
            properties = joinedEntity.getJoinedTableMatchingPropertiesList(joiningEntity.getPropertiesMap());
        } else if (entity.isTable()) {
            properties = entity.getPropertiesList();
        } else {
            Property leftColumn = entity.getPrimaryKeyProperty();
            PersistentEntity leftEntity = entity.getBaseTableRoot();
            if (leftEntity == null) {
                properties = null;
            } else {
                Entity baseEntity = leftEntity.getBaseRoot();
                rightEntity = leftEntity.getBaseTableRoot();
                if (rightEntity == null) {
                    properties = entity.getPropertiesList();
                } else {
                    properties = entity.getSingleJoinedTablePropertiesList(rightEntity.getPropertiesMap());
                    if (this._line) {
                        this.addJoin(leftColumn, rightEntity, maxDepth, depth, entity, baseEntity, true);
                    }
                }
            }
        }
        if (properties != null) {
            for (Property property : properties) {
                if (property instanceof Primitive) {
                    this._columns.add(property);
                    continue;
                }
                if (!(property instanceof PersistentEntity)) continue;
                PersistentEntity persistentEntity = (PersistentEntity)((Object)property);
                this._columns.add(property);
                Property leftColumn = property;
                rightEntity = persistentEntity;
                if (!this._star) continue;
                this.addJoin(leftColumn, rightEntity, maxDepth, depth);
            }
        }
        this.addQueryTable();
    }

    private void addQueryTable() {
        Project.addQueryTable(this);
    }

    private int getReferenceIndex(Entity entity) {
        String name = entity.getName();
        Entity declaringEntity = entity.getDeclaringEntity();
        Entity root = declaringEntity == null ? null : declaringEntity.getRoot();
        Property property = root == null ? null : root.getPropertiesMap().get(name);
        Entity reference = property == null ? null : (Entity)((Object)property);
        int referenceIndex = reference == null ? 0 : reference.getReferenceIndex();
        return referenceIndex;
    }

    private void initJoinFlags() {
        if (this._virtualEntityType == null) {
            this._line = true;
            this._star = true;
        } else {
            switch (this._virtualEntityType) {
                case SELECTION: {
                    this._line = false;
                    this._star = false;
                    break;
                }
                case LINE: {
                    this._line = true;
                    this._star = false;
                    break;
                }
                case STAR: {
                    this._line = false;
                    this._star = true;
                    break;
                }
                default: {
                    this._line = true;
                    this._star = true;
                }
            }
        }
    }

    private void addJoin(Property leftColumn, PersistentEntity rightEntity, int maxDepth, int depth) {
        this.addJoin(leftColumn, rightEntity, maxDepth, depth, null, null, false);
    }

    private void addJoin(Property leftColumn, PersistentEntity rightEntity, int maxDepth, int depth, PersistentEntity joinedEntity, Entity joiningEntity, boolean hierarchical) {
        if (depth >= maxDepth && maxDepth >= 0) {
            return;
        }
        if (leftColumn == null || rightEntity == null) {
            return;
        }
        Property rightColumn = rightEntity.getPrimaryKeyProperty();
        if (rightColumn == null) {
            return;
        }
        QueryJoinOp operator = this.queryJoinOp(leftColumn);
        QueryTable rightTable = new QueryTable(rightEntity, maxDepth, null, depth + 1, this, joinedEntity, joiningEntity);
        QueryJoin join = new QueryJoin(this._sqlProgrammer);
        join.setOperator(operator);
        join.setLeftTable(this);
        join.setLeftColumn(leftColumn);
        join.setRightTable(rightTable);
        join.setRightColumn(rightColumn);
        join.setHierarchical(hierarchical);
        this._joins.add(join);
    }

    private QueryJoinOp queryJoinOp(Property leftColumn) {
        boolean foreignKey;
        boolean nullable;
        if (leftColumn instanceof PersistentEntityReference) {
            PersistentEntityReference reference = (PersistentEntityReference)leftColumn;
            nullable = reference.isNullable();
            foreignKey = reference.isForeignKey();
        } else {
            nullable = leftColumn == null || leftColumn.isNullable();
            foreignKey = !nullable;
        }
        QueryJoinOp operator = nullable || !foreignKey ? QueryJoinOp.LEFT : QueryJoinOp.INNER;
        return operator;
    }

    public String toString() {
        return super.toString() + "\n\u00a7thisTable........: " + this.toString(this) + "\n\u00a7leftTable........: " + this.toString(this._leftTable) + "\n\u00a7joinedEntity.....: " + this._joinedEntity + "\n\u00a7joiningEntity....: " + this._joiningEntity + "\n";
    }

    private String toString(QueryTable qt) {
        return qt == null ? null : qt._entity + ", " + qt._name + ", " + qt._alias + ", " + qt._suffix + ", " + qt._index;
    }

    public Map<String, QueryJoin> getJoinsMap() {
        LinkedHashMap<String, QueryJoin> map = new LinkedHashMap<String, QueryJoin>();
        for (QueryJoin j : this._joins) {
            String qualifier = this.getSqlJoinQualifier(j.getRightTable());
            map.put(qualifier, j);
        }
        return map;
    }

    public Map<String, QueryJoin> getReferencedJoinsMap(Primitive primitive) {
        ArrayList<Property> referencedColumns = new ArrayList<Property>();
        referencedColumns.add(primitive);
        return this.getReferencedJoinsMap(referencedColumns);
    }

    public Map<String, QueryJoin> getReferencedJoinsMap(Property property) {
        ArrayList<Property> referencedColumns = new ArrayList<Property>();
        referencedColumns.add(property);
        return this.getReferencedJoinsMap(referencedColumns);
    }

    public Map<String, QueryJoin> getReferencedJoinsMap(List<Property> referencedColumns) {
        LinkedHashMap<String, QueryJoin> map = new LinkedHashMap<String, QueryJoin>();
        for (Property property : referencedColumns) {
            this.putPropertyJoin(property, map);
        }
        return map;
    }

    private void putPropertyJoin(Property property, Map<String, QueryJoin> map) {
        for (Property p : this._columns) {
            if (p != property) continue;
            return;
        }
        for (QueryJoin j : this._joins) {
            if (!j.getRightTable().isPropertyAtJoin(property)) continue;
            String qualifier = this.getSqlJoinQualifier(j.getRightTable());
            map.put(qualifier, j);
            return;
        }
    }

    private boolean isPropertyAtJoin(Property property) {
        for (Property p : this._columns) {
            if (p != property) continue;
            return true;
        }
        for (QueryJoin j : this._joins) {
            if (!j.getRightTable().isPropertyAtJoin(property)) continue;
            return true;
        }
        return false;
    }

    public QueryTable containingQueryTableOf(Property property) {
        for (Property p : this._columns) {
            if (p != property) continue;
            return this;
        }
        for (QueryJoin j : this._joins) {
            QueryTable queryTable = j.getRightTable().containingQueryTableOf(property);
            if (queryTable == null) continue;
            return queryTable;
        }
        return null;
    }

    public boolean contains(Property property) {
        return property != null && this.isPropertyAtJoin(property);
    }

    public boolean containsAny(List<Property> properties) {
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        for (Property property : properties) {
            if (!this.contains(property)) continue;
            return true;
        }
        return false;
    }

    public QueryTable getContainingQueryTableOf(Property property) {
        return property == null ? null : this.containingQueryTableOf(property);
    }

    public void merge(QueryTable anotherQueryTable) {
        if (anotherQueryTable != null && anotherQueryTable.getName().equals(this._name)) {
            boolean found;
            for (Property anotherColumn : anotherQueryTable.getColumns()) {
                found = false;
                String anotherColumnName = anotherColumn.getName();
                if (anotherColumnName != null) {
                    for (Property column : this._columns) {
                        if (!anotherColumnName.equals(column.getName())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                this._columns.add(anotherColumn);
            }
            for (QueryJoin anotherJoin : anotherQueryTable.getJoins()) {
                QueryJoinOp anotherOperator = anotherJoin.getOperator();
                QueryTable anotherLeftTable = anotherJoin.getLeftTable();
                Property anotherLeftColumn = anotherJoin.getLeftColumn();
                QueryTable anotherRightTable = anotherJoin.getRightTable();
                Property anotherRightColumn = anotherJoin.getRightColumn();
                String anotherLeftTableName = anotherLeftTable.getName();
                String anotherLeftColumnName = anotherLeftColumn.getName();
                String anotherRightTableName = anotherRightTable.getName();
                String anotherRightColumnName = anotherRightColumn.getName();
                found = false;
                QueryTable rightTable = null;
                if (anotherOperator != null && anotherLeftTableName != null && anotherLeftColumnName != null && anotherRightTableName != null && anotherRightColumnName != null) {
                    for (QueryJoin join : this._joins) {
                        QueryJoinOp operator = join.getOperator();
                        QueryTable leftTable = join.getLeftTable();
                        Property leftColumn = join.getLeftColumn();
                        rightTable = join.getRightTable();
                        Property rightColumn = join.getRightColumn();
                        if (!anotherOperator.equals((Object)operator) || !anotherLeftTableName.equals(leftTable.getName()) || !anotherLeftColumnName.equals(leftColumn.getName()) || !anotherRightTableName.equals(rightTable.getName()) || !anotherRightColumnName.equals(rightColumn.getName())) continue;
                        found = true;
                        break;
                    }
                }
                if (found && rightTable != null) {
                    rightTable.merge(anotherRightTable);
                    continue;
                }
                this._joins.add(anotherJoin);
            }
        }
    }

    public String getSqlAlias(Property property) {
        return this._sqlProgrammer.getSqlAlias(property, this);
    }

    public Property getProperty(String sqlAlias) {
        return this._sqlProgrammer.getProperty(sqlAlias, this);
    }

    public String getSqlQualifiedName(Property property) {
        return this._sqlProgrammer.getSqlQualifiedName(property, this);
    }

    public String getSqlJoinQualifier() {
        return this.getSqlJoinQualifier(this);
    }

    private String getSqlJoinQualifier(QueryTable queryTable) {
        return this._sqlProgrammer.getSqlJoinQualifier(queryTable);
    }

    public int getSelectColumnCount() {
        int count = this._columns.size();
        for (QueryJoin j : this.getJoins()) {
            count += j.getRightTable().getSelectColumnCount();
        }
        return count;
    }

    public List<Property> getSelectColumnsList() {
        ArrayList<Property> list = new ArrayList<Property>();
        list.addAll(this._columns);
        for (QueryJoin j : this.getJoins()) {
            list.addAll(j.getRightTable().getSelectColumnsList());
        }
        return list;
    }

    public Map<String, Property> getSelectColumnsMap() {
        return this._sqlProgrammer.getSelectColumnsMap(this);
    }

    public String getSqlSelectStatement() {
        return this.getSqlSelectStatement(null);
    }

    public String getSqlSelectStatement(List<Property> referencedColumns) {
        return this.getSqlSelectStatement(referencedColumns, false);
    }

    public String getSqlSelectStatement(List<Property> referencedColumns, boolean into) {
        return this.getSqlSelectStatement(referencedColumns, into, true);
    }

    public String getSqlSelectStatement(List<Property> referencedColumns, boolean into, boolean indent) {
        return this.getSqlSelectStatement(referencedColumns, into, indent, false);
    }

    public String getSqlSelectStatement(List<Property> referencedColumns, boolean into, boolean indent, boolean blobless) {
        return this.getSqlSelectStatement(referencedColumns, into, indent, blobless, false);
    }

    public String getSqlSelectStatement(List<Property> referencedColumns, boolean into, boolean indent, boolean blobless, boolean joinless) {
        return this._sqlProgrammer.getSqlSelectStatement(this, referencedColumns, into, indent, blobless, joinless);
    }
}

