/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2.meta.proyecto.base;

import adalid.commons.ProjectObjectModelReader;
import adalid.commons.enums.LoggingLevel;
import adalid.commons.interfaces.SubjectProject;
import adalid.commons.properties.Dictionary;
import adalid.commons.properties.ProjectBuilderDictionary;
import adalid.commons.properties.SqlDictionary;
import adalid.commons.util.ColUtils;
import adalid.commons.util.StrUtils;
import adalid.core.EntityCollection;
import adalid.core.Instance;
import adalid.core.NativeQuerySegment;
import adalid.core.Operation;
import adalid.core.Project;
import adalid.core.Trigger;
import adalid.core.annotations.ProjectModule;
import adalid.core.annotations.ProjectModuleDocGen;
import adalid.core.comparators.ByInstanceKeyValue;
import adalid.core.enums.DatabaseLockingMechanism;
import adalid.core.enums.Kleenean;
import adalid.core.enums.SpecialNumericValue;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.Parameter;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.SqlProgrammer;
import adalid.core.primitives.NumericPrimitive;
import adalid.core.programmers.ChiefProgrammer;
import adalid.core.sql.NativeQuery;
import adalid.jee2.ProjectObjectModel;
import adalid.jee2.SpecialPage;
import adalid.jee2.bundles.BaseBundle;
import adalid.jee2.bundles.BundleAbstracto;
import adalid.jee2.bundles.BundleMensajes;
import adalid.jee2.bundles.BundleWebui;
import adalid.jee2.features.SpecialEntityPack;
import adalid.jee2.features.SpecialEntityPackDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import meta.entidad.comun.configuracion.basica.ClaseRecurso;
import meta.entidad.comun.configuracion.basica.DominioParametro;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.configuracion.basica.FuncionParametro;
import meta.entidad.comun.configuracion.basica.ModuloAplicacion;
import meta.entidad.comun.configuracion.basica.Pagina;
import meta.entidad.comun.configuracion.basica.Parametro;
import meta.entidad.comun.operacion.basica.CondicionTarea;
import meta.proyecto.comun.ConfiguracionBasica;
import meta.proyecto.comun.EntidadesBasicas;
import meta.proyecto.comun.OperacionBasica;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ProyectoBase
extends Project
implements SubjectProject,
SpecialEntityPack {
    private static final Logger logger = Logger.getLogger(ProyectoBase.class);
    private static final String BASE_NAME = ProyectoBase.class.getName();
    private static final ResourceBundle RB = ResourceBundle.getBundle(BASE_NAME);
    private static final String PAGE_MAIN_FORM_ID = "mainForm";
    private static final String PAGE_NORTH_FORM_ID = "northForm";
    private static final String PAGE_SOUTH_FORM_ID = "southForm";
    private static final String PAGE_DATA_TABLE_ID = "dataTable";
    private static final String PAGE_DATA_TABLE_FILTER_ID = "filter";
    private static final String PAGE_DETAIL_PANEL_GRID_ID = "panelDetalle";
    private static final String PAGE_DETAIL_WRITING_PANEL_ID = "detailWritingPanel";
    private static final String PAGE_DIALOG_HEADER_ELEMENT_ID = "dialogHeaderElement";
    private static final String PAGE_WIZARD_LAST_STEP_ID = "lastStep";
    private static final String PAGE_MESSAGES_ID = "messages";
    private static final String PAGE_TREE_ID = "tree";
    private static final String PAGE_WIZARD_ID = "panelDetalle";
    private static final String PAGE_DATA_TABLE_COLUMN_SUFFIX = "DataTableColumn";
    private static final String PAGE_DETAIL_PANEL_DIV_SUFFIX = "PanelDetalle";
    private static final String PAGE_FIELD_SUFFIX = "Field";
    protected static final String URL_ZIP_THIRD_PARTY_DIR = "third.party.dir.zip.url";
    protected static final String THIRD_PARTY_DIR_LINUX = "third.party.dir.linux";
    protected static final String THIRD_PARTY_DIR_WINDOWS = "third.party.dir.windows";
    protected static final String THIRD_PARTY_DIR_VERSION = "third.party.dir.version";
    protected static final String VERSION_THIRD_PARTY_DIR = "third.party.dir.version";
    private static final String ADALID_SCHEMA = StringUtils.trimToEmpty((String)ProyectoBase.getString("adalid.schema"));
    SpecialEntityPack specialEntityPack = new SpecialEntityPackDelegate();
    private static final String select_where_destinatario = "select recurso_valor from tarea_usuario where destinatario={0}";
    private static final String and_clase_recurso_1a = " and id_clase_recurso_valor in ({1})";
    private static final String and_clase_recurso_1b = " and id_clase_recurso_valor={1}";
    private static final String and_condicion_2a = " and (condicion={2} and responsable={0})";
    private static final String and_condicion_2b = " and (condicion={2} or (condicion={3} and responsable={0}))";
    private final Map<String, SpecialPage> _projectSpecialPages = new TreeMap<String, SpecialPage>();
    private final ProjectObjectModel pom = new ProjectObjectModel();
    @ProjectModule(menu=Kleenean.FALSE, role=Kleenean.FALSE)
    @ProjectModuleDocGen(classDiagram=Kleenean.FALSE)
    EntidadesBasicas entidadesBasicas;
    @ProjectModule(menu=Kleenean.FALSE, role=Kleenean.FALSE)
    @ProjectModuleDocGen(classDiagram=Kleenean.FALSE)
    ConfiguracionBasica configuracionBasica;
    @ProjectModule(menu=Kleenean.FALSE, role=Kleenean.FALSE)
    @ProjectModuleDocGen(classDiagram=Kleenean.FALSE)
    OperacionBasica operacionBasica;
    private boolean _dictionaryEnabled;
    private boolean _projectBuilderDictionaryEnabled;
    private ProjectBuilderDictionary _projectBuilderDictionary;
    private SqlDictionary _entitiesDictionary;
    private SqlDictionary _entityParametersDictionary;
    private SqlDictionary _modulesDictionary;
    private SqlDictionary _operationsDictionary;
    private SqlDictionary _operationParametersDictionary;
    private SqlDictionary _pagesDictionary;
    private SqlDictionary _parametersDictionary;
    private String _baseFolderName;
    private String _databaseName;
    private String _databaseFormerSchemaName;
    private String _rootFolderName;
    private String _roleCodePrefix;
    private String _messageDigestAlgorithm;
    private boolean _sqlBusinessAuditTrail;
    private DatabaseLockingMechanism _databaseLockingMechanism;

    public String getPageMainFormID() {
        return PAGE_MAIN_FORM_ID;
    }

    public String getPageNorthFormID() {
        return PAGE_NORTH_FORM_ID;
    }

    public String getPageSouthFormID() {
        return PAGE_SOUTH_FORM_ID;
    }

    public String getPageDataTableID() {
        return PAGE_DATA_TABLE_ID;
    }

    public String getPageDataTableFilterID() {
        return PAGE_DATA_TABLE_FILTER_ID;
    }

    public String getPageDetailPanelGridID() {
        return "panelDetalle";
    }

    public String getPageDetailWritingPanelID() {
        return PAGE_DETAIL_WRITING_PANEL_ID;
    }

    public String getPageDialogHeaderElementID() {
        return PAGE_DIALOG_HEADER_ELEMENT_ID;
    }

    public String getPageWizardLastStepID() {
        return PAGE_WIZARD_LAST_STEP_ID;
    }

    public String getPageMessagesID() {
        return PAGE_MESSAGES_ID;
    }

    public String getPageTreeID() {
        return PAGE_TREE_ID;
    }

    public String getPageWizardID() {
        return "panelDetalle";
    }

    public String getPageDataTableColumnSuffix() {
        return PAGE_DATA_TABLE_COLUMN_SUFFIX;
    }

    public String getPageDetailPanelDivSuffix() {
        return PAGE_DETAIL_PANEL_DIV_SUFFIX;
    }

    public String getPageFieldSuffix() {
        return PAGE_FIELD_SUFFIX;
    }

    public static String getEsquemaEntidadesComunes() {
        return ADALID_SCHEMA;
    }

    public static Level getDictionaryLevel() {
        return Dictionary.getInfoLevel();
    }

    public static void setDictionaryLevel(Level level) {
        Dictionary.setInfoLevel(level);
    }

    public static LoggingLevel getDictionaryLoggingLevel() {
        return LoggingLevel.getLoggingLevel(ProyectoBase.getDictionaryLevel());
    }

    public static void setDictionaryLoggingLevel(LoggingLevel level) {
        ProyectoBase.setDictionaryLevel(level.getLevel());
    }

    private static String getString(String key) {
        try {
            String string = RB.getString(key);
            return StringUtils.trimToNull((String)string);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Entity getApplicationMessageEntity() {
        Class<? extends Entity> entityClass = this.getApplicationMessageEntityClass();
        return entityClass == null ? null : this.getEntity(entityClass);
    }

    public Entity getSegmentSetFactoryEntity() {
        Class<? extends Entity> entityClass = this.getSegmentSetFactoryEntityClass();
        return entityClass == null ? null : this.getEntity(entityClass);
    }

    public Entity getUploadedFileEntity() {
        Class<? extends Entity> entityClass = this.getUploadedFileEntityClass();
        return entityClass == null ? null : this.getEntity(entityClass);
    }

    public Entity getUserEntity() {
        Class<? extends Entity> entityClass = this.getUserEntityClass();
        return entityClass == null ? null : this.getEntity(entityClass);
    }

    public Entity getVersionEntity() {
        Class<? extends Entity> entityClass = this.getVersionEntityClass();
        return entityClass == null ? null : this.getEntity(entityClass);
    }

    @Override
    public Class<? extends Entity> getApplicationMessageEntityClass() {
        return this.specialEntityPack.getApplicationMessageEntityClass();
    }

    @Override
    public void setApplicationMessageEntityClass(Class<? extends Entity> clazz) {
        this.specialEntityPack.setApplicationMessageEntityClass(clazz);
    }

    @Override
    public Class<? extends Entity> getSegmentSetFactoryEntityClass() {
        return this.specialEntityPack.getSegmentSetFactoryEntityClass();
    }

    @Override
    public void setSegmentSetFactoryEntityClass(Class<? extends Entity> clazz) {
        this.specialEntityPack.setSegmentSetFactoryEntityClass(clazz);
    }

    @Override
    public Class<? extends Entity> getTaskNotificationEntityClass() {
        return this.specialEntityPack.getTaskNotificationEntityClass();
    }

    @Override
    public void setTaskNotificationEntityClass(Class<? extends Entity> clazz) {
        this.specialEntityPack.setTaskNotificationEntityClass(clazz);
    }

    @Override
    public Class<? extends Entity> getUploadedFileEntityClass() {
        return this.specialEntityPack.getUploadedFileEntityClass();
    }

    @Override
    public void setUploadedFileEntityClass(Class<? extends Entity> clazz) {
        this.specialEntityPack.setUploadedFileEntityClass(clazz);
    }

    @Override
    public Class<? extends Entity> getUserEntityClass() {
        return this.specialEntityPack.getUserEntityClass();
    }

    @Override
    public void setUserEntityClass(Class<? extends Entity> clazz) {
        this.specialEntityPack.setUserEntityClass(clazz);
    }

    @Override
    public Class<? extends Entity> getVersionEntityClass() {
        return this.specialEntityPack.getVersionEntityClass();
    }

    @Override
    public void setVersionEntityClass(Class<? extends Entity> clazz) {
        this.specialEntityPack.setVersionEntityClass(clazz);
    }

    @Override
    public List<Class<? extends Entity>> unsetSpecialEntityClasses() {
        return this.specialEntityPack.unsetSpecialEntityClasses();
    }

    @Override
    public List<NativeQuerySegment> getSpecialNativeQuerySegments(Entity entity) {
        Property pk;
        if (entity != null && entity.depth() == 0 && (pk = entity.getPrimaryKeyProperty()) instanceof NumericPrimitive) {
            NumericPrimitive np = (NumericPrimitive)pk;
            List<Trigger> triggers = entity.getTriggersList();
            if (triggers != null && !triggers.isEmpty()) {
                String usuario = this.specialValueOf(SpecialNumericValue.CURRENT_USER_ID);
                Object dominio = this.getEntityNumber(entity);
                List<Entity> extensions = entity.getExtensionsList();
                if (extensions != null && !extensions.isEmpty()) {
                    for (Entity extension : extensions) {
                        dominio = (String)dominio + ", " + this.getEntityNumber(extension);
                    }
                }
                CondicionTarea condicion = this.getTypedEntity(CondicionTarea.class);
                ArrayList<NativeQuerySegment> list = new ArrayList<NativeQuerySegment>();
                list.add(this.selectRecursosConTareasAsignadas(np, usuario, (String)dominio, condicion));
                list.add(this.selectRecursosConTareasPendientes(np, usuario, (String)dominio, condicion));
                return list;
            }
        }
        return null;
    }

    private NativeQuerySegment selectRecursosConTareasAsignadas(NumericPrimitive pk, String usuario, String dominio, CondicionTarea condicion) {
        NativeQuerySegment qs = pk.isIn(NativeQuery.of(this.selectRecursosConTareasAsignadas(usuario, dominio, condicion)));
        qs.setLocalizedCollectionLabel(ENGLISH, "Records with tasks assigned to you");
        qs.setLocalizedCollectionLabel(SPANISH, "Registros con tareas que usted tiene asignadas");
        qs.setLocalizedCollectionShortLabel(ENGLISH, "Records with assigned tasks");
        qs.setLocalizedCollectionShortLabel(SPANISH, "Registros con tareas asignadas");
        return qs;
    }

    private NativeQuerySegment selectRecursosConTareasPendientes(NumericPrimitive pk, String usuario, String dominio, CondicionTarea condicion) {
        NativeQuerySegment qs = pk.isIn(NativeQuery.of(this.selectRecursosConTareasPendientes(usuario, dominio, condicion)));
        qs.setLocalizedCollectionLabel(ENGLISH, "Records with pending tasks that you can perform");
        qs.setLocalizedCollectionLabel(SPANISH, "Registros con tareas pendientes que usted puede realizar");
        qs.setLocalizedCollectionShortLabel(ENGLISH, "Records with pending tasks");
        qs.setLocalizedCollectionShortLabel(SPANISH, "Registros con tareas pendientes");
        return qs;
    }

    private String selectRecursosConTareasAsignadas(String usuario, String dominio, CondicionTarea condicion) {
        String select = select_where_destinatario + (dominio.contains(",") ? and_clase_recurso_1a : and_clase_recurso_1b) + and_condicion_2a;
        Object asignada = condicion.ASIGNADA.getInstanceKeyValue();
        return StrUtils.getStringParametrizado(select, usuario, dominio, asignada);
    }

    private String selectRecursosConTareasPendientes(String usuario, String dominio, CondicionTarea condicion) {
        String select = select_where_destinatario + (dominio.contains(",") ? and_clase_recurso_1a : and_clase_recurso_1b) + and_condicion_2b;
        Object disponible = condicion.DISPONIBLE.getInstanceKeyValue();
        Object asignada = condicion.ASIGNADA.getInstanceKeyValue();
        return StrUtils.getStringParametrizado(select, usuario, dominio, disponible, asignada);
    }

    private String specialValueOf(SpecialNumericValue value) {
        SqlProgrammer sqlProgrammer = ChiefProgrammer.getSqlProgrammer();
        return sqlProgrammer == null ? value.name().toLowerCase() + "()" : sqlProgrammer.getSpecialNumericValue(value);
    }

    public SpecialPage addSpecialPage(SpecialPage specialPage) {
        return this._projectSpecialPages.put(specialPage.getCode(), specialPage);
    }

    public Map<String, SpecialPage> getProjectSpecialPagesMap() {
        return this._projectSpecialPages;
    }

    public Collection<SpecialPage> getProjectSpecialPagesCollection() {
        return this._projectSpecialPages.values();
    }

    @Override
    public boolean beforeWriting() {
        boolean beforeWriting = super.beforeWriting();
        boolean checkBundles = this.checkBundles();
        return beforeWriting && checkBundles;
    }

    private boolean checkBundles() {
        boolean b0 = this.checkBundle(new BaseBundle());
        boolean b1 = this.checkBundle(new BundleMensajes());
        boolean b2 = this.checkBundle(new BundleWebui());
        return b0 && b1 && b2;
    }

    private boolean checkBundle(BundleAbstracto bundle) {
        int warnings = 0;
        for (String warning : bundle.getWarnings()) {
            logger.warn((Object)warning);
            ++warnings;
        }
        int errors = 0;
        for (String error : bundle.getErrors()) {
            logger.error((Object)error);
            ++errors;
        }
        this.increaseWriterWarnings(warnings);
        this.increaseWriterErrors(errors);
        return errors == 0;
    }

    @Override
    protected boolean afterWriting(boolean ok) {
        boolean afterWriting = super.afterWriting(ok);
        boolean storeDictionary = this.storeDictionary();
        boolean checkDictionary = this.checkDictionary();
        return afterWriting && storeDictionary && checkDictionary;
    }

    @Override
    public ProjectObjectModelReader getProjectObjectModel() {
        return this.pom;
    }

    @Override
    public String getAdalidProjectVersion() {
        return this.pom.getProjectVersionNumber();
    }

    @Override
    protected void logAdalidProjectVersion() {
        this.pom.logProjectVersion();
    }

    @Override
    public void configureBuilder() {
        super.configureBuilder();
        this.enableProjectBuilderDictionary();
    }

    public boolean isDictionaryEnabled() {
        return this._dictionaryEnabled;
    }

    public void enableDictionary() {
        this.enableDictionary(this.getAlias());
    }

    public void enableDictionary(String subdir) {
        Dictionary.reset();
        String folder = subdir != null && subdir.matches("^\\w+$") ? subdir : this.getAlias();
        this._dictionaryEnabled = true;
        this._entitiesDictionary = SqlDictionary.load(ClaseRecurso.class, folder);
        this._entityParametersDictionary = SqlDictionary.load(DominioParametro.class, folder);
        this._modulesDictionary = SqlDictionary.load(ModuloAplicacion.class, folder);
        this._operationsDictionary = SqlDictionary.load(Funcion.class, folder);
        this._operationParametersDictionary = SqlDictionary.load(FuncionParametro.class, folder);
        this._pagesDictionary = SqlDictionary.load(Pagina.class, folder);
        this._parametersDictionary = SqlDictionary.load(Parametro.class, folder);
    }

    protected boolean isProjectBuilderDictionaryEnabled() {
        return this._projectBuilderDictionaryEnabled;
    }

    protected void enableProjectBuilderDictionary() {
        this._projectBuilderDictionary = ProjectBuilderDictionary.load();
        this._projectBuilderDictionaryEnabled = true;
    }

    private boolean storeDictionary() {
        if (this._dictionaryEnabled) {
            this._entitiesDictionary.store();
            this._entityParametersDictionary.store();
            this._modulesDictionary.store();
            this._operationsDictionary.store();
            this._operationParametersDictionary.store();
            this._pagesDictionary.store();
            this._parametersDictionary.store();
        }
        return this.storeProjectBuilderDictionary();
    }

    private boolean storeProjectBuilderDictionary() {
        if (this._projectBuilderDictionaryEnabled) {
            this._projectBuilderDictionary.setLastExecutedProjectAlias(this.getAlias());
            this._projectBuilderDictionary.setLastExecutedProjectBaseFolderName(this.getBaseFolderName());
            this._projectBuilderDictionary.setLastExecutedProjectClassName(this.getClass().getCanonicalName());
            this._projectBuilderDictionary.store();
        }
        return true;
    }

    private boolean checkDictionary() {
        if (this._dictionaryEnabled) {
            Dictionary.printSummary();
            return Dictionary.getErrorCount() == 0;
        }
        return true;
    }

    @Override
    public String getLastVersionCode() {
        List<Instance> list;
        Entity versionEntity = this.getVersionEntity();
        if (versionEntity != null && (list = versionEntity.getInstancesList()) != null) {
            Instance last = null;
            Collection<Instance> instances = ColUtils.sort(list, new ByInstanceKeyValue());
            Iterator<Instance> iterator = instances.iterator();
            while (iterator.hasNext()) {
                Instance instance;
                last = instance = iterator.next();
            }
            if (last != null) {
                String label = last.getInstanceKeyLabel();
                return label == null ? null : label.toString();
            }
        }
        return null;
    }

    @Override
    public Object getVersionEnumeration() {
        return this.getVersionEntity();
    }

    public Set<String> getEntityKeys() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.getEntitiesMap().keySet());
        return set;
    }

    public Set<String> getOperationKeys() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.getDefaultCrudOperationKeys());
        set.addAll(this.getUserDefinedOperationKeys());
        return set;
    }

    public Set<String> getDefaultCrudOperationKeys() {
        TreeSet<String> set = new TreeSet<String>();
        List<Entity> entities = this.getEntitiesList();
        String[] operations = Operation.getCrudOperationKeys();
        for (Entity entity : entities) {
            String simpleName = entity.getDataType().getSimpleName();
            for (String name : operations) {
                set.add(simpleName + "." + name);
            }
        }
        return set;
    }

    public Set<String> getUserDefinedOperationKeys() {
        TreeSet<String> set = new TreeSet<String>();
        List<Entity> entities = this.getEntitiesList();
        for (Entity entity : entities) {
            String simpleName = entity.getDataType().getSimpleName();
            for (Operation operation : entity.getOperationsList()) {
                set.add(simpleName + "." + operation.getName());
            }
        }
        return set;
    }

    public Set<String> getPageKeys() {
        TreeSet<String> set = new TreeSet<String>();
        set.addAll(this.getDisplaysMap().keySet());
        return set;
    }

    public Set<String> getParameterKeys() {
        TreeSet<String> set = new TreeSet<String>();
        List<Entity> entities = this.getEntitiesList();
        for (Entity entity : entities) {
            String simpleName = entity.getDataType().getSimpleName();
            for (Property property : entity.getPropertiesList()) {
                set.add(simpleName + "." + property.getName());
            }
            for (Operation operation : entity.getOperationsList()) {
                for (Parameter parameter : operation.getParametersList()) {
                    set.add(simpleName + "." + operation.getName() + "." + parameter.getName());
                }
            }
        }
        return set;
    }

    public String getEntityNumber(Entity entity) {
        return entity == null ? "?" : this.getEntityNumber(entity.getDataType());
    }

    public String getEntityNumber(Class<?> clazz) {
        return clazz == null || !Entity.class.isAssignableFrom(clazz) ? "?" : this.getEntityNumber(clazz.getSimpleName());
    }

    public String getEntityNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._entitiesDictionary);
    }

    public String getEntityParameterNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._entityParametersDictionary);
    }

    public String getModuleNumber(Project module) {
        return module == null ? "?" : this.getModuleNumber(module.getClass());
    }

    public String getModuleNumber(Class<?> clazz) {
        return clazz == null || !Project.class.isAssignableFrom(clazz) ? "?" : this.getModuleNumber(clazz.getCanonicalName());
    }

    public String getModuleNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._modulesDictionary);
    }

    public String getOperationNumber(Operation operation) {
        if (operation == null) {
            return "?";
        }
        String name = operation.getName();
        Entity declaringEntity = operation.getDeclaringEntity();
        return this.getOperationNumber(name, declaringEntity);
    }

    public String getOperationNumber(String name, Entity declaringEntity) {
        if (StringUtils.isBlank((String)name) || declaringEntity == null) {
            return "?";
        }
        String simpleName = declaringEntity.getDataType().getSimpleName();
        String key = simpleName + "." + name;
        return this.getOperationNumber(key);
    }

    public String getOperationNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._operationsDictionary);
    }

    public String getOperationParameterNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._operationParametersDictionary);
    }

    public String getPageNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._pagesDictionary);
    }

    public String getParameterNumber(Artifact artifact) {
        if (artifact == null) {
            return "?";
        }
        Artifact declaringArtifact = artifact.getDeclaringArtifact();
        if (declaringArtifact instanceof Entity) {
            Entity declaringEntity = (Entity)declaringArtifact;
            if (artifact instanceof Property || artifact instanceof EntityCollection) {
                String name = artifact.getName();
                return this.getParameterNumber(name, declaringEntity);
            }
        } else if (declaringArtifact instanceof Operation) {
            Operation declaringOperation = (Operation)declaringArtifact;
            if (artifact instanceof Parameter) {
                String name = artifact.getName();
                return this.getParameterNumber(name, declaringOperation);
            }
        }
        return "?";
    }

    public String getParameterNumber(String name, Entity declaringEntity) {
        if (StringUtils.isBlank((String)name) || declaringEntity == null) {
            return "?";
        }
        String simpleName = declaringEntity.getDataType().getSimpleName();
        String key = simpleName + "." + name;
        return this.getParameterNumber(key);
    }

    public String getParameterNumber(String name, Operation declaringOperation) {
        if (StringUtils.isBlank((String)name) || declaringOperation == null) {
            return "?";
        }
        Entity declaringEntity = declaringOperation.getDeclaringEntity();
        if (declaringEntity == null) {
            return "?";
        }
        String simpleName = declaringEntity.getDataType().getSimpleName();
        String key = simpleName + "." + declaringOperation.getName() + "." + name;
        return this.getParameterNumber(key);
    }

    public String getParameterNumber(String key) {
        return StringUtils.isBlank((String)key) ? "?" : this.longNumericCode(key, this._parametersDictionary);
    }

    private String longNumericCode(String key, Dictionary dictionary) {
        String humplessKey = StrUtils.getHumplessCase(key, '_');
        String numericCode = StrUtils.getLongNumericKeyCode(humplessKey);
        if (dictionary != null) {
            String value = dictionary.getProperty(key);
            if (Dictionary.isValidNumericCode(value)) {
                numericCode = value;
                dictionary.putProperty(key, numericCode);
            } else {
                dictionary.setProperty(key, numericCode);
            }
        }
        return numericCode;
    }

    @Override
    public String getBaseFolderName() {
        return StringUtils.defaultIfBlank((String)this._baseFolderName, (String)this.getDefaultBaseFolderName());
    }

    public void setBaseFolderName(String baseFolderName) {
        this._baseFolderName = StrUtils.getFileName(baseFolderName);
    }

    public String getDatabaseName() {
        return StringUtils.defaultIfBlank((String)this._databaseName, (String)this.getDefaultDatabaseName());
    }

    public void setDatabaseName(String databaseName) {
        this._databaseName = StrUtils.getLowerCaseIdentifier(databaseName, '-');
    }

    public String getDatabaseFormerSchemaName() {
        return StringUtils.defaultIfBlank((String)this._databaseFormerSchemaName, (String)this.getDefaultDatabaseFormerSchemaName());
    }

    public void setDatabaseFormerSchemaName(String databaseFormerSchemaName) {
        this._databaseFormerSchemaName = StrUtils.getLowerCaseIdentifier(databaseFormerSchemaName, '_');
    }

    public String getRootFolderName() {
        return StringUtils.defaultIfBlank((String)this._rootFolderName, (String)this.getDefaultRootFolderName());
    }

    public void setRootFolderName(String rootFolderName) {
        this._rootFolderName = StrUtils.getFileName(rootFolderName);
    }

    public String getRoleCodePrefix() {
        return StringUtils.trimToEmpty((String)this._roleCodePrefix);
    }

    public void setRoleCodePrefix(String roleCodePrefix) {
        this._roleCodePrefix = StrUtils.diacriticlessAscii(roleCodePrefix);
    }

    public String getMessageDigestAlgorithm() {
        return StringUtils.defaultIfBlank((String)this._messageDigestAlgorithm, (String)this.getDefaultMessageDigestAlgorithm());
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this._messageDigestAlgorithm = StrUtils.getIdentifier(messageDigestAlgorithm, '-');
    }

    public boolean isSqlBusinessAuditTrail() {
        return this._sqlBusinessAuditTrail;
    }

    public void setSqlBusinessAuditTrail(boolean enabled) {
        this._sqlBusinessAuditTrail = enabled;
    }

    public DatabaseLockingMechanism getDatabaseLockingMechanism() {
        return this._databaseLockingMechanism == null ? this.getDefaultDatabaseLockingMechanism() : this._databaseLockingMechanism;
    }

    public void setDatabaseLockingMechanism(DatabaseLockingMechanism databaseLockingMechanism) {
        this._databaseLockingMechanism = databaseLockingMechanism;
    }

    @Override
    public void print() {
        System.out.println(this.entidadesBasicas);
        System.out.println(this.configuracionBasica);
        System.out.println(this.operacionBasica);
    }

    protected String getDefaultBaseFolderName() {
        return this.getAlias();
    }

    protected String getDefaultDatabaseName() {
        return this.getAlias();
    }

    protected String getDefaultDatabaseFormerSchemaName() {
        return "former";
    }

    protected String getDefaultRootFolderName() {
        return this.getAlias();
    }

    protected String getDefaultMessageDigestAlgorithm() {
        return "MD5";
    }

    protected DatabaseLockingMechanism getDefaultDatabaseLockingMechanism() {
        return DatabaseLockingMechanism.ENTITY_VERSIONING;
    }

    static {
        ProyectoBase.setLocale(SPANISH);
    }
}

