/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2.meta.proyecto.base;

import adalid.commons.bundles.Bundle;
import adalid.commons.util.KVP;
import adalid.core.Page;
import adalid.core.Project;
import adalid.core.interfaces.Entity;
import adalid.core.interfaces.EnumerationEntity;
import adalid.core.jee.JavaWebModule;
import adalid.jee2.SpecialPage;
import adalid.jee2.help.en.DialogoFiltrarConsulta;
import adalid.jee2.help.en.Menu;
import adalid.jee2.help.es.BarraBotonesAccion1;
import adalid.jee2.help.es.BarraBotonesAccion2;
import adalid.jee2.help.es.DialogoGuardarConsulta;
import adalid.jee2.help.es.Favoritos;
import adalid.jee2.help.es.Personalizacion;
import adalid.jee2.meta.proyecto.base.ProyectoJava1;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;

public class ProyectoJava2
extends ProyectoJava1 {
    private static final String[] NECESSARY_BPL_ENTITY_NAMES = new String[]{"Usuario"};
    private static final String[] NECESSARY_DAF_ENTITY_NAMES = new String[]{"ArchivoAdjunto", "ClaseRecurso", "ColumnasOcultas", "ConjuntoSegmento", "DialogoDinamicoRemoto", "Dominio", "FiltroFuncion", "Funcion", "FuncionParametro", "GrupoUsuario", "Pagina", "PaginaEspecial", "Parametro", "RastroFuncion", "RastroInforme", "RastroProceso", "Rol", "TareaUsuario", "TareaUsuarioCorreo", "Usuario", "VistaFuncion"};
    private static final String[] X_PAGE_ARCHETYPE_NAMES = new String[]{"ArchivoAdjunto", "ElementoSegmento", "FuncionParametro", "RastroFuncion", "RastroFuncionPar", "RastroInforme", "RastroProceso", "TareaUsuario", "VistaFuncionCol"};
    private static final String[] X_PAGE_NAMES = new String[]{"Usuario34", "VistaFuncionCol21PorVista"};
    private static final String[] STRICTLY_PERSONALIZED_READING_PAGE_NAMES = new String[]{"FiltroFuncion21PorFuncion", "VistaFuncion21PorFuncion"};
    private static final String[] SPECIAL_PAGE_NAMES = new String[]{"Favoritos", "Menu", "Personalizacion", "HypertextFileViewer", "MultimediaPlayer", "StreamedContentViewer", "TextFileViewer"};
    private static final String[] SPECIAL_PAGE_ENTITY_NAMES = new String[]{"PaginaUsuario"};
    private static final String[] SPECIAL_HELP_PAGE_NAMES = new String[]{"Favoritos", "Menu", "Personalizacion"};
    private static final String[] SPECIAL_HELP_COMPONENT_NAMES = new String[]{"barraBotonesAccion1", "barraBotonesAccion2", "dialogoFiltrarConsulta", "dialogoGuardarConsulta"};
    protected final SpecialPage paginaCalendarioProcesos = SpecialPage.of("CalendarioProcesos", "/faces/views/base/code/CalendarioProcesos.xhtml");
    protected final SpecialPage paginaDistribucionTareas = SpecialPage.of("DistribucionTareas", "/faces/views/base/code/DistribucionTareas.xhtml");
    protected final SpecialPage paginaIndicadoresGestion = SpecialPage.of("IndicadoresGestion", "/faces/views/base/code/IndicadoresGestion.xhtml");
    protected final SpecialPage paginaMapaSitio = SpecialPage.of("Mapa", "/faces/views/base/code/Mapa.xhtml");
    private final Set<String> _entitiesReferencedByLocalPageFields = new TreeSet<String>();

    public List<String> getSpecialHelpPageNamesList() {
        return Arrays.asList(SPECIAL_HELP_PAGE_NAMES);
    }

    public List<String> getSpecialHelpComponentNamesList() {
        return Arrays.asList(SPECIAL_HELP_COMPONENT_NAMES);
    }

    @Override
    public void addDirectives() {
        super.addDirectives();
    }

    @Override
    public void addAttributes() {
        Entity entity;
        super.addAttributes();
        this.addAttribute("custom_layout", (Object)false);
        this.addAttribute("hlb_rendering", (Object)false);
        this.addAttribute("hcb_rendering", (Object)false);
        this.addAttribute("hrb_rendering", (Object)false);
        this.addAttribute("inline_help_rendering", (Object)true);
        this.addAttribute("partial_state_saving", (Object)true);
        this.addAttribute("primefaces_messages_escape", (Object)false);
        this.addAttribute("primefaces_inline_help_escape", (Object)false);
        this.addAttribute("primefaces_output_label_escape", (Object)false);
        this.addAttribute("primefaces_tooltip_escape", (Object)false);
        this.addAttribute("check_mailer_bean_session_before_each_delivery", (Object)false);
        Map<String, Entity> entitiesMap = this.getEntitiesMap();
        for (String name : X_PAGE_ARCHETYPE_NAMES) {
            if (!entitiesMap.containsKey(name)) continue;
            entity = entitiesMap.get(name);
            entity.addAttribute("page_archetype_package_name_suffix", (Object)"ext");
        }
        for (String name : X_PAGE_NAMES) {
            this.addAttribute((Class<?>)Page.class, name, KVP.join("abstract", (Object)true));
        }
        for (String name : STRICTLY_PERSONALIZED_READING_PAGE_NAMES) {
            this.addAttribute((Class<?>)Page.class, name, KVP.join("strictly.personalized.reading", (Object)true));
        }
        String directory = "special-page/";
        String extension = "." + this.getWebPageFileExtension();
        for (String name : SPECIAL_PAGE_NAMES) {
            this.addAttribute((Class<?>)Page.class, name, KVP.join("help.file.name", (Object)("special-page/" + name + extension)));
        }
        for (String name : SPECIAL_PAGE_ENTITY_NAMES) {
            if (!entitiesMap.containsKey(name)) continue;
            entity = entitiesMap.get(name);
            entity.setDisplayAvailable(true);
        }
        this.addHelpPageTextAttributes();
    }

    public void addHolidaysListBeanAttribute() {
        String beanName = "holidaysList";
        this.addHolidaysListBeanAttribute("holidaysList");
    }

    public void addHolidaysListBeanAttribute(String beanName) {
        String classSimpleName = "HolidaysList";
        this.addBeanAttribute("HolidaysList", beanName);
    }

    public String getHelpDocumentAttribute(String name) {
        Object attribute = this.getKeyValuePairAttribute(name, "help.embedded.document");
        return attribute == null ? this.getHelpDocument() : attribute.toString();
    }

    public String getHelpFileNameAttribute(String name) {
        Object attribute = this.getKeyValuePairAttribute(name, "help.file.name");
        return attribute == null ? this.getHelpFileName() : attribute.toString();
    }

    public String getHelpPageTextAttribute(String name) {
        Object attribute = this.getKeyValuePairAttribute(name, "help.page.text");
        return attribute == null ? null : attribute.toString();
    }

    private void addHelpPageTextAttributes() {
        String pid = "Favoritos";
        String str = new adalid.jee2.help.en.Favoritos(this).getHelpPageText();
        this.addAttribute((Class<?>)Page.class, pid + ":en", KVP.join("help.page.text", (Object)str));
        str = new Favoritos(this).getHelpPageText();
        this.addAttribute((Class<?>)Page.class, pid + ":es", KVP.join("help.page.text", (Object)str));
        pid = "Menu";
        str = new Menu(this).getHelpPageText();
        this.addAttribute((Class<?>)Page.class, pid + ":en", KVP.join("help.page.text", (Object)str));
        str = new adalid.jee2.help.es.Menu(this).getHelpPageText();
        this.addAttribute((Class<?>)Page.class, pid + ":es", KVP.join("help.page.text", (Object)str));
        pid = "Personalizacion";
        str = new adalid.jee2.help.en.Personalizacion(this).getHelpPageText();
        this.addAttribute((Class<?>)Page.class, pid + ":en", KVP.join("help.page.text", (Object)str));
        str = new Personalizacion(this).getHelpPageText();
        this.addAttribute((Class<?>)Page.class, pid + ":es", KVP.join("help.page.text", (Object)str));
        pid = "barraBotonesAccion1";
        str = new adalid.jee2.help.en.BarraBotonesAccion1(this).getHelpPageText();
        this.addAttribute((Class<?>)Component.class, pid + ":en", KVP.join("help.page.text", (Object)str));
        str = new BarraBotonesAccion1(this).getHelpPageText();
        this.addAttribute((Class<?>)Component.class, pid + ":es", KVP.join("help.page.text", (Object)str));
        pid = "barraBotonesAccion2";
        str = new adalid.jee2.help.en.BarraBotonesAccion2(this).getHelpPageText();
        this.addAttribute((Class<?>)Component.class, pid + ":en", KVP.join("help.page.text", (Object)str));
        str = new BarraBotonesAccion2(this).getHelpPageText();
        this.addAttribute((Class<?>)Component.class, pid + ":es", KVP.join("help.page.text", (Object)str));
        pid = "dialogoFiltrarConsulta";
        str = new DialogoFiltrarConsulta(this).getHelpPageText();
        this.addAttribute((Class<?>)Component.class, pid + ":en", KVP.join("help.page.text", (Object)str));
        str = new adalid.jee2.help.es.DialogoFiltrarConsulta(this).getHelpPageText();
        this.addAttribute((Class<?>)Component.class, pid + ":es", KVP.join("help.page.text", (Object)str));
        pid = "dialogoGuardarConsulta";
        str = new adalid.jee2.help.en.DialogoGuardarConsulta(this).getHelpPageText();
        this.addAttribute((Class<?>)Component.class, pid + ":en", KVP.join("help.page.text", (Object)str));
        str = new DialogoGuardarConsulta(this).getHelpPageText();
        this.addAttribute((Class<?>)Component.class, pid + ":es", KVP.join("help.page.text", (Object)str));
    }

    @Override
    public void configureGenerator() {
        super.configureGenerator();
        this.addSpecialPageCalendarioProcesos();
        this.addSpecialPageDistribucionTareas();
        this.addSpecialPageIndicadoresGestion();
        this.addSpecialPageMapaSitio();
    }

    private void addSpecialPageCalendarioProcesos() {
        this.paginaCalendarioProcesos.setIconClass("fa fa-calendar-check-o");
        this.paginaCalendarioProcesos.setLocalizedLabel(Bundle.ENGLISH, "Scheduled processes");
        this.paginaCalendarioProcesos.setLocalizedLabel(Bundle.SPANISH, "Procesos calendarizados");
        this.paginaCalendarioProcesos.setLocalizedShortDescription(Bundle.ENGLISH, "Execution of scheduled processes");
        this.paginaCalendarioProcesos.setLocalizedShortDescription(Bundle.SPANISH, "Ejecuci\u00f3n de procesos calendarizados");
        this.paginaCalendarioProcesos.setStartOption(false);
        this.addSpecialPage(this.paginaCalendarioProcesos);
    }

    private void addSpecialPageDistribucionTareas() {
        this.paginaDistribucionTareas.setIconClass("fa fa-bar-chart");
        this.paginaDistribucionTareas.setLocalizedLabel(Bundle.ENGLISH, "Task distribution");
        this.paginaDistribucionTareas.setLocalizedLabel(Bundle.SPANISH, "Distribuci\u00f3n de tareas");
        this.paginaDistribucionTareas.setLocalizedShortDescription(Bundle.ENGLISH, "Task distribution charts");
        this.paginaDistribucionTareas.setLocalizedShortDescription(Bundle.SPANISH, "Gr\u00e1ficos de distribuci\u00f3n de tareas");
        this.paginaDistribucionTareas.setStartOption(false);
        this.addSpecialPage(this.paginaDistribucionTareas);
    }

    private void addSpecialPageIndicadoresGestion() {
        this.paginaIndicadoresGestion.setIconClass("fa fa-dashboard");
        this.paginaIndicadoresGestion.setLocalizedLabel(Bundle.ENGLISH, "Dashboard");
        this.paginaIndicadoresGestion.setLocalizedLabel(Bundle.SPANISH, "Tablero");
        this.paginaIndicadoresGestion.setLocalizedShortDescription(Bundle.ENGLISH, "Dashboard of management indicators");
        this.paginaIndicadoresGestion.setLocalizedShortDescription(Bundle.SPANISH, "Tablero de indicadores de gesti\u00f3n");
        this.paginaIndicadoresGestion.setStartOption(true);
        this.addSpecialPage(this.paginaIndicadoresGestion);
    }

    private void addSpecialPageMapaSitio() {
        this.paginaMapaSitio.setIconClass("fa fa-sitemap fa-rotate-270");
        this.paginaMapaSitio.setLocalizedLabel(Bundle.ENGLISH, "Site Map");
        this.paginaMapaSitio.setLocalizedLabel(Bundle.SPANISH, "Mapa del Sitio");
        this.paginaMapaSitio.setLocalizedShortDescription(Bundle.ENGLISH, "Site Map");
        this.paginaMapaSitio.setLocalizedShortDescription(Bundle.SPANISH, "Mapa del Sitio");
        this.paginaMapaSitio.setStartOption(true);
        this.addSpecialPage(this.paginaMapaSitio);
    }

    @Override
    protected void disablePrivateAndOtherContextEntitiesCodeGen() {
        this.addEntitiesReferencedByPageFields(true);
        super.disablePrivateAndOtherContextEntitiesCodeGen();
    }

    protected void addEntitiesReferencedByPageFields() {
        this.addEntitiesReferencedByPageFields(false);
    }

    protected void addEntitiesReferencedByPageFields(boolean hidden) {
        for (Project module : this.getModulesList()) {
            if (!(module instanceof JavaWebModule)) continue;
            JavaWebModule jwm = (JavaWebModule)((Object)module);
            for (Page page : jwm.getPagesList()) {
                Set<Entity> entities;
                if (!page.isApplicationDefaultLocation() || (entities = page.getEntitiesReferencedByFields(hidden)) == null || entities.isEmpty()) continue;
                for (Entity entity : entities) {
                    if (entity == null || entity instanceof EnumerationEntity) continue;
                    this._entitiesReferencedByLocalPageFields.add(entity.getDataClass().getSimpleName());
                }
            }
        }
    }

    @Override
    protected boolean isOptionalBplCodeGen(Entity entity) {
        return entity != null && !this.necessary(entity, NECESSARY_BPL_ENTITY_NAMES);
    }

    @Override
    protected boolean isOptionalDafCodeGen(Entity entity) {
        return entity != null && !(entity instanceof EnumerationEntity) && !this.necessary(entity) && !this.necessary(entity, NECESSARY_DAF_ENTITY_NAMES);
    }

    private boolean necessary(Entity entity) {
        return this._entitiesReferencedByLocalPageFields.contains(entity.getDataClass().getSimpleName());
    }

    private boolean necessary(Entity entity, String[] simpleNames) {
        return ArrayUtils.contains((Object[])simpleNames, (Object)entity.getDataClass().getSimpleName());
    }
}

