/*
 * Decompiled with CFR 0.152.
 */
package adalid.jee2.meta.proyecto.base;

import adalid.commons.AbstractProjectObjectModel;
import adalid.commons.ProjectObjectModelReader;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.StrUtils;
import adalid.jee2.ProjectDependency;
import adalid.jee2.ProjectDependencyScope;
import adalid.jee2.ProjectModuleType;
import adalid.jee2.meta.proyecto.base.ProyectoJava2;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public abstract class ProyectoMaven
extends ProyectoJava2 {
    protected static final String POM_PROPERTIES = "/pom.properties";
    protected static final String DEFAULT_TLD = "org";
    protected static final String DEFAULT_SLD = "xyz";
    protected static final String DEFAULT_VERSION = "1.0-SNAPSHOT";
    private final ProjectModuleType[] _projectModuleTypes = ProjectModuleType.values();
    private final Map<ProjectModuleType, Map<String, ProjectDependency>> _projectDependencies;
    private Properties _pom;
    private String _groupId;
    private String _version;
    private final ProjectObjectModelReader pom = new AbstractProjectObjectModel("/pom.properties"){};

    public ProyectoMaven() {
        this._projectDependencies = new LinkedHashMap<ProjectModuleType, Map<String, ProjectDependency>>();
        for (ProjectModuleType moduleType : this._projectModuleTypes) {
            this._projectDependencies.put(moduleType, new LinkedHashMap());
        }
    }

    public ProjectObjectModelReader getMetaProjectObjectModel() {
        return this.pom;
    }

    public boolean addProjectDependency(ProjectDependency dependency) {
        if (dependency != null && dependency.isValid()) {
            boolean added = false;
            for (ProjectModuleType moduleType : this._projectModuleTypes) {
                added |= this.addProjectDependency(dependency, moduleType);
            }
            return added;
        }
        return false;
    }

    public boolean addProjectDependency(ProjectDependency dependency, ProjectModuleType moduleType) {
        if (dependency != null && dependency.isValid() && moduleType != null) {
            this.putProjectDependency(dependency, moduleType);
            if (ProjectModuleType.LIB.equals((Object)moduleType) && ProjectDependencyScope.PROVIDED.getMavenScope().equals(dependency.getScope())) {
                this.putProjectDependency(dependency, ProjectModuleType.LIB_DIR);
            }
            return true;
        }
        return false;
    }

    private void putProjectDependency(ProjectDependency dependency, ProjectModuleType moduleType) {
        Map<String, ProjectDependency> map = this._projectDependencies.get((Object)moduleType);
        String key = dependency.getKey();
        map.put(key, dependency.merge(map.get(key)));
    }

    public boolean removeProjectDependency(ProjectDependency dependency) {
        if (dependency != null) {
            boolean removed = false;
            for (ProjectModuleType moduleType : this._projectModuleTypes) {
                removed |= this.removeProjectDependency(dependency, moduleType);
            }
            return removed;
        }
        return false;
    }

    public boolean removeProjectDependency(ProjectDependency dependency, ProjectModuleType moduleType) {
        return dependency != null && moduleType != null && this._projectDependencies.get((Object)moduleType).remove(dependency.getKey()) != null;
    }

    protected void clearProjectDependencies() {
        for (ProjectModuleType moduleType : this._projectModuleTypes) {
            this.clearProjectDependencies(moduleType);
        }
    }

    protected void clearProjectDependencies(ProjectModuleType moduleType) {
        if (moduleType != null) {
            this._projectDependencies.get((Object)moduleType).clear();
        }
    }

    public Map<ProjectModuleType, Map<String, ProjectDependency>> getProjectDependencies() {
        return this._projectDependencies;
    }

    public List<ProjectDependency> getProjectDependencies(String moduleType) {
        return this.getProjectDependencies(ProjectModuleType.of(moduleType));
    }

    public List<ProjectDependency> getProjectDependencies(ProjectModuleType moduleType) {
        return moduleType == null ? null : new ArrayList<ProjectDependency>(this._projectDependencies.get((Object)moduleType).values());
    }

    @Override
    protected boolean readyToWrite(String platform) {
        boolean ready = super.readyToWrite(platform);
        this._pom = PropertiesHandler.getResourceAsProperties(POM_PROPERTIES);
        return ready && this._pom != null && !this._pom.isEmpty();
    }

    public Properties getPomProperties() {
        return this._pom;
    }

    public String getGroupId() {
        return StringUtils.defaultIfBlank((String)this._groupId, (String)this.getDefaultGroupId());
    }

    public void setGroupId(String groupId) {
        this._groupId = StrUtils.getMavenIdentifier(groupId);
    }

    public String getArtifactId() {
        return this.getAlias();
    }

    public String getVersion() {
        return StringUtils.defaultIfBlank((String)this._version, (String)this.getDefaultVersion());
    }

    public void setVersion(String version) {
        this._version = StrUtils.getMavenVersion(version);
    }

    public String getVersionNumber() {
        String version = this.getVersion();
        return version.contains("SNAPSHOT") ? StringUtils.replace((String)version, (String)"SNAPSHOT", (String)this.getBuildDate()) : version;
    }

    protected String getDefaultGroupId() {
        String groupId;
        if (this._pom != null && StringUtils.isNotBlank((String)(groupId = this._pom.getProperty("project.groupId")))) {
            return StrUtils.getMavenIdentifier(groupId) + "." + this.getAlias();
        }
        return "org.xyz." + this.getAlias();
    }

    protected String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    @Override
    protected String getDefaultEarProjectName() {
        return this.getAlias() + "-ear";
    }

    @Override
    protected String getDefaultWebProjectName() {
        return this.getAlias() + "-web";
    }

    @Override
    protected String getDefaultWebApiProjectName() {
        return this.getAlias() + "-web-api";
    }

    @Override
    protected String getDefaultRootPackageName() {
        String alias;
        String group = StrUtils.getLowerCaseIdentifier(this.getGroupId(), '.');
        return group.contains(alias = this.getAlias()) ? group : group + "." + alias;
    }

    @Override
    protected String getDefaultPersistenceRootPackageName() {
        return super.getDefaultPersistenceRootPackageName();
    }
}

