/*
 * Decompiled with CFR 0.152.
 */
package adalid.util;

import adalid.commons.MainClass;
import adalid.commons.ProjectBuilder;
import adalid.commons.ProjectObjectModelReader;
import adalid.commons.properties.BootstrappingFile;
import adalid.commons.properties.ProjectBuilderDictionary;
import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.FilUtils;
import adalid.commons.util.RunUtils;
import adalid.util.ProjectObjectModel;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Utility {
    private static final Logger logger;
    private static final String ARGS_FAILED = "method getArguments failed";
    private static final String ARGS_SUFFIX = ".args";
    private static final boolean TESTING = false;
    public static final String FILE_SEP;
    public static final String USER_DIR;
    public static final String USER_HOME;
    public static final String OS_NAME;
    public static final boolean WINDOWS;
    private static ProjectObjectModelReader pom;
    private static ProjectBuilderDictionary pbd;
    private final long startTime = System.currentTimeMillis();

    private static ProjectObjectModelReader pom() {
        if (pom == null) {
            pom = new ProjectObjectModel();
        }
        return pom;
    }

    protected static String getAdalidProjectVersion() {
        return Utility.pom().getProjectVersionNumber();
    }

    protected static void logAdalidProjectVersion() {
        Utility.pom().logProjectVersion();
    }

    protected static void updateProjectBuilderDictionary(Class<?> clazz) {
    }

    private static ProjectBuilderDictionary pbd() {
        if (pbd == null) {
            pbd = ProjectBuilderDictionary.load();
        }
        return pbd;
    }

    public static <T extends Utility> T instanceOf(Class<T> clazz) throws Exception {
        return (T)((Utility)Utility.newInstance(clazz));
    }

    public static <T> T newInstance(Class<T> clazz) throws Exception {
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static String getLastExecutedProjectAlias() {
        return Utility.pbd().getLastExecutedProjectAlias();
    }

    public static String getLastExecutedProjectBaseFolderName() {
        return Utility.pbd().getLastExecutedProjectBaseFolderName();
    }

    public static String getLastExecutedProjectClassName() {
        return Utility.pbd().getLastExecutedProjectClassName();
    }

    public static Class<? extends ProjectBuilder> getLastExecutedProjectClass() {
        return Utility.pbd().getLastExecutedProjectClass();
    }

    public static ProjectBuilder getLastExecutedProject() {
        return Utility.pbd().getLastExecutedProject();
    }

    public static void logSystemProperties() {
        Properties properties = System.getProperties();
        TreeSet<String> names = new TreeSet<String>(properties.stringPropertyNames());
        for (String name : names) {
            logger.info((Object)(name + "=" + System.getProperty(name)));
        }
    }

    public static String chooseDirectory(String path) {
        String currentDirectoryPath = FilUtils.isDirectory(path) ? path : USER_DIR;
        JFileChooser chooser = new JFileChooser(currentDirectoryPath);
        chooser.setFileSelectionMode(1);
        int option = chooser.showOpenDialog(null);
        return option == 0 ? chooser.getSelectedFile().getPath() : null;
    }

    public static String chooseFile(String path) {
        return Utility.chooseFile(path, (FileFilter[])null);
    }

    public static String chooseFile(String path, List<? extends FileFilter> list) {
        if (list == null) {
            return Utility.chooseFile(path, (FileFilter[])null);
        }
        FileFilter[] array1 = new FileFilter[list.size()];
        FileFilter[] array2 = list.toArray(array1);
        return Utility.chooseFile(path, true, array2);
    }

    public static String chooseFile(String path, FileFilter ... filters) {
        return Utility.chooseFile(path, true, filters);
    }

    public static String chooseFile(String path, boolean acceptAllFileFilterUsed, FileFilter ... filters) {
        int option;
        String currentDirectoryPath = FilUtils.isDirectory(path) ? path : USER_DIR;
        JFileChooser chooser = new JFileChooser(currentDirectoryPath);
        chooser.setFileSelectionMode(0);
        if (filters != null && filters.length > 0) {
            for (FileFilter filter : filters) {
                chooser.addChoosableFileFilter(filter);
            }
            chooser.setFileFilter(filters[0]);
            chooser.setAcceptAllFileFilterUsed(acceptAllFileFilterUsed);
        }
        return (option = chooser.showOpenDialog(null)) == 0 ? chooser.getSelectedFile().getPath() : null;
    }

    public static String[] getArguments(Class<?> clazz) {
        return Utility.getArguments(clazz == null ? null : clazz.getName());
    }

    public static String[] getArguments(String clazz) {
        String[] arguments = null;
        if (clazz == null) {
            logger.error((Object)"method getArguments failed; null value for clazz parameter");
        } else {
            ExtendedProperties properties = PropertiesHandler.getPrivateProperties();
            arguments = Utility.getArguments(clazz, properties, Level.TRACE);
            if (arguments == null) {
                properties = PropertiesHandler.getBootstrapping();
                arguments = Utility.getArguments(clazz, properties, Level.INFO);
            }
        }
        return arguments == null ? new String[]{} : arguments;
    }

    private static String[] getArguments(String clazz, ExtendedProperties properties, Level level) {
        if (properties == null) {
            logger.log((Priority)level, (Object)"method getArguments failed; properties is null");
        } else if (properties.isEmpty()) {
            logger.log((Priority)level, (Object)"method getArguments failed; properties is empty");
        } else {
            String key = clazz + ARGS_SUFFIX;
            try {
                String[] strings = properties.getStringArray(key);
                if (strings != null && strings.length != 0) {
                    return strings;
                }
                logger.log((Priority)level, (Object)("method getArguments failed; property " + key + " not found"));
            }
            catch (Exception e) {
                logger.log((Priority)level, (Object)("method getArguments failed; " + key + " not properly defined (" + e + ")"));
            }
        }
        return null;
    }

    public static boolean showConfirmDialog(String message, String title) {
        return Utility.showConfirmDialog(message, title, 3);
    }

    public static boolean showConfirmDialog(String message, String title, int messageType) {
        boolean type = false;
        int showConfirmDialog = JOptionPane.showConfirmDialog(null, message, title, 0, messageType);
        logger.info((Object)(title + " = " + (showConfirmDialog == 0 ? "Yes" : "No")));
        return showConfirmDialog == 0;
    }

    public static ExtendedProperties getBootstrapping() {
        return PropertiesHandler.getBootstrapping();
    }

    public static void setBootstrappingFileName(String name) {
        BootstrappingFile.setName(name);
    }

    protected String starting() {
        return this.starting(this.getClass());
    }

    protected String starting(Class<?> clazz) {
        return RunUtils.starting(clazz);
    }

    protected String finished() {
        return this.finished(this.getClass());
    }

    protected String finished(Class<?> clazz) {
        return this.finished(clazz, this.startTime);
    }

    protected String finished(Class<?> clazz, long millis) {
        return RunUtils.finished(clazz, millis);
    }

    static {
        MainClass.init();
        logger = Logger.getLogger(Utility.class);
        FILE_SEP = System.getProperty("file.separator");
        USER_DIR = System.getProperty("user.dir");
        USER_HOME = System.getProperty("user.home");
        OS_NAME = System.getProperty("os.name");
        WINDOWS = StringUtils.containsIgnoreCase((String)OS_NAME, (String)"windows");
    }
}

