/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import adalid.commons.properties.PropertiesHandler;
import adalid.commons.util.StrUtils;
import adalid.util.Utility;
import adalid.util.io.SmallFile;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FolderBrowser
extends Utility {
    private static final Logger logger = Logger.getLogger(FolderBrowser.class);
    private static final String B = "^";
    private static final String E = "$";
    private static final String X = ".*";
    private static final String D = "\\.";
    private final File rootFolder = PropertiesHandler.getRootFolder();
    private final Path rootFolderPath;
    private final File resourcesFolder;
    private final Path resourcesFolderPath;
    private final Path resourcesFolderRelativePath;
    private final File baseFolder;
    private final Path baseFolderPath;
    private final Map<Path, SmallFile> files;
    private final Map<String, Integer> fileTypes;
    private final Map<Path, Set<Path>> folders;
    private boolean detailAll;
    private List<String> detailPatterns;
    private int readingWarnings;
    private int readingErrors;

    public FolderBrowser(String path) {
        if (this.rootFolder == null) {
            throw new RuntimeException("root folder is missing or invalid");
        }
        this.rootFolderPath = Paths.get(this.rootFolder.getPath(), new String[0]);
        logger.info((Object)("root-folder=" + this.rootFolderPath));
        path = FolderBrowser.chooseDirectory(path);
        if (path == null) {
            throw new IllegalArgumentException("null folder path");
        }
        File file = new File(path);
        this.resourcesFolder = file.isAbsolute() ? file : new File(this.rootFolder.getAbsolutePath(), path);
        this.resourcesFolderPath = Paths.get(this.resourcesFolder.getPath(), new String[0]);
        this.resourcesFolderRelativePath = this.getRelativePath(this.resourcesFolderPath);
        logger.info((Object)("resources-folder=" + this.resourcesFolderPath));
        if (this.resourcesFolder.isDirectory()) {
            if (this.resourcesFolder.isHidden()) {
                throw new IllegalArgumentException(this.resourcesFolderPath + " is a hidden directory");
            }
        } else {
            throw new IllegalArgumentException(this.resourcesFolderPath + " is not a directory");
        }
        this.baseFolder = this.resourcesFolder.getParentFile();
        this.baseFolderPath = Paths.get(this.baseFolder.getPath(), new String[0]);
        logger.info((Object)("base-folder=" + this.baseFolderPath));
        this.files = new TreeMap<Path, SmallFile>();
        this.fileTypes = new TreeMap<String, Integer>();
        this.folders = new TreeMap<Path, Set<Path>>();
    }

    public FolderBrowser(String path, boolean detail) {
        this(path);
        this.detailAll = detail;
    }

    public FolderBrowser(String path, List<String> details) {
        this(path);
        this.detailAll = false;
        this.detailPatterns = details;
    }

    public boolean browse() {
        logger.info((Object)("browse" + StrUtils.enclose(this.resourcesFolderPath.toString())));
        this.init();
        this.doFiles();
        this.printSummary();
        FolderBrowser.updateProjectBuilderDictionary(FolderBrowser.class);
        return this.readingErrors == 0;
    }

    private void init() {
        this.readingWarnings = 0;
        this.readingErrors = 0;
    }

    protected boolean doFiles() {
        this.folders.clear();
        Collection list = FileUtils.listFiles((File)this.resourcesFolder, (IOFileFilter)this.fileFilter(), (IOFileFilter)this.dirFilter());
        for (File file : list) {
            this.addFolder(file);
            this.processFile(file);
        }
        return true;
    }

    private Path getRelativePath(Path path) {
        if (path.startsWith(this.resourcesFolderPath)) {
            try {
                return this.resourcesFolderPath.relativize(path);
            }
            catch (IllegalArgumentException ex) {
                return path;
            }
        }
        return path;
    }

    private void addFolder(File file) {
        Path path = Paths.get(file.getPath(), new String[0]);
        this.addFolder(this.getRelativePath(path), true);
    }

    private void addFolder(Path path, boolean file) {
        Set<Path> set;
        boolean rfp;
        Path parent = path.getParent();
        boolean bl = rfp = parent == null;
        if (rfp) {
            parent = this.resourcesFolderRelativePath;
        }
        if ((set = this.folders.get(parent)) == null) {
            if (!rfp) {
                this.addFolder(parent, false);
            }
            set = new TreeSet<Path>();
            this.folders.put(parent, set);
        }
        if (file) {
            set.add(path);
        }
    }

    protected void processFile(File file) {
        SmallFile sf = new SmallFile(file.getPath());
        sf.read();
        Charset charset = sf.getCharset();
        String name = sf.getName();
        String extension = StringUtils.defaultIfBlank((String)sf.getExtension().toLowerCase(), (String)"?");
        if (charset == null) {
            ++this.readingErrors;
            logger.error((Object)(name + " could not be read using any of the specified character sets "));
        } else if (sf.isEmpty()) {
            ++this.readingWarnings;
            logger.warn((Object)(name + " is empty "));
        } else {
            this.files.put(sf.getPath(), sf);
            this.updateFileTypes("" + charset);
            this.updateFileTypes(charset + " / " + extension);
        }
    }

    private void updateFileTypes(String type) {
        if (this.fileTypes.containsKey(type)) {
            int count = this.fileTypes.get(type);
            this.fileTypes.put(type, ++count);
        } else {
            this.fileTypes.put(type, 1);
        }
    }

    private void printSummary() {
        logger.info((Object)(this.files.size() + " files "));
        logger.info((Object)(this.fileTypes.size() + " file types "));
        for (String type : this.fileTypes.keySet()) {
            String tab = type.contains("/") ? "\t" : "";
            logger.info((Object)(tab + type + " = " + this.fileTypes.get(type)));
            this.printDetail(type);
        }
        logger.info((Object)(this.readingWarnings + " reading warnings "));
        logger.info((Object)(this.readingErrors + " reading errors "));
        logger.info((Object)"");
    }

    private void printDetail(String type) {
        if (this.detailAll || this.matches(type)) {
            String baseFolderPathString = this.baseFolderPath.toString();
            String tab = type.contains("/") ? "\t" : "";
            for (SmallFile sf : this.files.values()) {
                Charset charset = sf.getCharset();
                String extension = StringUtils.defaultIfBlank((String)sf.getExtension(), (String)"?");
                if (charset == null || !type.equals(charset + " / " + extension)) continue;
                logger.info((Object)(tab + "\t" + StringUtils.removeStartIgnoreCase((String)sf.getName(), (String)baseFolderPathString)));
            }
        }
    }

    private boolean matches(String type) {
        if (this.detailPatterns == null || this.detailPatterns.isEmpty()) {
            return false;
        }
        for (String regex : this.detailPatterns) {
            if (!type.matches(regex)) continue;
            return true;
        }
        return false;
    }

    protected IOFileFilter fileFilter() {
        return this.defaultFileFilter();
    }

    protected final IOFileFilter defaultFileFilter() {
        IOFileFilter fileFileFilter = FileFilterUtils.fileFileFilter();
        RegexFileFilter fileExtensions = this.defaultFileFilterExcludedFileExtensions();
        RegexFileFilter noNameDotFiles = this.defaultFileFilterExcludedNoNameDotFiles();
        IOFileFilter[] noes = new IOFileFilter[]{fileExtensions, noNameDotFiles};
        IOFileFilter noesFileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])noes));
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{fileFileFilter, noesFileFilter});
        return filter;
    }

    private RegexFileFilter defaultFileFilterExcludedFileExtensions() {
        String group = "(?i)(class|db|ear|err|jar|lnk|log|nbm|out|war|zip)";
        String regex = "^(.*)(\\.)" + group + E;
        logger.info((Object)("ExcludedFileExtensions=" + regex));
        return new RegexFileFilter(regex);
    }

    private RegexFileFilter defaultFileFilterExcludedNoNameDotFiles() {
        String group = "(?i)(classpath|gitignore|project)";
        String regex = "^(\\.)" + group + E;
        logger.info((Object)("ExcludedNoNameDotFiles=" + regex));
        return new RegexFileFilter(regex);
    }

    protected final IOFileFilter selectedFilesFilter() {
        IOFileFilter filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{this.selectedBinaryFilesFilter(), this.selectedImageFilesFilter(), this.selectedTextFilesFilter()});
        return filter;
    }

    protected final IOFileFilter selectedBinaryFilesFilter() {
        String group = "(?i)(doc|docx|pdf|ppt|pptx|xls|xlsx)";
        String regex = "^(.*)(\\.)" + group + E;
        logger.info((Object)("selectedBinaryFilesFilter=" + regex));
        IOFileFilter fileFileFilter = FileFilterUtils.fileFileFilter();
        RegexFileFilter fileExtensions = new RegexFileFilter(regex);
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{fileFileFilter, fileExtensions});
        return filter;
    }

    protected final IOFileFilter selectedImageFilesFilter() {
        String group = "(?i)(bmp|git|jpe?g|png|tiff)";
        String regex = "^(.*)(\\.)" + group + E;
        logger.info((Object)("selectedImageFilesFilter=" + regex));
        IOFileFilter fileFileFilter = FileFilterUtils.fileFileFilter();
        RegexFileFilter fileExtensions = new RegexFileFilter(regex);
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{fileFileFilter, fileExtensions});
        return filter;
    }

    protected final IOFileFilter selectedTextFilesFilter() {
        String group = "(?i)(bat|bpmn|conf|css|csv|html|java|jrtx|jrxml|js|jsp|jspf|properties|psql|sh|sql|tsv|txt|vm|xhtml|xml)";
        String regex = "^(.*)(\\.)" + group + E;
        logger.info((Object)("selectedTextFilesFilter=" + regex));
        IOFileFilter fileFileFilter = FileFilterUtils.fileFileFilter();
        RegexFileFilter fileExtensions = new RegexFileFilter(regex);
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{fileFileFilter, fileExtensions});
        return filter;
    }

    protected IOFileFilter dirFilter() {
        IOFileFilter makeCVSSVNAware = FileFilterUtils.makeCVSAware((IOFileFilter)FileFilterUtils.makeSVNAware(null));
        IOFileFilter[] noes = new IOFileFilter[]{new RegexFileFilter("^.*\\.git$"), new RegexFileFilter("^build$"), new RegexFileFilter("^dist$"), new RegexFileFilter("^target$")};
        IOFileFilter noesFileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])noes));
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{makeCVSSVNAware, noesFileFilter});
        return filter;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public Path getRootFolderPath() {
        return this.rootFolderPath;
    }

    public File getResourcesFolder() {
        return this.resourcesFolder;
    }

    public Path getResourcesFolderPath() {
        return this.resourcesFolderPath;
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public Path getBaseFolderPath() {
        return this.baseFolderPath;
    }

    public int getReadingWarnings() {
        return this.readingWarnings;
    }

    public int getReadingErrors() {
        return this.readingErrors;
    }

    public Map<Path, SmallFile> getFiles() {
        return this.files;
    }

    public Map<Path, Set<Path>> getFolders() {
        return this.folders;
    }

    public Map<String, Integer> getFileTypes() {
        return this.fileTypes;
    }
}

