/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.io;

import adalid.commons.util.Sequence;
import adalid.util.io.FileBytesSize;
import adalid.util.io.FileLinesSize;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;

public class FolderWrapper {
    private final File file;
    private final Path path;
    private final Map<FileBytesSize, Sequence> bytesSizes;
    private final Map<FileLinesSize, Sequence> linesSizes;
    private long localFiles;
    private long localBytes;
    private long localLines;
    private long totalFiles;
    private long totalBytes;
    private long totalLines;
    private double filesShare;
    private double bytesShare;
    private double linesShare;

    public FolderWrapper(File folder) {
        this.file = folder;
        this.path = Paths.get(folder.getPath(), new String[0]);
        this.bytesSizes = new LinkedHashMap<FileBytesSize, Sequence>();
        this.linesSizes = new LinkedHashMap<FileLinesSize, Sequence>();
        this.initBytesSizes();
        this.initLinesSizes();
    }

    private void initBytesSizes() {
        for (FileBytesSize bs : FileBytesSize.values()) {
            this.bytesSizes.put(bs, Sequence.startWith(0));
        }
    }

    private void initLinesSizes() {
        for (FileLinesSize ls : FileLinesSize.values()) {
            this.linesSizes.put(ls, Sequence.startWith(0));
        }
    }

    public File getFile() {
        return this.file;
    }

    public Path getPath() {
        return this.path;
    }

    public Map<FileBytesSize, Sequence> getBytesSizes() {
        return this.bytesSizes;
    }

    public Map<FileLinesSize, Sequence> getLinesSizes() {
        return this.linesSizes;
    }

    public long getLocalFiles() {
        return this.localFiles;
    }

    public void setLocalFiles(long files) {
        this.localFiles = files;
    }

    public long getLocalBytes() {
        return this.localBytes;
    }

    public void setLocalBytes(long bytes) {
        this.localBytes = bytes;
    }

    public long getLocalLines() {
        return this.localLines;
    }

    public void setLocalLines(long lines) {
        this.localLines = lines;
    }

    public long getTotalFiles() {
        return this.totalFiles;
    }

    public void setTotalFiles(long totalFiles) {
        this.totalFiles = totalFiles;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public long getTotalLines() {
        return this.totalLines;
    }

    public void setTotalLines(long totalLines) {
        this.totalLines = totalLines;
    }

    public double getFilesShare() {
        return this.filesShare;
    }

    public void setFilesShare(double filesShare) {
        this.filesShare = filesShare;
    }

    public double getBytesShare() {
        return this.bytesShare;
    }

    public void setBytesShare(double bytesShare) {
        this.bytesShare = bytesShare;
    }

    public double getLinesShare() {
        return this.linesShare;
    }

    public void setLinesShare(double linesShare) {
        this.linesShare = linesShare;
    }
}

