/*
 * Decompiled with CFR 0.152.
 */
package adalid.util.sql;

import adalid.util.sql.SqlArtifact;
import adalid.util.sql.SqlTable;

public class SqlColumn
extends SqlArtifact {
    private final SqlTable _table;
    private int _position;
    private String _defaultLabel;
    private String _type;
    private String _sqlDataType;
    private String _sqlType;
    private int _length;
    private int _precision;
    private int _scale;
    private boolean _collision;
    private boolean _updatable;
    private boolean _nullable;
    private boolean _primary;
    private boolean _unique;
    private boolean _booleanish;
    private boolean _foreign;
    private String _foreignTableName;
    private SqlTable _foreignTable;
    private String _default;
    private String _sqlDefaultValue;
    private String _sqlDefaultValueLiteral;
    private String _sqlPrimalDefaultValue;

    public SqlColumn(SqlTable table) {
        this._table = table;
    }

    public SqlTable getTable() {
        return this._table;
    }

    public int getPosition() {
        return this._position;
    }

    void setPosition(int position) {
        this._position = position;
    }

    public String getDefaultLabel() {
        return this._defaultLabel;
    }

    void setDefaultLabel(String defaultLabel) {
        this._defaultLabel = defaultLabel;
    }

    public String getType() {
        return this._type;
    }

    void setType(String type) {
        this._type = type;
    }

    public String getSqlDataType() {
        return this._sqlDataType;
    }

    void setSqlDataType(String sqlDataType) {
        this._sqlDataType = sqlDataType;
    }

    public String getSqlType() {
        return this._sqlType == null ? this._sqlDataType : this._sqlType;
    }

    void setSqlType(String sqlType) {
        this._sqlType = sqlType;
    }

    public int getLength() {
        return this._length;
    }

    void setLength(int length) {
        this._length = length;
    }

    public int getPrecision() {
        return this._precision;
    }

    void setPrecision(int precision) {
        this._precision = precision;
    }

    public int getScale() {
        return this._scale;
    }

    void setScale(int scale) {
        this._scale = scale;
    }

    public boolean isCollision() {
        return this._collision;
    }

    void setCollision(boolean collision) {
        this._collision = collision;
    }

    public boolean isUpdatable() {
        return this._updatable;
    }

    void setUpdatable(boolean updatable) {
        this._updatable = updatable;
    }

    public boolean isNullable() {
        return this._nullable;
    }

    void setNullable(boolean nullable) {
        this._nullable = nullable;
    }

    public boolean isPrimary() {
        return this._primary;
    }

    void setPrimary(boolean primary) {
        this._primary = primary;
        if (this._primary && this._table != null && this._table.getPrimaryKey() == null) {
            this._table.setPrimaryKey(this);
        }
    }

    public boolean isUnique() {
        return this._unique;
    }

    void setUnique(boolean unique) {
        this._unique = unique;
        if (this._unique && this._type != null && this._table != null && this._table.getBusinessKey() == null && this._type.equals("string")) {
            this._table.setBusinessKey(this);
        }
    }

    public boolean isBooleanish() {
        return this._booleanish;
    }

    void setBooleanish(boolean booleanish) {
        this._booleanish = booleanish;
    }

    public boolean isForeign() {
        return this._foreign;
    }

    void setForeign(boolean foreign) {
        this._foreign = foreign;
    }

    public String getForeignTableName() {
        return this._foreignTableName;
    }

    void setForeignTableName(String foreignTableName) {
        this._foreignTableName = foreignTableName;
    }

    public SqlTable getForeignTable() {
        return this._foreignTable;
    }

    void setForeignTable(SqlTable foreignTable) {
        this._foreignTable = foreignTable;
    }

    public String getDefault() {
        return this._default;
    }

    void setDefault(String defaultValue) {
        this._default = defaultValue;
    }

    public String getSqlDefaultValue() {
        return this._sqlDefaultValue;
    }

    void setSqlDefaultValue(String sqlDefaultValue) {
        this._sqlDefaultValue = sqlDefaultValue;
    }

    public String getSqlDefaultValueLiteral() {
        return this._sqlDefaultValueLiteral;
    }

    void setSqlDefaultValueLiteral(String literal) {
        this._sqlDefaultValueLiteral = literal;
    }

    public String getSqlPrimalDefaultValue() {
        return this._sqlPrimalDefaultValue;
    }

    void setSqlPrimalDefaultValue(String defaultValue) {
        this._sqlPrimalDefaultValue = defaultValue;
    }

    public boolean isVersion() {
        return !this._nullable && this.matches("long", "version");
    }

    public boolean isDiscriminator() {
        return !this._nullable && this._foreign && this.matches("integer", "discriminador");
    }

    public boolean isName() {
        return !this._nullable && this.matches("string", "nombre");
    }

    public boolean isDescription() {
        return this.matches("string", "descripcion");
    }

    public boolean matches(String type, String role) {
        String table = this._table.getName();
        String name = this.getName();
        return this._type.equalsIgnoreCase(type) && (name.equalsIgnoreCase(role) || name.equalsIgnoreCase(role + "_" + table) || name.equalsIgnoreCase(table + "_" + role));
    }

    public boolean isOrdinary() {
        return !this.isSpecial();
    }

    public boolean isSpecial() {
        return this.equals(this._table.getPrimaryKey()) || this.equals(this._table.getVersion()) || this.equals(this._table.getBusinessKey());
    }

    public String getTrueType() {
        return this._type;
    }

    public String getMetajavaType() {
        if (!this._primary && this._foreignTable != null) {
            return this._foreignTable.getCapitalizedJavaName();
        }
        return switch (this._type) {
            case "blob" -> "BinaryProperty";
            case "boolean" -> "BooleanProperty";
            case "char" -> "CharacterProperty";
            case "string" -> "StringProperty";
            case "short" -> "ShortProperty";
            case "integer" -> "IntegerProperty";
            case "long" -> "LongProperty";
            case "decimal" -> "BigDecimalProperty";
            case "float" -> "FloatProperty";
            case "double" -> "DoubleProperty";
            case "date" -> "DateProperty";
            case "time" -> "TimeProperty";
            case "timestamp" -> "TimestampProperty";
            default -> "Property";
        };
    }

    public String getQualifiedName() {
        return this.getTable().getName() + "." + this.getName();
    }
}

