/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ProcessOperation;
import adalid.core.annotations.BinaryField;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.QueryMapping;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.FetchType;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialBinaryValue;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.TableResponsiveMode;
import adalid.core.expressions.BooleanOrderedPairX;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.properties.BinaryProperty;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.control.acceso.Usuario;

@EntityClass(independent=Kleenean.TRUE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE, sortOption=SortOption.DESC)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.FALSE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.TRUE, responsiveMode=TableResponsiveMode.PRIORITY)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class ArchivoAdjunto
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @FileReference(blobField="octetos", loadField="fechaHoraCarga")
    @ColumnField(nullable=Kleenean.FALSE, unique=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.FALSE)
    public StringProperty archivoServidor;
    @NameProperty
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=256)
    public StringProperty archivoCliente;
    @OwnerProperty
    @SegmentProperty
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    @QueryMapping(mapKeyProperties=Kleenean.FALSE)
    public Usuario propietario;
    @PropertyField(responsivePriority=6, table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=254, displayLength=36)
    public StringProperty codigoUsuarioPropietario;
    @PropertyField(table=Kleenean.FALSE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty nombreUsuarioPropietario;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(responsivePriority=6, table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public TimestampProperty fechaHoraCarga;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty tipoCarga;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(responsivePriority=6, table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, overlay=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty tipoContenido;
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE)
    @StringField(maxLength=100)
    public StringProperty conjuntoCaracteres;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(responsivePriority=6, table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public LongProperty longitud;
    @BinaryField(fetch=FetchType.LAZY)
    @PropertyField(hidden=Kleenean.TRUE)
    public BinaryProperty octetos;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(table=Kleenean.FALSE, report=Kleenean.TRUE, search=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public IntegerProperty referencias;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty eliminable;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(responsivePriority=6, table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.TRUE)
    public BooleanProperty restaurable;
    protected RestaurarArchivoServidorWeb restaurarArchivoServidorWeb;
    protected EliminarArchivoServidorWeb eliminarArchivoServidorWeb;
    protected EliminarTotalmente eliminarTotalmente;

    public ArchivoAdjunto(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "attached file");
        this.setLocalizedLabel(SPANISH, "archivo adjunto");
        this.setLocalizedShortLabel(ENGLISH, "attachment");
        this.setLocalizedShortLabel(SPANISH, "adjunto");
        this.setLocalizedCollectionLabel(ENGLISH, "Attached Files");
        this.setLocalizedCollectionLabel(SPANISH, "Archivos Adjuntos");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Attachments");
        this.setLocalizedCollectionShortLabel(SPANISH, "Adjuntos");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Attached Files") + " represents an audit trail of the execution of file upload operations on the server.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Archivos Adjuntos") + " representa un rastro de auditor\u00eda de la ejecuci\u00f3n de operaciones de carga de archivos en el servidor.");
        this.setLocalizedShortDescription(ENGLISH, "audit trail of the execution of file upload operations on the server");
        this.setLocalizedShortDescription(SPANISH, "rastro de auditor\u00eda de la ejecuci\u00f3n de operaciones de carga de archivos en el servidor");
    }

    public BinaryProperty getBlobProperty() {
        return this.octetos;
    }

    public IntegerProperty getReferencesProperty() {
        return this.referencias;
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.propietario.setInitialValue(SpecialEntityValue.CURRENT_USER);
        this.propietario.setDefaultValue(SpecialEntityValue.CURRENT_USER);
        this.fechaHoraCarga.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraCarga.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.referencias.setInitialValue(0);
        this.referencias.setDefaultValue(0);
        this.eliminable.setInitialValue(false);
        this.eliminable.setDefaultValue(ArchivoAdjunto.not(this.tipoCarga.isNullOrEqualTo("FILA")));
        this.eliminable.setPrimalDefaultValue(true);
        BooleanOrderedPairX likish = ArchivoAdjunto.and(this.archivoServidor.contains("/media/"), this.archivoServidor.contains("/table-row-column/"));
        this.restaurable.setInitialValue(false);
        this.restaurable.setDefaultValue(ArchivoAdjunto.not(this.octetos.isNull().or(likish)));
        this.restaurable.setPrimalDefaultValue(true);
        this.archivoServidor.setLocalizedDescription(ENGLISH, "file name on the application server");
        this.archivoServidor.setLocalizedDescription(SPANISH, "nombre del archivo en el servidor de aplicaciones");
        this.archivoServidor.setLocalizedLabel(ENGLISH, "attached file's server file name");
        this.archivoServidor.setLocalizedLabel(SPANISH, "archivo servidor del archivo adjunto");
        this.archivoServidor.setLocalizedShortLabel(ENGLISH, "server file");
        this.archivoServidor.setLocalizedShortLabel(SPANISH, "archivo servidor");
        this.archivoServidor.setLocalizedColumnHeader(ENGLISH, "server", "file");
        this.archivoServidor.setLocalizedColumnHeader(SPANISH, "archivo", "servidor");
        this.archivoServidor.setLocalizedTooltip(ENGLISH, "open the attached file");
        this.archivoServidor.setLocalizedTooltip(SPANISH, "abrir el archivo adjunto");
        this.archivoCliente.setLocalizedDescription(ENGLISH, "name of the original file (file on the computer of the user who made the upload)");
        this.archivoCliente.setLocalizedDescription(SPANISH, "nombre del archivo original (archivo en el computador del usuario que realiz\u00f3 la carga)");
        this.archivoCliente.setLocalizedLabel(ENGLISH, "attached file's client file name");
        this.archivoCliente.setLocalizedLabel(SPANISH, "archivo cliente del archivo adjunto");
        this.archivoCliente.setLocalizedShortLabel(ENGLISH, "client file");
        this.archivoCliente.setLocalizedShortLabel(SPANISH, "archivo cliente");
        this.propietario.setLocalizedDescription(ENGLISH, "user who made the upload");
        this.propietario.setLocalizedDescription(SPANISH, "usuario que realiz\u00f3 la carga");
        this.propietario.setLocalizedLabel(ENGLISH, "attached file's owner");
        this.propietario.setLocalizedLabel(SPANISH, "propietario del archivo adjunto");
        this.propietario.setLocalizedShortLabel(ENGLISH, "owner");
        this.propietario.setLocalizedShortLabel(SPANISH, "propietario");
        this.codigoUsuarioPropietario.setLocalizedDescription(ENGLISH, "code of the user who made the upload");
        this.codigoUsuarioPropietario.setLocalizedDescription(SPANISH, "c\u00f3digo del usuario que realiz\u00f3 la carga");
        this.codigoUsuarioPropietario.setLocalizedLabel(ENGLISH, "owner");
        this.codigoUsuarioPropietario.setLocalizedLabel(SPANISH, "propietario");
        this.nombreUsuarioPropietario.setLocalizedDescription(ENGLISH, "name of the user who made the upload");
        this.nombreUsuarioPropietario.setLocalizedDescription(SPANISH, "nombre del usuario que realiz\u00f3 la carga");
        this.nombreUsuarioPropietario.setLocalizedLabel(ENGLISH, "owner name");
        this.nombreUsuarioPropietario.setLocalizedLabel(SPANISH, "nombre del propietario");
        this.fechaHoraCarga.setLocalizedDescription(ENGLISH, "date and time the upload was made");
        this.fechaHoraCarga.setLocalizedDescription(SPANISH, "fecha y hora en la que se realiz\u00f3 la carga");
        this.fechaHoraCarga.setLocalizedLabel(ENGLISH, "upload timestamp");
        this.fechaHoraCarga.setLocalizedLabel(SPANISH, "fecha hora carga");
        this.tipoCarga.setLocalizedLabel(ENGLISH, "file upload type");
        this.tipoCarga.setLocalizedLabel(SPANISH, "tipo de carga de archivo");
        this.tipoContenido.setLocalizedDescription(ENGLISH, "MIME type (Multipurpose Internet Mail Extensions) that corresponds to the content of the file");
        this.tipoContenido.setLocalizedDescription(SPANISH, "tipo MIME (Multipurpose Internet Mail Extensions) que corresponde al contenido del archivo");
        this.tipoContenido.setLocalizedLabel(ENGLISH, "content type");
        this.tipoContenido.setLocalizedLabel(SPANISH, "tipo contenido");
        this.conjuntoCaracteres.setLocalizedDescription(ENGLISH, "character set used for file encoding; only applies to text files");
        this.conjuntoCaracteres.setLocalizedDescription(SPANISH, "conjunto de caracteres utilizado para la codificaci\u00f3n del archivo; solo aplica a archivos de texto");
        this.conjuntoCaracteres.setLocalizedLabel(ENGLISH, "character set");
        this.conjuntoCaracteres.setLocalizedLabel(SPANISH, "conjunto de caracteres");
        this.longitud.setLocalizedDescription(ENGLISH, "file size, in bytes");
        this.longitud.setLocalizedDescription(SPANISH, "tama\u00f1o del archivo, en bytes");
        this.longitud.setLocalizedLabel(ENGLISH, "length");
        this.longitud.setLocalizedLabel(SPANISH, "longitud");
        this.octetos.setLocalizedDescription(ENGLISH, "file content, in bytes");
        this.octetos.setLocalizedDescription(SPANISH, "contenido del archivo, en bytes");
        this.octetos.setLocalizedLabel(ENGLISH, "bytes");
        this.octetos.setLocalizedLabel(SPANISH, "octetos");
        this.referencias.setLocalizedLabel(ENGLISH, "references");
        this.referencias.setLocalizedLabel(SPANISH, "referencias");
        this.eliminable.setLocalizedDescription(ENGLISH, "indicator that shows whether or not the file can be deleted from the web server's file system");
        this.eliminable.setLocalizedDescription(SPANISH, "indicador que muestra si el archivo puede, o no, ser eliminado del sistema de archivos del servidor web");
        this.eliminable.setLocalizedLabel(ENGLISH, "removable");
        this.eliminable.setLocalizedLabel(SPANISH, "eliminable");
        this.restaurable.setLocalizedDescription(ENGLISH, "indicator that shows whether or not the file can be restored after being removed from the application server");
        this.restaurable.setLocalizedDescription(SPANISH, "indicador que muestra si el archivo puede, o no, ser restaurado despu\u00e9s de ser eliminado del servidor de aplicaciones");
        this.restaurable.setLocalizedLabel(ENGLISH, "restorable");
        this.restaurable.setLocalizedLabel(SPANISH, "restaurable");
        this.restaurable.setLocalizedDefaultValueTag(ENGLISH, "False, if the content of the file was not stored or was stored in a column of another table; otherwise True");
        this.restaurable.setLocalizedDefaultValueTag(SPANISH, "Falso, si el contenido del archivo no se almacen\u00f3 o se almacen\u00f3 en una columna de otra tabla; de lo contrario, Verdadero");
    }

    @OperationClass(access=OperationAccess.PRIVATE, confirmation=Kleenean.TRUE)
    @ProcessOperationClass(builtIn=true)
    public class EliminarTotalmente
    extends ProcessOperation {
        @InstanceReference
        protected ArchivoAdjunto archivoAdjunto;
        protected Check check101;
        protected Check check102;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "completely delete the file");
            this.setLocalizedLabel(SPANISH, "eliminar totalmente el archivo");
            this.setLocalizedDescription(ENGLISH, "delete the file from both the web server's file system and the database;after completely deleting the file, it can no longer be restored");
            this.setLocalizedDescription(SPANISH, "eliminar el archivo tanto del sistema de archivos del servidor web como de la base de datos; despu\u00e9s de eliminar totalmente el archivo, \u00e9ste no podr\u00e1 ser restaurado");
            this.setLocalizedSuccessMessage(ENGLISH, "the file was deleted from both the web server's file system and the database");
            this.setLocalizedSuccessMessage(SPANISH, "el archivo se elimin\u00f3 tanto del sistema de archivos del servidor web como de la base de datos");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.archivoAdjunto.octetos.setCurrentValue(SpecialBinaryValue.NULL);
            this.archivoAdjunto.eliminable.setCurrentValue(false);
            this.archivoAdjunto.restaurable.setCurrentValue(false);
            this.archivoAdjunto.setLocalizedLabel(ENGLISH, "attached file");
            this.archivoAdjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.archivoAdjunto.referencias.isEqualTo(0);
            this.check102 = EliminarTotalmente.or(this.archivoAdjunto.eliminable, this.archivoAdjunto.octetos.isNotNull());
            this.check101.setLocalizedDescription(ENGLISH, "the file is not being referenced");
            this.check101.setLocalizedDescription(SPANISH, "el archivo no est\u00e1 siendo referenciado");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the file cannot be deleted because it is being referenced");
            this.check101.setLocalizedErrorMessage(SPANISH, "el archivo no se puede eliminar porque est\u00e1 siendo referenciado");
            this.check102.setLocalizedDescription(ENGLISH, "the file is removable");
            this.check102.setLocalizedDescription(SPANISH, "el archivo es eliminable");
            this.check102.setLocalizedErrorMessage(ENGLISH, "the file cannot be deleted from the web server's file system and is not stored in the database");
            this.check102.setLocalizedErrorMessage(SPANISH, "el archivo no se puede eliminar del sistema de archivos del servidor web y no se encuentra almacenado en la base de datos");
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    @ProcessOperationClass(builtIn=true)
    public class RestaurarArchivoServidorWeb
    extends ProcessOperation {
        @InstanceReference
        protected ArchivoAdjunto archivoAdjunto;
        protected Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "restore the file on the web server");
            this.setLocalizedLabel(SPANISH, "restaurar el archivo del servidor web");
            this.setLocalizedDescription(ENGLISH, "restore the file on the web server's file system using the file stored in the database");
            this.setLocalizedDescription(SPANISH, "restaurar el archivo al sistema de archivos del servidor web con el contenido del archivo almacenado en la base de datos");
            this.setLocalizedSuccessMessage(ENGLISH, "the file was restored to the web server's file system");
            this.setLocalizedSuccessMessage(SPANISH, "el archivo se restaur\u00f3 al sistema de archivos del servidor web");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.archivoAdjunto.eliminable.setCurrentValue(true);
            this.archivoAdjunto.setLocalizedLabel(ENGLISH, "attached file");
            this.archivoAdjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.archivoAdjunto.restaurable.isTrue();
            this.check101.setLocalizedDescription(ENGLISH, "the file is restorable");
            this.check101.setLocalizedDescription(SPANISH, "el archivo es restaurable");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the file is not restorable because it is not stored in the database");
            this.check101.setLocalizedErrorMessage(SPANISH, "el archivo no es restaurable porque no se encuentra almacenado en la base de datos");
        }
    }

    @OperationClass(access=OperationAccess.PRIVATE, confirmation=Kleenean.TRUE)
    @ProcessOperationClass(builtIn=true)
    public class EliminarArchivoServidorWeb
    extends ProcessOperation {
        @InstanceReference
        protected ArchivoAdjunto archivoAdjunto;
        protected Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "delete the file from the web server");
            this.setLocalizedLabel(SPANISH, "eliminar el archivo del servidor web");
            this.setLocalizedDescription(ENGLISH, "delete the file only from the web server's file system; if the file is stored in the database, it will remain stored in the database and it could be restored later; but if the file is not stored in the databas, it can no longer be restored");
            this.setLocalizedDescription(SPANISH, "eliminar el archivo solo del sistema de archivos del servidor web; si el archivo est\u00e1 almacenado en la base de datos, permanecer\u00e1 almacenado en la base de datos y podr\u00e1 ser restaurado posteriormente; pero si el archivo no est\u00e1 almacenado en la base de datos, \u00e9ste no podr\u00e1 ser restaurado");
            this.setLocalizedSuccessMessage(ENGLISH, "the file was removed from the web server's file system");
            this.setLocalizedSuccessMessage(SPANISH, "el archivo se elimin\u00f3 del sistema de archivos del servidor web");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.archivoAdjunto.eliminable.setCurrentValue(false);
            this.archivoAdjunto.setLocalizedLabel(ENGLISH, "attached file");
            this.archivoAdjunto.setLocalizedLabel(SPANISH, "archivo adjunto");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.archivoAdjunto.eliminable.isTrue();
            this.check101.setLocalizedDescription(ENGLISH, "the file is removable");
            this.check101.setLocalizedDescription(SPANISH, "el archivo es eliminable");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the file cannot be found or cannot be deleted from the web server's file system");
            this.check101.setLocalizedErrorMessage(SPANISH, "el archivo no se encuentra o no se puede eliminar del sistema de archivos del servidor web");
        }
    }
}

