/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ExportOperation;
import adalid.core.Key;
import adalid.core.ReportOperation;
import adalid.core.View;
import adalid.core.ViewField;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.EntityWarnings;
import adalid.core.annotations.ExportOperationClass;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.QueryMapping;
import adalid.core.annotations.ReportOperationClass;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UniformResourceLocator;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.StandardRelationalOp;
import adalid.core.enums.TableResponsiveMode;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Property;
import adalid.core.interfaces.Segment;
import adalid.core.page.format.DefaultPageFormat;
import adalid.core.parameters.StringParameter;
import adalid.core.parameters.TimestampParameter;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.CondicionEjeFun;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.configuracion.basica.TipoFuncion;
import meta.entidad.comun.control.acceso.Usuario;
import meta.entidad.comun.operacion.basica.RecursoValor;

@EntityClass(independent=Kleenean.TRUE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE, sortOption=SortOption.DESC)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.FALSE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.TRUE, responsiveMode=TableResponsiveMode.PRIORITY)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE)
@EntityTriggers(afterValue=Kleenean.TRUE)
@EntityWarnings(aboutBusinessKey=Kleenean.FALSE)
public class RastroFuncion
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @ColumnField(nullable=Kleenean.FALSE, indexed=Kleenean.TRUE)
    @PropertyField(responsivePriority=6, table=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, search=Kleenean.TRUE)
    public TimestampProperty fechaHoraEjecucion;
    @OwnerProperty
    @SegmentProperty
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    @QueryMapping(mapKeyProperties=Kleenean.FALSE)
    public Usuario usuario;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(responsivePriority=6, table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE)
    @StringField(maxLength=254, displayLength=36)
    public StringProperty codigoUsuario;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE, search=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty nombreUsuario;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(hidden=Kleenean.TRUE)
    @QueryMapping(mapKeyProperties=Kleenean.FALSE)
    public Funcion funcion;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE)
    @StringField(maxLength=200)
    public StringProperty codigoFuncion;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE, search=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE)
    @StringField(maxLength=200)
    public StringProperty nombreFuncion;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE)
    @StringField(maxLength=0)
    public StringProperty descripcionFuncion;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(responsivePriority=6, table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.FALSE, headertextless=Kleenean.TRUE)
    public StringProperty paginaFuncion;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(search=Kleenean.TRUE)
    public TipoFuncion tipoFuncion;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idClaseRecursoValor;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(search=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty codigoClaseRecursoValor;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(search=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty nombreClaseRecursoValor;
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    public RecursoValor recursoValor;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idRecurso;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty versionRecurso;
    @ColumnField(indexed=Kleenean.FALSE)
    @PropertyField(table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE)
    public StringProperty codigoRecurso;
    @ColumnField(indexed=Kleenean.FALSE)
    @PropertyField(table=Kleenean.FALSE, report=Kleenean.TRUE, search=Kleenean.TRUE)
    public StringProperty nombreRecurso;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idPropietarioRecurso;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idSegmentoRecurso;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idSelectRecurso;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(responsivePriority=6, table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.FALSE, headertextless=Kleenean.TRUE)
    public StringProperty paginaRecurso;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(responsivePriority=5, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public CondicionEjeFun condicionEjeFun;
    @StringField(maxLength=0)
    public StringProperty descripcionError;
    protected Key ix_rastro_funcion_0001;
    protected Segment dml;
    protected Segment biz;
    protected View rastros;
    protected ExportarArchivoRastros archivoRastros;
    protected EmitirInformeRastros informeRastros;

    public RastroFuncion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "function audit trail");
        this.setLocalizedLabel(SPANISH, "rastro de auditor\u00eda de funci\u00f3n");
        this.setLocalizedShortLabel(ENGLISH, "function trail");
        this.setLocalizedShortLabel(SPANISH, "rastro de funci\u00f3n");
        this.setLocalizedCollectionLabel(ENGLISH, "Function Audit Trails");
        this.setLocalizedCollectionLabel(SPANISH, "Rastros de Auditor\u00eda de Funciones");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Function Trails");
        this.setLocalizedCollectionShortLabel(SPANISH, "Rastros de Funciones");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Function Audit Trails") + " represents an audit trail of the execution of CRUD operations and business processes.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Rastros de Auditor\u00eda de Funciones") + " representa un rastro de auditor\u00eda de la ejecuci\u00f3n de operaciones de registro y procesos de negocio.");
        this.setLocalizedShortDescription(ENGLISH, "audit trail of the execution of CRUD operations and business processes");
        this.setLocalizedShortDescription(SPANISH, "rastro de auditor\u00eda de la ejecuci\u00f3n de operaciones de registro y procesos de negocio");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.fechaHoraEjecucion.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraEjecucion.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.descripcionFuncion.setCalculableValueExpression(this.funcion.descripcionFuncion);
        this.condicionEjeFun.setInitialValue(this.condicionEjeFun.EJECUTADO_SIN_ERRORES);
        this.condicionEjeFun.setDefaultValue(this.condicionEjeFun.EJECUTADO_SIN_ERRORES);
        this.fechaHoraEjecucion.setLocalizedDescription(ENGLISH, "date and time of the function execution");
        this.fechaHoraEjecucion.setLocalizedDescription(SPANISH, "fecha y hora de la ejecuci\u00f3n de la funci\u00f3n");
        this.fechaHoraEjecucion.setLocalizedLabel(ENGLISH, "timestamp");
        this.fechaHoraEjecucion.setLocalizedLabel(SPANISH, "fecha y hora");
        this.usuario.setLocalizedDescription(ENGLISH, "user who executed the function");
        this.usuario.setLocalizedDescription(SPANISH, "usuario que ejecut\u00f3 la funci\u00f3n");
        this.usuario.setLocalizedLabel(ENGLISH, "user");
        this.usuario.setLocalizedLabel(SPANISH, "usuario");
        this.codigoUsuario.setLocalizedDescription(ENGLISH, "code of the user who executed the function");
        this.codigoUsuario.setLocalizedDescription(SPANISH, "c\u00f3digo del usuario que ejecut\u00f3 la funci\u00f3n");
        this.codigoUsuario.setLocalizedLabel(ENGLISH, "user");
        this.codigoUsuario.setLocalizedLabel(SPANISH, "usuario");
        this.nombreUsuario.setLocalizedDescription(ENGLISH, "name of the user who executed the function");
        this.nombreUsuario.setLocalizedDescription(SPANISH, "nombre del usuario que ejecut\u00f3 la funci\u00f3n");
        this.nombreUsuario.setLocalizedLabel(ENGLISH, "user name");
        this.nombreUsuario.setLocalizedLabel(SPANISH, "nombre del usuario");
        this.funcion.setLocalizedDescription(ENGLISH, "function executed");
        this.funcion.setLocalizedDescription(SPANISH, "funci\u00f3n ejecutada");
        this.funcion.setLocalizedLabel(ENGLISH, "function");
        this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.tipoFuncion.setLocalizedDescription(ENGLISH, "type of the function");
        this.tipoFuncion.setLocalizedDescription(SPANISH, "tipo de funci\u00f3n");
        this.tipoFuncion.setLocalizedLabel(ENGLISH, "function type");
        this.tipoFuncion.setLocalizedLabel(SPANISH, "tipo de funci\u00f3n");
        this.codigoFuncion.setLocalizedDescription(ENGLISH, "code of the function");
        this.codigoFuncion.setLocalizedDescription(SPANISH, "c\u00f3digo de la funci\u00f3n");
        this.codigoFuncion.setLocalizedLabel(ENGLISH, "function");
        this.codigoFuncion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.nombreFuncion.setLocalizedDescription(ENGLISH, "name of the function");
        this.nombreFuncion.setLocalizedDescription(SPANISH, "nombre de la funci\u00f3n");
        this.nombreFuncion.setLocalizedLabel(ENGLISH, "function name");
        this.nombreFuncion.setLocalizedLabel(SPANISH, "nombre de la funci\u00f3n");
        this.descripcionFuncion.setLocalizedDescription(ENGLISH, "description of the function");
        this.descripcionFuncion.setLocalizedDescription(SPANISH, "descripci\u00f3n de la funci\u00f3n");
        this.descripcionFuncion.setLocalizedLabel(ENGLISH, "function description");
        this.descripcionFuncion.setLocalizedLabel(SPANISH, "descripci\u00f3n de la funci\u00f3n");
        this.paginaFuncion.setLocalizedDescription(ENGLISH, "hyperlink to open the page to execute the function");
        this.paginaFuncion.setLocalizedDescription(SPANISH, "hiperv\u00ednculo para abrir la p\u00e1gina para ejecutar la funci\u00f3n");
        this.paginaFuncion.setLocalizedLabel(ENGLISH, "function page");
        this.paginaFuncion.setLocalizedLabel(SPANISH, "p\u00e1gina de la funci\u00f3n");
        this.paginaFuncion.setLocalizedTooltip(ENGLISH, "open the function's processing page");
        this.paginaFuncion.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina de procesamiento de la funci\u00f3n");
        this.codigoClaseRecursoValor.setLocalizedDescription(ENGLISH, "resource class of the function");
        this.codigoClaseRecursoValor.setLocalizedDescription(SPANISH, "clase de recurso de la funci\u00f3n");
        this.idClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        this.idClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        this.codigoClaseRecursoValor.setLocalizedDescription(ENGLISH, "code of the resource class of the function");
        this.codigoClaseRecursoValor.setLocalizedDescription(SPANISH, "c\u00f3digo de la clase de recurso de la funci\u00f3n");
        this.codigoClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        this.codigoClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        this.nombreClaseRecursoValor.setLocalizedDescription(ENGLISH, "name of the resource class of the function");
        this.nombreClaseRecursoValor.setLocalizedDescription(SPANISH, "nombre de la clase de recurso de la funci\u00f3n");
        this.nombreClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class name");
        this.nombreClaseRecursoValor.setLocalizedLabel(SPANISH, "nombre de la clase de recurso");
        this.recursoValor.setLocalizedLabel(ENGLISH, "resource");
        this.recursoValor.setLocalizedLabel(SPANISH, "recurso");
        this.idRecurso.setLocalizedLabel(ENGLISH, "resource");
        this.idRecurso.setLocalizedLabel(SPANISH, "recurso");
        this.versionRecurso.setLocalizedLabel(ENGLISH, "resource version");
        this.versionRecurso.setLocalizedLabel(SPANISH, "versi\u00f3n del recurso");
        this.codigoRecurso.setLocalizedDescription(ENGLISH, "code of the resource on which the function was executed");
        this.codigoRecurso.setLocalizedDescription(SPANISH, "c\u00f3digo del recurso sobre el que se ejecut\u00f3 la funci\u00f3n");
        this.codigoRecurso.setLocalizedLabel(ENGLISH, "resource");
        this.codigoRecurso.setLocalizedLabel(SPANISH, "recurso");
        this.nombreRecurso.setLocalizedDescription(ENGLISH, "name of the resource on which the function was executed");
        this.nombreRecurso.setLocalizedDescription(SPANISH, "nombre del recurso sobre el que se ejecut\u00f3 la funci\u00f3n");
        this.nombreRecurso.setLocalizedLabel(ENGLISH, "resource name");
        this.nombreRecurso.setLocalizedLabel(SPANISH, "nombre del recurso");
        this.idPropietarioRecurso.setLocalizedLabel(ENGLISH, "resource owner");
        this.idPropietarioRecurso.setLocalizedLabel(SPANISH, "propietario del recurso");
        this.idSegmentoRecurso.setLocalizedLabel(ENGLISH, "resource segment");
        this.idSegmentoRecurso.setLocalizedLabel(SPANISH, "segmento del recurso");
        this.idSelectRecurso.setLocalizedLabel(ENGLISH, "resource select function");
        this.idSelectRecurso.setLocalizedLabel(SPANISH, "funci\u00f3n de selecci\u00f3n del recurso");
        this.paginaRecurso.setLocalizedDescription(ENGLISH, "hyperlink to open the page to edit the resource");
        this.paginaRecurso.setLocalizedDescription(SPANISH, "hiperv\u00ednculo para abrir la p\u00e1gina para editar el recurso");
        this.paginaRecurso.setLocalizedLabel(ENGLISH, "resource page");
        this.paginaRecurso.setLocalizedLabel(SPANISH, "p\u00e1gina del recurso");
        this.paginaRecurso.setLocalizedTooltip(ENGLISH, "open the resource's registration page");
        this.paginaRecurso.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina de registro del recurso");
        this.condicionEjeFun.setLocalizedDescription(ENGLISH, "condition code of the function execution");
        this.condicionEjeFun.setLocalizedDescription(SPANISH, "c\u00f3digo de condici\u00f3n de la ejecuci\u00f3n de la funci\u00f3n");
        this.condicionEjeFun.setLocalizedLabel(ENGLISH, "function execution condition");
        this.condicionEjeFun.setLocalizedLabel(SPANISH, "condici\u00f3n de ejecuci\u00f3n de funci\u00f3n");
        this.condicionEjeFun.setLocalizedShortLabel(ENGLISH, "condition");
        this.condicionEjeFun.setLocalizedShortLabel(SPANISH, "condici\u00f3n");
        this.descripcionError.setLocalizedDescription(ENGLISH, "text describing the result of the function execution");
        this.descripcionError.setLocalizedDescription(SPANISH, "texto que describe el resultado de la ejecuci\u00f3n de la funci\u00f3n");
        this.descripcionError.setLocalizedLabel(ENGLISH, "message");
        this.descripcionError.setLocalizedLabel(SPANISH, "mensaje");
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.ix_rastro_funcion_0001.setUnique(false);
        this.ix_rastro_funcion_0001.newKeyField(this.idClaseRecursoValor, this.recursoValor);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.biz = this.tipoFuncion.isIn(this.tipoFuncion.PROCEDIMIENTO_PARAMETROS, this.tipoFuncion.PROCESO);
        this.dml = this.tipoFuncion.isIn(this.tipoFuncion.CREACION, this.tipoFuncion.MODIFICACION, this.tipoFuncion.ELIMINACION);
        this.biz.setLocalizedCollectionLabel(ENGLISH, "Business Procedures and Processes");
        this.biz.setLocalizedCollectionLabel(SPANISH, "Procedimientos y Procesos de Negocio");
        this.biz.setLocalizedCollectionShortLabel(ENGLISH, "Business Operations");
        this.biz.setLocalizedCollectionShortLabel(SPANISH, "Operaciones de Negocio");
        this.dml.setLocalizedCollectionLabel(ENGLISH, "Registration Operations (Insert, Update and Delete)");
        this.dml.setLocalizedCollectionLabel(SPANISH, "Operaciones de Registro (Creaci\u00f3n, Modificaci\u00f3n y Eliminaci\u00f3n)");
        this.dml.setLocalizedCollectionShortLabel(ENGLISH, "Registration Operations");
        this.dml.setLocalizedCollectionShortLabel(SPANISH, "Operaciones de Registro");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.addSelectSegment(this.biz, this.dml);
    }

    @Override
    protected void settleViews() {
        ViewField vf008;
        ViewField vf007;
        ViewField vf006;
        ViewField vf005;
        ViewField vf004;
        ViewField vf003;
        ViewField vf002;
        super.settleViews();
        this.rastros.setPageFormatClass(DefaultPageFormat.class);
        int controlGroupReportElementsWidth = 720;
        ViewField vf = this.rastros.newControlField(this.codigoUsuario);
        vf.setPixels(720);
        vf = this.rastros.newHeadingField(this.nombreUsuario, this.codigoUsuario);
        vf.setPixels(720);
        vf = this.rastros.newDetailField((Property)this.fechaHoraEjecucion, SortOption.ASC);
        vf.setPixels(125);
        vf = this.rastros.newDetailField(this.codigoFuncion);
        vf.setPixels(125);
        vf = this.rastros.newDetailField(this.nombreFuncion);
        vf.setPixels(225);
        vf = this.rastros.newDetailField(this.codigoRecurso);
        vf.setPixels(125);
        vf = this.rastros.newDetailField(this.nombreRecurso);
        vf.setPixels(225);
        vf = this.rastros.newDetailField(this.condicionEjeFun.codigo);
        vf.setPixels(105);
        this.rastros.setLocalizedLabel(ENGLISH, "Function Trails");
        this.rastros.setLocalizedLabel(SPANISH, "Rastros de Funci\u00f3n");
        ViewField vf001 = this.rastros.getField(this.codigoUsuario);
        if (vf001 != null) {
            vf001.setLocalizedLabel(ENGLISH, "user");
            vf001.setLocalizedLabel(SPANISH, "usuario");
        }
        if ((vf002 = this.rastros.getField(this.nombreUsuario)) != null) {
            vf002.setLocalizedLabel(ENGLISH, "user name");
            vf002.setLocalizedLabel(SPANISH, "nombre del usuario");
        }
        if ((vf003 = this.rastros.getField(this.fechaHoraEjecucion)) != null) {
            vf003.setLocalizedLabel(ENGLISH, "timestamp");
            vf003.setLocalizedLabel(SPANISH, "fecha/hora");
        }
        if ((vf004 = this.rastros.getField(this.codigoFuncion)) != null) {
            vf004.setLocalizedLabel(ENGLISH, "function");
            vf004.setLocalizedLabel(SPANISH, "funci\u00f3n");
        }
        if ((vf005 = this.rastros.getField(this.nombreFuncion)) != null) {
            vf005.setLocalizedLabel(ENGLISH, "function name");
            vf005.setLocalizedLabel(SPANISH, "nombre de la funci\u00f3n");
        }
        if ((vf006 = this.rastros.getField(this.codigoRecurso)) != null) {
            vf006.setLocalizedLabel(ENGLISH, "resource");
            vf006.setLocalizedLabel(SPANISH, "recurso");
        }
        if ((vf007 = this.rastros.getField(this.nombreRecurso)) != null) {
            vf007.setLocalizedLabel(ENGLISH, "resource name");
            vf007.setLocalizedLabel(SPANISH, "nombre del recurso");
        }
        if ((vf008 = this.rastros.getField(this.condicionEjeFun.codigo)) != null) {
            vf008.setLocalizedLabel(ENGLISH, "condition");
            vf008.setLocalizedLabel(SPANISH, "condici\u00f3n");
        }
    }

    @ReportOperationClass(viewField="rastros")
    @OperationClass(access=OperationAccess.RESTRICTED)
    public class EmitirInformeRastros
    extends ReportOperation {
        @ParameterField(linkedField="fechaHoraEjecucion", operator=StandardRelationalOp.GTEQ)
        protected TimestampParameter desde;
        @ParameterField(linkedField="fechaHoraEjecucion", operator=StandardRelationalOp.LTEQ)
        protected TimestampParameter hasta;
        @ParameterField(linkedField="usuario")
        protected Usuario usuario;
        @ParameterField(linkedField="funcion")
        protected Funcion funcion;
        @ParameterField(linkedField="codigoRecurso")
        protected StringParameter codigoRecurso;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "generate function trails report");
            this.setLocalizedLabel(SPANISH, "generar informe de rastros");
            this.setLocalizedShortLabel(ENGLISH, "function trails report");
            this.setLocalizedShortLabel(SPANISH, "informe de rastros");
            this.setLocalizedDescription(ENGLISH, "issue a report of function execution audit trails");
            this.setLocalizedDescription(SPANISH, "emitir un informe de rastros de ejecuci\u00f3n de funci\u00f3n");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.desde.setMinValue("2001-01-01");
            this.desde.setMaxValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
            this.hasta.setMinValue(this.desde);
            this.hasta.setMaxValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
            this.desde.setLocalizedLabel(ENGLISH, "from");
            this.desde.setLocalizedLabel(SPANISH, "desde");
            this.hasta.setLocalizedLabel(ENGLISH, "to");
            this.hasta.setLocalizedLabel(SPANISH, "hasta");
            this.usuario.setLocalizedLabel(ENGLISH, "user");
            this.usuario.setLocalizedLabel(SPANISH, "usuario");
            this.funcion.setLocalizedLabel(ENGLISH, "function");
            this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
            this.codigoRecurso.setLocalizedLabel(ENGLISH, "resource code");
            this.codigoRecurso.setLocalizedLabel(SPANISH, "c\u00f3digo del recurso");
        }
    }

    @ExportOperationClass(viewField="rastros")
    @OperationClass(access=OperationAccess.RESTRICTED)
    public class ExportarArchivoRastros
    extends ExportOperation {
        @ParameterField(linkedField="fechaHoraEjecucion", operator=StandardRelationalOp.GTEQ)
        protected TimestampParameter desde;
        @ParameterField(linkedField="fechaHoraEjecucion", operator=StandardRelationalOp.LTEQ)
        protected TimestampParameter hasta;
        @ParameterField(linkedField="usuario")
        protected Usuario usuario;
        @ParameterField(linkedField="funcion")
        protected Funcion funcion;
        @ParameterField(linkedField="codigoRecurso")
        protected StringParameter codigoRecurso;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "generate function trails file");
            this.setLocalizedLabel(SPANISH, "generar archivo de rastros");
            this.setLocalizedShortLabel(ENGLISH, "function trails file");
            this.setLocalizedShortLabel(SPANISH, "archivo de rastros");
            this.setLocalizedDescription(ENGLISH, "export a file of function execution audit trails");
            this.setLocalizedDescription(SPANISH, "exportar un archivo de rastros de ejecuci\u00f3n de funci\u00f3n");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.desde.setMinValue("2001-01-01");
            this.desde.setMaxValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
            this.hasta.setMinValue(this.desde);
            this.hasta.setMaxValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
            this.desde.setLocalizedLabel(ENGLISH, "from");
            this.desde.setLocalizedLabel(SPANISH, "desde");
            this.hasta.setLocalizedLabel(ENGLISH, "to");
            this.hasta.setLocalizedLabel(SPANISH, "hasta");
            this.usuario.setLocalizedLabel(ENGLISH, "user");
            this.usuario.setLocalizedLabel(SPANISH, "usuario");
            this.funcion.setLocalizedLabel(ENGLISH, "function");
            this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
            this.codigoRecurso.setLocalizedLabel(ENGLISH, "resource code");
            this.codigoRecurso.setLocalizedLabel(SPANISH, "c\u00f3digo del recurso");
        }
    }
}

