/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.auditoria;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.ProcessOperation;
import adalid.core.Tab;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceConversionValidation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.EntityWarnings;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.QueryMapping;
import adalid.core.annotations.SegmentProperty;
import adalid.core.annotations.StringField;
import adalid.core.annotations.UniformResourceLocator;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.enums.SortOption;
import adalid.core.enums.SpecialTemporalValue;
import adalid.core.enums.TableResponsiveMode;
import adalid.core.enums.UrlDisplayType;
import adalid.core.enums.UrlType;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import adalid.core.properties.TimestampProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.CondicionEjeFun;
import meta.entidad.comun.configuracion.basica.Funcion;
import meta.entidad.comun.configuracion.basica.SubtipoGrafico;
import meta.entidad.comun.configuracion.basica.TipoFuncion;
import meta.entidad.comun.configuracion.basica.TipoGrafico;
import meta.entidad.comun.configuracion.basica.TipoInforme;
import meta.entidad.comun.control.acceso.Usuario;
import meta.entidad.comun.operacion.basica.RecursoValor;

@EntityClass(independent=Kleenean.TRUE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE, sortOption=SortOption.DESC)
@EntityInsertOperation(enabled=Kleenean.FALSE)
@EntityUpdateOperation(enabled=Kleenean.FALSE)
@EntityDeleteOperation(enabled=Kleenean.FALSE)
@EntityTableView(enabled=Kleenean.TRUE, responsiveMode=TableResponsiveMode.PRIORITY, readingViewBelowTableSnippet="/resources/snippets/base/entity/RastroInforme/overlayPanel")
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE, menu=Kleenean.FALSE)
@EntityTriggers(afterValue=Kleenean.TRUE)
@EntityWarnings(aboutBusinessKey=Kleenean.FALSE)
public class RastroInforme
extends AbstractPersistentEntity {
    @PrimaryKey
    @PropertyField(detail=Kleenean.TRUE, hidden=Kleenean.FALSE)
    public LongProperty id;
    @ColumnField(nullable=Kleenean.FALSE, indexed=Kleenean.TRUE)
    @PropertyField(responsivePriority=6, sequence=100, table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public TimestampProperty fechaHoraInicioEjecucion;
    @PropertyField(sequence=100)
    public TimestampProperty fechaHoraFinEjecucion;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(sequence=100, table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE, overlay=Kleenean.TRUE)
    @StringField(maxLength=200)
    public StringProperty nombreInforme;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(responsivePriority=5, sequence=200, table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE, overlay=Kleenean.TRUE)
    @StringField(maxLength=5)
    public StringProperty formatoInforme;
    @PropertyField(sequence=410, table=Kleenean.FALSE, search=Kleenean.FALSE, report=Kleenean.FALSE)
    public IntegerProperty limiteFilas;
    @OwnerProperty
    @SegmentProperty
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    @QueryMapping(mapKeyProperties=Kleenean.FALSE)
    public Usuario usuario;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(responsivePriority=6, sequence=250, table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=254, displayLength=36)
    public StringProperty codigoUsuario;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(sequence=250, table=Kleenean.FALSE, search=Kleenean.TRUE, report=Kleenean.TRUE, overlay=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty nombreUsuario;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(sequence=300, hidden=Kleenean.TRUE)
    @QueryMapping(mapKeyProperties=Kleenean.FALSE)
    public Funcion funcion;
    @PropertyField(sequence=300)
    @StringField(maxLength=200)
    public StringProperty codigoFuncion;
    @PropertyField(sequence=300)
    @StringField(maxLength=200)
    public StringProperty nombreFuncion;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.FALSE)
    @StringField(maxLength=0)
    public StringProperty descripcionFuncion;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(sequence=300, hidden=Kleenean.TRUE)
    public StringProperty paginaFuncion;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(sequence=300)
    public TipoFuncion tipoFuncion;
    @PropertyField(sequence=300, hidden=Kleenean.TRUE)
    public LongProperty idClaseRecursoValor;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(sequence=300, search=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty codigoClaseRecursoValor;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(sequence=300, search=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty nombreClaseRecursoValor;
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(sequence=300, hidden=Kleenean.TRUE)
    public RecursoValor recursoValor;
    @PropertyField(sequence=300, hidden=Kleenean.TRUE)
    public LongProperty idRecurso;
    @PropertyField(sequence=300, hidden=Kleenean.TRUE)
    public LongProperty versionRecurso;
    @ColumnField(indexed=Kleenean.FALSE)
    @PropertyField(sequence=300, table=Kleenean.TRUE, report=Kleenean.TRUE, search=Kleenean.TRUE)
    public StringProperty codigoRecurso;
    @ColumnField(indexed=Kleenean.FALSE)
    @PropertyField(sequence=300, table=Kleenean.FALSE, report=Kleenean.TRUE, search=Kleenean.TRUE)
    public StringProperty nombreRecurso;
    @PropertyField(sequence=300, hidden=Kleenean.TRUE)
    public LongProperty idPropietarioRecurso;
    @PropertyField(sequence=300, hidden=Kleenean.TRUE)
    public LongProperty idSegmentoRecurso;
    @UniformResourceLocator(urlType=UrlType.INTERNAL, urlDisplayType=UrlDisplayType.BUTTON)
    @PropertyField(sequence=300, hidden=Kleenean.TRUE)
    public StringProperty paginaRecurso;
    @PropertyField(sequence=400)
    @StringField(maxLength=0)
    public StringProperty criteriosBusqueda;
    @PropertyField(sequence=400)
    @StringField(maxLength=0)
    public StringProperty instruccionSelect;
    @PropertyField(sequence=400)
    public BooleanProperty selectRestringido;
    @PropertyField(sequence=400)
    public LongProperty filasSeleccionadas;
    @PropertyField(sequence=410)
    @StringField(maxLength=20)
    public StringProperty etiquetaLenguaje;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(responsivePriority=5, sequence=500, table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    public CondicionEjeFun condicionEjeFun;
    @FileReference(loadField="fechaHoraInicioEjecucion")
    @PropertyField(sequence=150, table=Kleenean.TRUE, report=Kleenean.FALSE, search=Kleenean.FALSE, readingTableSnippet="/resources/snippets/base/entity/RastroInforme/overlayPanelLink")
    public StringProperty nombreArchivo;
    @PropertyField(sequence=500)
    @StringField(maxLength=0)
    public StringProperty descripcionError;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(responsivePriority=6, sequence=200, table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public TipoInforme tipoInforme;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(sequence=200, table=Kleenean.FALSE, search=Kleenean.FALSE, report=Kleenean.FALSE, overlay=Kleenean.TRUE)
    public TipoGrafico tipoGrafico;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(sequence=200, table=Kleenean.FALSE, search=Kleenean.FALSE, report=Kleenean.FALSE, overlay=Kleenean.TRUE)
    public SubtipoGrafico subtipoGrafico;
    @ColumnField(nullable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(hidden=Kleenean.TRUE)
    @QueryMapping(mapKeyProperties=Kleenean.FALSE)
    public Usuario remitente;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(responsivePriority=6, sequence=250, table=Kleenean.TRUE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=254, displayLength=36)
    public StringProperty codigoRemitente;
    @ColumnField(indexed=Kleenean.TRUE)
    @PropertyField(sequence=250, table=Kleenean.FALSE, search=Kleenean.TRUE, report=Kleenean.TRUE)
    @StringField(maxLength=100)
    public StringProperty nombreRemitente;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(sequence=210)
    public BooleanProperty leido;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(sequence=210)
    public BooleanProperty descargado;
    @ColumnField(nullable=Kleenean.FALSE, indexed=Kleenean.FALSE)
    @PropertyField(responsivePriority=6, sequence=200, table=Kleenean.TRUE, search=Kleenean.FALSE, report=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public BooleanProperty personal;
    protected Key ix_rastro_informe_0001;
    protected Tab tab1;
    protected Tab tab2;
    protected Segment finalizado;
    protected Segment pendiente;
    protected Segment pendienteActual;
    protected MarcarComoLeido marcarComoLeido;
    protected MarcarComoNoLeido marcarComoNoLeido;
    protected EnviarCopia enviarCopia;

    public RastroInforme(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "report audit trail");
        this.setLocalizedLabel(SPANISH, "rastro de auditor\u00eda de informe");
        this.setLocalizedShortLabel(ENGLISH, "report trail");
        this.setLocalizedShortLabel(SPANISH, "rastro de informe");
        this.setLocalizedCollectionLabel(ENGLISH, "Report Audit Trails");
        this.setLocalizedCollectionLabel(SPANISH, "Rastros de Auditor\u00eda de Informes");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Report Trails");
        this.setLocalizedCollectionShortLabel(SPANISH, "Rastros de Informes");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Report Audit Trails") + " represents an audit trail of the execution of export and report operations.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Rastros de Auditor\u00eda de Informes") + " representa un rastro de auditor\u00eda de la generaci\u00f3n de archivos e informes.");
        this.setLocalizedShortDescription(ENGLISH, "audit trail of the execution of export and report operations");
        this.setLocalizedShortDescription(SPANISH, "rastro de auditor\u00eda de la generaci\u00f3n de archivos e informes");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.fechaHoraInicioEjecucion.setInitialValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.fechaHoraInicioEjecucion.setDefaultValue(SpecialTemporalValue.CURRENT_TIMESTAMP);
        this.descripcionFuncion.setCalculableValueExpression(this.funcion.descripcionFuncion);
        this.nombreArchivo.setFileDownloadStopFunction("hideDialogoMostrarStatusDownloadPlusRefresh");
        this.nombreArchivo.setFileViewerDialogReturnUpdate("mainForm", "northForm", "@(.xs-bar-updatable-component)");
        this.leido.setInitialValue(false);
        this.leido.setDefaultValue(false);
        this.descargado.setInitialValue(false);
        this.descargado.setDefaultValue(false);
        this.personal.setInitialValue(false);
        this.personal.setDefaultValue(false);
        this.condicionEjeFun.setInitialValue(this.condicionEjeFun.EJECUCION_PENDIENTE);
        this.condicionEjeFun.setDefaultValue(this.condicionEjeFun.EJECUCION_PENDIENTE);
        this.fechaHoraInicioEjecucion.setLocalizedLabel(ENGLISH, "start");
        this.fechaHoraInicioEjecucion.setLocalizedLabel(SPANISH, "inicio");
        this.fechaHoraFinEjecucion.setLocalizedLabel(ENGLISH, "end");
        this.fechaHoraFinEjecucion.setLocalizedLabel(SPANISH, "fin");
        this.nombreInforme.setLocalizedLabel(ENGLISH, "report");
        this.nombreInforme.setLocalizedLabel(SPANISH, "informe");
        this.formatoInforme.setLocalizedLabel(ENGLISH, "format");
        this.formatoInforme.setLocalizedLabel(SPANISH, "formato");
        this.tipoInforme.setLocalizedLabel(ENGLISH, "type");
        this.tipoInforme.setLocalizedLabel(SPANISH, "tipo");
        this.tipoGrafico.setLocalizedLabel(ENGLISH, "chart");
        this.tipoGrafico.setLocalizedLabel(SPANISH, "gr\u00e1fico");
        this.subtipoGrafico.setLocalizedLabel(ENGLISH, "subtype");
        this.subtipoGrafico.setLocalizedLabel(SPANISH, "subtipo");
        this.leido.setLocalizedLabel(ENGLISH, "read");
        this.leido.setLocalizedLabel(SPANISH, "le\u00eddo");
        this.descargado.setLocalizedLabel(ENGLISH, "downloaded");
        this.descargado.setLocalizedLabel(SPANISH, "descargado");
        this.personal.setLocalizedTooltip(ENGLISH, "user-defined report");
        this.personal.setLocalizedTooltip(SPANISH, "informe definido por el usuario");
        this.limiteFilas.setLocalizedLabel(ENGLISH, "limit");
        this.limiteFilas.setLocalizedLabel(SPANISH, "l\u00edmite");
        this.usuario.setLocalizedLabel(ENGLISH, "user");
        this.usuario.setLocalizedLabel(SPANISH, "usuario");
        this.codigoUsuario.setLocalizedLabel(ENGLISH, "user");
        this.codigoUsuario.setLocalizedLabel(SPANISH, "usuario");
        this.nombreUsuario.setLocalizedLabel(ENGLISH, "user name");
        this.nombreUsuario.setLocalizedLabel(SPANISH, "nombre del usuario");
        this.remitente.setLocalizedLabel(ENGLISH, "sender");
        this.remitente.setLocalizedLabel(SPANISH, "remitente");
        this.codigoRemitente.setLocalizedLabel(ENGLISH, "sender");
        this.codigoRemitente.setLocalizedLabel(SPANISH, "remitente");
        this.nombreRemitente.setLocalizedLabel(ENGLISH, "sender name");
        this.nombreRemitente.setLocalizedLabel(SPANISH, "nombre del remitente");
        this.funcion.setLocalizedLabel(ENGLISH, "function");
        this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.tipoFuncion.setLocalizedLabel(ENGLISH, "function type");
        this.tipoFuncion.setLocalizedLabel(SPANISH, "tipo de funci\u00f3n");
        this.codigoFuncion.setLocalizedLabel(ENGLISH, "function");
        this.codigoFuncion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.nombreFuncion.setLocalizedLabel(ENGLISH, "function name");
        this.nombreFuncion.setLocalizedLabel(SPANISH, "nombre de la funci\u00f3n");
        this.descripcionFuncion.setLocalizedLabel(ENGLISH, "function description");
        this.descripcionFuncion.setLocalizedLabel(SPANISH, "descripci\u00f3n de la funci\u00f3n");
        this.paginaFuncion.setLocalizedLabel(ENGLISH, "function page");
        this.paginaFuncion.setLocalizedLabel(SPANISH, "p\u00e1gina de la funci\u00f3n");
        this.paginaFuncion.setLocalizedTooltip(ENGLISH, "open the function's processing page");
        this.paginaFuncion.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina de procesamiento de la funci\u00f3n");
        this.idClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        this.idClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        this.codigoClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class");
        this.codigoClaseRecursoValor.setLocalizedLabel(SPANISH, "clase de recurso");
        this.nombreClaseRecursoValor.setLocalizedLabel(ENGLISH, "resource class name");
        this.nombreClaseRecursoValor.setLocalizedLabel(SPANISH, "nombre de la clase de recurso");
        this.recursoValor.setLocalizedLabel(ENGLISH, "resource");
        this.recursoValor.setLocalizedLabel(SPANISH, "recurso");
        this.idRecurso.setLocalizedLabel(ENGLISH, "resource");
        this.idRecurso.setLocalizedLabel(SPANISH, "recurso");
        this.versionRecurso.setLocalizedLabel(ENGLISH, "resource version");
        this.versionRecurso.setLocalizedLabel(SPANISH, "versi\u00f3n del recurso");
        this.codigoRecurso.setLocalizedDescription(ENGLISH, "code of the resource on which the report was executed");
        this.codigoRecurso.setLocalizedDescription(SPANISH, "c\u00f3digo del recurso sobre el que se ejecut\u00f3 el informe");
        this.codigoRecurso.setLocalizedLabel(ENGLISH, "resource");
        this.codigoRecurso.setLocalizedLabel(SPANISH, "recurso");
        this.nombreRecurso.setLocalizedDescription(ENGLISH, "name of the resource on which the report was executed");
        this.nombreRecurso.setLocalizedDescription(SPANISH, "nombre del recurso sobre el que se ejecut\u00f3 el informe");
        this.nombreRecurso.setLocalizedLabel(ENGLISH, "resource name");
        this.nombreRecurso.setLocalizedLabel(SPANISH, "nombre del recurso");
        this.idPropietarioRecurso.setLocalizedLabel(ENGLISH, "resource owner");
        this.idPropietarioRecurso.setLocalizedLabel(SPANISH, "propietario del recurso");
        this.idSegmentoRecurso.setLocalizedLabel(ENGLISH, "resource segment");
        this.idSegmentoRecurso.setLocalizedLabel(SPANISH, "segmento del recurso");
        this.paginaRecurso.setLocalizedLabel(ENGLISH, "resource page");
        this.paginaRecurso.setLocalizedLabel(SPANISH, "p\u00e1gina del recurso");
        this.paginaRecurso.setLocalizedTooltip(ENGLISH, "open the resource's registration page");
        this.paginaRecurso.setLocalizedTooltip(SPANISH, "abrir la p\u00e1gina de registro del recurso");
        this.criteriosBusqueda.setLocalizedLabel(ENGLISH, "search criteria");
        this.criteriosBusqueda.setLocalizedLabel(SPANISH, "criterios de b\u00fasqueda");
        this.instruccionSelect.setLocalizedLabel(ENGLISH, "select statement");
        this.instruccionSelect.setLocalizedLabel(SPANISH, "instrucci\u00f3n select");
        this.selectRestringido.setLocalizedLabel(ENGLISH, "restricted select");
        this.selectRestringido.setLocalizedLabel(SPANISH, "select restringido");
        this.filasSeleccionadas.setLocalizedLabel(ENGLISH, "selected rows");
        this.filasSeleccionadas.setLocalizedLabel(SPANISH, "filas seleccionadas");
        this.etiquetaLenguaje.setLocalizedLabel(ENGLISH, "language tag");
        this.etiquetaLenguaje.setLocalizedLabel(SPANISH, "etiqueta de lenguaje");
        this.etiquetaLenguaje.setLocalizedShortLabel(ENGLISH, "language");
        this.etiquetaLenguaje.setLocalizedShortLabel(SPANISH, "lenguaje");
        this.condicionEjeFun.setLocalizedLabel(ENGLISH, "function execution condition");
        this.condicionEjeFun.setLocalizedLabel(SPANISH, "condici\u00f3n de ejecuci\u00f3n de funci\u00f3n");
        this.condicionEjeFun.setLocalizedShortLabel(ENGLISH, "condition");
        this.condicionEjeFun.setLocalizedShortLabel(SPANISH, "condici\u00f3n");
        this.nombreArchivo.setLocalizedLabel(ENGLISH, "file");
        this.nombreArchivo.setLocalizedLabel(SPANISH, "archivo");
        this.nombreArchivo.setLocalizedTooltip(ENGLISH, "open the report file");
        this.nombreArchivo.setLocalizedTooltip(SPANISH, "abrir el archivo del informe");
        this.descripcionError.setLocalizedLabel(ENGLISH, "message");
        this.descripcionError.setLocalizedLabel(SPANISH, "mensaje");
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.ix_rastro_informe_0001.setUnique(false);
        this.ix_rastro_informe_0001.newKeyField(this.idClaseRecursoValor, this.recursoValor);
    }

    @Override
    protected void settleTabs() {
        super.settleTabs();
        this.tab1.newTabField(this.id, this.fechaHoraInicioEjecucion, this.fechaHoraFinEjecucion, this.nombreInforme, this.nombreArchivo, this.formatoInforme, this.tipoInforme, this.tipoGrafico, this.subtipoGrafico, this.personal, this.leido, this.descargado, this.usuario, this.codigoUsuario, this.nombreUsuario, this.remitente, this.codigoRemitente, this.nombreRemitente, this.condicionEjeFun, this.descripcionError);
        this.tab2.newTabField(this.funcion, this.codigoFuncion, this.nombreFuncion, this.descripcionFuncion, this.paginaFuncion, this.tipoFuncion, this.idClaseRecursoValor, this.codigoClaseRecursoValor, this.nombreClaseRecursoValor, this.recursoValor, this.idRecurso, this.versionRecurso, this.codigoRecurso, this.nombreRecurso, this.idPropietarioRecurso, this.idSegmentoRecurso, this.paginaRecurso, this.criteriosBusqueda, this.instruccionSelect, this.selectRestringido, this.filasSeleccionadas, this.limiteFilas, this.etiquetaLenguaje);
        this.tab1.setLocalizedLabel(ENGLISH, "general");
        this.tab1.setLocalizedLabel(SPANISH, "general");
        this.tab2.setLocalizedLabel(ENGLISH, "details");
        this.tab2.setLocalizedLabel(SPANISH, "detalles");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.finalizado = this.condicionEjeFun.isIn(this.condicionEjeFun.EJECUTADO_SIN_ERRORES, this.condicionEjeFun.EJECUTADO_CON_ERRORES, this.condicionEjeFun.EJECUCION_CANCELADA);
        this.pendiente = RastroInforme.and(this.finalizado, RastroInforme.not(this.leido), RastroInforme.not(this.descargado));
        this.pendienteActual = this.pendiente.and(this.codigoUsuario.isEqualTo(CURRENT_USER_CODE));
        this.pendiente.setLocalizedCollectionLabel(ENGLISH, "all reports not read or downloaded by their owner user");
        this.pendiente.setLocalizedCollectionLabel(SPANISH, "todos los informes no le\u00eddos ni descargados por su usuario propietario");
        this.pendiente.setLocalizedCollectionShortLabel(ENGLISH, "Reports not read nor downloaded");
        this.pendiente.setLocalizedCollectionShortLabel(SPANISH, "Informes no le\u00eddos ni descargados");
        this.pendiente.setLocalizedDescription(ENGLISH, "the report has not been read or downloaded by its owner user");
        this.pendiente.setLocalizedDescription(SPANISH, "el informe no ha sido le\u00eddo ni descargado por su usuario propietario");
        this.pendiente.setLocalizedErrorMessage(ENGLISH, "the report has already been read or downloaded by its owner user");
        this.pendiente.setLocalizedErrorMessage(SPANISH, "el informe ya fue le\u00eddo o descargado por su usuario propietario");
        this.pendienteActual.setLocalizedCollectionLabel(ENGLISH, "all your reports not read nor downloaded by you");
        this.pendienteActual.setLocalizedCollectionLabel(SPANISH, "todos sus informes no le\u00eddos ni descargados por usted");
        this.pendienteActual.setLocalizedCollectionShortLabel(ENGLISH, "My unread and undownloaded reports");
        this.pendienteActual.setLocalizedCollectionShortLabel(SPANISH, "Mis informes no le\u00eddos ni descargados");
        this.pendienteActual.setLocalizedDescription(ENGLISH, "the report has not been read or downloaded by the current user");
        this.pendienteActual.setLocalizedDescription(SPANISH, "el informe no ha sido le\u00eddo ni descargado por el usuario actual");
        this.pendienteActual.setLocalizedErrorMessage(ENGLISH, "the report has already been read or downloaded by you");
        this.pendienteActual.setLocalizedErrorMessage(SPANISH, "el informe ya fue le\u00eddo o descargado por usted");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.addSelectSegment(this.pendienteActual, false);
        this.addSelectSegment(this.pendiente, false);
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class EnviarCopia
    extends ProcessOperation {
        @InstanceReference
        protected RastroInforme informe;
        @ParameterField(required=Kleenean.TRUE)
        @EntityReferenceConversionValidation(restrictedAccess=Kleenean.FALSE)
        protected Usuario destinatario;
        protected Check check101;
        protected Check check201;
        protected Check check202;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "send a copy");
            this.setLocalizedLabel(SPANISH, "enviar copia");
            this.setLocalizedDescription(ENGLISH, "send a copy of the report to the specified recipient");
            this.setLocalizedDescription(SPANISH, "enviar una copia del informe al destinatario especificado");
            this.setLocalizedSuccessMessage(ENGLISH, "a copy of the report was sent to the specified recipient");
            this.setLocalizedSuccessMessage(SPANISH, "se envi\u00f3 una copia del informe al destinatario especificado");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.informe.setLocalizedLabel(ENGLISH, "report");
            this.informe.setLocalizedLabel(SPANISH, "informe");
            this.destinatario.setLocalizedLabel(ENGLISH, "recipient user");
            this.destinatario.setLocalizedLabel(SPANISH, "usuario destinatario");
            this.destinatario.setLocalizedShortLabel(ENGLISH, "recipient");
            this.destinatario.setLocalizedShortLabel(SPANISH, "destinatario");
            this.destinatario.setLocalizedShortDescription(ENGLISH, "report recipient");
            this.destinatario.setLocalizedShortDescription(SPANISH, "destinatario del informe");
            this.destinatario.setLocalizedTooltip(ENGLISH, "user code of the report recipient");
            this.destinatario.setLocalizedTooltip(SPANISH, "c\u00f3digo de usuario del destinatario del informe");
            this.destinatario.codigoUsuario.setLocalizedShortLabel(ENGLISH, "recipient code");
            this.destinatario.codigoUsuario.setLocalizedShortLabel(SPANISH, "destinatario");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.informe.condicionEjeFun.isEqualTo(this.informe.condicionEjeFun.EJECUTADO_SIN_ERRORES);
            this.check201 = this.destinatario.esUsuarioEspecial.isFalse();
            this.check202 = this.destinatario.id.isNotEqualTo(CURRENT_USER_ID);
            this.check101.setLocalizedDescription(ENGLISH, "the report has finished without errors");
            this.check101.setLocalizedDescription(SPANISH, "el informe ha terminado sin errores");
            this.check101.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of reports that have not finished without errors");
            this.check101.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de informes que no hayan terminado sin errores");
            this.check201.setLocalizedDescription(ENGLISH, "the recipient is not a special user");
            this.check201.setLocalizedDescription(SPANISH, "el destinatario no es un usuario especial");
            this.check201.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of reports to special users");
            this.check201.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de informes a usuarios especiales");
            this.check202.setLocalizedDescription(ENGLISH, "the recipient is not the current user");
            this.check202.setLocalizedDescription(SPANISH, "el destinatario no es el usuario actual");
            this.check202.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of reports to yourself");
            this.check202.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviarse copias de informes a uno mismo");
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            this.destinatario.setSearchQueryFilter(EnviarCopia.and(this.check201, this.check202));
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    public class MarcarComoNoLeido
    extends ProcessOperation {
        @InstanceReference
        protected RastroInforme informe;
        protected Check check101;
        protected Check check102;
        protected Check check103;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "mark as unread and undownloaded");
            this.setLocalizedLabel(SPANISH, "marcar como no le\u00eddo ni descargado");
            this.setLocalizedDescription(ENGLISH, "mark report as unread and undownloaded");
            this.setLocalizedDescription(SPANISH, "marcar informe como no le\u00eddo ni descargado");
            this.setLocalizedSuccessMessage(ENGLISH, "the report was marked as unread and undownloaded");
            this.setLocalizedSuccessMessage(SPANISH, "el informe fue marcado como no le\u00eddo ni descargado");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.informe.leido.setCurrentValue(false);
            this.informe.descargado.setCurrentValue(false);
            this.informe.setLocalizedLabel(ENGLISH, "report");
            this.informe.setLocalizedLabel(SPANISH, "informe");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.informe.condicionEjeFun.isIn(this.informe.condicionEjeFun.EJECUTADO_SIN_ERRORES, this.informe.condicionEjeFun.EJECUTADO_CON_ERRORES, this.informe.condicionEjeFun.EJECUCION_CANCELADA);
            this.check102 = this.informe.codigoUsuario.isEqualTo(CURRENT_USER_CODE);
            this.check103 = this.informe.leido.or(this.informe.descargado);
            this.check101.setLocalizedDescription(ENGLISH, "the report has finished");
            this.check101.setLocalizedDescription(SPANISH, "el informe ha terminado");
            this.check101.setLocalizedErrorMessage(ENGLISH, "it is not allowed to mark as unread those reports that have not finished");
            this.check101.setLocalizedErrorMessage(SPANISH, "no se permite marcar como no le\u00eddos aquellos informes que no hayan finalizado");
            this.check102.setLocalizedDescription(ENGLISH, "the report belongs to the current user");
            this.check102.setLocalizedDescription(SPANISH, "el informe le pertenece al usuario actual");
            this.check102.setLocalizedErrorMessage(ENGLISH, "the report does not belong to your user");
            this.check102.setLocalizedErrorMessage(SPANISH, "el informe no le pertenece a su usuario");
            this.check103.setLocalizedDescription(ENGLISH, "the report has been read or downloaded");
            this.check103.setLocalizedDescription(SPANISH, "el informe ya fue le\u00eddo o descargado");
            this.check103.setLocalizedErrorMessage(ENGLISH, "the report has not been read nor downloaded");
            this.check103.setLocalizedErrorMessage(SPANISH, "el informe no ha sido le\u00eddo ni descargado");
        }
    }

    @OperationClass(access=OperationAccess.RESTRICTED)
    public class MarcarComoLeido
    extends ProcessOperation {
        @InstanceReference
        protected RastroInforme informe;
        protected Check check101;
        protected Check check102;
        protected Check check103;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "mark as read");
            this.setLocalizedLabel(SPANISH, "marcar como le\u00eddo");
            this.setLocalizedDescription(ENGLISH, "mark report as read");
            this.setLocalizedDescription(SPANISH, "marcar informe como le\u00eddo");
            this.setLocalizedSuccessMessage(ENGLISH, "the report was marked as read");
            this.setLocalizedSuccessMessage(SPANISH, "el informe fue marcado como le\u00eddo");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.informe.leido.setCurrentValue(true);
            this.informe.setLocalizedLabel(ENGLISH, "report");
            this.informe.setLocalizedLabel(SPANISH, "informe");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.informe.condicionEjeFun.isIn(this.informe.condicionEjeFun.EJECUTADO_SIN_ERRORES, this.informe.condicionEjeFun.EJECUTADO_CON_ERRORES, this.informe.condicionEjeFun.EJECUCION_CANCELADA);
            this.check102 = this.informe.codigoUsuario.isEqualTo(CURRENT_USER_CODE);
            this.check103 = MarcarComoLeido.not(this.informe.leido.or(this.informe.descargado));
            this.check101.setLocalizedDescription(ENGLISH, "the report has finished");
            this.check101.setLocalizedDescription(SPANISH, "el informe ha terminado");
            this.check101.setLocalizedErrorMessage(ENGLISH, "it is not allowed to mark as read those reports that have not finished");
            this.check101.setLocalizedErrorMessage(SPANISH, "no se permite marcar como le\u00eddos aquellos informes que no hayan finalizado");
            this.check102.setLocalizedDescription(ENGLISH, "the report belongs to the current user");
            this.check102.setLocalizedDescription(SPANISH, "el informe le pertenece al usuario actual");
            this.check102.setLocalizedErrorMessage(ENGLISH, "the report does not belong to your user");
            this.check102.setLocalizedErrorMessage(SPANISH, "el informe no le pertenece a su usuario");
            this.check103.setLocalizedDescription(ENGLISH, "the report has not been read nor downloaded");
            this.check103.setLocalizedDescription(SPANISH, "el informe no ha sido le\u00eddo ni descargado");
            this.check103.setLocalizedErrorMessage(ENGLISH, "the report has been read or downloaded");
            this.check103.setLocalizedErrorMessage(SPANISH, "el informe ya fue le\u00eddo o descargado");
        }
    }
}

