/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.VariantString;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.TableResponsiveMode;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Segment;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ClaseRecurso;
import meta.entidad.comun.control.acceso.ConjuntoSegmento;

@EntityClass(independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.FALSE, responsiveMode=TableResponsiveMode.PRIORITY)
@EntityDetailView(enabled=Kleenean.FALSE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class ElementoSegmento
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable=Kleenean.FALSE)
    public ConjuntoSegmento conjuntoSegmento;
    @ColumnField(calculable=Kleenean.TRUE)
    @PropertyField(table=Kleenean.TRUE)
    public ClaseRecurso claseRecurso;
    @VariantString
    @PropertyField(table=Kleenean.TRUE, detail=Kleenean.TRUE, create=Kleenean.TRUE, update=Kleenean.TRUE, required=Kleenean.TRUE)
    public StringProperty segmento;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty segmentoEnteroGrande;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idSegmento;
    @PropertyField(hidden=Kleenean.TRUE)
    public StringProperty codigoSegmento;
    @PropertyField(hidden=Kleenean.TRUE)
    public StringProperty nombreSegmento;
    protected Key uk_elemento_segmento_0001;
    protected Segment modificables;
    protected Segment ordinarios;

    public ElementoSegmento(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("conjuntoSegmento.grupo", "conjuntoSegmento.claseRecurso", "conjuntoSegmento.claseFabricador");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "segment set element");
        this.setLocalizedLabel(SPANISH, "elemento del conjunto de segmentos");
        this.setLocalizedShortLabel(ENGLISH, "element");
        this.setLocalizedShortLabel(SPANISH, "elemento");
        this.setLocalizedCollectionLabel(ENGLISH, "Segment Set Elements");
        this.setLocalizedCollectionLabel(SPANISH, "Elementos del Conjunto de Segmentos");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Elements");
        this.setLocalizedCollectionShortLabel(SPANISH, "Elementos");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Segment Set Elements") + " represents a segment set element, which typically corresponds to a row of a table in the database.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Elementos del Conjunto de Segmentos") + " representa un elemento de conjunto de segmentos, el cual normalmente corresponde a una fila de una tabla en la base de datos.");
        this.setLocalizedShortDescription(ENGLISH, "segment set element, which typically corresponds to a row of a table in the database");
        this.setLocalizedShortDescription(SPANISH, "elemento de conjunto de segmentos, el cual normalmente corresponde a una fila de una tabla en la base de datos");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.claseRecurso.setCalculableValueEntityReference(this.conjuntoSegmento.claseRecurso);
        this.segmento.setTypeNameExpression(this.conjuntoSegmento.claseRecurso.claseJavaClaseRecurso);
        this.segmento.setLocalizedLabel(ENGLISH, "segment");
        this.segmento.setLocalizedLabel(SPANISH, "segmento");
        this.segmentoEnteroGrande.setLocalizedLabel(ENGLISH, "segment");
        this.segmentoEnteroGrande.setLocalizedLabel(SPANISH, "segmento");
        this.idSegmento.setLocalizedLabel(ENGLISH, "segment");
        this.idSegmento.setLocalizedLabel(SPANISH, "segmento");
        this.codigoSegmento.setLocalizedLabel(ENGLISH, "segment");
        this.codigoSegmento.setLocalizedLabel(SPANISH, "segmento");
        this.nombreSegmento.setLocalizedLabel(ENGLISH, "segment name");
        this.nombreSegmento.setLocalizedLabel(SPANISH, "nombre del segmento");
        this.conjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set");
        this.conjuntoSegmento.setLocalizedLabel(SPANISH, "conjunto de segmentos");
        this.conjuntoSegmento.setLocalizedShortLabel(ENGLISH, "set");
        this.conjuntoSegmento.setLocalizedShortLabel(SPANISH, "conjunto");
        this.claseRecurso.setLocalizedLabel(ENGLISH, "resource class");
        this.claseRecurso.setLocalizedLabel(SPANISH, "clase de recurso");
        this.claseRecurso.setLocalizedShortLabel(ENGLISH, "class");
        this.claseRecurso.setLocalizedShortLabel(SPANISH, "clase");
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignSegmentProperty(this.conjuntoSegmento.grupo);
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.uk_elemento_segmento_0001.setUnique(true);
        this.uk_elemento_segmento_0001.newKeyField(this.conjuntoSegmento, this.segmentoEnteroGrande);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.modificables = ElementoSegmento.not(this.conjuntoSegmento.esConjuntoEspecial);
        this.ordinarios = this.modificables.and(this.conjuntoSegmento.claseFabricador.isNull().or(this.conjuntoSegmento.claseFabricador.elemental));
        this.modificables.setLocalizedDescription(ENGLISH, "the set is not a basic configuration set");
        this.modificables.setLocalizedDescription(SPANISH, "el conjunto no es un conjunto de configuraci\u00f3n b\u00e1sica del sistema");
        this.modificables.setLocalizedErrorMessage(ENGLISH, "the set is a basic configuration set; it can't be modified or deleted");
        this.modificables.setLocalizedErrorMessage(SPANISH, "el conjunto es un conjunto de configuraci\u00f3n b\u00e1sica del sistema; no se permite modificarlo ni eliminarlo");
        this.ordinarios.setLocalizedDescription(ENGLISH, "the set is not a basic configuration set and its elements are explicitly specified");
        this.ordinarios.setLocalizedDescription(SPANISH, "el conjunto no es un conjunto de configuraci\u00f3n b\u00e1sica del sistema y sus elementos son especificados expl\u00edcitamente");
        this.ordinarios.setLocalizedErrorMessage(ENGLISH, "the set is a basic configuration set or its elements are determined by a factory class that does not uses elements; its elements cannot be explicitly specified");
        this.ordinarios.setLocalizedErrorMessage(SPANISH, "el conjunto es un conjunto de configuraci\u00f3n b\u00e1sica del sistema o sus elementos son determinados por una clase de fabricador que no usa elementos; sus elementos no pueden ser especificados expl\u00edcitamente");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setMasterDetailFilter(this.conjuntoSegmento.ordinarios);
        this.setInsertFilter(this.conjuntoSegmento.ordinarios);
        this.setUpdateFilter(this.ordinarios);
        this.setDeleteFilter(this.ordinarios);
        this.segmento.setModifyingFilter(this.conjuntoSegmento.isNotNull());
        this.idSegmento.setModifyingFilter(this.conjuntoSegmento.isNotNull());
    }
}

