/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.acceso;

import adalid.core.AbstractPersistentEntity;
import adalid.core.Key;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceSearch;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.Kleenean;
import adalid.core.enums.ListStyle;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.PropertyAccess;
import adalid.core.enums.QuickAddingFilter;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SearchType;
import adalid.core.enums.TableResponsiveMode;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.ext.CloakedStringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ext.ClaseRecurso;
import meta.entidad.comun.configuracion.basica.ext.Funcion;
import meta.entidad.comun.control.acceso.ConjuntoSegmento;
import meta.entidad.comun.control.acceso.Rol;

@EntityClass(independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE, responsiveMode=TableResponsiveMode.PRIORITY)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.FALSE)
public class RolFuncion
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @NameProperty
    @ColumnField(calculable=Kleenean.TRUE)
    public CloakedStringProperty nombre;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE, viewSequence=20)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public Rol rol;
    @ColumnField(calculable=Kleenean.TRUE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(responsivePriority=6, search=Kleenean.TRUE, create=Kleenean.TRUE, update=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE, export=Kleenean.TRUE, overlay=Kleenean.TRUE)
    public ClaseRecurso clase;
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE, quickAdding=QuickAddingFilter.MISSING)
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(required=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE, heading=Kleenean.TRUE, overlay=Kleenean.TRUE, access=PropertyAccess.RESTRICTED_WRITING)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
    public Funcion funcion;
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(responsivePriority=6, required=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE, create=Kleenean.TRUE, access=PropertyAccess.RESTRICTED_WRITING)
    @EntityReferenceSearch(searchType=SearchType.LIST, listStyle=ListStyle.NAME)
    public ConjuntoSegmento conjuntoSegmento;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(responsivePriority=6, required=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE, create=Kleenean.TRUE, access=PropertyAccess.RESTRICTED_WRITING, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public BooleanProperty esAccesoPersonalizado;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(responsivePriority=6, required=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE, create=Kleenean.TRUE)
    public BooleanProperty esTarea;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(responsivePriority=6, create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.TRUE)
    public BooleanProperty esAutorizacionInvalida;
    protected Key ix_rol_funcion_0001;
    protected Segment modificables;
    protected Segment conjuntables;
    protected Check checkAccesoUsuario;
    protected Check checkFuncionPersonalizada;
    protected Check checkFuncionSegmentada;
    protected Check checkConjuntoSegmentos;
    protected Check checkTipoFuncionTarea;

    public RolFuncion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("rol.grupo", "conjuntoSegmento.claseRecurso", "funcion.dominio.claseRecurso.claseRecursoSegmento", "funcion.tipoFuncion");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "role/function association");
        this.setLocalizedLabel(SPANISH, "asociaci\u00f3n Rol/Funci\u00f3n");
        this.setLocalizedCollectionLabel(ENGLISH, "Role/Function Associations");
        this.setLocalizedCollectionLabel(SPANISH, "Asociaciones Rol/Funci\u00f3n");
        this.setLocalizedCollectionLabel(ENGLISH, this.rol, "Functions by Role");
        this.setLocalizedCollectionLabel(SPANISH, this.rol, "Funciones por Rol");
        this.setLocalizedCollectionShortLabel(ENGLISH, this.rol, "Functions");
        this.setLocalizedCollectionShortLabel(SPANISH, this.rol, "Funciones");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Role/Function Associations") + " represents a function associated with an application role.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Asociaciones Rol/Funci\u00f3n") + " representa una funci\u00f3n asociada con un rol de la aplicaci\u00f3n.");
        this.setLocalizedShortDescription(ENGLISH, "function associated with an application role");
        this.setLocalizedShortDescription(SPANISH, "funci\u00f3n asociada con un rol de la aplicaci\u00f3n");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.nombre.setCalculableValueExpression(RolFuncion.concatenate(this.funcion.codigoFuncion, SLASH, this.rol.codigoRol));
        this.esAccesoPersonalizado.setInitialValue(this.funcion.esPersonalizable);
        this.esAccesoPersonalizado.setDefaultValue(this.funcion.esPersonalizable);
        this.esTarea.setInitialValue(false);
        this.esTarea.setDefaultValue(false);
        this.esAutorizacionInvalida.setInitialValue(false);
        this.esAutorizacionInvalida.setDefaultValue(false);
        this.rol.setLocalizedLabel(ENGLISH, "role");
        this.rol.setLocalizedLabel(SPANISH, "rol");
        this.clase.setLocalizedLabel(ENGLISH, "resource class");
        this.clase.setLocalizedLabel(SPANISH, "clase de recurso");
        this.clase.setLocalizedShortLabel(ENGLISH, "class");
        this.clase.setLocalizedShortLabel(SPANISH, "clase");
        this.funcion.setLocalizedLabel(ENGLISH, "function");
        this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.conjuntoSegmento.setLocalizedLabel(ENGLISH, "segment set");
        this.conjuntoSegmento.setLocalizedLabel(SPANISH, "conjunto de segmentos");
        this.conjuntoSegmento.setLocalizedShortLabel(ENGLISH, "set");
        this.conjuntoSegmento.setLocalizedShortLabel(SPANISH, "conjunto");
        this.esAccesoPersonalizado.setLocalizedLabel(ENGLISH, "personalized access");
        this.esAccesoPersonalizado.setLocalizedLabel(SPANISH, "acceso personalizado");
        this.esAccesoPersonalizado.setLocalizedColumnHeader(ENGLISH, "personalized", "access");
        this.esAccesoPersonalizado.setLocalizedColumnHeader(SPANISH, "acceso", "personalizado");
        this.esTarea.setLocalizedLabel(ENGLISH, "task");
        this.esTarea.setLocalizedLabel(SPANISH, "tarea");
        this.esAutorizacionInvalida.setLocalizedLabel(ENGLISH, "invalid authorization");
        this.esAutorizacionInvalida.setLocalizedLabel(SPANISH, "autorizaci\u00f3n inv\u00e1lida");
        this.esAutorizacionInvalida.setLocalizedColumnHeader(ENGLISH, "invalid", "authorization");
        this.esAutorizacionInvalida.setLocalizedColumnHeader(SPANISH, "autorizaci\u00f3n", "inv\u00e1lida");
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignSegmentProperty(this.rol.grupo);
        this.clase.linkCalculableValueEntityReference(this.funcion.dominio.claseRecurso);
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.ix_rol_funcion_0001.setUnique(false);
        this.ix_rol_funcion_0001.newKeyField(this.rol, this.funcion);
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.modificables = this.rol.id.isGreaterOrEqualTo(10000L);
        this.conjuntables = this.conjuntoSegmento.claseRecurso.isEqualTo(this.funcion.dominio.claseRecurso.claseRecursoSegmento);
        this.checkAccesoUsuario = this.funcion.esProgramatica.isFalse();
        this.checkFuncionPersonalizada = this.funcion.esPersonalizable.isFalse().implies(this.esAccesoPersonalizado.isNotTrue());
        this.checkFuncionSegmentada = this.funcion.esSegmentable.isFalse().implies(this.conjuntoSegmento.isNull());
        this.checkConjuntoSegmentos = this.conjuntoSegmento.isNull().or(this.conjuntables);
        this.checkTipoFuncionTarea = this.funcion.tipoFuncion.isNullOrNotEqualTo(this.funcion.tipoFuncion.PROCESO).implies(this.esTarea.isNotTrue());
        this.modificables.setLocalizedDescription(ENGLISH, "the role is not a basic configuration role");
        this.modificables.setLocalizedDescription(SPANISH, "el rol no es un rol de configuraci\u00f3n b\u00e1sica del sistema");
        this.modificables.setLocalizedErrorMessage(ENGLISH, "the role is a basic configuration role; its functions can't be modified or deleted");
        this.modificables.setLocalizedErrorMessage(SPANISH, "el rol es un rol de configuraci\u00f3n b\u00e1sica del sistema; no se permite modificar ni eliminar sus funciones");
        this.conjuntables.setLocalizedDescription(ENGLISH, "the segment set is of the same resource class as the function");
        this.conjuntables.setLocalizedDescription(SPANISH, "el conjunto de segmentos es de la misma clase de recursos que la funci\u00f3n");
        this.conjuntables.setLocalizedErrorMessage(ENGLISH, "the segment set is not of the same resource class as the function");
        this.conjuntables.setLocalizedErrorMessage(SPANISH, "el conjunto de segmentos no es de la misma clase de recursos que la funci\u00f3n");
        this.checkAccesoUsuario.setLocalizedDescription(ENGLISH, "access can only be granted to non-programmatic functions");
        this.checkAccesoUsuario.setLocalizedDescription(SPANISH, "solo se puede otorgar acceso a funciones no program\u00e1ticas");
        this.checkAccesoUsuario.setLocalizedErrorMessage(ENGLISH, "the function is programmatic");
        this.checkAccesoUsuario.setLocalizedErrorMessage(SPANISH, "la funci\u00f3n es program\u00e1tica");
        this.checkFuncionPersonalizada.setLocalizedDescription(ENGLISH, "personalized access can only be granted to personalizable functions");
        this.checkFuncionPersonalizada.setLocalizedDescription(SPANISH, "solo se puede otorgar acceso personalizado a funciones personalizables");
        this.checkFuncionPersonalizada.setLocalizedErrorMessage(ENGLISH, "the function doesn't allow personalized access");
        this.checkFuncionPersonalizada.setLocalizedErrorMessage(SPANISH, "la funci\u00f3n no permite acceso personalizado");
        this.checkFuncionSegmentada.setLocalizedDescription(ENGLISH, "segmented access can only be granted to segmentable functions");
        this.checkFuncionSegmentada.setLocalizedDescription(SPANISH, "solo se puede otorgar acceso segmentado a funciones segmentables");
        this.checkFuncionSegmentada.setLocalizedErrorMessage(ENGLISH, "the function doesn't allow segmented access");
        this.checkFuncionSegmentada.setLocalizedErrorMessage(SPANISH, "la funci\u00f3n no permite acceso segmentado");
        this.checkConjuntoSegmentos.setLocalizedDescription(ENGLISH, "access can only be granted to a segment set of the same resource class as the function");
        this.checkConjuntoSegmentos.setLocalizedDescription(SPANISH, "solo se puede otorgar acceso a un conjunto de segmentos de la misma clase de recursos que la funci\u00f3n");
        this.checkConjuntoSegmentos.setLocalizedErrorMessage(ENGLISH, "the segment set is not of the same resource class as the function");
        this.checkConjuntoSegmentos.setLocalizedErrorMessage(SPANISH, "el conjunto de segmentos no es de la misma clase de recursos que la funci\u00f3n");
        this.checkTipoFuncionTarea.setLocalizedDescription(ENGLISH, "only business processes can be tasks");
        this.checkTipoFuncionTarea.setLocalizedDescription(SPANISH, "solo los procesos de negocio pueden ser tareas");
        this.checkTipoFuncionTarea.setLocalizedErrorMessage(ENGLISH, "only business processes can be tasks");
        this.checkTipoFuncionTarea.setLocalizedErrorMessage(SPANISH, "solo los procesos de negocio pueden ser tareas");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setMasterDetailFilter(this.rol.rolesOrdinarios);
        this.setInsertFilter(this.rol.modificables);
        this.setUpdateFilter(this.modificables);
        this.setDeleteFilter(this.modificables);
        this.funcion.setSearchQueryFilter(this.checkAccesoUsuario.and(this.clase.isNull().or(this.funcion.dominio.claseRecurso.isEqualTo(this.clase))));
        this.conjuntoSegmento.setSearchQueryFilter(this.conjuntables);
        this.conjuntoSegmento.setModifyingFilter(this.funcion.dominio.claseRecurso.claseRecursoSegmento.isNotNull());
        this.conjuntoSegmento.setNullifyingFilter(this.funcion.dominio.claseRecurso.claseRecursoSegmento.isNull());
        this.esAccesoPersonalizado.setModifyingFilter(this.funcion.esPersonalizable.isTrue());
        this.esAccesoPersonalizado.setNullifyingFilter(this.funcion.esPersonalizable.isNotTrue());
        this.esTarea.setModifyingFilter(this.funcion.tipoFuncion.isEqualTo(this.funcion.tipoFuncion.PROCESO));
        this.esTarea.setNullifyingFilter(this.funcion.tipoFuncion.isNullOrNotEqualTo(this.funcion.tipoFuncion.PROCESO));
    }
}

