/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.control.prueba;

import adalid.core.Key;
import adalid.core.ProcessOperation;
import adalid.core.Tab;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityTriggers;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.FileReference;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.ProcessOperationClass;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SelectOnloadOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.parameters.StringParameter;
import adalid.core.properties.IntegerProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.base.PersistentEntityBase;
import meta.entidad.comun.control.prueba.EscenarioPrueba;
import meta.entidad.comun.control.prueba.ProgramaPrueba;

@EntityClass(independent=Kleenean.FALSE, resourceType=ResourceType.TESTING, resourceGender=ResourceGender.FEMININE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE, onload=SelectOnloadOption.EXECUTE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE, inserts=Kleenean.FALSE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE)
@EntityTriggers(afterCheck=Kleenean.TRUE)
public class LineaPrueba
extends PersistentEntityBase {
    @BusinessKey
    @StringField(maxLength=70)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, defaultCondition=DefaultCondition.UNCONDITIONALLY, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public StringProperty codigo;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(create=Kleenean.TRUE)
    public IntegerProperty numero;
    @ColumnField(nullable=Kleenean.FALSE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @PropertyField(create=Kleenean.TRUE, update=Kleenean.FALSE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public ProgramaPrueba programa;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public EscenarioPrueba escenario;
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(create=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public ProgramaPrueba subprograma;
    @PropertyField(create=Kleenean.TRUE)
    @StringField(maxLength=0)
    public StringProperty condiciones;
    @PropertyField(create=Kleenean.TRUE)
    @StringField(maxLength=0)
    public StringProperty repeticiones;
    @PropertyField(create=Kleenean.TRUE)
    @StringField(maxLength=0)
    public StringProperty comentarios;
    Key key1;
    protected Tab tab1;
    protected Tab tab2;
    protected Check check0101;
    protected Check check0102;
    protected Check check0103;
    protected Check check0104;
    protected Check check0105;
    protected Cargar cargar;

    public LineaPrueba(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("programa.caso", "programa.propietario", "escenario.caso");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "test program line");
        this.setLocalizedLabel(SPANISH, "l\u00ednea de programa de prueba");
        this.setLocalizedShortLabel(ENGLISH, "l\u00edne");
        this.setLocalizedShortLabel(SPANISH, "l\u00ednea");
        this.setLocalizedCollectionLabel(ENGLISH, "Test Program Lines");
        this.setLocalizedCollectionLabel(SPANISH, "L\u00edneas de Programas de Prueba");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Lines");
        this.setLocalizedCollectionShortLabel(SPANISH, "L\u00edneas");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.codigo.setDefaultValue(LineaPrueba.concat(this.programa.codigo, HYPHEN, this.numero));
        this.numero.setMinValue(1);
        this.numero.setMaxValue(10000);
        this.codigo.setLocalizedLabel(ENGLISH, "test program line code");
        this.codigo.setLocalizedLabel(SPANISH, "c\u00f3digo de la l\u00ednea de programa de prueba");
        this.codigo.setLocalizedShortLabel(ENGLISH, "code");
        this.codigo.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.numero.setLocalizedLabel(ENGLISH, "number");
        this.numero.setLocalizedLabel(SPANISH, "n\u00famero");
        this.programa.setLocalizedLabel(ENGLISH, "program");
        this.programa.setLocalizedLabel(SPANISH, "programa");
        this.escenario.setLocalizedLabel(ENGLISH, "scenario");
        this.escenario.setLocalizedLabel(SPANISH, "escenario");
        this.subprograma.setLocalizedLabel(ENGLISH, "subprogram");
        this.subprograma.setLocalizedLabel(SPANISH, "subprograma");
        this.condiciones.setLocalizedLabel(ENGLISH, "conditions");
        this.condiciones.setLocalizedLabel(SPANISH, "condiciones");
        this.repeticiones.setLocalizedLabel(ENGLISH, "repetitions");
        this.repeticiones.setLocalizedLabel(SPANISH, "repeticiones");
        this.comentarios.setLocalizedLabel(ENGLISH, "comments");
        this.comentarios.setLocalizedLabel(SPANISH, "comentarios");
    }

    @Override
    protected void settleLinks() {
        super.settleLinks();
        this.linkForeignOwnerProperty(this.programa.propietario);
    }

    @Override
    protected void settleKeys() {
        super.settleKeys();
        this.key1.newKeyField(this.programa, this.numero, this.id);
        this.key1.setUnique(true);
        this.setOrderBy(this.key1);
    }

    @Override
    protected void settleTabs() {
        super.settleTabs();
        this.tab1.newTabField(this.codigo, this.programa, this.numero, this.escenario, this.subprograma);
        this.tab2.newTabField(this.condiciones, this.repeticiones, this.comentarios);
        this.tab1.setLocalizedLabel(ENGLISH, "basic data");
        this.tab1.setLocalizedLabel(SPANISH, "datos b\u00e1sicos");
        this.tab2.setLocalizedLabel(ENGLISH, "additional data");
        this.tab2.setLocalizedLabel(SPANISH, "datos adicionales");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.check0101 = this.escenario.isNotNull().xor(this.subprograma.isNotNull());
        this.check0102 = this.programa.caso.isNotNull().implies(this.escenario.isNotNull());
        this.check0103 = this.programa.caso.isNotNull().and(this.escenario.isNotNull()).implies(this.programa.caso.isEqualTo(this.escenario.caso));
        this.check0104 = this.programa.caso.isNotNull().implies(this.subprograma.isNull());
        this.check0105 = this.subprograma.isNullOrNotEqualTo(this.programa);
        this.check0101.setLocalizedDescription(ENGLISH, "scenario and subprogram are mutually exclusive");
        this.check0101.setLocalizedDescription(SPANISH, "escenario y subprograma son mutuamente excluyentes");
        this.check0101.setLocalizedErrorMessage(ENGLISH, "scenario and subprogram are mutually exclusive");
        this.check0101.setLocalizedErrorMessage(SPANISH, "escenario y subprograma son mutuamente excluyentes");
        this.check0102.setLocalizedDescription(ENGLISH, "the scenario is required when the program is linked to a test case");
        this.check0102.setLocalizedDescription(SPANISH, "el escenario es requerido cuando el programa est\u00e1 enlazado a un caso de prueba");
        this.check0102.setLocalizedErrorMessage(ENGLISH, "the scenario is required when the program is linked to a test case");
        this.check0102.setLocalizedErrorMessage(SPANISH, "el escenario es requerido porque el programa est\u00e1 enlazado a un caso de prueba");
        this.check0103.setLocalizedDescription(ENGLISH, "the scenario must be from the same test case to which the program is linked");
        this.check0103.setLocalizedDescription(SPANISH, "el escenario debe ser del mismo caso de prueba al cual est\u00e1 enlazado el programa");
        this.check0103.setLocalizedErrorMessage(ENGLISH, "the scenario must be from the same test case to which the program is linked");
        this.check0103.setLocalizedErrorMessage(SPANISH, "el escenario debe ser del mismo caso de prueba al cual est\u00e1 enlazado el programa");
        this.check0104.setLocalizedDescription(ENGLISH, "the line only supports references to linked case scenarios");
        this.check0104.setLocalizedDescription(SPANISH, "la l\u00ednea solo admite referencias a escenarios del caso enlazado");
        this.check0104.setLocalizedErrorMessage(ENGLISH, "the reference to the subroutine is not valid because the program is linked to a test case and only supports references to linked case scenarios");
        this.check0104.setLocalizedErrorMessage(SPANISH, "la referencia al subprograma no es v\u00e1lida porque el programa est\u00e1 enlazado a un caso de prueba y solo admite referencias a escenarios del caso enlazado");
        this.check0105.setLocalizedDescription(ENGLISH, "the subprogram is not equal to the program");
        this.check0105.setLocalizedDescription(SPANISH, "el subprograma no es igual al programa");
        this.check0105.setLocalizedErrorMessage(ENGLISH, "the reference to the subprogram is not valid because the subprogram is equal to the program");
        this.check0105.setLocalizedErrorMessage(SPANISH, "la referencia al subprograma no es v\u00e1lida porque el subprograma es igual al programa");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.escenario.setRequiringFilter(this.programa.caso.isNotNull());
    }

    @ProcessOperationClass
    public class Cargar
    extends ProcessOperation {
        @InstanceReference
        protected LineaPrueba linea;
        @FileReference
        @ParameterField(required=Kleenean.TRUE)
        protected StringParameter archivo;
        @ParameterField(required=Kleenean.FALSE)
        protected StringParameter descripcionArchivo;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "upload");
            this.setLocalizedLabel(SPANISH, "cargar");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.linea.setLocalizedLabel(ENGLISH, "line");
            this.linea.setLocalizedLabel(SPANISH, "l\u00ednea");
            this.archivo.setLocalizedLabel(ENGLISH, "file");
            this.archivo.setLocalizedLabel(SPANISH, "archivo");
            this.descripcionArchivo.setLocalizedLabel(ENGLISH, "file description");
            this.descripcionArchivo.setLocalizedLabel(SPANISH, "descripci\u00f3n archivo");
        }
    }
}

