/*
 * Decompiled with CFR 0.152.
 */
package meta.entidad.comun.operacion.basica;

import adalid.core.AbstractPersistentEntity;
import adalid.core.ProcessOperation;
import adalid.core.annotations.BusinessKey;
import adalid.core.annotations.ColumnField;
import adalid.core.annotations.DescriptionProperty;
import adalid.core.annotations.EntityClass;
import adalid.core.annotations.EntityCodeGen;
import adalid.core.annotations.EntityConsoleView;
import adalid.core.annotations.EntityDeleteOperation;
import adalid.core.annotations.EntityDetailView;
import adalid.core.annotations.EntityInsertOperation;
import adalid.core.annotations.EntityReferenceConversionValidation;
import adalid.core.annotations.EntitySelectOperation;
import adalid.core.annotations.EntityTableView;
import adalid.core.annotations.EntityTreeView;
import adalid.core.annotations.EntityUpdateOperation;
import adalid.core.annotations.ForeignKey;
import adalid.core.annotations.InstanceReference;
import adalid.core.annotations.ManyToOne;
import adalid.core.annotations.NameProperty;
import adalid.core.annotations.OperationClass;
import adalid.core.annotations.OwnerProperty;
import adalid.core.annotations.ParameterField;
import adalid.core.annotations.PrimaryKey;
import adalid.core.annotations.PropertyField;
import adalid.core.annotations.StringField;
import adalid.core.annotations.VersionProperty;
import adalid.core.enums.Checkpoint;
import adalid.core.enums.DefaultCondition;
import adalid.core.enums.Kleenean;
import adalid.core.enums.MasterDetailView;
import adalid.core.enums.Navigability;
import adalid.core.enums.OnDeleteAction;
import adalid.core.enums.OnUpdateAction;
import adalid.core.enums.OperationAccess;
import adalid.core.enums.ResourceGender;
import adalid.core.enums.ResourceType;
import adalid.core.enums.SpecialEntityValue;
import adalid.core.enums.TableResponsiveMode;
import adalid.core.enums.ViewMenuOption;
import adalid.core.interfaces.Artifact;
import adalid.core.interfaces.Check;
import adalid.core.interfaces.Segment;
import adalid.core.properties.BooleanProperty;
import adalid.core.properties.LongProperty;
import adalid.core.properties.StringProperty;
import java.lang.reflect.Field;
import meta.entidad.comun.configuracion.basica.ext.Funcion;
import meta.entidad.comun.control.acceso.Usuario;

@EntityClass(base=Kleenean.TRUE, independent=Kleenean.FALSE, resourceType=ResourceType.OPERATION, resourceGender=ResourceGender.MASCULINE)
@EntityCodeGen(bws=Kleenean.FALSE, fws=Kleenean.FALSE)
@EntitySelectOperation(enabled=Kleenean.TRUE)
@EntityInsertOperation(enabled=Kleenean.TRUE)
@EntityUpdateOperation(enabled=Kleenean.TRUE)
@EntityDeleteOperation(enabled=Kleenean.TRUE)
@EntityTableView(enabled=Kleenean.TRUE, responsiveMode=TableResponsiveMode.PRIORITY, menu=ViewMenuOption.NONE)
@EntityDetailView(enabled=Kleenean.TRUE)
@EntityTreeView(enabled=Kleenean.FALSE)
@EntityConsoleView(enabled=Kleenean.TRUE, menu=Kleenean.FALSE)
public class FiltroFuncion
extends AbstractPersistentEntity {
    @PrimaryKey
    public LongProperty id;
    @VersionProperty
    public LongProperty version;
    @BusinessKey
    @StringField(maxLength=100)
    @PropertyField(create=Kleenean.FALSE, update=Kleenean.FALSE, table=Kleenean.FALSE, heading=Kleenean.FALSE, defaultCondition=DefaultCondition.UNCONDITIONALLY_ON_INSERT, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public StringProperty codigoFiltroFuncion;
    @NameProperty
    public StringProperty nombreFiltroFuncion;
    @DescriptionProperty
    @StringField(maxLength=0)
    public StringProperty descripcionFiltroFuncion;
    @ManyToOne(navigability=Navigability.BIDIRECTIONAL, view=MasterDetailView.TABLE_AND_DETAIL)
    @ColumnField(nullable=Kleenean.FALSE)
    public Funcion funcion;
    @OwnerProperty
    @ForeignKey(onDelete=OnDeleteAction.CASCADE, onUpdate=OnUpdateAction.CASCADE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @ColumnField(nullable=Kleenean.TRUE)
    @PropertyField(responsivePriority=6, create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE, defaultCondition=DefaultCondition.IF_NULL_ON_INSERT, defaultCheckpoint=Checkpoint.USER_INTERFACE)
    public Usuario usuario;
    @ColumnField(nullable=Kleenean.TRUE)
    @ForeignKey(onDelete=OnDeleteAction.NONE, onUpdate=OnUpdateAction.NONE)
    @ManyToOne(navigability=Navigability.UNIDIRECTIONAL, view=MasterDetailView.NONE)
    @PropertyField(responsivePriority=6, create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.FALSE)
    public Usuario remitente;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(responsivePriority=6, create=Kleenean.FALSE, update=Kleenean.FALSE, search=Kleenean.TRUE, table=Kleenean.TRUE, report=Kleenean.TRUE)
    public BooleanProperty esPublico;
    @ColumnField(nullable=Kleenean.FALSE)
    @PropertyField(hidden=Kleenean.TRUE)
    public BooleanProperty esEspecial;
    @PropertyField(hidden=Kleenean.TRUE)
    public LongProperty idFiltroFuncionOriginal;
    protected Segment privados;
    protected EnviarCopia enviarCopia;
    protected Publicar publicar;
    protected Privatizar privatizar;

    public FiltroFuncion(Artifact declaringArtifact, Field declaringField) {
        super(declaringArtifact, declaringField);
    }

    @Override
    protected void addAllocationStrings() {
        super.addAllocationStrings();
        super.addAllocationStrings("funcion.dominio");
    }

    @Override
    protected void settleAttributes() {
        super.settleAttributes();
        this.setLocalizedLabel(ENGLISH, "query filter");
        this.setLocalizedLabel(SPANISH, "filtro de b\u00fasqueda");
        this.setLocalizedShortLabel(ENGLISH, "filter");
        this.setLocalizedShortLabel(SPANISH, "filtro");
        this.setLocalizedCollectionLabel(ENGLISH, "Query Filters");
        this.setLocalizedCollectionLabel(SPANISH, "Filtros de B\u00fasqueda");
        this.setLocalizedCollectionShortLabel(ENGLISH, "Filters");
        this.setLocalizedCollectionShortLabel(SPANISH, "Filtros");
        this.setLocalizedDescription(ENGLISH, "Each instance of " + this.b("Query Filters") + " represents a query filter defined by the user.");
        this.setLocalizedDescription(SPANISH, "Cada instancia de " + this.b("Filtros de B\u00fasqueda") + " representa un filtro de b\u00fasqueda definido por el usuario.");
        this.setLocalizedShortDescription(ENGLISH, "query filter defined by the user");
        this.setLocalizedShortDescription(SPANISH, "filtro de b\u00fasqueda definido por el usuario");
    }

    @Override
    protected void settleProperties() {
        super.settleProperties();
        this.setOrderBy(this.funcion, this.esPublico, this.nombreFiltroFuncion);
        this.codigoFiltroFuncion.setDefaultValue(FiltroFuncion.concat(this.funcion.dominio.codigoDominio, HYPHEN, this.id));
        this.esPublico.setInitialValue(false);
        this.esPublico.setDefaultValue(false);
        this.esEspecial.setInitialValue(false);
        this.esEspecial.setDefaultValue(false);
        this.codigoFiltroFuncion.setLocalizedLabel(ENGLISH, "query filter code");
        this.codigoFiltroFuncion.setLocalizedLabel(SPANISH, "c\u00f3digo del filtro de b\u00fasqueda");
        this.codigoFiltroFuncion.setLocalizedShortLabel(ENGLISH, "code");
        this.codigoFiltroFuncion.setLocalizedShortLabel(SPANISH, "c\u00f3digo");
        this.codigoFiltroFuncion.setLocalizedDefaultValueTag(ENGLISH, this.b("code") + " of " + this.b("domain") + " of " + this.b("function") + " + " + this.b("id"));
        this.codigoFiltroFuncion.setLocalizedDefaultValueTag(SPANISH, this.b("c\u00f3digo") + " de " + this.b("dominio") + " de " + this.b("funci\u00f3n") + " + " + this.b("id"));
        this.nombreFiltroFuncion.setLocalizedLabel(ENGLISH, "query filter name");
        this.nombreFiltroFuncion.setLocalizedLabel(SPANISH, "nombre del filtro de b\u00fasqueda");
        this.nombreFiltroFuncion.setLocalizedShortLabel(ENGLISH, "name");
        this.nombreFiltroFuncion.setLocalizedShortLabel(SPANISH, "nombre");
        this.descripcionFiltroFuncion.setLocalizedLabel(ENGLISH, "query filter description");
        this.descripcionFiltroFuncion.setLocalizedLabel(SPANISH, "descripci\u00f3n del filtro de b\u00fasqueda");
        this.descripcionFiltroFuncion.setLocalizedShortLabel(ENGLISH, "description");
        this.descripcionFiltroFuncion.setLocalizedShortLabel(SPANISH, "descripci\u00f3n");
        this.funcion.setLocalizedLabel(ENGLISH, "function");
        this.funcion.setLocalizedLabel(SPANISH, "funci\u00f3n");
        this.usuario.setLocalizedLabel(ENGLISH, "owner");
        this.usuario.setLocalizedLabel(SPANISH, "propietario");
        this.remitente.setLocalizedLabel(ENGLISH, "sender");
        this.remitente.setLocalizedLabel(SPANISH, "remitente");
        this.esPublico.setLocalizedLabel(ENGLISH, "public");
        this.esPublico.setLocalizedLabel(SPANISH, "p\u00fablico");
        this.esPublico.setLocalizedDescription(ENGLISH, "Public query filter indicator; public query filters can be used by all users authorized to query the entity");
        this.esPublico.setLocalizedDescription(SPANISH, "indicador de filtro de b\u00fasqueda p\u00fablico; los filtros de b\u00fasqueda p\u00fablicos pueden ser utilizados por todos los usuarios autorizados a hacer consultas sobre la entidad");
        this.esEspecial.setLocalizedLabel(ENGLISH, "special");
        this.esEspecial.setLocalizedLabel(SPANISH, "especial");
        this.esEspecial.setLocalizedDescription(ENGLISH, "Special query filter indicator; special query filters are predefined filters of the application; they are initially public, but can be privatized");
        this.esEspecial.setLocalizedDescription(SPANISH, "indicador de filtro de b\u00fasqueda especial; los filtros de b\u00fasqueda especiales son filtros predefinidos de la aplicaci\u00f3n; inicialmente son p\u00fablicos, pero pueden ser privatizados");
        this.idFiltroFuncionOriginal.setLocalizedLabel(ENGLISH, "original query filter");
        this.idFiltroFuncionOriginal.setLocalizedLabel(SPANISH, "filtro original");
        this.idFiltroFuncionOriginal.setLocalizedShortLabel(ENGLISH, "original");
        this.idFiltroFuncionOriginal.setLocalizedShortLabel(SPANISH, "original");
    }

    @Override
    protected void settleExpressions() {
        super.settleExpressions();
        this.privados = this.esPublico.isFalse();
        this.privados.setLocalizedErrorMessage(ENGLISH, "the filter is public");
        this.privados.setLocalizedErrorMessage(SPANISH, "el filtro es p\u00fablico");
    }

    @Override
    protected void settleFilters() {
        super.settleFilters();
        this.setUpdateFilter(this.privados);
        this.setDeleteFilter(this.privados);
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class Privatizar
    extends ProcessOperation {
        @InstanceReference
        protected FiltroFuncion filtro;
        protected Check check101;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "privatize");
            this.setLocalizedLabel(SPANISH, "privatizar");
            this.setLocalizedDescription(ENGLISH, "make a public filter private");
            this.setLocalizedDescription(SPANISH, "convertir un fitro p\u00fablico en privado");
            this.setLocalizedSuccessMessage(ENGLISH, "the filter was successfully privatized");
            this.setLocalizedSuccessMessage(SPANISH, "el filtro se privatiz\u00f3 con \u00e9xito");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.filtro.esPublico.setCurrentValue(false);
            this.filtro.usuario.setCurrentValue(SpecialEntityValue.CURRENT_USER);
            this.filtro.setLocalizedLabel(ENGLISH, "filter");
            this.filtro.setLocalizedLabel(SPANISH, "filtro");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.filtro.usuario.isNull().and(this.filtro.esPublico.isTrue());
            this.check101.setLocalizedDescription(ENGLISH, "the filter is not a private filter");
            this.check101.setLocalizedDescription(SPANISH, "el filtro no es un filtro privado");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the filter is already private");
            this.check101.setLocalizedErrorMessage(SPANISH, "el filtro ya es privado");
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class Publicar
    extends ProcessOperation {
        @InstanceReference
        protected FiltroFuncion filtro;
        protected Check check101;
        protected Check check102;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "publish");
            this.setLocalizedLabel(SPANISH, "publicar");
            this.setLocalizedDescription(ENGLISH, "make a private filter public");
            this.setLocalizedDescription(SPANISH, "convertir un fitro privado en p\u00fablico");
            this.setLocalizedSuccessMessage(ENGLISH, "the filter was successfully published");
            this.setLocalizedSuccessMessage(SPANISH, "el filtro se public\u00f3 con \u00e9xito");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.filtro.esPublico.setCurrentValue(true);
            this.filtro.usuario.setCurrentValue(SpecialEntityValue.NULL);
            this.filtro.setLocalizedLabel(ENGLISH, "filter");
            this.filtro.setLocalizedLabel(SPANISH, "filtro");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.filtro.esPublico.isFalse();
            this.check102 = this.filtro.usuario.id.isEqualTo(CURRENT_USER_ID);
            this.check101.setLocalizedDescription(ENGLISH, "the filter is not a public filter");
            this.check101.setLocalizedDescription(SPANISH, "el filtro no es un filtro p\u00fablico");
            this.check101.setLocalizedErrorMessage(ENGLISH, "the filter is already public");
            this.check101.setLocalizedErrorMessage(SPANISH, "el filtro ya es p\u00fablico");
            this.check102.setLocalizedDescription(ENGLISH, "the filter belongs to the current user");
            this.check102.setLocalizedDescription(SPANISH, "el filtro le pertenece al usuario actual");
            this.check102.setLocalizedErrorMessage(ENGLISH, "it is not allowed to publish filters that do not belong to you");
            this.check102.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido publicar filtros que no le pertenecen");
        }
    }

    @OperationClass(access=OperationAccess.PROTECTED)
    public class EnviarCopia
    extends ProcessOperation {
        @InstanceReference
        protected FiltroFuncion filtro;
        @ParameterField(required=Kleenean.TRUE)
        @EntityReferenceConversionValidation(restrictedAccess=Kleenean.FALSE)
        protected Usuario destinatario;
        protected Check check101;
        protected Check check102;
        protected Check check201;
        protected Check check202;

        @Override
        protected void settleAttributes() {
            super.settleAttributes();
            this.setLocalizedLabel(ENGLISH, "send a copy");
            this.setLocalizedLabel(SPANISH, "enviar copia");
            this.setLocalizedDescription(ENGLISH, "send a copy of the filter to the specified recipient");
            this.setLocalizedDescription(SPANISH, "enviar una copia del filtro al destinatario especificado");
            this.setLocalizedSuccessMessage(ENGLISH, "a copy of the filter was sent to the specified recipient");
            this.setLocalizedSuccessMessage(SPANISH, "se envi\u00f3 una copia del filtro al destinatario especificado");
        }

        @Override
        protected void settleParameters() {
            super.settleParameters();
            this.filtro.setLocalizedLabel(ENGLISH, "filter");
            this.filtro.setLocalizedLabel(SPANISH, "filtro");
            this.destinatario.setLocalizedLabel(ENGLISH, "recipient user");
            this.destinatario.setLocalizedLabel(SPANISH, "usuario destinatario");
            this.destinatario.setLocalizedShortLabel(ENGLISH, "recipient");
            this.destinatario.setLocalizedShortLabel(SPANISH, "destinatario");
            this.destinatario.setLocalizedShortDescription(ENGLISH, "filter recipient");
            this.destinatario.setLocalizedShortDescription(SPANISH, "destinatario del filtro");
            this.destinatario.setLocalizedTooltip(ENGLISH, "user code of the filter recipient");
            this.destinatario.setLocalizedTooltip(SPANISH, "c\u00f3digo de usuario del destinatario del filtro");
            this.destinatario.codigoUsuario.setLocalizedShortLabel(ENGLISH, "recipient code");
            this.destinatario.codigoUsuario.setLocalizedShortLabel(SPANISH, "destinatario");
        }

        @Override
        protected void settleExpressions() {
            super.settleExpressions();
            this.check101 = this.filtro.esPublico.isFalse();
            this.check102 = this.filtro.usuario.id.isEqualTo(CURRENT_USER_ID);
            this.check201 = this.destinatario.esUsuarioEspecial.isFalse();
            this.check202 = this.destinatario.id.isNotEqualTo(CURRENT_USER_ID);
            this.check101.setLocalizedDescription(ENGLISH, "the filter is not a public filter");
            this.check101.setLocalizedDescription(SPANISH, "el filtro no es un filtro p\u00fablico");
            this.check101.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of public filters");
            this.check101.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de filtros p\u00fablicos");
            this.check102.setLocalizedDescription(ENGLISH, "the filter belongs to the current user");
            this.check102.setLocalizedDescription(SPANISH, "el filtro le pertenece al usuario actual");
            this.check102.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of filters that do not belong to you");
            this.check102.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de filtros que no le pertenecen");
            this.check201.setLocalizedDescription(ENGLISH, "the recipient is not a special user");
            this.check201.setLocalizedDescription(SPANISH, "el destinatario no es un usuario especial");
            this.check201.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of filters to special users");
            this.check201.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviar copias de filtros a usuarios especiales");
            this.check202.setLocalizedDescription(ENGLISH, "the recipient is not the current user");
            this.check202.setLocalizedDescription(SPANISH, "el destinatario no es el usuario actual");
            this.check202.setLocalizedErrorMessage(ENGLISH, "it is not allowed to send copies of filters to yourself");
            this.check202.setLocalizedErrorMessage(SPANISH, "no est\u00e1 permitido enviarse copias de filtros a uno mismo");
        }

        @Override
        protected void settleFilters() {
            super.settleFilters();
            this.destinatario.setSearchQueryFilter(EnviarCopia.and(this.check201, this.check202));
        }
    }
}

